/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.ConnectionWithOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.PerUserOAuth2Helper;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;

public interface ConnectionWithPerUserOAuth2Credentials
extends ConnectionWithOAuth2Credentials {
    public static final DKULogger logger = DKULogger.getLogger((String)"dip.oauth2");

    public boolean actuallyHasPerUserOAuth2Credential();

    public boolean hasRefreshTokenRotation();

    public String getNameForCredentials();

    default public OAuth2Client.AccessTokenResult getAccessTokenFromRefreshTokenAndUpdateIfNeeded(AuthCtx authCtx, OAuth2Client oAuth2Client, boolean useOIDCIdToken) throws URISyntaxException, IOException, ParseException, DKUSecurityException {
        AutoCloseableLock lock = null;
        if (this.hasRefreshTokenRotation()) {
            lock = NamedLock.acquire((String)(this.getNameForCredentials() + " " + oAuth2Client.getClientId() + " " + authCtx.toString()));
        }
        try {
            ICredentialsService ics = (ICredentialsService)SpringUtils.getBean(ICredentialsService.class);
            String refreshToken = ((ICredentialsService.OAuthRefreshTokenCredential)ics.getDecryptedCredential_AutoTXN((AuthCtx)authCtx, (DSSConnection)((DSSConnection)((Object)this)))).refreshToken;
            OAuth2Client.AccessTokenResult accessTokenResult = PerUserOAuth2Helper.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, refreshToken, useOIDCIdToken, lock != null, ((DSSConnection)((Object)this)).name, "connection");
            return accessTokenResult;
        }
        catch (DKUSecurityException e) {
            throw e.withPayload("connectionName", (Object)this.getNameForCredentials()).withPayload("user", (Object)authCtx.getDSSUserForImpersonation()).withPayload("sameUser", (Object)authCtx.isUserSameAsParent());
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    default public OAuth2Client.AccessTokenResult getAccessTokenFromFromResourceOwnerPassword(AuthCtx authCtx, OAuth2Client oAuth2Client, boolean useOIDCIdToken) throws URISyntaxException, IOException, ParseException, DKUSecurityException {
        String password;
        String userName;
        try {
            ICredentialsService ics = (ICredentialsService)SpringUtils.getBean(ICredentialsService.class);
            userName = ((ICredentialsService.BasicCredential)ics.getDecryptedCredential_AutoTXN((AuthCtx)authCtx, (DSSConnection)((DSSConnection)((Object)this)))).user;
            password = ((ICredentialsService.BasicCredential)ics.getDecryptedCredential_AutoTXN((AuthCtx)authCtx, (DSSConnection)((DSSConnection)((Object)this)))).password;
        }
        catch (IOException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get username/password credentials", (Throwable)e);
        }
        if (userName == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "The connection has no username defined");
        }
        if (password == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "The connection has no password defined");
        }
        return oAuth2Client.acquireAccessTokenResultFromResourceOwnerPassword(authCtx, userName, password, ((DSSConnection)((Object)this)).name + "-" + userName, useOIDCIdToken);
    }
}

