/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.InsightParams;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum InsightDeserializer implements JsonDeserializer<Insight>
{
    INSTANCE;

    private static final Map<String, Class<? extends InsightParams>> paramsMap;

    public static void registerType(String type, Class<? extends InsightParams> paramsClass) {
        paramsMap.put(type, paramsClass);
    }

    public Insight deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Insight ret = new Insight();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.has("id")) {
            ret.id = jsonObj.get("id").getAsString();
        }
        if (jsonObj.has("name") && !jsonObj.get("name").isJsonNull()) {
            ret.name = jsonObj.get("name").getAsString();
        }
        if (!jsonObj.has("type")) {
            throw new IllegalArgumentException("Type field is required for insights.");
        }
        ret.type = jsonObj.get("type").getAsString();
        Class<? extends InsightParams> paramsClass = paramsMap.get(ret.type);
        if (paramsClass == null) {
            throw new JsonParseException("Insight type " + ret.type + " is unknown. (id: " + ret.id + ")");
        }
        JsonElement paramJson = jsonObj.get("params");
        if (paramJson != null) {
            ret.params = (InsightParams)jsonDeserializationContext.deserialize(paramJson, paramsClass);
        }
        if (jsonObj.has("projectKey")) {
            ret.projectKey = jsonObj.get("projectKey").getAsString();
        }
        if (jsonObj.has("owner")) {
            ret.owner = jsonObj.get("owner").getAsString();
        }
        if (jsonObj.has("shortDesc")) {
            ret.shortDesc = jsonObj.get("shortDesc").getAsString();
        }
        if (jsonObj.has("description")) {
            ret.description = jsonObj.get("description").getAsString();
        }
        if (jsonObj.has("checklists")) {
            ret.checklists = (Checklists)jsonDeserializationContext.deserialize(jsonObj.get("checklists"), Checklists.class);
        }
        if (jsonObj.has("tags")) {
            ret.tags = (List)jsonDeserializationContext.deserialize(jsonObj.get("tags"), List.class);
        }
        if (jsonObj.has("listed")) {
            ret.listed = jsonObj.get("listed").getAsBoolean();
        }
        if (jsonObj.has("dashboardCreationId")) {
            ret.dashboardCreationId = jsonObj.get("dashboardCreationId").getAsString();
        }
        if (jsonObj.has("versionTag")) {
            ret.versionTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("versionTag"), VersionTag.class);
        }
        if (jsonObj.has("creationTag")) {
            ret.creationTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("creationTag"), VersionTag.class);
        }
        if (jsonObj.has("customFields")) {
            ret.customFields = jsonObj.getAsJsonObject("customFields");
        }
        return ret;
    }

    static {
        JSON.registerAdapter(Insight.class, (Object)((Object)INSTANCE));
        paramsMap = Collections.synchronizedMap(new HashMap());
    }
}

