/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshOfSubgraphs;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.util.ArrayList;

public class ComputeRequiredRefreshMissingOnlyBuild
extends ComputeRequiredRefreshOfSubgraphs {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute.prune");

    public ComputeRequiredRefreshMissingOnlyBuild(ComputableHashComputer dtComputer, RecipeHashComputer ttcomputer, JobDef jobDef, JobActivity topLevelActivity) {
        super(dtComputer, ttcomputer, jobDef, topLevelActivity);
    }

    @Override
    public void pruneInternal(DSSDBConnection conn) throws Exception {
        this.prune(conn, this.topLevelActivity);
    }

    private boolean prune(DSSDBConnection conn, JobActivity item) throws Exception {
        return this.pruneAndReturnIfNeeded(conn, item, 0);
    }

    private boolean pruneAndReturnIfNeeded(DSSDBConnection conn, JobActivity item, int indentLevel) throws Exception {
        if (item.pruned) {
            return false;
        }
        if (this.requiredActivityCache.containsKey(item)) {
            return (Boolean)this.requiredActivityCache.get(item);
        }
        if (indentLevel > 0) {
            this.infoV(item, indentLevel, "checking if targets exist", new Object[0]);
            boolean allTargetsExist = this.allTargetsExist(conn, item, indentLevel);
            if (allTargetsExist) {
                this.infoV(item, indentLevel, "all targets exist --> activity is not required", new Object[0]);
                return this.cacheAndReturnIsActivityRequired(item, false);
            }
            this.infoV(item, indentLevel, "some targets don't exist --> activity is required, and recursing", new Object[0]);
        } else {
            this.infoV(item, indentLevel, "working on top-level activity --> not checking existence", new Object[0]);
        }
        this.infoV(item, indentLevel, "checking the status of its %d dependencies", item.dependencies.size());
        ArrayList<JobActivity> neededDependencies = new ArrayList<JobActivity>();
        for (JobActivity dependency : item.dependencies) {
            logger.info((Object)(DKUtils.indent((int)indentLevel) + " checking dep  " + dependency.id()));
            boolean depIsNeeded = this.pruneAndReturnIfNeeded(conn, dependency, indentLevel + 1);
            if (depIsNeeded) {
                neededDependencies.add(dependency);
                continue;
            }
            dependency.pruned = true;
        }
        item.dependencies = neededDependencies;
        return this.cacheAndReturnIsActivityRequired(item, true);
    }
}

