/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.exec.split.AbstractSplitRecipeExecutor;
import com.dataiku.dip.dataflow.exec.split.AbstractSplitRecipeSQLlikeExecutor;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeJobDef;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeJobDefBuilder;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeSparkExecutor
extends AbstractSplitRecipeSQLlikeExecutor {
    @Autowired
    private DatasetsDAO datasetsDAO;

    public SplitRecipeSparkExecutor(JobActivity activity, SplitRecipePayloadParams splitParams, SparkSQLExecutor.SparkSQLExecutorParams sparkSQL, boolean lowerCaseColumns) {
        super(activity, splitParams, lowerCaseColumns, new SparkSQLDialect());
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected void assertSupportRandom() {
    }

    @Override
    protected void runSplit(String outputDatasetFullId) throws Exception {
        throw new Error("unreachable");
    }

    @Override
    protected void runAllSplits() throws Exception {
        this.runSparkJob();
    }

    protected void runSparkJob() throws Exception {
        SplitRecipeJobDef jobDef = new SplitRecipeJobDefBuilder(this.activity, this.params, this.splitHelper).build(this.params.engineParams.sparkSQL);
        SparkRecipeUtils.clearActivityOutputsIfNeeded(this.activity, this.datasetsDAO, this.recipe, this.authCtxService.getAuthCtx());
        SparkSplitActivityRunner runner = new SparkSplitActivityRunner(this.activity, jobDef);
        runner.init();
        this.run(runner);
    }

    class SparkSplitActivityRunner
    extends AbstractSparkBasedRecipeRunner {
        private final SplitRecipeJobDef jobDef;

        public SparkSplitActivityRunner(JobActivity activity, SplitRecipeJobDef jobDef) {
            super(activity);
            this.jobDef = jobDef;
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public void init() throws Exception {
            this.activity.fillSourceTotalSizes(this.datasetsDAO);
            this.activity.setStatusMessage("Initializing");
        }

        @Override
        public void run() throws Exception {
            final SparkOverrideConfig sparkConfig = SplitRecipeSparkExecutor.this.params.engineParams.sparkSQL.sparkConfig;
            AbstractSplitRecipeExecutor.logger.info((Object)("Executing Spark Split recipe job with sparkConfig: " + JSON.json((Object)sparkConfig)));
            this.runSpark("Spark", SplitRecipeSparkExecutor.this.params.engineParams.sparkSQL.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                @Override
                public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                    AutoDelete serializedFile = FlowJobUtils.getJobTempFile("spark-recipe", "spark-split-recipe-desc", "json");
                    JSON.prettyToFile((Object)SparkSplitActivityRunner.this.jobDef, (File)serializedFile);
                    T job = helper.makeClassJob("DSS (Split): " + SparkSplitActivityRunner.this.activity.id(), false, effectiveConf, "com.dataiku.dip.spark.SparkSplitRecipeJob", serializedFile.getAbsolutePath());
                    ((SparkJob)job).secretDriverFiles.add(serializedFile.getAbsolutePath());
                    return job;
                }

                @Override
                public SparkOverrideConfig getRecipeOverrideConf() {
                    return sparkConfig;
                }
            }, null);
            this.activity.setAllSourcesCompletelyRead();
            this.activity.fillTargetWrittenSizes(this.datasetsDAO);
            this.activity.setStatusMessage("Done");
        }

        @Override
        public void notifyBeforeAborting() {
        }
    }
}

