/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.stream;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.SingleCallAsserter;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;

public class ToDatasetStreamer {
    private final AuthCtx authCtx;
    private ColumnFactory cf;
    private Dataset dataset;
    private Partition partition;
    private OutputWriter streamOutput;
    private DatasetHandler streamDh;
    private int targetSplit;
    private int resplitFactor;
    private WarningsContext warningsContext;
    private SingleCallAsserter sca = new SingleCallAsserter();
    private Output.WriteMode mode;
    public long writtenRows;

    public static ToDatasetStreamer newWithAutoBucketing(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, ColumnFactory cf, WarningsContext warningsContext, Output.WriteMode mode) {
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(targetDataset);
        int resplitFactor = 0;
        if (meta.supportsOrderPreservation()) {
            SerializedDataset.ReadWriteOptions rwOptions = targetDataset.getModel().readWriteOptions;
            if (rwOptions.preserveOrder) {
                resplitFactor = 1;
            } else if (rwOptions.writeBuckets > 0) {
                resplitFactor = rwOptions.writeBuckets;
            }
            if (rwOptions.forceSingleOutputFile) {
                resplitFactor = 1;
            }
        }
        return new ToDatasetStreamer(authCtx, targetDataset, targetPartition, 0, resplitFactor, cf, warningsContext, mode);
    }

    public static ToDatasetStreamer newNonSplittedNonBucketed(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, ColumnFactory cf, WarningsContext warningsContext, Output.WriteMode mode) {
        return new ToDatasetStreamer(authCtx, targetDataset, targetPartition, 0, 0, cf, warningsContext, mode);
    }

    public static ToDatasetStreamer newToSpecificSplit(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, int targetSplit, ColumnFactory cf, WarningsContext warningsContext, Output.WriteMode mode) {
        return new ToDatasetStreamer(authCtx, targetDataset, targetPartition, targetSplit, 0, cf, warningsContext, mode);
    }

    private ToDatasetStreamer(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, int targetSplit, int resplitFactor, ColumnFactory cf, WarningsContext warningsContext, Output.WriteMode mode) {
        assert (targetDataset != null);
        assert (targetPartition != null);
        this.authCtx = authCtx;
        this.dataset = targetDataset;
        this.partition = targetPartition;
        this.targetSplit = targetSplit;
        this.resplitFactor = resplitFactor;
        this.cf = cf;
        this.warningsContext = warningsContext;
        this.mode = mode;
    }

    public SingleInputRowProcessor getAsProcessor() throws Exception {
        this.sca.call("ToDatasetStreamer::get");
        this.init();
        return new Streamer();
    }

    public ProcessorOutput getAsOutput() throws Exception {
        return new ProcessorOutputToSIP(this.getAsProcessor());
    }

    public long getWrittenBytes() throws IOException {
        return this.streamOutput.writtenBytes();
    }

    private void init() throws Exception {
        this.streamDh = DatasetHandlerFactory.build(this.authCtx, this.dataset);
        Output od = this.streamDh.buildOutput(this.partition, this.targetSplit, this.resplitFactor, this.warningsContext);
        this.streamOutput = od.getWriter(this.mode);
        this.streamOutput.init(this.cf);
    }

    private class Streamer
    implements SingleInputRowProcessor,
    WithFactories {
        private Streamer() {
        }

        public void processRow(Row row) throws Exception {
            ToDatasetStreamer.this.streamOutput.emitRow(row);
            ++ToDatasetStreamer.this.writtenRows;
        }

        public void postProcess() throws Exception {
            try {
                ToDatasetStreamer.this.streamOutput.lastRowEmitted();
            }
            finally {
                ToDatasetStreamer.this.streamDh.close();
            }
        }

        @Override
        public void setFactories(ColumnFactory cf, RowFactory rf) {
        }

        public void cancel() throws Exception {
            ToDatasetStreamer.this.streamOutput.cancel();
            ToDatasetStreamer.this.streamDh.close();
        }
    }
}

