/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.UpsertRecipeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private UpsertRecipeService service;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private UpsertRecipePayloadParams params;
    private static Logger logger = Logger.getLogger((String)"dip.upsert.schema");

    public UpsertRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.service.loadParams(payload, this.recipe);
    }

    public void setParams(UpsertRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        Schema inputSchema;
        logger.info((Object)("update recipe options=" + JSON.json((Object)optionsObj)));
        UpsertRecipeUpdateOptions options = optionsObj == null ? new UpsertRecipeUpdateOptions() : (UpsertRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, UpsertRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        try (Transaction t = this.transactionService.beginRead();){
            Iterator<ComputedColumn> inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
            Dataset inputDataset = this.datasetAccessService.getMandatory((AnyLoc)((Object)inputLoc));
            inputSchema = inputDataset.getSchema();
        }
        HashMap columns = Maps.newHashMap();
        for (SchemaColumn c2 : inputSchema.columns) {
            columns.put(c2.getName(), c2);
        }
        for (ComputedColumn cc : this.params.computedColumns) {
            columns.put(cc.name, new SchemaColumn(cc.name, Type.forName((String)cc.type)));
        }
        if (options.removeMissingKeys) {
            ArrayList keyToRemove = Lists.newArrayList();
            for (UpsertRecipePayloadParams.UpsertKey key : this.params.keys) {
                if (columns.containsKey(key.column)) continue;
                keyToRemove.add(key);
            }
            logger.info((Object)("found " + keyToRemove.size() + " keys to remove"));
            this.params.keys.removeAll(keyToRemove);
            for (UpsertRecipePayloadParams.UpsertKey key : keyToRemove) {
                ret.recipeChanges.add(String.format("Removed upsert key %s", key.column));
            }
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        return this.service.getOutputSchemaAfterOverride(inputDataset, this.params, lowerCase, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
    }

    public static class UpsertRecipeUpdateOptions {
        public boolean removeMissingKeys = true;
    }
}

