/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.datasets.consistency.ConsistencyCheckRunner;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.recipes.consistency.RecipeConsistencyCheckRequest;
import com.dataiku.dip.recipes.consistency.RecipeConsistencyCheckRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConsistencyTool
extends AbstractFlowTool.FlowTool {
    private ProjectFlowGraph graph;
    private FutureProgressState mainProgressState = null;
    private ConsistencyToolOptions currentUpdateOptions;
    private ConsistencyToolState state = new ConsistencyToolState();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.propagate");

    public ConsistencyTool(AuthCtx authCtx, String projectKey) throws IOException {
        super(authCtx, projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            this.graph = this.graphService.getProjectGraphWithOrphans(projectKey);
        }
        for (FlowComputable computable : this.graph.listComputables()) {
            this.state.stateByNode.put(GraphIds.forComputable(computable), new NodeState(State.UNCHECKED, computable));
        }
        for (FlowRecipe recipe : this.graph.listRecipes()) {
            this.state.stateByNode.put(GraphIds.forRecipe(recipe), new NodeState(State.UNCHECKED, recipe));
        }
        for (FlowLabelingTask labelingTask : this.graph.listLabelingTaks()) {
            this.state.stateByNode.put(GraphIds.forLabelingTask(labelingTask), new NodeState(State.UNCHECKED, labelingTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(JsonObject options) throws InterruptedException {
        this.currentUpdateOptions = (ConsistencyToolOptions)JSON.parse((JsonElement)options, ConsistencyToolOptions.class);
        this.state.everRun = true;
        this.state.visitedAtThisRound.clear();
        this.mainProgressState = FutureProgress.pushState((String)"Checking", (double)this.state.stateByNode.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            for (FlowComputable sourceComputable : this.graph.listSourceComputables()) {
                logger.infoV("Starting check on computable %s", new Object[]{sourceComputable.getFullId()});
                this.incrementalMarkComputable(sourceComputable, 0);
            }
            for (FlowRecipe sourceRecipe : this.graph.listSourceRecipes()) {
                this.incrementalMarkRecipe(sourceRecipe, 0);
            }
        }
        finally {
            FutureProgress.popState();
        }
    }

    public void recheck(Set<String> nodeIds) {
        logger.infoV("Rechecking nodes %s", new Object[]{nodeIds});
        for (String id : nodeIds) {
            NodeState ns = this.state.stateByNode.get(id);
            if (ns == null) {
                throw new IllegalArgumentException("Node not found: " + id);
            }
            if (ns.recipe != null) {
                this.checkRecipe(ns.recipe);
                continue;
            }
            if (ns.labelingTask != null) {
                this.checkLabelingTask(ns.labelingTask);
                continue;
            }
            if (ns.computable != null) {
                this.checkComputable(ns.computable);
                continue;
            }
            throw new Error("unreachable: " + String.valueOf(ns));
        }
    }

    public void forceMarkOK(Set<String> nodeIds) {
        logger.infoV("Marking nodes %s as OK", new Object[]{nodeIds});
        for (String id : nodeIds) {
            NodeState ns = this.state.stateByNode.get(id);
            if (ns == null) {
                throw new IllegalArgumentException("Node not found: " + id);
            }
            ns.state = State.CHECKED;
            ns.checkFailure = null;
            if (ns.recipe != null) {
                ns.recipeCheckResult = new GenericRecipesValidationService.RecipeValidationResult();
                continue;
            }
            if (ns.computable == null) continue;
            switch (ns.computable.getType()) {
                case DATASET: {
                    ns.datasetCheckResult = new DatasetConsistencyChecker.DatasetConsistencyCheckResult();
                    break;
                }
                case MANAGED_FOLDER: 
                case SAVED_MODEL: 
                case MODEL_EVALUATION_STORE: 
                case RETRIEVABLE_KNOWLEDGE: {
                    break;
                }
                case STREAMING_ENDPOINT: {
                    throw new NotImplementedException("Schema checks on streaming endpoints is not implemented");
                }
            }
        }
    }

    @Override
    public ConsistencyToolState getFlowState(JsonObject options) {
        int unchecked = 0;
        int failed = 0;
        int ok = 0;
        int info = 0;
        int warning = 0;
        int error = 0;
        for (NodeState ns : this.state.stateByNode.values()) {
            if (ns.recipeCheckResult != null) {
                if (ns.recipeCheckResult.maxSeverity == InfoMessage.Severity.ERROR) {
                    ++error;
                    continue;
                }
                if (ns.recipeCheckResult.maxSeverity == InfoMessage.Severity.WARNING) {
                    ++warning;
                    continue;
                }
                if (ns.recipeCheckResult.maxSeverity == InfoMessage.Severity.INFO) {
                    ++info;
                    continue;
                }
                ++ok;
                continue;
            }
            if (ns.datasetCheckResult != null) {
                if (ns.datasetCheckResult.error) {
                    ++error;
                    continue;
                }
                if (ns.datasetCheckResult.warning) {
                    ++warning;
                    continue;
                }
                if (ns.datasetCheckResult.anyMessage) {
                    ++info;
                    continue;
                }
                ++ok;
                continue;
            }
            if (ns.labelingTaskCheckResult != null) {
                if (ns.labelingTaskCheckResult.error) {
                    ++error;
                    continue;
                }
                if (ns.labelingTaskCheckResult.warning) {
                    ++warning;
                    continue;
                }
                if (ns.labelingTaskCheckResult.anyMessage) {
                    ++info;
                    continue;
                }
                ++ok;
                continue;
            }
            if (ns.checkFailure != null) {
                ++failed;
                continue;
            }
            ++unchecked;
        }
        this.state.summary = JF.obj().with("TOTAL", (Number)this.state.stateByNode.size()).with("OK", (Number)ok).with("ERROR", (Number)error).with("WARNING", (Number)warning).with("INFO", (Number)info).with("FAILED_CHECK", (Number)failed).with("UNCHECKED", (Number)unchecked).get();
        return this.state;
    }

    private void checkRecipe(FlowRecipe recipe) {
        String nodeId = GraphIds.forRecipe(recipe);
        NodeState nodeState = this.state.stateByNode.get(nodeId);
        RecipeConsistencyCheckRunner runner = new RecipeConsistencyCheckRunner();
        try {
            nodeState.recipeCheckResult = runner.checkWithFlow_NT(this.authCtx, recipe, this.currentUpdateOptions.recipes);
            nodeState.state = State.CHECKED;
        }
        catch (Throwable e) {
            logger.warn((Object)("Check failed for recipe: " + recipe.getFullId()), e);
            nodeState.state = State.FAILED_CHECK;
            nodeState.checkFailure = new SerializedError(e, !ApplicationConfigurator.hideErrorStacks(), !DKUApp.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
        }
    }

    private void checkLabelingTask(FlowLabelingTask labelingTask) {
        String nodeId = GraphIds.forLabelingTask(labelingTask);
        NodeState nodeState = this.state.stateByNode.get(nodeId);
        nodeState.state = State.CHECKED;
        nodeState.labelingTaskCheckResult = new InfoMessage.InfoMessages();
    }

    private void checkComputable(FlowComputable computable) {
        String nodeId = GraphIds.forComputable(computable);
        NodeState nodeState = this.state.stateByNode.get(nodeId);
        try {
            switch (computable.getType()) {
                case DATASET: {
                    FlowDataset fds = (FlowDataset)computable;
                    nodeState.datasetCheckResult = ConsistencyCheckRunner.checkWithFlow_NT(this.authCtx, fds, this.currentUpdateOptions.datasets);
                    nodeState.state = State.CHECKED;
                    break;
                }
                case MANAGED_FOLDER: 
                case SAVED_MODEL: 
                case MODEL_EVALUATION_STORE: 
                case RETRIEVABLE_KNOWLEDGE: {
                    nodeState.state = State.CHECKED;
                    break;
                }
                case STREAMING_ENDPOINT: {
                    throw new NotImplementedException("Schema check on streaming endpoints is not implemented");
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("Check failed for computable: " + computable.getFullId()), e);
            nodeState.state = State.FAILED_CHECK;
            nodeState.checkFailure = new SerializedError(e, !ApplicationConfigurator.hideErrorStacks(), !DKUApp.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalMarkLabelingTask(FlowLabelingTask labelingTask, int depth) throws InterruptedException {
        String labelingTaskNodeId = GraphIds.forLabelingTask(labelingTask);
        NodeState labelingTaskState = this.state.stateByNode.get(labelingTaskNodeId);
        assert (labelingTaskState != null);
        FutureProgressState.checkInterrupt();
        if (this.state.visitedAtThisRound.contains(labelingTaskNodeId)) {
            return;
        }
        this.state.visitedAtThisRound.add(labelingTaskNodeId);
        boolean needsRecheck = labelingTaskState.state == State.UNCHECKED || labelingTaskState.state == State.FAILED_CHECK || this.currentUpdateOptions.recheckAll;
        logger.infoV(DKUtils.indent((int)depth) + "Maybe-check labeling task %s node %s (currentState=%s) check=%s", new Object[]{labelingTask.getFullId(), labelingTaskNodeId, labelingTaskState.state, needsRecheck});
        if (needsRecheck) {
            logger.infoV(DKUtils.indent((int)depth) + " Checking labeling task %s (current_state=%s)", new Object[]{labelingTask.getFullId(), labelingTaskState.state});
            try {
                this.checkLabelingTask(labelingTask);
            }
            finally {
                this.mainProgressState.increment(1.0);
            }
        }
        for (FlowComputable labelingTaskOutput : labelingTask.getTargets()) {
            this.incrementalMarkComputable(labelingTaskOutput, depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalMarkRecipe(FlowRecipe recipe, int depth) throws InterruptedException {
        boolean needsRecheck;
        String recipeNodeId = GraphIds.forRecipe(recipe);
        NodeState recipeState = this.state.stateByNode.get(recipeNodeId);
        assert (recipeState != null);
        FutureProgressState.checkInterrupt();
        if (this.state.visitedAtThisRound.contains(recipeNodeId)) {
            return;
        }
        this.state.visitedAtThisRound.add(recipeNodeId);
        boolean bl = needsRecheck = recipeState.state == State.UNCHECKED || recipeState.state == State.FAILED_CHECK || this.currentUpdateOptions.recheckAll;
        if (recipeState.state == State.CHECKED && recipeState.recipeCheckResult != null && recipeState.recipeCheckResult.anyFatal()) {
            needsRecheck = true;
        }
        logger.infoV(DKUtils.indent((int)depth) + "Maybe-check recipe %s node %s (currentState=%s) check=%s", new Object[]{recipe.getFullId(), recipeNodeId, recipeState.state, needsRecheck});
        if (needsRecheck) {
            logger.infoV(DKUtils.indent((int)depth) + " Checking recipe %s (current_state=%s)", new Object[]{recipe.getFullId(), recipeState.state});
            try {
                this.checkRecipe(recipe);
            }
            finally {
                this.mainProgressState.increment(1.0);
            }
        }
        for (FlowComputable recipeOutput : recipe.getTargets()) {
            this.incrementalMarkComputable(recipeOutput, depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalMarkComputable(FlowComputable computable, int depth) throws InterruptedException {
        boolean needsRecheck;
        String nodeId = GraphIds.forComputable(computable);
        String nodeIdWithSuccessors = nodeId + String.valueOf(computable.getSuccessors());
        NodeState nodeState = this.state.stateByNode.get(nodeId);
        assert (nodeState != null);
        FutureProgressState.checkInterrupt();
        if (this.state.visitedAtThisRound.contains(nodeIdWithSuccessors)) {
            return;
        }
        this.state.visitedAtThisRound.add(nodeIdWithSuccessors);
        boolean bl = needsRecheck = nodeState.state == State.UNCHECKED || nodeState.state == State.FAILED_CHECK || this.currentUpdateOptions.recheckAll;
        if (nodeState.state == State.CHECKED && nodeState.datasetCheckResult != null && nodeState.datasetCheckResult.anyMessage) {
            needsRecheck = true;
        }
        logger.infoV(DKUtils.indent((int)depth) + "Maybe-check computable %s node %s (currentState=%s) check=%s", new Object[]{computable.getFullId(), nodeId, nodeState.state, needsRecheck});
        if (needsRecheck) {
            logger.infoV(DKUtils.indent((int)depth) + " Checking computable %s (currentState=%s)", new Object[]{computable.getFullId(), nodeState.state});
            try {
                this.checkComputable(computable);
            }
            finally {
                this.mainProgressState.increment(1.0);
            }
        }
        for (GraphNode graphNode : computable.getSuccessors()) {
            if (graphNode instanceof FlowRecipe) {
                this.incrementalMarkRecipe((FlowRecipe)graphNode, depth + 1);
                continue;
            }
            if (!(graphNode instanceof FlowLabelingTask)) continue;
            this.incrementalMarkLabelingTask((FlowLabelingTask)graphNode, depth + 1);
        }
    }

    static class ConsistencyToolState
    implements AbstractFlowTool.FlowState {
        public boolean everRun;
        Map<String, NodeState> stateByNode = new HashMap<String, NodeState>();
        Set<String> visitedAtThisRound = new HashSet<String>();
        public JsonObject summary;

        ConsistencyToolState() {
        }
    }

    static class NodeState {
        State state;
        GenericRecipesValidationService.RecipeValidationResult recipeCheckResult;
        DatasetConsistencyChecker.DatasetConsistencyCheckResult datasetCheckResult;
        InfoMessage.InfoMessages labelingTaskCheckResult;
        SerializedError checkFailure;
        transient FlowRecipe recipe;
        transient FlowLabelingTask labelingTask;
        transient FlowComputable computable;

        NodeState(State state, FlowRecipe recipe) {
            this.state = state;
            this.recipe = recipe;
        }

        NodeState(State state, FlowLabelingTask labelingTask) {
            this.state = state;
            this.labelingTask = labelingTask;
        }

        NodeState(State state, FlowComputable computable) {
            this.state = state;
            this.computable = computable;
        }
    }

    public static enum State {
        UNCHECKED,
        CHECKED,
        FAILED_CHECK;

    }

    static class ConsistencyToolOptions {
        boolean recheckAll;
        DatasetConsistencyChecker.DatasetConsistencyCheckRequest datasets;
        RecipeConsistencyCheckRequest recipes;

        ConsistencyToolOptions() {
        }
    }
}

