/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableTracking;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;

public class MemRow
implements Row,
Serializable {
    transient MemTable table;
    private static final long serialVersionUID = -1L;
    public static final int FLAG_DELETED = 1;
    public static final int FLAG_CHANGE_TRACKING = 2;
    byte rowState;
    int flags = 0;
    int lostChars;
    byte[] cellStates = null;
    public char[] buffer = new char[32];
    public int[] cellOffsets = new int[4];
    public int[] cellLengths = new int[4];
    int bufferWritePos;
    private Row.RowContext recordContext;
    public int origRowIdx;

    public MemRow(MemTable table) {
        this.table = table;
    }

    boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public boolean isDeleted() {
        return this.hasFlag(1);
    }

    public void put(Column key, String value) {
        this.flags = MemTableTracking.addImpactFlags(this.flags, this.table.resetableImpactDepth);
        ((MemColumn)key).flags = MemTableTracking.addImpactFlags(((MemColumn)key).flags, this.table.resetableImpactDepth);
        if (value == null || value.length() == 0) {
            this.delete(key);
        } else {
            int idx = ((MemColumn)key).index;
            this.indexEnsure(idx);
            if (this.hasFlag(2)) {
                this.cellStates[idx] = 2;
            }
            if (value.length() <= this.cellLengths[idx]) {
                this.lostChars += this.cellLengths[idx] - value.length();
                this.bufOverwrite(idx, value);
            } else {
                this.lostChars += this.cellLengths[idx];
                this.bufEnsure(this.bufferWritePos + value.length());
                this.bufAppend(idx, value);
            }
        }
    }

    public void put(Column key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void put(Column key, long value) {
        this.put(key, Long.toString(value));
    }

    public void put(Column key, double value) {
        this.put(key, Double.toString(value));
    }

    public void put(Column key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public MemRow with(Column key, String value) {
        this.put(key, value);
        return this;
    }

    public MemRow with(Column key, int value) {
        this.put(key, value);
        return this;
    }

    public MemRow with(Column key, long value) {
        this.put(key, value);
        return this;
    }

    public MemRow with(Column key, double value) {
        this.put(key, value);
        return this;
    }

    public MemRow with(Column key, boolean value) {
        this.put(key, value);
        return this;
    }

    public MemRow with(ColumnFactory cf, String key, String value) {
        this.put(cf.column(key), value);
        return this;
    }

    public double getAsDoubleOrNaN(Column cd) {
        String val = this.get(cd);
        if (val == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public String get(String columnName) {
        return this.get(this.table.column(columnName));
    }

    public String get(Column cd, String defaultValue) {
        String v = this.get(cd);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String get(Column key) {
        int cellIndex = ((MemColumn)key).index;
        if (cellIndex >= this.cellOffsets.length) {
            return null;
        }
        if (this.cellLengths[cellIndex] == 0) {
            return null;
        }
        return new String(this.buffer, this.cellOffsets[cellIndex], this.cellLengths[cellIndex]);
    }

    public void get(Column key, CellData buf) {
        int cellIndex = ((MemColumn)key).index;
        if (cellIndex >= this.cellOffsets.length || this.cellLengths[cellIndex] == 0) {
            buf.reset();
        } else {
            buf.set(this.buffer, this.cellOffsets[cellIndex], this.cellLengths[cellIndex]);
        }
    }

    public boolean empty(Column cd) {
        String v = this.get(cd);
        return v == null || v.length() == 0;
    }

    public void delete(Column key) {
        this.flags = MemTableTracking.addImpactFlags(this.flags, this.table.resetableImpactDepth);
        int idx = ((MemColumn)key).index;
        this.indexEnsure(idx);
        this.lostChars += this.cellLengths[idx];
        this.cellLengths[idx] = 0;
        if (this.hasFlag(2)) {
            this.cellStates[idx] = 2;
        }
    }

    public void delete() {
        this.flags |= 1;
        this.flags = MemTableTracking.addDeleteFlags(this.flags, this.table.resetableImpactDepth);
        this.rowState = (byte)2;
    }

    public Row.RowContext getRowContext() {
        if (this.recordContext == null) {
            this.recordContext = new Row.RowContext();
        }
        return this.recordContext;
    }

    public String getFast(int index) {
        if (index >= this.cellOffsets.length || this.cellLengths[index] == 0) {
            return null;
        }
        return new String(this.buffer, this.cellOffsets[index], this.cellLengths[index]);
    }

    public byte getCellState(MemColumn c2) {
        if (c2.state == 3) {
            return 3;
        }
        if (this.hasFlag(1)) {
            return 3;
        }
        if (this.cellStates == null || c2.index >= this.cellStates.length) {
            return 0;
        }
        return this.cellStates[c2.index];
    }

    private void indexEnsure(int index) {
        int newLen;
        if (index >= this.cellOffsets.length) {
            newLen = (int)((double)(index + 1) * 1.4);
            int[] newOffsets = new int[newLen];
            System.arraycopy(this.cellOffsets, 0, newOffsets, 0, this.cellOffsets.length);
            this.cellOffsets = newOffsets;
            int[] newLengths = new int[newLen];
            System.arraycopy(this.cellLengths, 0, newLengths, 0, this.cellLengths.length);
            this.cellLengths = newLengths;
        }
        if (this.hasFlag(2)) {
            newLen = (int)((double)(index + 1) * 1.4);
            if (this.cellStates == null) {
                this.cellStates = new byte[newLen];
            } else if (index >= this.cellStates.length) {
                byte[] newStates = new byte[newLen];
                System.arraycopy(this.cellStates, 0, newStates, 0, this.cellStates.length);
                this.cellStates = newStates;
            }
        }
    }

    private void bufEnsure(int length) {
        if (this.buffer.length < length) {
            char[] newBuf = new char[(int)((double)length * 1.2) + 1];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
    }

    private void bufAppend(int cellIndex, String str) {
        this.cellOffsets[cellIndex] = this.bufferWritePos;
        this.cellLengths[cellIndex] = str.length();
        char[] strArr = str.toCharArray();
        System.arraycopy(strArr, 0, this.buffer, this.bufferWritePos, strArr.length);
        this.bufferWritePos += strArr.length;
    }

    private void bufOverwrite(int cellIndex, String str) {
        int writePos = this.cellOffsets[cellIndex];
        assert (str.length() <= this.cellLengths[cellIndex]);
        this.cellLengths[cellIndex] = str.length();
        char[] strArr = str.toCharArray();
        System.arraycopy(strArr, 0, this.buffer, writePos, strArr.length);
    }

    public int compact() {
        if (this.lostChars == 0) {
            return this.buffer.length;
        }
        char[] newBuf = new char[this.bufferWritePos - this.lostChars];
        int writePos = 0;
        for (int i = 0; i < this.cellLengths.length; ++i) {
            if (this.cellLengths[i] == 0) continue;
            int prevOffset = this.cellOffsets[i];
            System.arraycopy(this.buffer, prevOffset, newBuf, writePos, this.cellLengths[i]);
            this.cellOffsets[i] = writePos;
            writePos += this.cellLengths[i];
        }
        this.buffer = newBuf;
        this.bufferWritePos = this.buffer.length;
        this.lostChars = 0;
        return this.buffer.length;
    }

    int rewrite(int[] oldIndexes) {
        char[] newBuf = new char[this.bufferWritePos - this.lostChars];
        int length = 0;
        for (int i = oldIndexes.length - 1; i > -1; --i) {
            boolean cellStateChanged;
            int oldIndex = oldIndexes[i];
            boolean cellNotEmpty = oldIndex < this.cellLengths.length && this.cellLengths[oldIndex] > 0;
            boolean bl = cellStateChanged = this.cellStates != null && oldIndex < this.cellStates.length && this.cellStates[oldIndex] != 0;
            if (!cellNotEmpty && !cellStateChanged) continue;
            length = i + 1;
            break;
        }
        int[] newCellOffsets = new int[length];
        int[] newCellLength = new int[length];
        byte[] newCellStates = null;
        if (this.cellStates != null) {
            newCellStates = new byte[length];
        }
        int writePos = 0;
        for (int i = 0; i < length; ++i) {
            int l = 0;
            int oldIndex = oldIndexes[i];
            if (oldIndex < this.cellLengths.length) {
                l = this.cellLengths[oldIndex];
                System.arraycopy(this.buffer, this.cellOffsets[oldIndex], newBuf, writePos, l);
            }
            newCellOffsets[i] = writePos;
            newCellLength[i] = l;
            if (this.cellStates != null && oldIndex < this.cellStates.length) {
                newCellStates[i] = this.cellStates[oldIndex];
            }
            writePos += l;
        }
        this.cellOffsets = newCellOffsets;
        this.cellStates = newCellStates;
        this.cellLengths = newCellLength;
        if (writePos != newBuf.length) {
            this.buffer = new char[writePos];
            System.arraycopy(newBuf, 0, this.buffer, 0, writePos);
        } else {
            this.buffer = newBuf;
        }
        this.bufferWritePos = this.buffer.length;
        this.lostChars = 0;
        return this.buffer.length;
    }

    public MemRow(MemTable table, int[] cellLengths, char[] buffer) {
        this.table = table;
        this.buffer = buffer;
        this.bufferWritePos = buffer.length;
        this.cellLengths = cellLengths;
        this.cellOffsets = new int[cellLengths.length];
        int total = 0;
        for (int i = 0; i < cellLengths.length; ++i) {
            this.cellOffsets[i] = total;
            total += cellLengths[i];
        }
    }

    public void dump() {
        for (int i = 0; i < this.cellLengths.length; ++i) {
            if (this.cellLengths[i] <= 0) continue;
            System.out.println(i + " -> " + this.getFast(i));
        }
    }

    public String dumpToString(@Nonnull List<String> columnSubset, int maxSize) {
        StringBuilder sb = new StringBuilder();
        for (String column : columnSubset) {
            MemColumn c2 = this.table.column(column);
            String columnSubstring = String.format(" %s=%s", c2.getName(), this.get(c2));
            if (sb.length() + columnSubstring.length() > maxSize) {
                sb.append(" ...");
                break;
            }
            sb.append(columnSubstring);
        }
        return sb.toString().trim();
    }

    public long getMemoryUsed() {
        long size = 17L;
        size += (long)(2 * this.buffer.length);
        return size += this.getAllocatedColumnRelatedMemory();
    }

    public long getAllocatedColumnRelatedMemory() {
        long mem = 0L;
        mem += (long)(4 * this.cellOffsets.length);
        mem += (long)(4 * this.cellLengths.length);
        if (this.cellStates != null) {
            mem += (long)this.cellStates.length;
        }
        return mem;
    }

    public long getNewColumnRelatedMemory(int newLength) {
        long mem = 0L;
        mem += (long)(8 * newLength);
        if (this.cellStates != null) {
            mem += (long)newLength;
        }
        return mem;
    }
}

