/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RowsComparator
implements Comparator<NumberedRow> {
    private final int n;
    private final List<RowValueAccessorFactory.ValueReader> valueReaders;
    private final List<Comparator<Object>> comparators;
    private final LRUMap cachedValues = new LRUMap(2000);
    protected long count = 0L;
    protected long cacheHit = 0L;
    protected long cacheMiss = 0L;

    public RowsComparator(List<Sorter.SortSpec> specs, NullsOrdering nullsOrdering) {
        this.n = specs.size();
        this.comparators = Lists.newArrayList();
        this.valueReaders = Lists.newArrayList();
        for (Sorter.SortSpec spec : specs) {
            this.valueReaders.add(RowValueAccessorFactory.getReader(spec.schemaColumn, spec.factoryColumn));
            this.comparators.add(RowValueAccessorFactory.getComparator(spec.schemaColumn, spec.factoryColumn, spec.ascending, nullsOrdering));
        }
    }

    private Object[] getKeys(NumberedRow row) {
        if (this.cachedValues.containsKey(row.number)) {
            ++this.cacheHit;
            return (Object[])this.cachedValues.get(row.number);
        }
        ++this.cacheMiss;
        Object[] values = new Object[this.n];
        for (int i = 0; i < this.n; ++i) {
            values[i] = this.valueReaders.get(i).read(row.row);
        }
        this.cachedValues.put(row.number, values);
        return values;
    }

    @Override
    public int compare(NumberedRow a, NumberedRow b) {
        ++this.count;
        Object[] valuesA = this.getKeys(a);
        Object[] valuesB = this.getKeys(b);
        for (int i = 0; i < this.n; ++i) {
            int cmp = this.comparators.get(i).compare(valuesA[i], valuesB[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public void sort(List<NumberedRow> rows) {
        Collections.sort(rows, this);
    }

    private class LRUMap
    extends LinkedHashMap<Long, Object[]> {
        private static final long serialVersionUID = 1L;
        private final int maxCapacity;

        LRUMap(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Object[]> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }

    public static enum NullsOrdering {
        NULLS_FIRST,
        NULLS_LAST,
        AUTO;

    }
}

