/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;

public class AvgAggregation
extends WindowAggregation {
    private static final Date dateMeaning = new Date();
    private static final DateOnly dateOnlyMeaning = new DateOnly();
    private static final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private double sumD;
    private long cnt;
    private final Type type;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        if (schemaColumn.getType() == Type.DATE) {
            return new SchemaColumn(name, Type.DATE);
        }
        if (schemaColumn.getType() == Type.DATEONLY || schemaColumn.getType() == Type.DATETIMENOTZ) {
            return new SchemaColumn(name, Type.DATETIMENOTZ);
        }
        return new SchemaColumn(name, Type.DOUBLE);
    }

    public AvgAggregation(Column column, Column result, SchemaColumn schemaColumn) {
        super(column, result, schemaColumn, AvgAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        if (schemaColumn.getType().isNumeric()) {
            this.type = schemaColumn.getType().isFloatingPoint() ? Type.DOUBLE : Type.BIGINT;
        } else if (schemaColumn.getType() == Type.BOOLEAN) {
            this.type = Type.BOOLEAN;
        } else if (schemaColumn.getType() == Type.DATE) {
            this.type = Type.DATE;
        } else if (schemaColumn.getType() == Type.DATEONLY) {
            this.type = Type.DATEONLY;
        } else if (schemaColumn.getType() == Type.DATETIMENOTZ) {
            this.type = Type.DATETIMENOTZ;
        } else {
            throw new RuntimeException("Cannot avg non-numeric column " + column.getName() + " of type " + String.valueOf(schemaColumn.getType()));
        }
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.sumD = 0.0;
        this.cnt = 0L;
    }

    @Override
    public void expandInternal(Object value) {
        if (value != null) {
            if (this.type == Type.DOUBLE) {
                this.sumD += ((Double)value).doubleValue();
            } else if (this.type == Type.BIGINT) {
                this.sumD += (double)((Long)value).longValue();
            } else if (this.type == Type.BOOLEAN) {
                this.sumD += (Boolean)value != false ? 1.0 : 0.0;
            } else if (this.type == Type.DATE) {
                this.sumD += (double)dateMeaning.msSinceEpoch((String)value);
            } else if (this.type == Type.DATEONLY) {
                this.sumD += (double)dateOnlyMeaning.msSinceEpoch((String)value);
            } else if (this.type == Type.DATETIMENOTZ) {
                this.sumD += (double)datetimeNoTzMeaning.msSinceEpoch((String)value);
            }
            ++this.cnt;
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        if (value != null) {
            if (this.cnt == 1L) {
                this.reset();
                return;
            }
            if (this.type == Type.DOUBLE) {
                this.sumD -= ((Double)value).doubleValue();
            } else if (this.type == Type.BIGINT) {
                this.sumD -= (double)((Long)value).longValue();
            } else if (this.type == Type.BOOLEAN) {
                this.sumD -= (Boolean)value != false ? 1.0 : 0.0;
            } else if (this.type == Type.DATE) {
                this.sumD -= (double)dateMeaning.msSinceEpoch((String)value);
            } else if (this.type == Type.DATEONLY) {
                this.sumD -= (double)dateOnlyMeaning.msSinceEpoch((String)value);
            } else if (this.type == Type.DATETIMENOTZ) {
                this.sumD -= (double)datetimeNoTzMeaning.msSinceEpoch((String)value);
            }
            --this.cnt;
        }
    }

    @Override
    public Object produceValueInternal() {
        if (this.cnt == 0L) {
            return null;
        }
        if (this.type == Type.DOUBLE) {
            return this.sumD / (double)this.cnt;
        }
        if (this.type == Type.BIGINT) {
            return this.sumD / (double)this.cnt;
        }
        if (this.type == Type.BOOLEAN) {
            return this.sumD / (double)this.cnt;
        }
        if (this.type == Type.DATE) {
            long avg = (long)Math.floor(this.sumD / (double)this.cnt);
            return Date.CANONICAL_FORMATTER.print(avg) + "Z";
        }
        if (this.type == Type.DATEONLY || this.type == Type.DATETIMENOTZ) {
            long avg = (long)Math.floor(this.sumD / (double)this.cnt);
            return DatetimeNoTz.CANONICAL_FORMATTER.print(avg);
        }
        throw new RuntimeException("unreachable");
    }
}

