/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.utils.ColumnRebalanceApproximateProcessorOutput;
import com.dataiku.dip.datalayer.utils.ColumnSamplingProcessorOutput;
import com.dataiku.dip.datalayer.utils.FilterProcessorOutput;
import com.dataiku.dip.datalayer.utils.LastRecordsSamplingProcessorOutput;
import com.dataiku.dip.datalayer.utils.LimitProcessorOutput;
import com.dataiku.dip.datalayer.utils.RandomRatioSamplingProcessorOutput;
import com.dataiku.dip.datalayer.utils.ReservoirSamplingProcessorOutput;
import com.dataiku.dip.datalayer.utils.StratifiedReservoirSamplingProcessorOutput;
import com.dataiku.dip.datasets.AbstractSingleThreadPusher;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetOrdering;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.input.stream.StreamOrientedDatasetHandler;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;

public class SingleThreadPusherToMemTable
extends AbstractSingleThreadPusher {
    private DatasetSelectionToMemTable originalSelection;
    private final MemTable table;
    private ProcessorOutput finalOutput;
    private static final Logger logger = Logger.getLogger((String)"dku.input.push");

    public SingleThreadPusherToMemTable(AuthCtx authCtx, Dataset dataset, MemTable table) {
        this(authCtx, dataset, table, false);
    }

    public SingleThreadPusherToMemTable(AuthCtx authCtx, Dataset dataset, MemTable table, boolean countProcessedRows) {
        super(authCtx, dataset, table, table, countProcessedRows);
        this.table = table;
    }

    public void setDatasetSelection(DatasetSelectionToMemTable selection) throws Exception {
        this.originalSelection = selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push() throws Exception {
        assert (this.finalOutput == null);
        assert (this.originalSelection != null);
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(this.dataset);
        if (!this.originalSelection.ordering.enabled && meta.supportsReadOrdering()) {
            this.originalSelection.ordering = (DatasetOrdering)JSON.deepCopy((Object)this.dataset.getModel().readWriteOptions.defaultReadOrdering);
            logger.info((Object)("Using ordering from dataset: " + JSON.json((Object)this.originalSelection.ordering)));
        }
        this.finalOutput = new MemTableAppendingOutput(this.table);
        this.finalOutput.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
        try (DatasetHandler handler = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            boolean bl;
            FutureProgressState state;
            Object pushOutput;
            List splits;
            InputFilter ifilter = this.buildInputFilter(this.originalSelection);
            FilterProcessorOutput filterOutput = null;
            if (ifilter != null) {
                FilterResultWithSplits result = handler.getFilterSplits(ifilter);
                if (result.getSplits().isEmpty()) {
                    boolean bl2 = true;
                    return bl2;
                }
                splits = result.getSplits();
                filterOutput = this.buildUnpluggedFilterOutput(ifilter, result);
            } else if (handler instanceof RowOrientedDatasetHandler) {
                splits = Lists.newArrayList((Object[])new RowsInputSplit[]{((RowOrientedDatasetHandler)handler).getSingleSplit()});
            } else if (handler instanceof StreamOrientedDatasetHandler) {
                splits = Lists.newArrayList((Object[])new InputSplit[]{((StreamOrientedDatasetHandler)handler).getSingleSplit()});
            } else {
                throw new Error("Impossible");
            }
            ExtractionLimit pushLimit = new ExtractionLimit(this.originalSelection.maxRecords, this.originalSelection.maxReadUncompressedBytes);
            pushLimit.ordering = this.originalSelection.ordering;
            pushLimit.samplingMethod = this.originalSelection.samplingMethod;
            pushLimit.samplingRatio = this.originalSelection.targetRatio;
            pushLimit.samplingSeed = this.originalSelection.seed;
            logger.info((Object)("MSTP: push selection.method= " + String.valueOf(this.originalSelection.samplingMethod) + " records= " + this.originalSelection.maxRecords + " order=" + JSON.json((Object)pushLimit.ordering)));
            switch (this.originalSelection.samplingMethod) {
                case COLUMN_BASED: {
                    pushLimit.maxRecords = -1L;
                    ColumnSamplingProcessorOutput samplerToFinal = this.buildOutputForColumnBased(this.originalSelection, ifilter, this.finalOutput);
                    samplerToFinal.setWarningsContext(this.warningsContext);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case RANDOM_FIXED_NB: {
                    Object samplerToFinal;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        samplerToFinal = this.finalOutput;
                    } else {
                        pushLimit.maxRecords = -1L;
                        samplerToFinal = this.buildOutputForRandomNb(this.originalSelection, ifilter, this.finalOutput);
                    }
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, samplerToFinal);
                    break;
                }
                case RANDOM_FIXED_RATIO: {
                    Object samplerToFinal;
                    pushLimit.maxRecords = -1L;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        samplerToFinal = this.finalOutput;
                    } else {
                        samplerToFinal = new RandomRatioSamplingProcessorOutput(this.finalOutput, this.originalSelection.targetRatio, this.originalSelection.seed);
                    }
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, samplerToFinal);
                    break;
                }
                case HEAD_SEQUENTIAL: {
                    if (filterOutput != null) {
                        pushLimit.maxRecords = -1L;
                        filterOutput.setDownstream((ProcessorOutput)new LimitProcessorOutput(this.finalOutput, this.originalSelection.maxRecords));
                        pushOutput = filterOutput;
                        break;
                    }
                    pushOutput = this.finalOutput;
                    break;
                }
                case FULL: {
                    pushLimit.maxRecords = -1L;
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, this.finalOutput);
                    break;
                }
                case TAIL_SEQUENTIAL: {
                    pushLimit.maxRecords = -1L;
                    LastRecordsSamplingProcessorOutput processorOutput = new LastRecordsSamplingProcessorOutput(this.table, (int)this.originalSelection.maxRecords);
                    processorOutput.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, processorOutput);
                    break;
                }
                case RANDOM_FIXED_NB_EXACT: {
                    Object samplerToFinal;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        samplerToFinal = this.finalOutput;
                    } else {
                        pushLimit.maxRecords = -1L;
                        samplerToFinal = new ReservoirSamplingProcessorOutput(this.table, (int)this.originalSelection.maxRecords, this.originalSelection.seed);
                        samplerToFinal.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                    }
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, samplerToFinal);
                    break;
                }
                case RANDOM_FIXED_RATIO_EXACT: {
                    pushLimit.maxRecords = -1L;
                    if (handler.handlesSamplingMethodDuringPush(pushLimit)) {
                        this.wasSamplingPushedDownToDB = true;
                        pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, this.finalOutput);
                        break;
                    }
                    long totalRecords = SingleThreadPusherToMemTable.nbRecordsWithFilter(this.authCtx, this.dataset, ifilter);
                    int targetRecords = (int)Math.ceil(this.originalSelection.targetRatio * (double)totalRecords);
                    if (filterOutput != null) {
                        ReservoirSamplingProcessorOutput processorOutput = new ReservoirSamplingProcessorOutput(this.table, targetRecords, this.originalSelection.seed);
                        processorOutput.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                        filterOutput.setDownstream((ProcessorOutput)processorOutput);
                        pushOutput = filterOutput;
                        break;
                    }
                    pushOutput = new ReservoirSamplingProcessorOutput(this.table, (int)this.originalSelection.maxRecords, this.originalSelection.seed);
                    pushOutput.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                    break;
                }
                case STRATIFIED_TARGET_NB_EXACT: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = SingleThreadPusherToMemTable.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    StratifiedReservoirSamplingProcessorOutput reservoirsToFinal = new StratifiedReservoirSamplingProcessorOutput(this.table, this.originalSelection.column, (int)this.originalSelection.maxRecords, map, this.originalSelection.seed);
                    reservoirsToFinal.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                    reservoirsToFinal.setWarningsContext(this.warningsContext);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, (ProcessorOutput)reservoirsToFinal);
                    break;
                }
                case STRATIFIED_TARGET_RATIO_EXACT: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = SingleThreadPusherToMemTable.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    StratifiedReservoirSamplingProcessorOutput reservoirsToFinal = new StratifiedReservoirSamplingProcessorOutput(this.table, this.originalSelection.column, this.originalSelection.targetRatio, map, this.originalSelection.seed);
                    reservoirsToFinal.setMaxMemoryUsed(this.originalSelection.maxStoredBytes);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, (ProcessorOutput)reservoirsToFinal);
                    break;
                }
                case CLASS_REBALANCE_TARGET_NB_APPROX: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = SingleThreadPusherToMemTable.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    ColumnRebalanceApproximateProcessorOutput samplerToFinal = new ColumnRebalanceApproximateProcessorOutput(this.finalOutput, this.cf, this.originalSelection.column, this.originalSelection.maxRecords, map, this.originalSelection.seed);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                case CLASS_REBALANCE_TARGET_RATIO_APPROX: {
                    pushLimit.maxRecords = -1L;
                    CountMap<String> map = SingleThreadPusherToMemTable.buildCountMap(this.authCtx, this.dataset, ifilter, -1L, this.originalSelection.column);
                    ColumnRebalanceApproximateProcessorOutput samplerToFinal = new ColumnRebalanceApproximateProcessorOutput(this.finalOutput, this.cf, this.originalSelection.column, this.originalSelection.targetRatio, map, this.originalSelection.seed);
                    pushOutput = SingleThreadPusherToMemTable.filterIfNeeded(filterOutput, (ProcessorOutput)samplerToFinal);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled sampling method: " + String.valueOf(this.originalSelection.samplingMethod));
                }
            }
            if (this.originalSelection.maxRecords > 0L) {
                long maxRecords = this.originalSelection.maxRecordsForDisplay > 0L ? this.originalSelection.maxRecordsForDisplay : pushLimit.maxRecords;
                state = FutureProgress.pushState((String)"Reading records", (double)maxRecords, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);
            } else {
                state = FutureProgress.pushState((String)"Reading records", (double)-1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE);
            }
            try {
                if (this.countProcessedRows) {
                    pushOutput = new CountingProcessorOutput((ProcessorOutput)pushOutput);
                }
                boolean ret = this.pushSplits(handler, (ProcessorOutput)pushOutput, state, splits, pushLimit);
                pushOutput.lastRowEmitted();
                if (this.countProcessedRows) {
                    this.processedRowCount = ((CountingProcessorOutput)((Object)pushOutput)).getCount();
                }
                bl = ret;
            }
            catch (Throwable throwable) {
                FutureProgress.popState();
                throw throwable;
            }
            FutureProgress.popState();
            return bl;
        }
    }
}

