/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobStorageFSProvider;
import com.dataiku.dip.datasets.fs.AzureBlobStorageFSTestProvider;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DatabricksVolumeFSProvider;
import com.dataiku.dip.datasets.fs.DatabricksVolumeFSTestProvider;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.datasets.fs.FTPFSProvider;
import com.dataiku.dip.datasets.fs.GoogleCloudStorageFSProvider;
import com.dataiku.dip.datasets.fs.GoogleCloudStorageFSTestProvider;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.HTTPFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.fs.RemoteFSProvider;
import com.dataiku.dip.datasets.fs.S3FSProvider;
import com.dataiku.dip.datasets.fs.S3FSTestProvider;
import com.dataiku.dip.datasets.fs.SCPFSProvider;
import com.dataiku.dip.datasets.fs.SFTPFSProvider;
import com.dataiku.dip.datasets.fs.SharePointOnlineFSProvider;
import com.dataiku.dip.datasets.fs.SharePointOnlineFSTestProvider;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.recipes.download.DownloadRecipeSource;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class FSProviderFactory {
    private FSProviderFactory() {
    }

    public static boolean isDirectoryAware(String type) {
        switch (type) {
            case "Filesystem": 
            case "FTP": 
            case "SFTP": 
            case "SCP": 
            case "HDFS": {
                return true;
            }
        }
        return false;
    }

    public static boolean hasProvider(String type) {
        HashSet types = Sets.newHashSet();
        types.add("Filesystem");
        types.add("FTP");
        types.add("SFTP");
        types.add("SCP");
        types.add("HDFS");
        types.add("S3");
        types.add("GCS");
        types.add("Azure");
        return types.contains(type) || CustomFSProviderBuildersRegistry.has(type);
    }

    public static FSProvider getProvider(String type, AuthCtx authCtx, String projectKey, AbstractFSDatasetHandler.AbstractFSConfig params, String path, DSSConnection connection) throws IOException, CodedException, DKUSecurityException {
        switch (type) {
            case "Filesystem": {
                if (connection.name != null && connection.name.startsWith("@virtual(")) {
                    return new LocalFSProvider(connection, path);
                }
                if (ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CDE) {
                    return new RemoteFSProvider(connection, path);
                }
                return new LocalFSProvider(connection, path);
            }
            case "HTTP": {
                return new HTTPFSProvider(authCtx, path, ((DownloadRecipeSource.URLConfig)params).consider404AsEmpty, ((DownloadRecipeSource.URLConfig)params).fallbackHeadToGet, ((DownloadRecipeSource.URLConfig)params).trustAnySSLCertificate, FSProviderFactory.getProxySettings());
            }
            case "FTP": {
                return new FTPFSProvider(authCtx, connection, path, ((BuiltinFSDatasets.FTPDatasetConfig)params).timeout);
            }
            case "SFTP": {
                return new SFTPFSProvider(authCtx, connection, path, ((BuiltinFSDatasets.SFTPDatasetConfig)params).timeout);
            }
            case "SCP": {
                return new SCPFSProvider(authCtx, connection, path, ((BuiltinFSDatasets.SCPDatasetConfig)params).timeout);
            }
            case "HDFS": {
                return new HDFSProvider(authCtx, connection, path, projectKey);
            }
            case "S3": {
                EC2Connection.Params s3Params = ((EC2Connection)connection).params;
                String chbucket = s3Params.chbucket;
                String bucket = StringUtils.isNotBlank((String)chbucket) ? chbucket : ((BuiltinFSDatasets.S3DatasetConfig)params).bucket;
                return new S3FSProvider(authCtx, connection, path, bucket);
            }
            case "GCS": {
                String chbucket = ((GCSConnection)connection).params.chbucket;
                String bucket = StringUtils.isNotBlank((String)chbucket) ? chbucket : ((BuiltinFSDatasets.GCSDatasetConfig)params).bucket;
                return new GoogleCloudStorageFSProvider(authCtx, connection, path, bucket, connection.getProxySettings());
            }
            case "Azure": {
                String chcontainer = ((AzureConnection)connection).params.chcontainer;
                String container = StringUtils.isNotBlank((String)chcontainer) ? chcontainer : ((BuiltinFSDatasets.AzureBlobDatasetConfig)params).container;
                return new AzureBlobStorageFSProvider(authCtx, connection, path, container, connection.getProxySettings());
            }
            case "DatabricksVolume": {
                if (connection instanceof DatabricksConnection) {
                    connection = ((DatabricksConnection)connection).asDatabricksVolumeConnection();
                }
                DatabricksVolumeConnection.Params dbParams = ((DatabricksVolumeConnection)connection).params;
                String chvolume = dbParams.chvolume;
                String volume = StringUtils.isNotBlank((String)chvolume) ? chvolume : ((BuiltinFSDatasets.DatabricksVolumeDatasetConfig)params).volume;
                return new DatabricksVolumeFSProvider(authCtx, connection, path, volume);
            }
            case "SharePointOnline": {
                BuiltinFSDatasets.SharePointOnlineDatasetConfig config = (BuiltinFSDatasets.SharePointOnlineDatasetConfig)params;
                return new SharePointOnlineFSProvider(authCtx, connection, path, connection.getProxySettings(), config.siteId, config.site, config.driveId, config.drive);
            }
        }
        return FSProviderFactory.getPluginProvider(type, authCtx, projectKey, params, path);
    }

    private static FSProvider getPluginProvider(String type, AuthCtx authCtx, String projectKey, AbstractFSDatasetHandler.AbstractFSConfig params, String path) {
        return CustomFSProviderBuildersRegistry.get(type).build(authCtx, projectKey, params, path);
    }

    public static FSTestProvider getTestProvider(AuthCtx authCtx, String type, AbstractFSDatasetHandler.AbstractFSConfig params, DSSConnection connection) {
        switch (type) {
            case "Azure": {
                return new AzureBlobStorageFSTestProvider(authCtx, connection, params);
            }
            case "S3": {
                return new S3FSTestProvider(authCtx, connection, params);
            }
            case "GCS": {
                return new GoogleCloudStorageFSTestProvider(authCtx, connection, params);
            }
            case "DatabricksVolume": {
                if (connection instanceof DatabricksConnection) {
                    connection = ((DatabricksConnection)connection).asDatabricksVolumeConnection();
                }
                return new DatabricksVolumeFSTestProvider(authCtx, connection, params);
            }
            case "SharePointOnline": {
                return new SharePointOnlineFSTestProvider(authCtx, connection, params);
            }
        }
        return FSProviderFactory.getPluginTestProvider(type, params);
    }

    private static FSTestProvider getPluginTestProvider(String type, AbstractFSDatasetHandler.AbstractFSConfig params) {
        if (CustomFSProviderBuildersRegistry.has(type)) {
            return CustomFSProviderBuildersRegistry.get(type).buildTester(params);
        }
        throw new IllegalArgumentException("Unhandled FS type '" + type + "'");
    }

    private static ProxySettings getProxySettings() {
        return ApplicationConfigurator.getProxySettings();
    }
}

