/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;

public class HDFSProvider
extends FSLikeFSProvider
implements PathToURIConverter {
    private final HDFSConnection connection;
    private final List<SimpleKeyValue> fsExtraConf;
    private final boolean extraConfDefinesDefaultFS;
    private final String connectionRootSchemeAndAuthority;
    private final String rootPathWithinURIAuthority;
    private final Path rootPathWithinURIAuthorityPath;
    private final String hadoopUser;
    private final AuthCtx authCtx;
    private FileSystem iFS = null;
    private FileSystem niFS = null;
    private UserGroupInformation ugi = null;
    private String connectionRootWithinURIAuthority;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.hdfs");

    public HDFSProvider(AuthCtx authCtx, DSSConnection connection, String pathWithinConnectionRoot, String projectKey) throws IOException, DKUSecurityException {
        this.authCtx = authCtx;
        this.hadoopUser = this.getHadoopUser(authCtx, projectKey);
        assert (connection instanceof HDFSConnection);
        this.connection = (HDFSConnection)connection;
        this.fsExtraConf = Lists.newArrayList();
        try {
            HadoopSettings hadoopSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getHadoopSettings();
            this.fsExtraConf.addAll(hadoopSettings.extraConf.getAsSimpleKeyValueList());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get Hadoop settings:", e);
        }
        HDFSConnection.RootAndExtraConf rec = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), HDFSConnection.RootAndExtraConf.class);
        this.fsExtraConf.addAll(rec.getExtraConfAsSimpleKeyValue());
        this.extraConfDefinesDefaultFS = HDFSProvider.extraConfHasDefaultFS(this.fsExtraConf);
        try {
            URI connectionRootURI = new URI(StringUtils.defaultIfEmpty((String)rec.root, (String)""));
            this.connectionRootSchemeAndAuthority = connectionRootURI.getScheme() != null && connectionRootURI.getAuthority() != null ? connectionRootURI.getScheme() + "://" + connectionRootURI.getAuthority() : null;
            this.connectionRootWithinURIAuthority = connectionRootURI.getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot resolve connection root URI", e);
        }
        this.rootPathWithinURIAuthority = PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.connectionRootWithinURIAuthority, pathWithinConnectionRoot, false)));
        this.rootPathWithinURIAuthorityPath = new Path(this.rootPathWithinURIAuthority);
        logger.debugV("Build HDFSProvider conn=%s cpr=%s pWCR=%s crSA=%s crWSA=%s rpWSA=%s", new Object[]{connection.name, rec.root, pathWithinConnectionRoot, this.connectionRootSchemeAndAuthority, this.connectionRootWithinURIAuthority, this.rootPathWithinURIAuthority});
    }

    private static boolean extraConfHasDefaultFS(List<SimpleKeyValue> extraConf) {
        for (SimpleKeyValue p : extraConf) {
            if (!"fs.defaultFS".equals(p.key)) continue;
            return true;
        }
        return false;
    }

    private String getHadoopUser(AuthCtx authCtx, String projectKey) throws IOException {
        IImpersonationResolverService impersonationService = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
        if (impersonationService.isEnabled() && authCtx.getAuthSource() != AuthCtx.AuthSource.NONE) {
            try {
                return impersonationService.getTargetUser((String)projectKey, (AuthCtx)authCtx).hadoopUser;
            }
            catch (DKUSecurityException e) {
                throw new IOException("Failed to get hadoop user for fs-provider", e);
            }
        }
        return null;
    }

    public synchronized UserGroupInformation makeUGI() throws IOException {
        if (this.ugi == null) {
            this.ugi = this.hadoopUser != null ? UserGroupInformation.createProxyUser((String)this.hadoopUser, (UserGroupInformation)UserGroupInformation.getLoginUser()) : UserGroupInformation.getCurrentUser();
            logger.trace(() -> "Built impersonated Hadoop UGI for : " + String.valueOf(this.ugi));
        }
        return this.ugi;
    }

    public synchronized FileSystem getImpersonatedFS() throws IOException {
        if (this.iFS == null) {
            try {
                this.iFS = (FileSystem)this.makeUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws IOException {
                        FileSystem fs = HadoopLoader.getFS(HDFSProvider.this.connectionRootSchemeAndAuthority, HDFSProvider.this.fsExtraConf);
                        logger.debug((Object)("Built Hadoop FS for: " + HDFSProvider.this.connectionRootSchemeAndAuthority + " -> " + String.valueOf(fs)));
                        return fs;
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Could not get impersonated FS", e);
            }
        }
        return this.iFS;
    }

    private synchronized FileSystem getNonImpersonatedFS() throws IOException {
        if (this.niFS == null) {
            this.niFS = HadoopLoader.getFS(this.connectionRootSchemeAndAuthority, this.fsExtraConf);
        }
        return this.niFS;
    }

    public String getRootPathUri() {
        return this.connectionRootSchemeAndAuthority;
    }

    public List<SimpleKeyValue> getFSExtraConf() {
        return this.fsExtraConf;
    }

    public Configuration setupHadoopConf(boolean keepDefaultFS) {
        Configuration conf = new Configuration();
        this.addExtraConf(conf, keepDefaultFS);
        return conf;
    }

    public JobConf setupHadoopJobConf(boolean keepDefaultFS) {
        JobConf conf = new JobConf();
        this.addExtraConf((Configuration)conf, keepDefaultFS);
        return conf;
    }

    public void addExtraConf(Configuration conf, boolean keepDefaultFS) {
        if (StringUtils.isNotBlank((String)this.connectionRootSchemeAndAuthority) && !"/".equals(this.connectionRootSchemeAndAuthority)) {
            for (SimpleKeyValue extra : this.fsExtraConf) {
                conf.set(extra.key, extra.value);
            }
            if (!keepDefaultFS) {
                conf.set("fs.defaultFS", this.connectionRootSchemeAndAuthority);
            }
        } else if (this.extraConfDefinesDefaultFS) {
            for (SimpleKeyValue extra : this.fsExtraConf) {
                conf.set(extra.key, extra.value);
            }
        }
    }

    private Path getPathInsideRoot(String path) {
        String fullPath = PathUtils.concatLNT((String[])new String[]{this.rootPathWithinURIAuthority, path});
        return new Path(fullPath);
    }

    public void close() {
        if (this.iFS != null) {
            this.iFS = null;
        }
    }

    public boolean allowsWrite() {
        return this.connection.allowWrite;
    }

    public HDFSConnection.ClearMode getClearMode() {
        Preconditions.checkNotNull((Object)this.connection, (Object)"Connection is null");
        Preconditions.checkNotNull((Object)this.connection.params, (Object)"Connection params is null");
        Preconditions.checkArgument((this.connection.params.clearMode != null ? 1 : 0) != 0, (Object)"Connection clear mode is not specified");
        return this.connection.params.clearMode;
    }

    public FileSystem getFSForClearMode() throws IOException {
        switch (this.getClearMode()) {
            case IMPERSONATED_NO_SETACL: {
                return this.getImpersonatedFS();
            }
            case DSS_USER: {
                return this.getNonImpersonatedFS();
            }
        }
        throw new Error("unreachable");
    }

    public HDFSConnection.ACLSynchronizationMode getAclSynchronizationMode() {
        Preconditions.checkNotNull((Object)this.connection, (Object)"Connection is null");
        Preconditions.checkNotNull((Object)this.connection.params, (Object)"Connection params is null");
        Preconditions.checkArgument((this.connection.params.clearMode != null ? 1 : 0) != 0, (Object)"Connection clear mode is not specified");
        return this.connection.params.aclSynchronizationMode;
    }

    public FileSystem getFSForAclSynchronizationMode() throws IOException {
        switch (this.getAclSynchronizationMode()) {
            case NONE: {
                logger.info((Object)"ACL synchronization disabled, noop");
                return null;
            }
            case SUBDIRECTORY: {
                return this.getNonImpersonatedFS();
            }
        }
        throw new Error("unreachable");
    }

    public String getPath(String pathInDataset) {
        return PathUtils.concatLNT((String[])new String[]{this.rootPathWithinURIAuthority, pathInDataset});
    }

    public void mkdirs(String path) throws DKUSecurityException, IOException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        Path fullPath = this.getPathInsideRoot(path);
        this.getImpersonatedFS().mkdirs(fullPath);
    }

    public void makeEmpty(String path) throws IOException, DKUSecurityException {
        logger.info((Object)("Make '" + path + "' empty"));
        PathUtils.ensurePathStaysWithinRoot((String)path);
        FileSystem fs = this.getImpersonatedFS();
        Path fullPath = this.getPathInsideRoot(path);
        logger.info((Object)("Make empty " + path + " -> " + String.valueOf(fullPath)));
        if (fs.exists(fullPath)) {
            if (fs.isFile(fullPath)) {
                logger.info((Object)"Exists : clean file");
                fs.create(fullPath, true).close();
            } else {
                logger.info((Object)"Exists : clean dir");
                this.deleteRecursive(path);
                fs.mkdirs(fullPath);
            }
        } else {
            logger.info((Object)"Doesn't exist : create dir");
            fs.mkdirs(fullPath);
        }
    }

    public void ensureDirectory(String path) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        FileSystem fs = this.getImpersonatedFS();
        Path fullPath = this.getPathInsideRoot(path);
        if (fs.exists(fullPath) && fs.isFile(fullPath)) {
            throw new IOException("Cannot make directory, '" + path + "' is a file");
        }
        fs.mkdirs(fullPath);
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return this.connectionRootWithinURIAuthority;
    }

    @Override
    public String getRoot() {
        return this.rootPathWithinURIAuthority;
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) {
        HashMap ret = Maps.newHashMap();
        ret.put("root", this.rootPathWithinURIAuthority);
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            ret.put("hadoopUser", this.hadoopUser);
        }
        return ret;
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        Path pathToBrowse = this.getPathInsideRoot(prefix);
        logger.infoV("Browsing HDFS prefix=%s connectionRoot=%s fullPath=%s strategy=%s", new Object[]{prefix, this.rootPathWithinURIAuthority, pathToBrowse, strategy.name()});
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)prefix, (boolean)false);
        FileSystem fs = this.getImpersonatedFS();
        if (fs.exists(pathToBrowse)) {
            if (fs.isFile(pathToBrowse) && (strategy == FSProvider.FSBrowseStrategy.FILE || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY)) {
                FileStatus fileStatus = fs.getFileStatus(pathToBrowse);
                ret.exists = true;
                ret.size = fileStatus.getLen();
                ret.directory = false;
                ret.name = !ret.pathElts.isEmpty() ? (String)ret.pathElts.get(ret.pathElts.size() - 1) : null;
                ret.lastModified = fileStatus.getModificationTime();
                return ret;
            }
            if (fs.isDirectory(pathToBrowse) && (strategy == FSProvider.FSBrowseStrategy.DIRECTORY || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY)) {
                int enumerationLimit;
                ret.exists = true;
                ret.directory = true;
                FileStatus[] fileStatuses = fs.listStatus(pathToBrowse);
                if (fileStatuses.length > (enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000)))) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this HDFS location (> %d). Enumeration aborted.", enumerationLimit));
                }
                for (FileStatus fp : fileStatuses) {
                    String fullPath = PathUtils.concatLNT((String[])new String[]{prefix, fp.getPath().getName()});
                    ret.children.add(FSBrowsePath.makeChild((String)fp.getPath().getName(), (List)ret.pathElts, (String)fullPath, (boolean)fp.isDirectory(), (long)fp.getLen(), (long)fp.getModificationTime(), (boolean)false));
                }
                return ret;
            }
        }
        return new FSBrowsePath();
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, enumerationSettings);
            if (paths == null) {
                return HDFSEnumerationResult.fromNonExistingPrefix();
            }
            return HDFSEnumerationResult.fromPaths(enumerationSettings.filter(paths));
        }
        catch (Exception e) {
            return HDFSEnumerationResult.fromError(e);
        }
    }

    private void recurseBreadthFirst(FileSystem fs, FileStatus[] curContent, int depth, BreadthFirstVisitor visitor, Path datasetRootPath, FSEnumerationSettings enumerationSettings) throws IOException {
        assert (curContent != null);
        logger.infoV("HDFS-enumerate depth=%d curContent=%d", new Object[]{depth, curContent.length});
        ArrayList<Path> subfolders = new ArrayList<Path>();
        for (FileStatus cur : curContent) {
            String fileName = cur.getPath().getName();
            if (FSDatasetUtils.isBadFile(fileName, enumerationSettings.showHiddenFiles)) continue;
            String filePathInDS = cur.getPath().toString().replace(datasetRootPath.toString(), "");
            if ("".equals(filePathInDS)) {
                filePathInDS = "/";
            }
            if (FSDatasetUtils.isBadPath(filePathInDS)) continue;
            if (!visitor.visit(cur)) {
                return;
            }
            if (!cur.isDirectory() || enumerationSettings.selectionRules.excludesPrefix(PathUtils.slashes((String)filePathInDS, (Boolean)false, (Boolean)false, (boolean)true, (String)""))) continue;
            subfolders.add(cur.getPath());
        }
        if (!subfolders.isEmpty()) {
            logger.infoV("HDFS-enumerate: depth=%d recursing on %d subfolders", new Object[]{depth, subfolders.size()});
            long before = System.currentTimeMillis();
            FileStatus[] subfolderContents = fs.listStatus(subfolders.toArray(new Path[0]));
            long after = System.currentTimeMillis();
            logger.infoV("HDFS-enumerated: depth=%d enumerated %d subfolders in %d ms, got %d entries", new Object[]{depth, subfolders.size(), after - before, subfolderContents.length});
            this.recurseBreadthFirst(fs, subfolderContents, depth + 1, visitor, datasetRootPath, enumerationSettings);
        }
    }

    private List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException {
        FileSystem fs = this.getImpersonatedFS();
        Path requiredEnumerationRootPath = this.getPathInsideRoot(prefix);
        logger.info((Object)("Enumerating HDFS Filesystem from root : " + requiredEnumerationRootPath.toString()));
        Path datasetRootPath = null;
        Path enumerationRootPath = null;
        FileStatus[] enumerationRootContent = null;
        try {
            FileStatus rootStatus = fs.getFileStatus(requiredEnumerationRootPath);
            if (rootStatus.isFile()) {
                datasetRootPath = fs.getFileStatus(this.rootPathWithinURIAuthorityPath).getPath();
                String filePathInDS = rootStatus.getPath().toString().replace(datasetRootPath.toString(), "");
                if ("".equals(filePathInDS)) {
                    filePathInDS = "/";
                }
                return Lists.newArrayList((Object[])new FSPath[]{new FSPath(filePathInDS, rootStatus.getLen(), rootStatus.getModificationTime())});
            }
            enumerationRootPath = rootStatus.getPath();
            enumerationRootContent = fs.listStatus(enumerationRootPath);
            if (enumerationRootContent == null) {
                return null;
            }
            datasetRootPath = fs.getFileStatus(this.rootPathWithinURIAuthorityPath).getPath();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        PathCollector visitor = new PathCollector(datasetRootPath, enumerationSettings);
        this.recurseBreadthFirst(fs, enumerationRootContent, 0, visitor, datasetRootPath, enumerationSettings);
        logger.infoV("Done HDFS enumeration: nb_paths=%d total_size=%d", new Object[]{visitor.paths.size(), FSDatasetUtils.totalSize(visitor.paths)});
        return visitor.paths;
    }

    public FSPathOrDirectory stat(String path) throws IOException, DKUSecurityException {
        Path datasetRootPath;
        Path fullPath;
        FileSystem fs;
        block10: {
            PathUtils.ensurePathStaysWithinRoot((String)path);
            fs = this.getImpersonatedFS();
            fullPath = this.getPathInsideRoot(path);
            if (StringUtils.isNotBlank((String)path) && !"/".equals(PathUtils.canonical((String)path))) {
                try {
                    datasetRootPath = fs.getFileStatus(this.rootPathWithinURIAuthorityPath).getPath();
                    if (datasetRootPath == null) {
                        throw new FileNotFoundException();
                    }
                    break block10;
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)("Dataset root path does not exist : " + String.valueOf(this.rootPathWithinURIAuthorityPath)));
                    return null;
                }
            }
            datasetRootPath = null;
        }
        FileStatus status = null;
        try {
            status = fs.getFileStatus(fullPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (status == null) {
            return null;
        }
        logger.traceV("status path=%s datasetPath=%s", new Object[]{status.getPath().toString(), datasetRootPath});
        if (datasetRootPath == null) {
            return new FSPathOrDirectory("/", status.getLen(), status.getModificationTime(), status.isDirectory());
        }
        Object filePathInDataset = status.getPath().toString().replace(datasetRootPath.toString(), "");
        if ("".equals(filePathInDataset)) {
            filePathInDataset = "/";
        }
        if (!((String)filePathInDataset).startsWith("/")) {
            filePathInDataset = "/" + (String)filePathInDataset;
        }
        return new FSPathOrDirectory((String)filePathInDataset, status.getLen(), status.getModificationTime(), status.isDirectory());
    }

    public EnrichedInputStream read(String path) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        Path fullPath = this.getPathInsideRoot(path);
        FileSystem fs = this.getImpersonatedFS();
        FileStatus status = fs.getFileStatus(fullPath);
        if (status == null) {
            throw new IOException("File '" + path + "' doesn't exist");
        }
        return new HDFSInputStream(this.ugi, this.connectionRootSchemeAndAuthority, this.fsExtraConf, fs, status, fullPath, path, fullPath.getName(), fullPath.toString());
    }

    public OutputStream write(String path) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)path);
        FileSystem fs = this.getImpersonatedFS();
        return fs.create(this.getPathInsideRoot(path), true);
    }

    public void deleteRecursive(String path) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)path);
        FileSystem fs = this.getFSForClearMode();
        Path fullPath = this.getPathInsideRoot(path);
        logger.info((Object)("delete recursive " + path + " -> " + String.valueOf(fullPath)));
        FileStatus status = fs.getFileStatus(fullPath);
        if (status == null) {
            throw new FileNotFoundException("Cannot find '" + path + "' to delete");
        }
        if (fullPath.getParent() == null) {
            throw new IOException("Safety guard: cannot recursively delete the HDFS root");
        }
        logger.info((Object)("is a directory " + status.isDirectory()));
        RemoteIterator it = fs.listFiles(fullPath, true);
        while (it.hasNext()) {
            LocatedFileStatus descendantStatus = (LocatedFileStatus)it.next();
            if (fs.delete(descendantStatus.getPath(), true)) continue;
            throw new IOException("Unable to delete directory " + descendantStatus.toString() + " on HDFS");
        }
        if (status.isDirectory() && !fs.delete(status.getPath(), true)) {
            throw new IOException("Unable to delete directory " + status.toString() + " on HDFS");
        }
        try {
            status = fs.getFileStatus(fullPath);
            logger.info((Object)("after delete " + (String)(status == null ? "gone" : "" + status.isDirectory())));
        }
        catch (Exception e) {
            logger.info((Object)("after delete " + e.getMessage()));
        }
    }

    private void rename(String from, String to) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        FileSystem fs = this.getImpersonatedFS();
        FSDatasetUtils.checkDestPathDoesNotExist(to, this.stat(to));
        this.ensureDirectory(PathUtils.getParent((String)to));
        if (!fs.rename(this.getPathInsideRoot(from), this.getPathInsideRoot(to))) {
            throw new IOException("Renaming failed, but I don't know why");
        }
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    private void checkConnectionWritability() {
        if (!this.connection.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.connection.name);
        }
    }

    public void setLastModified(String path, long lastModified) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)path);
        Path fullPath = this.getPathInsideRoot(path);
        FileSystem fs = this.getImpersonatedFS();
        fs.setTimes(fullPath, lastModified, lastModified);
    }

    public String convertPathToURI(String path) {
        StringBuilder uri = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.connectionRootSchemeAndAuthority)) {
            uri.append(this.connectionRootSchemeAndAuthority);
        } else {
            uri.append("hdfs://");
        }
        String fullPathOnFs = PathUtils.concatLNT((String[])new String[]{this.rootPathWithinURIAuthority, path});
        uri.append(fullPathOnFs);
        return uri.toString();
    }

    static class HDFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public HDFSEnumerationResult() {
        }

        public HDFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public HDFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static HDFSEnumerationResult fromError(Throwable error) {
            return new HDFSEnumerationResult(error);
        }

        private static HDFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new HDFSEnumerationResult(paths);
        }

        private static HDFSEnumerationResult fromNonExistingPrefix() {
            return new HDFSEnumerationResult();
        }
    }

    private static interface BreadthFirstVisitor {
        public boolean visit(FileStatus var1) throws CodedIOException;
    }

    private static class PathCollector
    implements BreadthFirstVisitor {
        private final List<FSPath> paths = Lists.newArrayList();
        private long totalSize = 0L;
        private final Path datasetRootPath;
        private final FSEnumerationSettings enumerationSettings;

        public PathCollector(Path datasetRootPath, FSEnumerationSettings enumerationSettings) {
            this.datasetRootPath = datasetRootPath;
            this.enumerationSettings = enumerationSettings;
        }

        @Override
        public boolean visit(FileStatus status) throws CodedIOException {
            if (!status.isDirectory()) {
                Object filePathInDS = status.getPath().toString().replace(this.datasetRootPath.toString(), "");
                if ("".equals(filePathInDS)) {
                    filePathInDS = "/";
                }
                if (!((String)filePathInDS).startsWith("/")) {
                    filePathInDS = "/" + (String)filePathInDS;
                }
                boolean accept = true;
                if (this.enumerationSettings.firstNonEmpty) {
                    accept = status.getLen() > 0L;
                }
                boolean bl = accept = accept && this.enumerationSettings.selectionRules.includes(PathUtils.slashes((String)filePathInDS, (Boolean)false, (Boolean)false, (boolean)true, (String)""));
                if (accept) {
                    int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
                    if (this.paths.size() + 1 > enumerationLimit) {
                        throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this HDFS location (> %d). Enumeration aborted.", enumerationLimit));
                    }
                    this.paths.add(new FSPath((String)filePathInDS, status.getLen(), status.getModificationTime()));
                    this.totalSize += status.getLen();
                }
            }
            return !this.enumerationSettings.shouldStopEnumeration(this.paths, this.totalSize);
        }
    }

    public static class HDFSInputStream
    extends AutoEnrichedInputStream {
        private final Path fsPath;
        private final FileSystem fs;
        private final UserGroupInformation ugi;
        private final List<SimpleKeyValue> fsExtraConf;
        private final String rootPathUri;
        private final boolean extraConfDefinesDefaultFS;

        public HDFSInputStream(UserGroupInformation ugi, String rootPathUri, List<SimpleKeyValue> fsExtraConf, FileSystem fs, FileStatus status, Path fsPath, String pathWithinProvider, String filename, String desc) {
            super(status.getLen(), pathWithinProvider, filename, desc, () -> ((FileStatus)status).getModificationTime());
            this.ugi = ugi;
            this.fs = fs;
            this.rootPathUri = rootPathUri;
            this.fsExtraConf = fsExtraConf;
            this.fsPath = fsPath;
            this.extraConfDefinesDefaultFS = HDFSProvider.extraConfHasDefaultFS(this.fsExtraConf);
        }

        protected InputStream getBasicInputStream() throws IOException, InterruptedException {
            return new AbortingStream((InputStream)this.fs.open(this.fsPath));
        }

        public Path getFSPath() {
            return this.fsPath;
        }

        public FileSystem getFS() {
            return this.fs;
        }

        public UserGroupInformation getUGI() {
            return this.ugi;
        }

        public String getRootPathUri() {
            return this.rootPathUri;
        }

        public List<SimpleKeyValue> getFSExtraConf() {
            return this.fsExtraConf;
        }

        public Configuration setupHadoopConf(boolean keepDefaultFS) {
            Configuration conf = new Configuration();
            if (StringUtils.isNotBlank((String)this.rootPathUri) && !"/".equals(this.rootPathUri)) {
                for (SimpleKeyValue extra : this.fsExtraConf) {
                    conf.set(extra.key, extra.value);
                }
                if (!keepDefaultFS) {
                    conf.set("fs.defaultFS", this.rootPathUri);
                }
            } else if (this.extraConfDefinesDefaultFS) {
                for (SimpleKeyValue extra : this.fsExtraConf) {
                    conf.set(extra.key, extra.value);
                }
            }
            return conf;
        }

        public JobConf setupHadoopJobConf(boolean keepDefaultFS) {
            JobConf conf = new JobConf();
            if (StringUtils.isNotBlank((String)this.rootPathUri) && !"/".equals(this.rootPathUri)) {
                for (SimpleKeyValue extra : this.fsExtraConf) {
                    conf.set(extra.key, extra.value);
                }
                if (!keepDefaultFS) {
                    conf.set("fs.defaultFS", this.rootPathUri);
                }
            } else if (this.extraConfDefinesDefaultFS) {
                for (SimpleKeyValue extra : this.fsExtraConf) {
                    conf.set(extra.key, extra.value);
                }
            }
            return conf;
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, InterruptedException {
            return new AbortingStream((InputStream)this.fs.open(this.fsPath));
        }
    }

    private static class AbortingStream
    extends InputStream {
        private InputStream stream;

        AbortingStream(final InputStream stream) {
            this.stream = stream;
            FutureAborter.pushHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info((Object)"Closing HDFS stream to abort reading from it.");
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to close stream while aborting", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public void close() throws IOException {
            FutureAborter.popHook();
            this.stream.close();
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }
    }
}

