/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SQLTableOutput
implements Output,
CanShareSQLConnection {
    private AbstractSQLTableDatasetHandler handler;
    private Dataset dataset;
    private final Partition targetPartition;
    private WarningsContext warningsContext;
    private final Map<String, String> targetPartitionValues = Maps.newHashMap();
    private CanShareSQLConnection.SQLConnectionShare connectionShare = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.output.sql");

    public SQLTableOutput(AbstractSQLTableDatasetHandler handler, Dataset outputDataset, Partition targetPartition, WarningsContext warningsContext) throws Exception {
        this.handler = handler;
        this.warningsContext = warningsContext;
        assert (DatasetInspector.isSQL(outputDataset));
        if (outputDataset.getSchema() == null) {
            throw ErrorContext.iaef((String)"Cannot write to a SQLTable dataset with no schema: %s", (Object)outputDataset.getName(), (Object[])new Object[0]);
        }
        if (handler.getResolvedAbstractConfig().mode.equals("query")) {
            throw ErrorContext.iaef((String)"Cannot write to a SQL dataset in 'query' mode: %s", (Object)outputDataset.getName(), (Object[])new Object[0]);
        }
        this.dataset = outputDataset;
        this.targetPartition = targetPartition;
        if (targetPartition != null && targetPartition.getDimensionValues().size() > 0) {
            for (String dimensionName : this.dataset.getPartitioningSchema().getDimensionNames()) {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                if (dimensionValue == null) {
                    this.targetPartitionValues.put(dimensionName, null);
                    continue;
                }
                SchemaColumn partitionColumn = this.dataset.getSchema().getColumn(dimensionName);
                if (partitionColumn == null) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset '" + this.dataset.getName() + "' does not contain the partitioning column: " + dimensionName);
                }
                Type partitionColumnType = partitionColumn.getType();
                this.targetPartitionValues.put(dimensionName, ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType));
            }
        }
    }

    @Override
    public void shareSQLConnection(CanShareSQLConnection.SQLConnectionShare share) throws DKUSecurityException {
        this.connectionShare = share;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        try {
            CanShareSQLConnection.SQLConnectionShare connectionShareToUse = this.connectionShare == null ? new CanShareSQLConnection.SQLConnectionShare(this.handler.getConnectionData()) : this.connectionShare;
            return new SQLTableOutputWriter(mode, connectionShareToUse);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public class SQLTableOutputWriter
    extends OutputWriter {
        SQLConnectionProvider.SQLConnectionWrapper conn;
        PreparedStatement ps;
        private Output.WriteMode mode;
        private AbstractSQLDatasetHandler.AbstractSQLConfig config;
        private CanShareSQLConnection.SQLConnectionShare connectionShare;
        private List<Column> columns = new ArrayList<Column>();
        private List<Type> types = new ArrayList<Type>();
        private Map<Integer, String> partitioningColumnIndices = Maps.newHashMap();
        private boolean supportBatchUpdates = true;
        private SQLDialect dialect;
        private ComputeResourceUsage cru;
        private List<String[]> rows;
        private String sql;
        int totalRows = 0;
        int failedRows = 0;
        int rowsWithFailedCells = 0;
        int rowsInBatch = 0;

        public SQLTableOutputWriter(Output.WriteMode mode, CanShareSQLConnection.SQLConnectionShare connectionShare) throws SQLException {
            this.mode = mode;
            this.connectionShare = connectionShare;
            this.config = SQLTableOutput.this.dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        }

        public void init(ColumnFactory cf) throws Exception {
            HashSet partitioningColumnNames = Sets.newHashSet();
            if (SQLTableOutput.this.dataset.getPartitioningSchema().isPartitioned()) {
                partitioningColumnNames.addAll(SQLTableOutput.this.dataset.getPartitioningSchema().getDimensionNames());
            }
            for (SchemaColumn sc : SQLTableOutput.this.dataset.getSchema().getColumns()) {
                if (partitioningColumnNames.contains(sc.getName())) {
                    this.partitioningColumnIndices.put(this.columns.size(), sc.getName());
                }
                this.columns.add(cf.column(sc.getName()));
                this.types.add(sc.getType());
            }
            SQLConnectionProvider.SQLConnectionData connData = this.connectionShare.getConnectionData();
            this.conn = this.connectionShare.take(SQLTableOutput.this.handler.getAuthCtx(), SQLTableOutput.this.handler.getDataset().getProjectKey());
            this.dialect = connData.getDialect();
            this.supportBatchUpdates = this.dialect.supportsBatchUpdates(connData) && this.conn.getMetaData().supportsBatchUpdates();
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            this.dialect.dropIfNeededAndCreateTableOrPartition(SQLTableOutput.this.handler.getAuthCtx(), connData, this.conn, SQLTableOutput.this.dataset, SQLTableOutput.this.targetPartition, this.mode, messages);
            if (!messages.isEmpty()) {
                SQLTableOutput.this.warningsContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            if (!this.config.supportsInsertWithPreparedStatement() || !this.dialect.supportsInsertWithPreparedStatement(connData)) {
                this.rows = new ArrayList<String[]>();
            }
            SQLUtils.executePreWriteStatements(connData, this.conn, SQLTableOutput.this.dataset);
            this.sql = AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrNull(SQLTableOutput.this.dataset.getModel().dkuProperties, "write.forced_statement");
            if (StringUtils.isBlank((String)this.sql)) {
                this.sql = this.dialect.getInsertStatementSQL(SQLTableOutput.this.handler.getResolvedAbstractConfig().catalog, SQLTableOutput.this.handler.getResolvedAbstractConfig().schema, SQLTableOutput.this.handler.getResolvedAbstractConfig().table, SQLTableOutput.this.dataset.getSchema().getColumns());
            }
            this.ps = this.conn.prepareStatement(this.sql);
            this.cru = SQLComputeResourceUsage.startSQLQuery(this.conn, this.sql, true);
        }

        public void emitRow(Row row) throws Exception {
            SQLException cur;
            boolean rowFailed = false;
            boolean rowHasFailedCells = false;
            SQLConnectionProvider.SQLConnectionData connData = SQLTableOutput.this.handler.getConnectionData();
            this.cru.setUpdateCheckingIfMissing(SQLComputeResourceUsage.getUpdateChecking());
            String[] rowCols = this.config.supportsInsertWithPreparedStatement() && this.dialect.supportsInsertWithPreparedStatement(connData) ? null : new String[SQLTableOutput.this.dataset.getSchema().getColumns().size()];
            for (int i = 0; i < SQLTableOutput.this.dataset.getSchema().getColumns().size(); ++i) {
                String value;
                if (this.partitioningColumnIndices.containsKey(i)) {
                    assert (SQLTableOutput.this.targetPartition.getScheme().isPartitioned());
                    String partitionVal = SQLTableOutput.this.targetPartitionValues.get(this.partitioningColumnIndices.get(i));
                    this.dialect.fill(this.ps, this.types.get(i), i + 1, partitionVal);
                    value = partitionVal;
                } else {
                    value = row.get(this.columns.get(i));
                    if (value == null || value.isEmpty()) {
                        this.dialect.fillWithEmpty(this.ps, SQLTableOutput.this.dataset, this.types.get(i), i + 1);
                    } else {
                        try {
                            this.dialect.fill(this.ps, this.types.get(i), i + 1, value);
                        }
                        catch (Exception e) {
                            String error = String.format("Failed sending SQL data: column=%s type=%s val=%s err=%s", this.columns.get(i).getName(), this.types.get(i), value, ExceptionUtils.getMessageWithCauses((Throwable)e));
                            WarningsContext.WarningType wt = null;
                            switch (this.types.get(i)) {
                                case TINYINT: 
                                case SMALLINT: 
                                case INT: 
                                case BIGINT: {
                                    wt = WarningsContext.WarningType.OUTPUT_DATA_BAD_INT;
                                    break;
                                }
                                case ARRAY: 
                                case MAP: 
                                case STRING: 
                                case GEOMETRY: 
                                case GEOPOINT: 
                                case OBJECT: {
                                    wt = WarningsContext.WarningType.OUTPUT_DATA_SQL_BAD_DATA;
                                    break;
                                }
                                case BOOLEAN: {
                                    wt = WarningsContext.WarningType.OUTPUT_DATA_BAD_BOOLEAN;
                                    break;
                                }
                                case DATE: 
                                case DATEONLY: 
                                case DATETIMENOTZ: {
                                    wt = WarningsContext.WarningType.OUTPUT_DATA_BAD_DATE;
                                    break;
                                }
                                case DOUBLE: 
                                case FLOAT: {
                                    wt = WarningsContext.WarningType.OUTPUT_DATA_BAD_FLOAT;
                                }
                            }
                            SQLTableOutput.this.warningsContext.addWarning(wt, error, logger);
                            if (this.config.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_CELL) {
                                rowHasFailedCells = true;
                            }
                            if (this.config.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_ROW) {
                                rowFailed = true;
                                break;
                            }
                            throw new IllegalArgumentException(error, e);
                        }
                    }
                }
                if (rowCols == null) continue;
                rowCols[i] = value == null ? null : this.dialect.getValueAsSQLString(this.types.get(i), value);
            }
            if (rowCols != null) {
                this.rows.add(rowCols);
            }
            if (!this.supportBatchUpdates) {
                try {
                    logger.info((Object)"Database does not support batch operation. Inserting single row.");
                    this.executeQuery(connData, false);
                    this.ps.clearParameters();
                }
                catch (SQLException e) {
                    logger.error((Object)"Encountered SQL exception", (Throwable)e);
                    for (cur = e.getNextException(); cur != null; cur = cur.getNextException()) {
                        logger.error((Object)"Nested exception", (Throwable)cur);
                    }
                    throw e;
                }
            }
            if (!rowFailed) {
                ++this.rowsInBatch;
                this.ps.addBatch();
            } else {
                ++this.failedRows;
                this.ps.clearParameters();
            }
            if (rowHasFailedCells) {
                ++this.rowsWithFailedCells;
            }
            ++this.totalRows;
            try {
                if (this.totalRows % this.config.writeInsertBatchSize == 0) {
                    logger.info((Object)"Executing SQL insert batch ...");
                    this.executeQuery(connData, true);
                    this.ps.clearBatch();
                    this.cru.updateInsertedRowCountAndCheck((long)this.totalRows);
                    this.rowsInBatch = 0;
                    logger.info((Object)"SQL insert batch done");
                    if (connData.getType() == ConnectionUtils.SQLConnectionType.TERADATA) {
                        logger.info((Object)"Doing partial Teradata commit to avoid error 9128");
                        this.conn.commit();
                    }
                    logger.info((Object)("appended " + this.totalRows + " rows, failedRows=" + this.failedRows + " rowsWithFailedCells=" + this.rowsWithFailedCells));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Encountered SQL exception", (Throwable)e);
                for (cur = e.getNextException(); cur != null; cur = cur.getNextException()) {
                    logger.error((Object)"Nested exception", (Throwable)cur);
                }
                throw e;
            }
        }

        private void executeQuery(SQLConnectionProvider.SQLConnectionData connData, boolean isBatched) throws SQLException {
            if (this.config.supportsInsertWithPreparedStatement() && this.dialect.supportsInsertWithPreparedStatement(connData)) {
                if (isBatched) {
                    this.ps.executeBatch();
                } else {
                    this.ps.execute();
                }
            } else {
                try (Statement stmt = this.conn.createStatement();){
                    String equivalentSQL = this.buildSQLInsertQuery(this.rows);
                    stmt.execute(equivalentSQL);
                }
                this.rows.clear();
            }
        }

        public void lastRowEmitted() throws Exception {
            logger.info((Object)("committing, appended " + this.totalRows + " failedRows=" + this.failedRows + " rowsWithFailedCells=" + this.rowsWithFailedCells));
            if (this.failedRows > 0) {
                logger.warn((Object)("Errors were encountered on " + this.failedRows + " rows"));
            }
            try {
                if (this.ps != null) {
                    if (this.rowsInBatch > 0) {
                        try {
                            logger.info((Object)"Executing final batch");
                            this.executeQuery(SQLTableOutput.this.handler.getConnectionData(), true);
                            logger.info((Object)"Executed final batch");
                        }
                        catch (SQLException e) {
                            logger.error((Object)"Encountered SQL exception", (Throwable)e);
                            for (SQLException cur = e.getNextException(); cur != null; cur = cur.getNextException()) {
                                logger.error((Object)"Nested exception", (Throwable)cur);
                            }
                            throw e;
                        }
                    }
                    this.ps.close();
                    this.ps = null;
                }
                if (this.conn != null) {
                    SQLConnectionProvider.SQLConnectionData connData = SQLTableOutput.this.handler.getConnectionData();
                    if (connData.getType() == ConnectionUtils.SQLConnectionType.TERADATA) {
                        logger.info((Object)"Doing partial Teradata commit before post-write statements");
                        this.conn.commit();
                    }
                    SQLUtils.executePostWriteStatements(connData, this.conn, SQLTableOutput.this.dataset);
                    this.connectionShare.give(false);
                    this.conn = null;
                }
            }
            finally {
                this.cru.reportCompleteWithRowCount((long)this.totalRows);
            }
            logger.info((Object)"Transaction done");
        }

        public void cancel() throws Exception {
            if (this.cru != null) {
                this.cru.reportCompleteNoFail();
            }
            logger.info((Object)"Aborting transaction");
            if (this.ps != null) {
                this.ps.close();
                this.ps = null;
            }
            if (this.conn != null) {
                this.connectionShare.give(true);
                this.conn = null;
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }

        private String buildSQLInsertQuery(List<String[]> rows) {
            String[] templateParts = this.sql.split("VALUES");
            StringBuilder queryBuilder = new StringBuilder(templateParts[0]);
            queryBuilder.append("VALUES ");
            for (int i = 0; i < rows.size(); ++i) {
                String[] row = rows.get(i);
                queryBuilder.append("(");
                for (int j = 0; j < row.length; ++j) {
                    queryBuilder.append(this.dialect.appendLiteralForInsertStatementFromValueAsSQLString(this.types.get(j), row[j]));
                    if (j >= row.length - 1) continue;
                    queryBuilder.append(", ");
                }
                queryBuilder.append(")");
                if (i >= rows.size() - 1) continue;
                queryBuilder.append(", ");
            }
            logger.trace(() -> "Manual insert : " + queryBuilder.toString());
            return queryBuilder.toString();
        }
    }
}

