/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datastory;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datastory.PowerslideClient;
import com.dataiku.dip.datastory.StoryIntegrationCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.workspaces.Workspace;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatastoryIntegrationService {
    @Autowired
    private PublicAPIKeysService publicApiKeysService;
    public static final String DATASTORY_LABEL = "story";
    public static final String DATASTORY_REQUESTED_BY = "story";
    private static final Logger logger = Logger.getLogger(DatastoryIntegrationService.class);

    public String create(AuthCtx authCtx, Workspace workspace, Workspace.Story story) throws IOException, ApplicativeException {
        try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
            String string = powerSlideClient.createStory(workspace, story);
            return string;
        }
    }

    public String duplicate(AuthCtx authCtx, Workspace workspace, String dataStoryId, @Nullable String newTitle) throws IOException, ApplicativeException {
        try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
            String string = powerSlideClient.duplicateStory(workspace, dataStoryId, newTitle);
            return string;
        }
    }

    public void update(AuthCtx authCtx, Workspace workspace, Workspace.Story story) throws IOException, ApplicativeException {
        try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
            powerSlideClient.updateStory(workspace, story);
        }
    }

    public void delete(AuthCtx authCtx, String dataStoryId) throws IOException, ApplicativeException {
        try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
            powerSlideClient.deleteStory(dataStoryId);
        }
    }

    public byte[] getThumbnail(AuthCtx authCtx, String dataStoryId) throws IOException, ApplicativeException {
        try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
            byte[] byArray = powerSlideClient.getThumbnail(dataStoryId);
            return byArray;
        }
    }

    private PowerslideClient getPowerslideClient(AuthCtx authCtx) throws ApplicativeException {
        GeneralSettingsDAO.DataikuStoriesSettings settings = this.getDataikuStoriesSettings();
        if (!settings.enabled) {
            throw new ApplicativeException("Configuration error", "Dataiku Stories has not been enabled");
        }
        String storyPort = System.getenv("DKU_STORIES_PORT");
        if (storyPort == null) {
            throw new IllegalStateException("DKU_STORIES_PORT environment variable is not set");
        }
        boolean ssl = Boolean.parseBoolean(DKUApp.getIniValue((String)"server", (String)"ssl"));
        String baseURI = (ssl ? "https" : "http") + "://localhost:" + Integer.parseInt(storyPort) + "/stories";
        LegacyGlobalScopePublicAPIKey apiKey = this.publicApiKeysService.getInMemoryAPIKey("story", "story", "");
        return new PowerslideClient(authCtx, baseURI, apiKey.getKey());
    }

    public InfoMessage.InfoMessages testDatastoryIntegration(AuthCtx authCtx) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        GeneralSettingsDAO.DataikuStoriesSettings settings = this.getDataikuStoriesSettings();
        if (settings.enabled) {
            try (PowerslideClient powerSlideClient = this.getPowerslideClient(authCtx);){
                powerSlideClient.getStoryStatus();
                ret.withSuccess((InfoMessage.MessageCode)StoryIntegrationCodes.INFO_STORY_TEST_OK, "Dataiku Stories Integration test passed successfully");
            }
            catch (APIError.APIErrorException apiError) {
                logger.error((Object)"", (Throwable)apiError);
                ret.withErrorV((InfoMessage.MessageCode)StoryIntegrationCodes.INFO_STORY_TEST_KO, "The Dataiku Stories instance can be accessed but something went wrong: %s", new Object[]{apiError.getMessage()});
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
                ret.withErrorV((InfoMessage.MessageCode)StoryIntegrationCodes.ERR_STORY_UNREACHABLE, "The Dataiku Stories instance is unreachable, please try again later or check your configuration settings: %s", new Object[]{e});
            }
        } else {
            ret.withError((InfoMessage.MessageCode)StoryIntegrationCodes.ERR_STORY_DISABLED, "The Dataiku Stories integration is disabled");
        }
        return ret;
    }

    private GeneralSettingsDAO.DataikuStoriesSettings getDataikuStoriesSettings() {
        return ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().dataikuStoriesSettings;
    }
}

