/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeMeta;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class GenerateFeaturesRecipePlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
    @Override
    public Class<SerializedRecipe> getInputType() {
        return SerializedRecipe.class;
    }

    protected boolean isGenerateFeatures(SerializedRecipe recipe) {
        return AutoFeatureGenerationRecipeMeta.META.getType().equals(recipe.type);
    }

    protected AutoFeatureGenerationRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        return (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), AutoFeatureGenerationRecipePayloadParams.class);
    }

    protected void assertType(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!this.isGenerateFeatures(sr)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Generate Features recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    protected AutoFeatureGenerationRecipePayloadParams assertTypeAndGetPayload(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        this.assertType(recipe);
        return this.getPayload(context, recipe);
    }

    public static class FeatureTransformations
    extends GenerateFeaturesRecipePlaceholder {
        @Nullable
        private final VariableType variableType;
        private static final Map<AutoFeatureGenerationRecipePayloadParams.Feature, String> DESCRIPTION_OVERRIDES;

        public FeatureTransformations(@Nullable VariableType variableType) {
            this.variableType = variableType;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            AutoFeatureGenerationRecipePayloadParams params = this.assertTypeAndGetPayload(context, recipe);
            List featureTransformations = params.getAllFeaturesForVariableType(this.variableType).stream().map(feature -> DESCRIPTION_OVERRIDES.getOrDefault(feature, feature.description)).filter(Objects::nonNull).collect(Collectors.toList());
            return new PlaceholderOutput.Text(String.join((CharSequence)", ", featureTransformations));
        }

        static {
            EnumMap<AutoFeatureGenerationRecipePayloadParams.Feature, String> overrides = new EnumMap<AutoFeatureGenerationRecipePayloadParams.Feature, String>(AutoFeatureGenerationRecipePayloadParams.Feature.class);
            overrides.put(AutoFeatureGenerationRecipePayloadParams.Feature.MAX, "maximum");
            overrides.put(AutoFeatureGenerationRecipePayloadParams.Feature.MIN, "minimum");
            DESCRIPTION_OVERRIDES = Collections.unmodifiableMap(overrides);
        }
    }

    public static class CutoffTimeColumn
    extends GenerateFeaturesRecipePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            AutoFeatureGenerationRecipePayloadParams params = this.assertTypeAndGetPayload(context, recipe);
            String timeIndexString = null;
            if (params.cutoffTime.mode == AutoFeatureGenerationRecipePayloadParams.CutoffTime.CutoffTimeMode.COLUMN && !params.virtualInputs.isEmpty()) {
                timeIndexString = params.getPrimaryDataset().timeIndexColumn;
            }
            return PlaceholderOutputFactory.makeTextOutputMaybeNull(timeIndexString);
        }
    }

    public static class PrimaryDatasetName
    extends GenerateFeaturesRecipePlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            List<SerializedRecipe.RecipeInput> inputs;
            SerializedRecipe.RecipeInput primaryInput;
            AutoFeatureGenerationRecipePayloadParams params = this.assertTypeAndGetPayload(context, recipe);
            String nameString = "";
            if (!params.virtualInputs.isEmpty() && (primaryInput = (inputs = recipe.getInputsForRole("main")).get(params.getPrimaryDataset().index)) != null) {
                nameString = primaryInput.ref;
            }
            return new PlaceholderOutput.Text(nameString);
        }
    }
}

