/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCardContainer;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceInterval;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.ConfidenceIntervalFixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.ConfidenceLevelFixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.Fixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.HighlightingFixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.WorksheetRootCardFixer;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

public class WorksheetRootCard
extends AbstractCardContainer
implements CardWithHighlight,
CardWithConfidenceLevel,
CardWithConfidenceInterval {
    public static final String TYPE = "worksheet_root";
    public double confidenceLevel;
    public boolean showConfidenceInterval;
    @Nullable
    public Filter highlightFilter;

    public WorksheetRootCard(Card ... cards) {
        this.cards = Lists.newArrayList((Object[])cards);
        this.confidenceLevel = 0.95;
    }

    private WorksheetRootCard() {
        this.confidenceLevel = 0.95;
    }

    @Override
    public Fixer getFixer() {
        WorksheetRootCardFixer rootFixer = new WorksheetRootCardFixer();
        for (Card card : this.cards) {
            rootFixer.addCard(card.getFixer());
        }
        return rootFixer.thenRecursive(new ConfidenceLevelFixer(this.confidenceLevel).then(new ConfidenceIntervalFixer(this.showConfidenceInterval)).then(new HighlightingFixer(this.highlightFilter)));
    }

    @Override
    protected AbstractCardContainer.AbstractCardContainerResult buildContainerResult(List<CardResult> results) {
        return new WorksheetRootCardResult(results);
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    @Override
    public void setShowConfidenceInterval(boolean showConfidenceInterval) {
        this.showConfidenceInterval = showConfidenceInterval;
    }

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public static class WorksheetRootCardResult
    extends AbstractCardContainer.AbstractCardContainerResult {
        public WorksheetRootCardResult(List<CardResult> results) {
            this.results = results;
            this.computationCount = 0;
            this.failedComputationsCount = 0;
            this.notComputedCount = 0;
            for (CardResult cr : results) {
                this.computationCount += cr.computationCount;
                this.failedComputationsCount += cr.failedComputationsCount;
                this.notComputedCount += cr.notComputedCount;
            }
        }

        private WorksheetRootCardResult() {
        }
    }
}

