/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.output.ExportOutput;

public class BindableExportOutput
implements ExportOutput {
    private ExportOutput exportable;
    private volatile long msBindTimeout;
    private ExportOutput.ExportContext exportContext;

    public BindableExportOutput(long msBindTimeout) {
        this.msBindTimeout = msBindTimeout;
    }

    public ExportOutput getExportable() throws Exception {
        if (this.exportable == null) {
            throw new Exception("Not ready to stream");
        }
        return this.exportable;
    }

    public synchronized void bind(ExportOutput exportable) {
        if (this.exportable != null) {
            throw new RuntimeException("Export is already bound");
        }
        this.exportable = exportable;
        if (this.exportContext != null) {
            this.exportable.setExportContext(this.exportContext);
        }
    }

    private void waitUntilBound() throws InterruptedException {
        long start;
        long current = start = System.currentTimeMillis();
        while (current - start < this.msBindTimeout + 1000L) {
            if (this.exportable != null) {
                return;
            }
            Thread.sleep(500L);
            current = System.currentTimeMillis();
        }
        if (this.exportable == null) {
            throw new RuntimeException("No data has been received (timeout expired)");
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        if (this.exportable != null) {
            return this.exportable.getWrittenBytes();
        }
        return -1L;
    }

    @Override
    public void close() {
        if (this.exportable != null) {
            this.exportable.close();
        }
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.waitUntilBound();
        this.exportable.initialize(job, schema, cf);
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        this.exportable.stream(stream);
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) throws Exception {
        if (!ExportUtils.canExportToStream(job.status.params.selection)) {
            throw new Exception("Sampling method uses more than 1 pass, cannot be streamed (use a temporary file).");
        }
    }

    @Override
    public void setExportContext(ExportOutput.ExportContext exportContext) {
        this.exportContext = exportContext;
        if (this.exportable != null) {
            this.exportable.setExportContext(exportContext);
        }
    }
}

