/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.snowpark.datamodel;

import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkResource;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class SnowparkDetailedService
extends SnowparkService {
    @Nonnull
    public final Map<String, String> environmentVariables;
    @Nullable
    public final String eventTableLogLevel;
    public final String healthUrl;
    public final String containerImageUri;
    public final boolean publicEndpoint;
    @Nonnull
    public final SnowparkResource requests;
    @Nonnull
    public final SnowparkResource limits;

    public SnowparkDetailedService(@Nonnull String name, @Nonnull String databaseName, @Nonnull String schemaName, @Nullable String computePoolName, int minInstances, int maxInstances, @Nonnull Map<String, String> environmentVariables, String healthUrl, String containerImageUri, boolean publicEndpoint, @Nonnull SnowparkResource requests, @Nonnull SnowparkResource limits, @Nullable String eventTableLogLevel) {
        super(name, databaseName, schemaName, computePoolName, minInstances, maxInstances);
        this.environmentVariables = environmentVariables;
        this.healthUrl = healthUrl;
        this.containerImageUri = containerImageUri;
        this.publicEndpoint = publicEndpoint;
        this.requests = requests;
        this.limits = limits;
        this.eventTableLogLevel = eventTableLogLevel;
    }

    public static SnowparkDetailedService buildFromSpecification(@Nonnull String name, @Nonnull String databaseName, @Nonnull String schemaName, @Nullable String computePoolName, int minInstances, int maxInstances, @Nonnull String yamlSpecification) {
        YamlSpecHolder yamlSpecHolder = SnowparkDetailedService.parseYamlSpecification(yamlSpecification);
        List<YamlContainer> containers = yamlSpecHolder.spec.containers;
        List<YamlEndpoint> endpoints = yamlSpecHolder.spec.endpoints;
        YamlLogExporters logExporters = yamlSpecHolder.spec.logExporters;
        String eventTableLogLevel = logExporters != null && logExporters.eventTableConfig != null ? logExporters.eventTableConfig.logLevel : null;
        String healthUrl = null;
        String containerImageUri = null;
        Map<String, String> environmentVariables = new HashMap<String, String>();
        boolean publicEndpoint = false;
        SnowparkResource requests = new SnowparkResource();
        SnowparkResource limits = new SnowparkResource();
        if (!containers.isEmpty()) {
            YamlResources resources;
            YamlContainer container = containers.get(0);
            healthUrl = container.readinessProbe.path;
            containerImageUri = container.image;
            if (container.env != null) {
                environmentVariables = container.env;
            }
            if ((resources = container.resources) != null) {
                requests = SnowparkDetailedService.mapResource(resources.requests);
                limits = SnowparkDetailedService.mapResource(resources.limits);
            }
        }
        if (!endpoints.isEmpty()) {
            YamlEndpoint endpoint = endpoints.get(0);
            publicEndpoint = endpoint.isPublic();
        }
        return new SnowparkDetailedService(name, databaseName, schemaName, computePoolName, minInstances, maxInstances, environmentVariables, healthUrl, containerImageUri, publicEndpoint, requests, limits, eventTableLogLevel);
    }

    public String createYamlSpecification() {
        YamlSpecHolder data = this.createYamlSpecHolder();
        Yaml yaml = SnowparkDetailedService.createYaml();
        return yaml.dump((Object)data);
    }

    private static YamlSpecHolder parseYamlSpecification(String yamlSpec) {
        Yaml yaml = SnowparkDetailedService.createYaml();
        return (YamlSpecHolder)yaml.loadAs(yamlSpec, YamlSpecHolder.class);
    }

    private static Yaml createYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setIndent(2);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(dumperOptions){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.getPropertyUtils().setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(YamlSpecHolder.class, loaderOptions);
        TypeDescription resourceDesc = new TypeDescription(YamlResource.class);
        resourceDesc.substituteProperty("nvidia.com/gpu", String.class, "getNvidiaComGpu", "setNvidiaComGpu", new Class[0]);
        resourceDesc.setExcludes(new String[]{"nvidiaComGpu"});
        constructor.addTypeDescription(resourceDesc);
        representer.addTypeDescription(resourceDesc);
        return new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions);
    }

    @Nonnull
    private static SnowparkResource mapResource(@Nullable YamlResource yamlResource) {
        SnowparkResource result = new SnowparkResource();
        if (yamlResource != null) {
            result.cpu = yamlResource.cpu;
            result.memory = yamlResource.memory;
            result.gpu = yamlResource.nvidiaComGpu;
        }
        return result;
    }

    @Nullable
    private static YamlResource mapResource(@Nonnull SnowparkResource resource) {
        if (resource.isEmpty()) {
            return null;
        }
        YamlResource result = new YamlResource();
        result.cpu = StringUtils.nullIfBlank((String)resource.cpu);
        result.memory = StringUtils.nullIfBlank((String)resource.memory);
        result.nvidiaComGpu = StringUtils.nullIfBlank((String)resource.gpu);
        return result;
    }

    @Nonnull
    public YamlSpecHolder createYamlSpecHolder() {
        YamlLogExporters yamlLogExporters;
        YamlEndpoint endpoint = new YamlEndpoint();
        endpoint.name = "prediction-endpoint";
        endpoint.port = 8080;
        endpoint.publicAccess = this.publicEndpoint;
        ArrayList<YamlEndpoint> endpoints = new ArrayList<YamlEndpoint>(1);
        endpoints.add(endpoint);
        YamlReadinessProbe readinessProbe = new YamlReadinessProbe();
        readinessProbe.path = this.healthUrl;
        readinessProbe.port = 8080;
        YamlContainer container = new YamlContainer();
        container.name = "prediction-container";
        container.image = this.containerImageUri;
        container.readinessProbe = readinessProbe;
        if (!this.environmentVariables.isEmpty()) {
            container.env = this.environmentVariables;
        }
        if (!this.requests.isEmpty() || !this.limits.isEmpty()) {
            YamlResources resources = new YamlResources();
            resources.requests = SnowparkDetailedService.mapResource(this.requests);
            if (resources.requests == null) {
                throw ErrorContext.ice((String)"You can't specify a memory/CPU limit for the container without a requested memory/CPU. You can update this in the infrastructure settings.");
            }
            resources.limits = SnowparkDetailedService.mapResource(this.limits);
            container.resources = resources;
        }
        ArrayList<YamlContainer> containers = new ArrayList<YamlContainer>();
        containers.add(container);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.eventTableLogLevel)) {
            yamlLogExporters = null;
        } else {
            YamlEventTableConfig eventTableConfig = new YamlEventTableConfig();
            eventTableConfig.logLevel = this.eventTableLogLevel;
            yamlLogExporters = new YamlLogExporters();
            yamlLogExporters.eventTableConfig = eventTableConfig;
        }
        YamlSpec spec = new YamlSpec();
        spec.containers = containers;
        spec.endpoints = endpoints;
        spec.logExporters = yamlLogExporters;
        YamlSpecHolder data = new YamlSpecHolder();
        data.spec = spec;
        return data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnowparkDetailedService)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnowparkDetailedService service = (SnowparkDetailedService)o;
        return this.publicEndpoint == service.publicEndpoint && this.environmentVariables.equals(service.environmentVariables) && Objects.equals(this.eventTableLogLevel, service.eventTableLogLevel) && Objects.equals(this.healthUrl, service.healthUrl) && Objects.equals(this.containerImageUri, service.containerImageUri) && this.requests.equals(service.requests) && this.limits.equals(service.limits);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.environmentVariables, this.eventTableLogLevel, this.healthUrl, this.containerImageUri, this.publicEndpoint, this.requests, this.limits);
    }

    public static class YamlSpecHolder {
        public YamlSpec spec;
    }

    public static class YamlSpec {
        public List<YamlContainer> containers;
        public List<YamlEndpoint> endpoints;
        public YamlLogExporters logExporters;
    }

    public static class YamlLogExporters {
        public YamlEventTableConfig eventTableConfig;
    }

    public static class YamlEventTableConfig {
        public String logLevel;
    }

    public static class YamlContainer {
        public String image;
        public String name;
        public YamlReadinessProbe readinessProbe;
        public Map<String, String> env;
        public YamlResources resources;
    }

    public static class YamlReadinessProbe {
        public String path;
        public int port;
    }

    public static class YamlResources {
        public YamlResource requests;
        public YamlResource limits;
    }

    public static class YamlResource {
        public String memory;
        public String cpu;
        public static final String GPU_YAML_NAME = "nvidia.com/gpu";
        public static final String GPU_FIELD_NAME = "nvidiaComGpu";
        private String nvidiaComGpu;
        public static final String GPU_GETTER_NAME = "getNvidiaComGpu";
        public static final String GPU_SETTER_NAME = "setNvidiaComGpu";

        public String getNvidiaComGpu() {
            return this.nvidiaComGpu;
        }

        public void setNvidiaComGpu(String nvidiaComGpu) {
            this.nvidiaComGpu = nvidiaComGpu;
        }
    }

    public static class YamlEndpoint {
        public String name;
        public int port;
        private boolean publicAccess;

        public boolean isPublic() {
            return this.publicAccess;
        }

        public void setPublic(boolean publik) {
            this.publicAccess = publik;
        }
    }
}

