/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.RowFactoryWithContextInfo;
import com.dataiku.dip.input.formats.xml.JDOM2XPath;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.UnresolvableException;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final FormatMeta<XmlFormatExtractor, Config> META = new FormatMeta<XmlFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "xml";
        }

        @Override
        public String getLabel() {
            return "Xml";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.advancedSelect("retrievalMode", "Data extraction", "How columns names are built from the xml element", new String[]{"simple", "explicit"}, new String[]{"Simple", "Explicit XPath"}), ParamDesc.advancedSelect("ancestorCapture", "Context capture", "How the parents of the xml element are saved", new String[]{"none", "object", "columns", "explicit", "full_object"}, new String[]{"No capture", "Sparse parents, as JSON object", "Sparse parents, one per column", "Explicit XPaths", "Full capture, as JSON object"}), ParamDesc.string("rootPath", "Root element XPath").withMandatory(true).withCanBeEmpty(false), new ParamDesc("cellContentMapping", "map").withMandatory(false).withCanBeEmpty(true).withLabel("XPaths to the values"), new ParamDesc("ancestorMapping", "map").withMandatory(false).withCanBeEmpty(true).withLabel("XPaths to the parents"), ParamDesc.string("ancestorCaptureColumn", "Column for parents").withMandatory(false).withCanBeEmpty(true), ParamDesc.booleanP("hasNoTopLevelElement", "Is stream of xml elements"), ParamDesc.booleanP("shortTextMode", "Treat text-only elements as attributes"), new ParamDesc("charset", "charset").withMandatory(false).withLabel("Charset"), ParamDesc.booleanP("overrideFileCharset", "Override file-specified charset"), FormatFactory.getStandardCompressionMethods()};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new XmlFormatExtractor((Config)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new NotImplementedException();
        }
    };
    private static final String TEXT_CONTENT_COLUMN_NAME = "xml_text";
    private static final String ANCESTOR_TAG_NAME = "__xml_element_name";
    public boolean shortTextMode;
    public boolean hasNoTopLevelElement;
    private final String rootPath;
    private final String charset;
    private final boolean overrideFileCharset;
    private final String ancestorsCaptureColumn;
    private final Config.AncestorContextCapture ancestorCapture;
    private final List<XPathExtraction> explicitXPaths;
    private final List<XPathExtraction> ancestorsXPaths;
    private final Pattern whitespace;
    private final SimpleNamespaceContext prefixMap;

    public XmlFormatExtractor(Config params) {
        if (params.rootPath == null || params.rootPath.trim().length() == 0) {
            throw new IllegalArgumentException("XPath to the elements to extract must be defined");
        }
        this.rootPath = params.rootPath;
        this.hasNoTopLevelElement = params.hasNoTopLevelElement;
        this.charset = params.charset;
        this.overrideFileCharset = params.overrideFileCharset;
        this.shortTextMode = params.shortTextMode;
        this.explicitXPaths = params.retrievalMode == Config.CellContentRetrieval.EXPLICIT ? params.cellContentMapping : null;
        this.ancestorCapture = params.ancestorCapture;
        this.ancestorsXPaths = params.ancestorCapture == Config.AncestorContextCapture.EXPLICIT ? params.ancestorMapping : null;
        this.ancestorsCaptureColumn = params.ancestorCapture == Config.AncestorContextCapture.ARRAY || params.ancestorCapture == Config.AncestorContextCapture.OBJECT || params.ancestorCapture == Config.AncestorContextCapture.FULL_OBJECT ? params.ancestorCaptureColumn : null;
        this.whitespace = Pattern.compile("^\\s+$");
        this.prefixMap = new SimpleNamespaceContext();
    }

    private String extractValueFromTextOnlyNode(Element element) {
        if (element.getAttributes().size() > 0 || element.getContentSize() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        List childNodes = element.getContent();
        for (Content childNode : childNodes) {
            if (!(childNode instanceof Text)) {
                return null;
            }
            sb.append(((Text)childNode).getText());
        }
        return sb.toString();
    }

    protected Map<String, String> extractAttributes(Element element, Map<String, String> liftedSubElements) {
        HashMap extracted = Maps.newHashMap();
        List attributeNodes = element.getAttributes();
        for (Attribute attribute : attributeNodes) {
            extracted.put(attribute.getQualifiedName(), attribute.getValue());
        }
        for (Map.Entry entry : liftedSubElements.entrySet()) {
            if (extracted.containsKey(entry.getKey())) {
                this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_DATA, "The value from a text-only node has overwritten the value from an attribute '" + (String)entry.getKey() + "' on a '" + element.getQualifiedName() + "'", null);
            }
            extracted.put((String)entry.getKey(), (String)entry.getValue());
        }
        return extracted;
    }

    protected Map<String, String> extractSubElementsToLiftToAttribute(Element element) {
        HashMap extracted = Maps.newHashMap();
        if (this.shortTextMode) {
            HashSet tags = Sets.newHashSet();
            List childNodes = element.getContent();
            for (Content childNode : childNodes) {
                Element child;
                String text;
                if (!(childNode instanceof Element) || (text = this.extractValueFromTextOnlyNode(child = (Element)childNode)) == null) continue;
                String tag = child.getQualifiedName();
                if (tags.contains(tag)) {
                    extracted.remove(tag);
                    continue;
                }
                tags.add(tag);
                extracted.put(tag, text);
            }
        }
        return extracted;
    }

    protected Map<String, List<Element>> extractSubElements(Element element, Map<String, String> liftedSubElements) {
        HashMap extracted = Maps.newHashMap();
        List childNodes = element.getContent();
        for (Content childNode : childNodes) {
            Element child;
            String nodeName;
            if (!(childNode instanceof Element) || liftedSubElements.containsKey(nodeName = (child = (Element)childNode).getQualifiedName())) continue;
            if (!extracted.containsKey(nodeName)) {
                extracted.put(nodeName, new ArrayList());
            }
            ((List)extracted.get(nodeName)).add(child);
        }
        return extracted;
    }

    protected String extractTextContent(Element element) {
        StringBuilder sb = new StringBuilder();
        List childNodes = element.getContent();
        for (Content childNode : childNodes) {
            Text child;
            String text;
            if (!(childNode instanceof Text) || this.whitespace.matcher(text = (child = (Text)childNode).getText()).matches()) continue;
            sb.append(text);
        }
        return sb.toString();
    }

    protected JSONObject extractAll(Element element, boolean recurse, boolean expectOnlyOneSubElementPerTag) {
        JSONObject extracted = new JSONObject();
        Map<String, String> liftedSubElements = this.extractSubElementsToLiftToAttribute(element);
        Map<String, String> attributes = this.extractAttributes(element, liftedSubElements);
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            extracted.put(attribute.getKey(), (Object)attribute.getValue());
        }
        String text = this.extractTextContent(element);
        if (text != null && text.length() > 0) {
            extracted.put(TEXT_CONTENT_COLUMN_NAME, (Object)text);
        }
        if (recurse) {
            for (Map.Entry<String, List<Element>> subElements : this.extractSubElements(element, liftedSubElements).entrySet()) {
                ArrayList subElementList = Lists.newArrayList();
                for (Element node : subElements.getValue()) {
                    subElementList.add(this.extractAll(node, recurse, false));
                }
                if (expectOnlyOneSubElementPerTag) {
                    if (subElementList.size() != 1) continue;
                    extracted.put(subElements.getKey(), subElementList.get(0));
                    continue;
                }
                extracted.put(subElements.getKey(), (Collection)subElementList);
            }
        }
        return extracted;
    }

    private Object extractContent(Object node) {
        if (node instanceof Element) {
            return this.extractAll((Element)node, true, false);
        }
        if (node instanceof Attribute) {
            JSONObject attributeObject = new JSONObject();
            attributeObject.put(((Attribute)node).getQualifiedName(), (Object)((Attribute)node).getValue());
            return attributeObject;
        }
        if (node instanceof Text) {
            return ((Text)node).getText();
        }
        if (node instanceof Document) {
            if (((Document)node).hasRootElement()) {
                return this.extractAll(((Document)node).getRootElement(), true, false);
            }
            return new JSONObject();
        }
        return null;
    }

    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        RowFactoryWithContextInfo rowFactory = new RowFactoryWithContextInfo(rf, isn);
        SAXParserFactory parserFactory = XmlFormatExtractor.getSAXParserFactory();
        SAXParser parser = parserFactory.newSAXParser();
        if (!(this.ancestorCapture != Config.AncestorContextCapture.ARRAY && this.ancestorCapture != Config.AncestorContextCapture.OBJECT && this.ancestorCapture != Config.AncestorContextCapture.FULL_OBJECT || this.ancestorsCaptureColumn != null && this.ancestorsCaptureColumn.length() != 0)) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "The column for parents must be defined");
        }
        InputStream xmlStream = is;
        if (this.hasNoTopLevelElement) {
            Vector<InputStream> streams = new Vector<InputStream>();
            streams.add(new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"" + Charset.forName(this.charset).name() + "\"?><root>").getBytes(this.charset)));
            streams.add(is);
            streams.add(new ByteArrayInputStream("</root>".getBytes(this.charset)));
            xmlStream = new SequenceInputStream(streams.elements());
        }
        try {
            RootElementHandler handler;
            InputSource xmlSource;
            if (!this.hasNoTopLevelElement && this.overrideFileCharset) {
                xmlSource = new InputSource(new InputStreamReader(xmlStream, this.charset));
                xmlSource.setEncoding(this.charset);
            } else {
                xmlSource = new InputSource(xmlStream);
            }
            RootElementHandler rootElementHandler = handler = this.explicitXPaths == null ? new SimpleRootElementHandler(out, cf, rowFactory, observer) : new ExplicitColumnsRootElementHandler(out, cf, rowFactory, observer);
            CaptureParentsHelper captureParent = this.ancestorCapture == Config.AncestorContextCapture.EXPLICIT && this.ancestorsXPaths != null ? new CaptureParentsAsXPathHelper() : (this.ancestorCapture == Config.AncestorContextCapture.COLUMNS ? new CaptureParentsAsColumnsHelper() : (this.ancestorCapture == Config.AncestorContextCapture.ARRAY && this.ancestorsCaptureColumn != null ? new CaptureParentsAsArrayHelper() : (this.ancestorCapture == Config.AncestorContextCapture.OBJECT && this.ancestorsCaptureColumn != null ? new CaptureParentsAsObjectHelper() : (this.ancestorCapture == Config.AncestorContextCapture.FULL_OBJECT && this.ancestorsCaptureColumn != null ? new CaptureParentsAsFullContextObjectHelper() : new NoOpCaptureParentsHelper()))));
            parser.parse(xmlSource, (DefaultHandler)new RootElementFilter(handler, captureParent));
        }
        catch (WrappedExceptionAsSAXException e) {
            throw e.wrappedException;
        }
        catch (EmissionLimitAsSAXException e) {
            return false;
        }
        return true;
    }

    public static SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.security.xml.dangerous.allowUnsafeExternalEntities", false)) {
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setXIncludeAware(false);
        }
        return parserFactory;
    }

    public static class Config
    extends CompressibleFormatParams {
        public boolean hasNoTopLevelElement = false;
        public boolean shortTextMode = true;
        public CellContentRetrieval retrievalMode = CellContentRetrieval.SIMPLE;
        public AncestorContextCapture ancestorCapture = AncestorContextCapture.NONE;
        public String rootPath = null;
        public String charset = "utf-8";
        public boolean overrideFileCharset = false;
        public String ancestorCaptureColumn = null;
        public List<XPathExtraction> cellContentMapping = new ArrayList<XPathExtraction>();
        public List<XPathExtraction> ancestorMapping = new ArrayList<XPathExtraction>();

        protected Config withOverrideFileCharset() {
            this.overrideFileCharset = true;
            return this;
        }

        protected Config withNoTopLevel() {
            this.hasNoTopLevelElement = true;
            return this;
        }

        protected Config withoutShortTextMode() {
            this.shortTextMode = false;
            return this;
        }

        protected Config withRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        protected Config withCharset(String charset) {
            this.charset = charset;
            return this;
        }

        protected Config withXPathMapping(List<XPathExtraction> cellContentMapping) {
            this.cellContentMapping = cellContentMapping;
            this.retrievalMode = CellContentRetrieval.EXPLICIT;
            return this;
        }

        protected Config withArrayAncestors(String column) {
            this.ancestorCaptureColumn = column;
            this.ancestorCapture = AncestorContextCapture.ARRAY;
            return this;
        }

        protected Config withObjectAncestors(String column) {
            this.ancestorCaptureColumn = column;
            this.ancestorCapture = AncestorContextCapture.OBJECT;
            return this;
        }

        protected Config withFullContext(String column) {
            this.ancestorCaptureColumn = column;
            this.ancestorCapture = AncestorContextCapture.FULL_OBJECT;
            return this;
        }

        protected Config withXPathAncestors(List<XPathExtraction> ancestorMapping) {
            this.ancestorMapping = ancestorMapping;
            this.ancestorCapture = AncestorContextCapture.EXPLICIT;
            return this;
        }

        protected Config withColumnifiedAncestors() {
            this.ancestorCapture = AncestorContextCapture.COLUMNS;
            return this;
        }

        public static enum CellContentRetrieval {
            SIMPLE("simple"),
            EXPLICIT("explicit");

            private final String name;

            public String toString() {
                return this.name;
            }

            private CellContentRetrieval(String name) {
                this.name = name;
            }
        }

        public static enum AncestorContextCapture {
            NONE("none"),
            ARRAY("array"),
            OBJECT("object"),
            COLUMNS("columns"),
            EXPLICIT("explicit"),
            FULL_OBJECT("full_object");

            private final String name;

            public String toString() {
                return this.name;
            }

            private AncestorContextCapture(String name) {
                this.name = name;
            }
        }
    }

    private class SimpleRootElementHandler
    extends RootElementHandler {
        public SimpleRootElementHandler(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
            super(out, cf, rf, observer);
        }

        @Override
        public void convert(Object element, Row r) {
            Map<String, String> liftedSubElements = XmlFormatExtractor.this.extractSubElementsToLiftToAttribute((Element)element);
            for (Map.Entry<String, String> attribute : XmlFormatExtractor.this.extractAttributes((Element)element, liftedSubElements).entrySet()) {
                Column c2 = this.cf.column(attribute.getKey());
                r.put(c2, attribute.getValue());
            }
            String text = XmlFormatExtractor.this.extractTextContent((Element)element);
            if (text != null && text.length() > 0) {
                Column c3 = this.cf.column(XmlFormatExtractor.TEXT_CONTENT_COLUMN_NAME);
                r.put(c3, text);
            }
            Map<String, List<Element>> childrenByTag = XmlFormatExtractor.this.extractSubElements((Element)element, liftedSubElements);
            for (Map.Entry<String, List<Element>> children : childrenByTag.entrySet()) {
                ArrayList subElementList = Lists.newArrayList();
                for (Element node : children.getValue()) {
                    subElementList.add(XmlFormatExtractor.this.extractAll(node, true, false));
                }
                Column c4 = this.cf.column(children.getKey());
                r.put(c4, new JSONArray((Collection)subElementList).toString());
            }
        }
    }

    private class ExplicitColumnsRootElementHandler
    extends RootElementHandler {
        private final JDOM2XPath[] columnExpressions;
        private final String[] columnNames;
        private final boolean[] columnUnicities;

        public ExplicitColumnsRootElementHandler(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
            super(out, cf, rf, observer);
            this.columnExpressions = new JDOM2XPath[XmlFormatExtractor.this.explicitXPaths.size()];
            this.columnNames = new String[XmlFormatExtractor.this.explicitXPaths.size()];
            this.columnUnicities = new boolean[XmlFormatExtractor.this.explicitXPaths.size()];
            for (int i = 0; i < XmlFormatExtractor.this.explicitXPaths.size(); ++i) {
                String xpath = XmlFormatExtractor.this.explicitXPaths.get((int)i).from == null ? null : XmlFormatExtractor.this.explicitXPaths.get((int)i).from.trim();
                String name = XmlFormatExtractor.this.explicitXPaths.get((int)i).to == null ? null : XmlFormatExtractor.this.explicitXPaths.get((int)i).to.trim();
                xpath = xpath != null && xpath.length() == 0 ? null : xpath;
                String string = name = name != null && name.length() == 0 ? null : name;
                if (xpath == null || name == null) {
                    if (name != null) {
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete column XPath mapping, xpath expression not set for column '" + name + "'");
                    }
                    if (xpath != null) {
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete column XPath mapping, column name not set for '" + xpath + "'");
                    }
                    throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete column XPath mapping ");
                }
                this.columnNames[i] = name;
                this.columnUnicities[i] = XmlFormatExtractor.this.explicitXPaths.get((int)i).unique;
                this.columnExpressions[i] = new JDOM2XPath(xpath);
                this.columnExpressions[i].setNamespaceContext((NamespaceContext)XmlFormatExtractor.this.prefixMap);
            }
        }

        @Override
        public void convert(Object element, Row r) throws JaxenException {
            for (int i = 0; i < this.columnNames.length; ++i) {
                Object foundSet = null;
                try {
                    foundSet = this.columnExpressions[i].evaluate(element);
                }
                catch (UnresolvableException unresolvableException) {
                    // empty catch block
                }
                if (foundSet == null || !(foundSet instanceof List)) continue;
                List founds = (List)foundSet;
                Object contents = null;
                Object contentOverflow = null;
                if (this.columnUnicities[i]) {
                    if (founds.size() >= 1) {
                        contents = XmlFormatExtractor.this.extractContent(founds.get(0));
                    }
                    if (founds.size() > 1) {
                        contentList = new JSONArray();
                        for (int j = 1; j < founds.size(); ++j) {
                            contentList.put(XmlFormatExtractor.this.extractContent(founds.get(j)));
                        }
                        contentOverflow = contentList;
                    }
                } else if (founds.size() > 0) {
                    contentList = new JSONArray();
                    for (Object found : founds) {
                        contentList.put(XmlFormatExtractor.this.extractContent(found));
                    }
                    contents = contentList;
                }
                if (contents != null) {
                    r.put(this.cf.column(this.columnNames[i]), contents.toString());
                }
                if (contentOverflow == null) continue;
                r.put(this.cf.column(this.columnNames[i] + "_OVERFLOW"), contentOverflow.toString());
            }
        }
    }

    private class CaptureParentsAsXPathHelper
    implements CaptureParentsHelper {
        private final XPathTarget[] ancestorTargets;
        private final String[] ancestorColumnNames;
        private int activeXPathTarget;
        private final NodeAccumulator parentElementAccumulator;

        public CaptureParentsAsXPathHelper() throws Exception {
            this.ancestorTargets = new XPathTarget[XmlFormatExtractor.this.ancestorsXPaths.size()];
            this.ancestorColumnNames = new String[XmlFormatExtractor.this.ancestorsXPaths.size()];
            for (int i = 0; i < XmlFormatExtractor.this.ancestorsXPaths.size(); ++i) {
                String xpath = XmlFormatExtractor.this.ancestorsXPaths.get((int)i).from == null ? null : XmlFormatExtractor.this.ancestorsXPaths.get((int)i).from.trim();
                String name = XmlFormatExtractor.this.ancestorsXPaths.get((int)i).to == null ? null : XmlFormatExtractor.this.ancestorsXPaths.get((int)i).to.trim();
                xpath = xpath != null && xpath.length() == 0 ? null : xpath;
                String string = name = name != null && name.length() == 0 ? null : name;
                if (xpath == null || name == null) {
                    if (name != null) {
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping, xpath expression not set for column '" + name + "'");
                    }
                    if (xpath != null) {
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping, column name not set for '" + xpath + "'");
                    }
                    throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping ");
                }
                this.ancestorColumnNames[i] = name;
                this.ancestorTargets[i] = new XPathTarget(xpath, XmlFormatExtractor.this.ancestorsXPaths.get((int)i).unique);
            }
            this.parentElementAccumulator = new FullNodeAccumulator();
            this.activeXPathTarget = -1;
        }

        @Override
        public void startElement(Document root, String qName, Element node) throws JaxenException {
            if (!this.parentElementAccumulator.isAccumulating()) {
                for (int i = 0; i < XmlFormatExtractor.this.ancestorsXPaths.size(); ++i) {
                    Object match = this.ancestorTargets[i].matches(root, node);
                    if (match == null || !(match instanceof List)) continue;
                    List matches = (List)match;
                    if (matches.size() == 1 && matches.get(0) == node) {
                        this.parentElementAccumulator.startNode(node);
                        this.activeXPathTarget = i;
                        this.ancestorTargets[this.activeXPathTarget].setLastMatchSeen(this.parentElementAccumulator.getAccumulatedNode());
                        break;
                    }
                    this.ancestorTargets[i].setLastMatchSeen(match);
                }
            }
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
            if (this.parentElementAccumulator.endElement(node)) {
                this.ancestorTargets[this.activeXPathTarget].setLastMatchSeen(this.parentElementAccumulator.getAccumulatedNode());
            }
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
            if (!this.parentElementAccumulator.isAccumulating()) {
                for (int i = 0; i < XmlFormatExtractor.this.ancestorsXPaths.size(); ++i) {
                    Object match = this.ancestorTargets[i].matches(root, node);
                    if (match == null || !(match instanceof List)) continue;
                    List matches = (List)match;
                    if (matches.size() == 1 && matches.get(0) == node) {
                        this.ancestorTargets[i].setLastMatchSeen(node);
                        break;
                    }
                    this.ancestorTargets[i].setLastMatchSeen(match);
                }
            }
        }

        @Override
        public boolean isCapturing() {
            return this.parentElementAccumulator.isAccumulating();
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
            for (int i = 0; i < XmlFormatExtractor.this.ancestorsXPaths.size(); ++i) {
                if (this.ancestorTargets[i].getLastMatchSeen() != null) {
                    r.put(cf.column(this.ancestorColumnNames[i]), this.ancestorTargets[i].getLastMatchSeen());
                }
                if (this.ancestorTargets[i].getLastOverflow() == null) continue;
                r.put(cf.column(this.ancestorColumnNames[i] + "_OVERFLOW"), this.ancestorTargets[i].getLastOverflow());
            }
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            return qName == null;
        }
    }

    private class CaptureParentsAsColumnsHelper
    implements CaptureParentsHelper {
        private final Stack<JSONObject> parentStack = new Stack();
        private final Stack<String> tagStack = new Stack();

        private CaptureParentsAsColumnsHelper() {
        }

        @Override
        public void startElement(Document root, String qName, Element node) {
            JSONObject jsonifiedNode = XmlFormatExtractor.this.extractAll(node, true, false);
            this.parentStack.push(jsonifiedNode);
            this.tagStack.push(qName);
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
            this.parentStack.pop();
            this.tagStack.pop();
            if (XmlFormatExtractor.this.shortTextMode && !hasSubElements && node.getAttributes().size() == 0 && this.parentStack.size() > 0) {
                JSONObject previous = this.parentStack.peek();
                if (previous.has(qName)) {
                    previous.remove(qName);
                }
                previous.put(qName, (Object)node.getValue());
            }
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
            for (int i = 0; i < this.parentStack.size(); ++i) {
                String tag = (String)this.tagStack.get(i);
                JSONObject json = (JSONObject)this.parentStack.get(i);
                Column c2 = cf.column(tag);
                r.put(c2, json.toString());
            }
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            return qName == null && XmlFormatExtractor.this.shortTextMode;
        }
    }

    private class CaptureParentsAsArrayHelper
    implements CaptureParentsHelper {
        private final Stack<JSONObject> parentStack = new Stack();

        private CaptureParentsAsArrayHelper() {
        }

        @Override
        public void startElement(Document root, String qName, Element node) {
            JSONObject jsonifiedNode = XmlFormatExtractor.this.extractAll(node, true, false);
            jsonifiedNode.put(XmlFormatExtractor.ANCESTOR_TAG_NAME, (Object)qName);
            this.parentStack.push(jsonifiedNode);
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
            this.parentStack.pop();
            if (XmlFormatExtractor.this.shortTextMode && !hasSubElements && node.getAttributes().size() == 0 && this.parentStack.size() > 0) {
                JSONObject previous = this.parentStack.peek();
                if (previous.has(qName)) {
                    previous.remove(qName);
                }
                previous.put(qName, (Object)node.getValue());
            }
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
            JSONArray array = new JSONArray();
            for (JSONObject parentObject : this.parentStack) {
                array.put((Object)parentObject);
            }
            Column c2 = cf.column(XmlFormatExtractor.this.ancestorsCaptureColumn);
            r.put(c2, array.toString());
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            return qName == null && XmlFormatExtractor.this.shortTextMode;
        }
    }

    private class CaptureParentsAsObjectHelper
    implements CaptureParentsHelper {
        private final Stack<JSONObject> parentStack = new Stack();

        private CaptureParentsAsObjectHelper() {
        }

        @Override
        public void startElement(Document root, String qName, Element node) {
            JSONObject stackTail = this.parentStack.size() > 0 ? this.parentStack.peek() : null;
            JSONObject jsonifiedNode = XmlFormatExtractor.this.extractAll(node, true, false);
            this.parentStack.push(jsonifiedNode);
            if (stackTail != null) {
                if (stackTail.has(qName)) {
                    stackTail.remove(qName);
                }
                stackTail.put(qName, (Object)jsonifiedNode);
            }
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
            JSONObject stackTail;
            if (this.parentStack.size() > 0) {
                this.parentStack.pop();
            }
            JSONObject jSONObject = stackTail = this.parentStack.size() > 0 ? this.parentStack.peek() : null;
            if (stackTail != null && stackTail.has(qName)) {
                stackTail.remove(qName);
            }
            if (XmlFormatExtractor.this.shortTextMode && !hasSubElements && node.getAttributes().size() == 0 && this.parentStack.size() > 0) {
                JSONObject previous = this.parentStack.peek();
                if (previous.has(qName)) {
                    previous.remove(qName);
                }
                previous.put(qName, (Object)node.getValue());
            }
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
            if (this.parentStack.size() > 0) {
                Column c2 = cf.column(XmlFormatExtractor.this.ancestorsCaptureColumn);
                r.put(c2, ((JSONObject)this.parentStack.get(0)).toString());
            }
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            return qName == null && XmlFormatExtractor.this.shortTextMode;
        }
    }

    private class CaptureParentsAsFullContextObjectHelper
    implements CaptureParentsHelper {
        private Document root;

        private CaptureParentsAsFullContextObjectHelper() {
        }

        @Override
        public void startElement(Document root, String qName, Element node) {
            this.root = root;
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
            if (this.root != null) {
                Column c2 = cf.column(XmlFormatExtractor.this.ancestorsCaptureColumn);
                JSONObject extracted = new JSONObject();
                if (this.root.hasRootElement()) {
                    String topParentQName = this.root.getRootElement().getQualifiedName();
                    extracted.put(topParentQName, (Object)XmlFormatExtractor.this.extractAll(this.root.getRootElement(), true, true));
                }
                r.put(c2, extracted.toString());
            }
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            if (node != null) {
                Parent parent = node.getParent();
                for (int i = parent.getContentSize() - 1; i >= 0; --i) {
                    Content brother = parent.getContent(i);
                    if (brother == node || !(brother instanceof Element) || !((Element)brother).getQualifiedName().equals(qName)) continue;
                    parent.removeContent(i);
                }
            }
            return true;
        }
    }

    private static class NoOpCaptureParentsHelper
    implements CaptureParentsHelper {
        private NoOpCaptureParentsHelper() {
        }

        @Override
        public void startElement(Document root, String qName, Element node) throws JaxenException {
        }

        @Override
        public void endElement(String qName, Element node, boolean hasSubElements) {
        }

        @Override
        public boolean isCapturing() {
            return false;
        }

        @Override
        public void fillRow(Row r, ColumnFactory cf, Element node) {
        }

        @Override
        public boolean wantsToKeep(String qName, Element node) {
            return false;
        }

        @Override
        public void characters(Document root, Text node) throws JaxenException {
        }
    }

    private class RootElementFilter
    extends DefaultHandler {
        private Row accumulationRow;
        private final RootElementHandler rootElementHandler;
        private final Document stackedElementDocument;
        private final XPathTarget rootElementTarget;
        private final NodeAccumulator rootElementAccumulator;
        private final DomStackHelper domStack;
        private boolean hasSeenTheRootElement;
        private final CaptureParentsHelper captureParentsHelper;
        private boolean hasSubElements;
        private final Stack<StringBuilder> textContentGluer;
        private final Map<String, String> internalizedNames = Maps.newHashMap();

        public RootElementFilter(RootElementHandler rootElementHandler, CaptureParentsHelper captureParentsHelper) throws JaxenException {
            this.rootElementHandler = rootElementHandler;
            this.captureParentsHelper = captureParentsHelper;
            this.textContentGluer = new Stack();
            this.accumulationRow = null;
            this.stackedElementDocument = new Document();
            this.rootElementTarget = new XPathTarget(XmlFormatExtractor.this.rootPath != null && XmlFormatExtractor.this.rootPath.trim().length() > 0 ? XmlFormatExtractor.this.rootPath : "/*", true);
            this.rootElementAccumulator = new FullNodeAccumulator();
            this.domStack = new DomStackHelper(this.stackedElementDocument);
            this.hasSeenTheRootElement = !XmlFormatExtractor.this.hasNoTopLevelElement;
        }

        private String internalize(String name) {
            String existing = this.internalizedNames.get(name);
            if (existing != null) {
                return existing;
            }
            this.internalizedNames.put(name, name);
            return name;
        }

        private Element createElement(String qName) {
            int colonPosition = qName.indexOf(58);
            if (colonPosition >= 0) {
                String prefix = this.internalize(qName.substring(0, colonPosition));
                String localName = this.internalize(qName.substring(colonPosition + 1));
                XmlFormatExtractor.this.prefixMap.addNamespace(prefix, prefix);
                Namespace namespace = "xml".equals(prefix) ? Namespace.XML_NAMESPACE : Namespace.getNamespace((String)prefix, (String)prefix);
                return new Element(localName, namespace);
            }
            return new Element(this.internalize(qName));
        }

        private void addAttribute(Element node, String qName, String value) {
            int colonPosition = qName.indexOf(58);
            if (colonPosition >= 0) {
                String prefix = this.internalize(qName.substring(0, colonPosition));
                String localName = this.internalize(qName.substring(colonPosition + 1));
                if ("xmlns".equals(prefix)) {
                    Namespace.getNamespace((String)localName, (String)localName);
                } else {
                    XmlFormatExtractor.this.prefixMap.addNamespace(prefix, prefix);
                    Namespace namespace = "xml".equals(prefix) ? Namespace.XML_NAMESPACE : Namespace.getNamespace((String)prefix, (String)prefix);
                    node.setAttribute(localName, value, namespace);
                }
            } else if (!"xmlns".equals(qName)) {
                node.setAttribute(this.internalize(qName), value);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.textContentGluer.size() > 0) {
                StringBuilder parentText = this.textContentGluer.peek();
                String text = parentText.toString();
                parentText.delete(0, parentText.length());
                if (text.length() > 0) {
                    this.emitCharacters(text);
                }
            }
            this.textContentGluer.push(new StringBuilder());
            Element node = this.createElement(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.addAttribute(node, atts.getQName(i), atts.getValue(i));
            }
            this.hasSubElements = false;
            try {
                Object match;
                boolean nodePushedOnStack;
                if (!this.hasSeenTheRootElement) {
                    this.hasSeenTheRootElement = true;
                    nodePushedOnStack = false;
                } else {
                    this.domStack.pushAndAddAsChild(node);
                    nodePushedOnStack = true;
                }
                if (!this.rootElementAccumulator.isAccumulating() && (match = this.rootElementTarget.matches(this.stackedElementDocument, node)) instanceof List && ((List)match).size() == 1 && ((List)match).get(0) == node) {
                    this.rootElementAccumulator.startNode(node);
                    this.domStack.pop(true);
                    this.accumulationRow = this.rootElementHandler.handleAncestors(node, this.captureParentsHelper);
                    this.domStack.pushAndAddAsChild(node);
                }
                if (nodePushedOnStack && !this.rootElementAccumulator.isAccumulating()) {
                    this.captureParentsHelper.startElement(this.stackedElementDocument, qName, node);
                }
            }
            catch (JaxenException | JSONException e) {
                throw new WrappedExceptionAsSAXException((Exception)e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.emitCharacters(this.textContentGluer.pop().toString());
            Element node = this.domStack.peek();
            if (node != null && !this.rootElementAccumulator.isAccumulating()) {
                try {
                    this.captureParentsHelper.endElement(qName, node, this.hasSubElements);
                }
                catch (JSONException e) {
                    throw new WrappedExceptionAsSAXException((Exception)((Object)e));
                }
            }
            boolean rowFinished = false;
            if (this.rootElementAccumulator.endElement(node)) {
                this.rootElementHandler.handleContent(this.accumulationRow, this.rootElementAccumulator.getAccumulatedNode());
                this.accumulationRow = null;
                rowFinished = true;
            }
            this.domStack.pop(rowFinished || !this.rootElementAccumulator.isAccumulating() && !this.captureParentsHelper.isCapturing() && !this.captureParentsHelper.wantsToKeep(qName, node));
            this.hasSubElements = true;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textContentGluer.peek().append(ch, start, length);
        }

        private void emitCharacters(String text) throws SAXException {
            if ((this.rootElementAccumulator.isAccumulating() || this.captureParentsHelper.isCapturing() || this.captureParentsHelper.wantsToKeep(null, null)) && this.domStack.peek() != null) {
                Text node = new Text(text);
                this.domStack.peek().addContent((Content)node);
                if (!this.rootElementAccumulator.isAccumulating()) {
                    try {
                        this.captureParentsHelper.characters(this.stackedElementDocument, node);
                    }
                    catch (JaxenException | JSONException e) {
                        throw new WrappedExceptionAsSAXException((Exception)e);
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.rootElementHandler.finish();
        }
    }

    private abstract class RootElementHandler {
        private final RowFactory rf;
        protected final ColumnFactory cf;
        private final ProcessorOutput out;
        private final ArchiveCapableFormatExtractor.ArchiveCapableObserver observer;
        private long emittedCount = 0L;
        private final JDOM2XPath[] ancestorColumnExpressions;
        private final String[] ancestorColumnNames;

        public RootElementHandler(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
            this.out = out;
            this.cf = cf;
            this.rf = rf;
            this.observer = observer;
            if (XmlFormatExtractor.this.ancestorsXPaths != null) {
                this.ancestorColumnExpressions = new JDOM2XPath[XmlFormatExtractor.this.ancestorsXPaths.size()];
                this.ancestorColumnNames = new String[XmlFormatExtractor.this.ancestorsXPaths.size()];
                for (int i = 0; i < XmlFormatExtractor.this.ancestorsXPaths.size(); ++i) {
                    String xpath = XmlFormatExtractor.this.ancestorsXPaths.get((int)i).from == null ? null : XmlFormatExtractor.this.ancestorsXPaths.get((int)i).from.trim();
                    String name = XmlFormatExtractor.this.ancestorsXPaths.get((int)i).to == null ? null : XmlFormatExtractor.this.ancestorsXPaths.get((int)i).to.trim();
                    xpath = xpath != null && xpath.length() == 0 ? null : xpath;
                    String string = name = name != null && name.length() == 0 ? null : name;
                    if (xpath == null || name == null) {
                        if (name != null) {
                            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping, xpath expression not set for column '" + name + "'");
                        }
                        if (xpath != null) {
                            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping, column name not set for '" + xpath + "'");
                        }
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_FORMAT_CONFIG, "Incomplete parent XPath mapping ");
                    }
                    this.ancestorColumnNames[i] = name;
                    this.ancestorColumnExpressions[i] = new JDOM2XPath(xpath);
                    this.ancestorColumnExpressions[i].setNamespaceContext((NamespaceContext)XmlFormatExtractor.this.prefixMap);
                }
            } else {
                this.ancestorColumnExpressions = null;
                this.ancestorColumnNames = null;
            }
        }

        public abstract void convert(Object var1, Row var2) throws JaxenException;

        public Row handleAncestors(Element accumulationNode, CaptureParentsHelper captureParentsHelper) throws SAXException {
            Row r = this.rf.row();
            try {
                captureParentsHelper.fillRow(r, this.cf, accumulationNode);
            }
            catch (Exception e) {
                throw new WrappedExceptionAsSAXException(e);
            }
            return r;
        }

        public void handleContent(Row r, Object accumulationNode) throws SAXException {
            try {
                this.convert(accumulationNode, r);
                if (!this.observer.checkLimit(this.emittedCount)) {
                    throw new EmissionLimitAsSAXException();
                }
                ++this.emittedCount;
                this.out.emitRow(r);
                this.observer.onInterval(this.emittedCount);
            }
            catch (IOException | ParserConfigurationException e) {
                throw new SAXException("Failed to read element from xml stream : " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
            }
            catch (EmissionLimitAsSAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedExceptionAsSAXException(e);
            }
        }

        public void finish() throws SAXException {
            try {
                this.observer.onEnd(this.emittedCount);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrappedExceptionAsSAXException((Exception)e);
            }
        }
    }

    private static interface CaptureParentsHelper {
        public void startElement(Document var1, String var2, Element var3) throws JaxenException;

        public void endElement(String var1, Element var2, boolean var3);

        public void characters(Document var1, Text var2) throws JaxenException;

        public boolean isCapturing();

        public void fillRow(Row var1, ColumnFactory var2, Element var3);

        public boolean wantsToKeep(String var1, Element var2);
    }

    private class WrappedExceptionAsSAXException
    extends SAXException {
        private static final long serialVersionUID = -1L;
        public final Exception wrappedException;

        WrappedExceptionAsSAXException(Exception wrappedException) {
            this.wrappedException = wrappedException;
        }
    }

    private class EmissionLimitAsSAXException
    extends SAXException {
        private static final long serialVersionUID = -1L;

        EmissionLimitAsSAXException() {
        }
    }

    private class DomStackHelper {
        private final Document root;
        private final Deque<Element> domElements = new ArrayDeque<Element>();

        public DomStackHelper(Document root) {
            this.root = root;
        }

        public Element peek() {
            return this.domElements.size() > 0 ? this.domElements.peek() : null;
        }

        public void pushAndAddAsChild(Element node) {
            if (this.domElements.size() == 0) {
                this.root.setRootElement(node);
            } else {
                this.domElements.peek().addContent((Content)node);
            }
            this.domElements.push(node);
        }

        public void pop(boolean removeFromChildren) {
            Element node;
            Element element = node = this.domElements.size() > 0 ? this.domElements.pop() : null;
            if (node != null && removeFromChildren) {
                if (this.domElements.size() == 0) {
                    this.root.removeContent((Content)node);
                } else {
                    this.domElements.peek().removeContent((Content)node);
                }
            }
        }
    }

    private class FullNodeAccumulator
    implements NodeAccumulator {
        private Element accumulationNode = null;
        private boolean complete = false;
        private boolean accumulating = false;

        private FullNodeAccumulator() {
        }

        @Override
        public void startNode(Element node) {
            this.accumulationNode = node;
            this.complete = false;
            this.accumulating = true;
        }

        @Override
        public boolean endElement(Element node) {
            boolean newComplete = node != null && node == this.accumulationNode;
            boolean done = newComplete && !this.complete;
            this.complete = newComplete;
            if (this.complete) {
                this.accumulating = false;
            }
            return done;
        }

        @Override
        public Element getAccumulatedNode() {
            return this.accumulationNode;
        }

        @Override
        public boolean isAccumulating() {
            return this.accumulating;
        }
    }

    private static interface NodeAccumulator {
        public boolean isAccumulating();

        public void startNode(Element var1);

        public boolean endElement(Element var1);

        public Element getAccumulatedNode();
    }

    private class XPathTarget {
        private final JDOM2XPath elementPath;
        private Object accumulatedNode;
        private String jsonifiedNode;
        private String jsonifiedOverflow;
        private final boolean elementUnicity;

        public XPathTarget(String xpath, boolean unicity) throws JaxenException {
            this.elementPath = new JDOM2XPath(xpath);
            this.elementPath.setNamespaceContext((NamespaceContext)XmlFormatExtractor.this.prefixMap);
            this.elementUnicity = unicity;
        }

        public Object matches(Document stackedElementDocument, Object currentNode) throws JaxenException {
            if (stackedElementDocument.getContentSize() == 0 || currentNode == null) {
                return null;
            }
            Object found = null;
            try {
                found = this.elementPath.evaluate(stackedElementDocument);
                if (!(found instanceof List) || ((List)found).size() == 0) {
                    found = null;
                }
            }
            catch (UnresolvableException unresolvableException) {
                // empty catch block
            }
            return found;
        }

        public void setLastMatchSeen(Object accumulatedNode) {
            this.accumulatedNode = accumulatedNode;
            this.jsonifiedNode = null;
            this.jsonifiedOverflow = null;
        }

        private void jsonifyAccumulated() {
            if (this.accumulatedNode instanceof List) {
                List list = (List)this.accumulatedNode;
                if (this.elementUnicity) {
                    if (list.size() >= 1) {
                        this.jsonifiedNode = String.valueOf(XmlFormatExtractor.this.extractContent(list.get(0)));
                    }
                    if (list.size() > 1) {
                        JSONArray jsonifiedList = new JSONArray();
                        for (int j = 1; j < list.size(); ++j) {
                            jsonifiedList.put(XmlFormatExtractor.this.extractContent(list.get(j)));
                        }
                        this.jsonifiedOverflow = jsonifiedList.toString();
                    }
                } else {
                    JSONArray jsonifiedList = new JSONArray();
                    for (Object aList : list) {
                        jsonifiedList.put(XmlFormatExtractor.this.extractContent(aList));
                    }
                    this.jsonifiedNode = jsonifiedList.toString();
                }
            } else {
                Object extracted = XmlFormatExtractor.this.extractContent(this.accumulatedNode);
                this.jsonifiedNode = extracted != null ? extracted.toString() : "";
            }
        }

        public String getLastMatchSeen() {
            if (this.accumulatedNode == null) {
                return null;
            }
            if (this.jsonifiedNode == null) {
                this.jsonifyAccumulated();
            }
            return this.jsonifiedNode;
        }

        public String getLastOverflow() {
            if (this.accumulatedNode == null) {
                return null;
            }
            if (this.jsonifiedNode == null) {
                this.jsonifyAccumulated();
            }
            return this.jsonifiedOverflow;
        }
    }

    public static class XPathExtraction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String from;
        public String to;
        public boolean unique;

        public XPathExtraction(String from, String to, boolean unique) {
            this.from = from;
            this.to = to;
            this.unique = unique;
        }
    }
}

