/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVParser;
import com.dataiku.dip.input.formats.csv.EscapingOnlyCSVParser;
import com.dataiku.dip.input.formats.csv.NoEscapeNoQuoteCSVParser;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.formats.csv.UNIXStyleCSVParser;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.BoundedBufferedLineReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.BOMInputStream;
import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CSVFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final String TYPE = "csv";
    public static final CSVFormatMeta META = new CSVFormatMeta();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.format.csv");
    private final CSVFormatConfig conf;
    private CSVDeserializer deserializer;
    private StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
    private int cellsCharWarnThreshold;

    public CSVFormatExtractor(CSVFormatConfig conf) {
        if (conf.style == null || conf.getSeparatorStr() == null) {
            throw new IllegalArgumentException("Missing parameters for CSV");
        }
        this.conf = conf;
        this.cellsCharWarnThreshold = DKUApp.isConfigured() ? DKUApp.getParams().getIntParam("dku.input.formats.csv.cellCharsWarnThreshold", Integer.valueOf(500000)) : 500000;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        if (this.deserializer == null) {
            assert (this.warnContext != null);
            this.deserializer = new CSVDeserializer(this.conf, this.warnContext, this.rc);
        }
        if (com.dataiku.dip.utils.StringUtils.isUtf8((String)this.conf.charset)) {
            is = new BOMInputStream(is);
        }
        BoundedBufferedLineReader bufferedReader = new BoundedBufferedLineReader((Reader)new InputStreamReader(is, this.conf.charset), this.conf.getMaxRowChars());
        CSVParser parser = null;
        switch (this.conf.style) {
            case ESCAPE_ONLY_NO_QUOTE: {
                parser = new EscapingOnlyCSVParser((LineReader)bufferedReader, this.conf);
                break;
            }
            case EXCEL: {
                parser = new RFC4180CSVParser((LineReader)bufferedReader, this.conf);
                break;
            }
            case UNIX: {
                parser = new UNIXStyleCSVParser(new InputStreamReader(is, this.conf.charset), this.conf);
                break;
            }
            case NO_ESCAPE_NO_QUOTE: {
                parser = new NoEscapeNoQuoteCSVParser((LineReader)bufferedReader, this.conf.getSeparatorChar());
                break;
            }
        }
        try {
            return this.doExtractStream(isn, parser, out, cf, rf, observer);
        }
        catch (EOFException e) {
            try {
                if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"Unexpected end of ZLIB input stream")) {
                    throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_TRUNCATED_COMPRESSED_DATA, "Failed to read file " + isn.getFilename(), (Throwable)e);
                }
                throw new IOException("Failed to read file " + isn.getFilename(), e);
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e2) {
                    throw e2;
                }
                catch (IOException e3) {
                    throw new IOException("Failed to read file " + isn.getFilename(), e3);
                }
            }
            catch (IOException e4) {
                switch (this.conf.fileReadFailureBehavior) {
                    case FAIL: {
                        throw e4;
                    }
                    case WARN_AND_CONTINUE: {
                        this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_DATA, ExceptionUtils.getMessageWithCauses((Throwable)e4), logger);
                        return true;
                    }
                }
                throw new Error("unreachable");
            }
        }
    }

    public boolean doExtractStream(InputStreamWithContextInfo isn, LineReader rd, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        CSVParser parser = null;
        switch (this.conf.style) {
            case NO_ESCAPE_NO_QUOTE: {
                parser = new NoEscapeNoQuoteCSVParser(rd, this.conf.getSeparatorChar());
                break;
            }
            case EXCEL: {
                parser = new RFC4180CSVParser(rd, this.conf);
                break;
            }
            case ESCAPE_ONLY_NO_QUOTE: {
                parser = new EscapingOnlyCSVParser(rd, this.conf);
                break;
            }
            case UNIX: {
                throw new IllegalArgumentException("Unix CSV format not supported for complex input formats");
            }
        }
        return this.doExtractStream(isn, parser, out, cf, rf, observer);
    }

    protected boolean doExtractStream(InputStreamWithContextInfo isn, CSVParser parser, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        ArrayList<Column> columns = new ArrayList<Column>();
        if (this.schema != null) {
            for (SchemaColumn col : this.schema.getColumns()) {
                columns.add(cf.column(col.getName()));
            }
        }
        long fileLines = 0L;
        long emittedLines = 0L;
        long nintern = 0L;
        ArrayList<String> line = new ArrayList<String>();
        while (parser.next(line)) {
            this.rc.setLine(fileLines + 1L);
            if (!observer.checkLimit(emittedLines)) {
                return false;
            }
            if (fileLines >= (long)this.conf.skipRowsBeforeHeader) {
                if (fileLines == (long)this.conf.skipRowsBeforeHeader && this.conf.parseHeaderRow) {
                    List<String> columnNamesFromHeader = CSVFormatExtractor.fixDuplicateColumnNames(this.extractColumnNamesFromHeader(line));
                    int colIdx = 0;
                    for (String ch : columnNamesFromHeader) {
                        if (columns.size() <= colIdx) {
                            if (this.schema == null) {
                                columns.add(cf.column(ch));
                            } else if (colIdx < this.schema.getColumns().size()) {
                                columns.add(cf.column(ch));
                            } else if (colIdx >= this.schema.getColumns().size()) {
                                switch (this.conf.readAdditionalColumnsBehavior) {
                                    case DISCARD_SILENT: {
                                        break;
                                    }
                                    case DISCARD_WARNING: {
                                        this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_EXTRA_COLUMNS, this.rc.describe() + "Unexpected column found in header:" + ch, logger);
                                        break;
                                    }
                                    case ERROR: {
                                        throw ErrorContext.iae((String)(this.rc.describe() + "Unexpected column found in header: " + ch));
                                    }
                                    case INSERT_IN_DATA_SILENT: {
                                        columns.add(cf.column(ch));
                                        break;
                                    }
                                    case INSERT_IN_DATA_WARNING: {
                                        this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_EXTRA_COLUMNS, this.rc.describe() + "Unexpected column found in header:" + ch, logger);
                                        columns.add(cf.column(ch));
                                    }
                                }
                            }
                            cf.column(ch);
                        }
                        ++colIdx;
                    }
                } else if (fileLines >= (long)(this.conf.skipRowsBeforeHeader + this.conf.skipRowsAfterHeader + (this.conf.parseHeaderRow ? 1 : 0))) {
                    if (columns.size() > 0 && line.size() > columns.size()) {
                        switch (this.conf.readAdditionalColumnsBehavior) {
                            case DISCARD_SILENT: 
                            case INSERT_IN_DATA_SILENT: {
                                break;
                            }
                            case DISCARD_WARNING: 
                            case INSERT_IN_DATA_WARNING: {
                                this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_EXTRA_COLUMNS, this.rc.describe() + "Unexpected extra columns (expected=" + columns.size() + " read=" + line.size() + ")", logger);
                                break;
                            }
                            case ERROR: {
                                throw ErrorContext.iae((String)(this.rc.describe() + "Unexpected column found in line: (expected=" + columns.size() + " read=" + line.size() + ")"));
                            }
                        }
                    }
                    if (line.size() > columns.size()) {
                        boolean shouldAdd;
                        boolean bl = shouldAdd = this.schema == null || this.conf.readAdditionalColumnsBehavior == CSVFormatConfig.ReadAdditionalColumnsBehavior.INSERT_IN_DATA_SILENT || this.conf.readAdditionalColumnsBehavior == CSVFormatConfig.ReadAdditionalColumnsBehavior.INSERT_IN_DATA_WARNING;
                        if (shouldAdd) {
                            for (int i = columns.size(); i < line.size(); ++i) {
                                Object name = null;
                                name = this.getSchema() != null && this.getSchema().getColumns().size() > i ? ((SchemaColumn)this.getSchema().getColumns().get(i)).getName() : "col_" + i;
                                Column cd = cf.column((String)name);
                                columns.add(cd);
                            }
                        }
                    }
                    Row r = rf.row();
                    if (isn != null) {
                        isn.fillRowContext(r.getRowContext());
                        r.getRowContext().sourceRecord = emittedLines + 1L;
                    }
                    for (int i = 0; i < line.size() && i < columns.size(); ++i) {
                        String s = ((String)line.get(i)).trim();
                        if (this.cellsCharWarnThreshold > 0 && s.length() > this.cellsCharWarnThreshold) {
                            this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_VERY_LONG, "Unusually large column (quoting issue ?) : >>>>>>" + s.substring(0, Math.min(this.cellsCharWarnThreshold, 500)) + "<<<<<<", logger);
                        }
                        boolean nullString = false;
                        if (s.equals("null")) {
                            s = "null";
                            nullString = true;
                            ++nintern;
                        } else if (s.equals("NULL")) {
                            s = "NULL";
                            nullString = true;
                            ++nintern;
                        } else if (s.equals("\\N")) {
                            s = "\\N";
                            nullString = true;
                            ++nintern;
                        } else if (s.equals("true")) {
                            s = "true";
                            ++nintern;
                        } else if (s.equals("false")) {
                            s = "false";
                            ++nintern;
                        } else if (s.equals("Y")) {
                            s = "Y";
                            ++nintern;
                        } else if (s.equals("N")) {
                            s = "N";
                            ++nintern;
                        } else if (s.equals("0")) {
                            s = "0";
                            ++nintern;
                        }
                        if (!nullString && this.schema != null && i < this.schema.getColumns().size()) {
                            SchemaColumn sc = (SchemaColumn)this.schema.getColumns().get(i);
                            if (!sc.getType().isPrimitive()) {
                                s = this.deserializer.parseComplex(s, sc);
                            } else if (sc.getType() == Type.DATE) {
                                s = this.deserializer.parseDate(s, sc);
                            } else if (sc.getType() == Type.BOOLEAN) {
                                s = this.deserializer.parseBoolean(s, sc);
                            } else if (sc.getType() == Type.FLOAT || sc.getType() == Type.DOUBLE) {
                                s = this.deserializer.parseDouble(s, sc);
                            }
                        }
                        if (this.schema != null && i < this.schema.getColumns().size()) {
                            s = this.storageTypeVerifier.verify(s, (SchemaColumn)this.schema.getColumns().get(i), this.conf.readDataTypeMismatchBehavior, this.warnContext, this.rc);
                        }
                        r.put((Column)columns.get(i), s);
                    }
                    ++emittedLines;
                    out.emitRow(r);
                }
            }
            ++fileLines;
            if (emittedLines % 500L == 0L) {
                observer.onInterval(emittedLines);
            }
            if (emittedLines <= 0L || emittedLines % 100000L != 0L) continue;
            Runtime runtime = Runtime.getRuntime();
            double p = (double)runtime.totalMemory() / (double)runtime.maxMemory() * 100.0;
            logger.info((Object)("CSV Emitted " + emittedLines + " lines from file, " + columns.size() + " columns - interned: " + nintern + " MEM: " + p + "%"));
        }
        observer.onEnd(emittedLines);
        return true;
    }

    @VisibleForTesting
    static List<String> fixDuplicateColumnNames(List<String> columnNames) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        Map<String, Integer> originalNamesIndexes = columnNames.stream().collect(Collectors.toMap(colName -> colName, colName -> 2, (first, second) -> first));
        for (String originalColumnName : columnNames) {
            Object columnName = originalColumnName;
            int index = originalNamesIndexes.get(originalColumnName);
            while (result.contains(columnName)) {
                columnName = originalColumnName + "_" + index++;
                while (originalNamesIndexes.containsKey(columnName)) {
                    columnName = originalColumnName + "_" + index++;
                }
            }
            originalNamesIndexes.put(originalColumnName, index);
            result.add(columnName);
        }
        return new ArrayList<String>(result);
    }

    private List<String> extractColumnNamesFromHeader(List<String> line) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < line.size(); ++i) {
            Object header = line.get(i);
            header = StringUtils.defaultIfBlank((String)header, (String)"").trim();
            if (i == 0 && ((String)header).startsWith("#")) {
                header = ((String)header).substring(1);
            }
            if (this.schema != null && i < this.schema.getColumns().size()) {
                header = ((SchemaColumn)this.schema.getColumns().get(i)).getName();
            } else if (((String)header).isEmpty()) {
                header = "col_" + i;
            }
            result.add((String)header);
        }
        return result;
    }

    public static class CSVFormatMeta
    extends FormatMeta<CSVFormatExtractor, CSVFormatConfig> {
        @Override
        public String getType() {
            return CSVFormatExtractor.TYPE;
        }

        @Override
        public String getLabel() {
            return this.translate("DATASET_FORMAT_TYPE.CSV.LABEL", "Separated values (CSV, TSV, ...)");
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.advancedSelect("style", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.QUOTING_STYLE.LABEL", "Quoting style"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.QUOTING_STYLE.DESCRIPTION", "How quoting and escaping is handled"), new String[]{"excel", "unix", "escape_only_no_quote", "no_escape_no_quote"}, new String[]{"Excel style", "Unix style", "Escaping only", "No escaping nor quoting"}), new ParamDesc("separator", "char").withLabel(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.SEPARATOR.LABEL", "Separator")).withTooltip(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.SEPARATOR.DESCRIPTION", "Can be a single character, or a Unicode escape sequence like \\u0001")), new ParamDesc("quoteChar", "char").withMandatory(false).withCanBeEmpty(true).withLabel(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.QUOTING_CHARACTER.LABEL", "Quoting character")).withTooltip(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.QUOTING_CHARACTER.DESCRIPTION", "Character to enclose cells containing the separator. Can be a single character, or a Unicode escape sequence like \\u0001")), new ParamDesc("escapeChar", "char").withMandatory(false).withCanBeEmpty(true).withLabel(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.ESCAPE_CHARACTER.LABEL", "Escape character")).withTooltip(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.ESCAPE_CHARACTER.DESCRIPTION", "Character to escape special characters in cells. Can be a single character, or a Unicode escape sequence like \\u0001")), ParamDesc.intP("skipRowsBeforeHeader", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.SKIP_FIRST_LINES", "Skip first lines"), null), ParamDesc.booleanP("parseHeaderRow", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.PARSE_NEXT_LINE_AS_HEADER", "Parse next line as column headers"), null), ParamDesc.intP("skipRowsAfterHeader", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.SKIP_NEXT_LINES", "Skip next lines"), null), new ParamDesc("charset", "charset").withMandatory(false).withLabel(this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.CHARSET", "Charset")).withTooltip("Ex: utf-8, utf-16, windows-1252"), ParamDesc.simpleSelect("arrayMapFormat", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.ARRAY_MAP_FORMAT.LABEL", "arrayMapFormat"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.ARRAY_MAP_FORMAT.DESCRIPTION", "Format for map and array inside a column"), "json", "delimited", "hive"), new ParamDesc("arrayItemSeparator", "char").withMandatory(false), new ParamDesc("mapKeySeparator", "char").withMandatory(false), ParamDesc.simpleSelect("dateSerializationFormat", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.DATE_SERIALIZATION_FORMAT.LABEL", "Date serialization format"), "", "ISO", "HIVE", "ISO_FORCED_UTC").withDefaultValue("ISO"), FormatFactory.getStandardCompressionMethods(this.translationService, this.lang), ParamDesc.advancedSelect("readDataTypeMismatchBehavior", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.BAD_DATA_TYPE_BEHAVIOUR.READ.LABEL", "Bad data type behavior (read)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.BAD_DATA_TYPE_BEHAVIOUR.READ.DESCRIPTION", "How to react when reading data and a value not matching the storage type is  encountered"), StorageTypeVerifier.DataTypeMismatchBehavior.valueNames(), StorageTypeVerifier.DataTypeMismatchBehavior.labels(this.translationService, this.lang)), ParamDesc.advancedSelect("writeDataTypeMismatchBehavior", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.BAD_DATA_TYPE_BEHAVIOUR.WRITE.LABEL", "Bad data type behavior (write)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.BAD_DATA_TYPE_BEHAVIOUR.WRITE.DESCRIPTION", "How to react when writing data and a value not matching the storage type is  encountered"), StorageTypeVerifier.DataTypeMismatchBehavior.valueNames(), StorageTypeVerifier.DataTypeMismatchBehavior.labels(this.translationService, this.lang)), ParamDesc.booleanP("normalizeBooleans", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.NORMALIZE_BOOLEANS.LABEL", "Normalize booleans"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.NORMALIZE_BOOLEANS.DESCRIPTION", "Normalize all possible boolean values (0, 1, yes, no, ...) to 'true' and 'false'")), ParamDesc.booleanP("normalizeDoubles", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.NORMALIZE_FLOATS.LABEL", "Normalize floats & doubles"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.NORMALIZE_FLOATS.DESCRIPTION", "Normalize floating point values (force '42' to '42.0')")), ParamDesc.advancedSelect("readAdditionalColumnsBehavior", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.LABEL", "Add. columns behavior (read)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.DESCRIPTION", "How to react when reading data and additional columns are encountered"), new String[]{"INSERT_IN_DATA_SILENT", "INSERT_IN_DATA_WARNING", "DISCARD_SILENT", "DISCARD_WARNING", "ERROR"}, new String[]{this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.INSERT_IN_DATA_SILENT", "Insert in data (silent)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.INSERT_IN_DATA_WARNING", "Insert in data (and warn)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.DISCARD_SILENT", "Discard (silent)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.DISCARD_WARNING", "Discard (and warn)"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.READ_ADDITIONAL_COLUMNS_BEHAVIOUR.ERROR", "Error")}), ParamDesc.advancedSelect("fileReadFailureBehavior", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.FILE_READ_FAILURE_BEHAVIOUR.LABEL", "File read failure behavior"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.FILE_READ_FAILURE_BEHAVIOUR.DESCRIPTION", "How to react when reading data fails for the whole file"), new String[]{"FAIL", "WARN_AND_CONTINUE"}, new String[]{this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.FILE_READ_FAILURE_BEHAVIOUR.FAIL", "Fail"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.FILE_READ_FAILURE_BEHAVIOUR.WARN_AND_CONTINUE", "Emit a warning and continue with the next file (if any)")}), ParamDesc.intP("maxRowChars", this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.MAX_ROW_CHARS.LABEL", "Maximum characters per row"), this.translate("DATASET_FORMAT_TYPE.CSV.PARAMS.MAX_ROW_CHARS.DESCRIPTION", "Will fail if row length exceeds this value. 0 means no limit.")).withCanBeEmpty(true).withMandatory(false).withMaxI(Integer.MAX_VALUE)};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return CSVFormatConfig.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new CSVFormatExtractor((CSVFormatConfig)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new CSVOutputFormatter((CSVFormatConfig)params);
        }
    }
}

