/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerService;
import com.dataiku.dip.code.ICodeEnvResolutionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.engine.AsyncCloser;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.KernelUtils;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class PythonSecretProtectedKernel<Link extends SecretProtectedKernelLink>
extends DSSKernelBase {
    protected final String resourceFolderPath;
    protected final Map<String, String> pythonlibs;
    protected final boolean useProjectLibs;
    protected final Link link;
    protected final String envName;
    protected final String projectKey;
    protected final boolean impersonated;
    protected final File workDir;
    protected final AuthCtx authCtx;
    protected final GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType;
    private final IImpersonationResolverService impersonationResolverService;
    protected final WorkerPool workerPool;
    @VisibleForTesting
    public final Map<String, String> kernelEnvVariables = new HashMap<String, String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.python.kernel");

    protected PythonSecretProtectedKernel(AuthCtx authCtx, Link link, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonLibs, String projectKey, String envName, boolean impersonated, File workDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, @Nullable WorkerPool workerPool) {
        this(authCtx, link, resourceFolderPath, useProjectLibs, pythonLibs, projectKey, envName, impersonated, workDir, cgrouppableProcessType, workerPool, "python-single-command-kernel");
    }

    protected PythonSecretProtectedKernel(AuthCtx authCtx, Link link, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonLibs, String projectKey, String envName, boolean impersonated, File workDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, @Nullable WorkerPool workerPool, String kernelId) {
        super(kernelId);
        this.authCtx = authCtx;
        this.link = link;
        this.resourceFolderPath = resourceFolderPath;
        this.pythonlibs = pythonLibs;
        this.useProjectLibs = useProjectLibs;
        this.projectKey = projectKey;
        this.envName = envName;
        this.cgrouppableProcessType = cgrouppableProcessType;
        this.impersonated = impersonated;
        this.workDir = workDir;
        this.impersonationResolverService = impersonated ? (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class) : null;
        this.kernelEnvVariables.put("PYTHONIOENCODING", "UTF-8");
        if (StringUtils.isNotBlank((String)projectKey) && !"__DKU_ANY_PROJECT__".equals(projectKey)) {
            this.kernelEnvVariables.put("DKU_CURRENT_PROJECT_KEY", projectKey);
        }
        if (this.resourceFolderPath != null && this.resourceFolderPath.length() > 0) {
            this.kernelEnvVariables.put("DKU_CUSTOM_RESOURCE_FOLDER", this.resourceFolderPath);
        }
        if (workerPool == null) {
            workerPool = ((WorkerService)SpringUtils.getBean(WorkerService.class)).createWorkerPool(projectKey, envName, authCtx, null, impersonated, useProjectLibs, pythonLibs);
        }
        this.workerPool = workerPool;
        this.kernelEnvVariables.put("REMOTE_WORKER_POOL_ID", workerPool.getId());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Attached worker pool to " + ((Object)((Object)this)).getClass().getName() + " kernel: " + workerPool.getId()));
        }
        this.addOnShutdown(() -> new AsyncCloser().close(this.workerPool));
    }

    public PythonSecretProtectedKernel(AuthCtx authCtx, Link link, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonlibs, String projectKey, String envName, boolean impersonated, File workDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) {
        this(authCtx, link, resourceFolderPath, useProjectLibs, pythonlibs, projectKey, envName, impersonated, workDir, cgrouppableProcessType, null);
    }

    protected static Map<String, String> makePythonLibs(String libName, String libFolder) {
        if (StringUtils.isNotBlank((String)libFolder)) {
            return ImmutableMap.of((Object)"plugin-lib", (Object)libFolder);
        }
        return Collections.emptyMap();
    }

    public PythonSecretProtectedKernel<Link> withExtraKernelEnv(Map<String, String> extraEnv) {
        this.kernelEnvVariables.putAll(extraEnv);
        return this;
    }

    protected abstract String getPythonModule();

    protected List<String> getPythonCmd() throws IOException {
        return ((ICodeEnvResolutionService)SpringUtils.getBean(ICodeEnvResolutionService.class)).getPythonCmd(this.envName, this.projectKey, new ArrayList<String>());
    }

    protected Map<String, String> getCodeEnvResourcesEnvVariables() throws IOException {
        return ((ICodeEnvResolutionService)SpringUtils.getBean(ICodeEnvResolutionService.class)).getEnvironmentVariablesForPythonCmd(this.envName, this.projectKey);
    }

    public void start() throws Exception {
        List<String> args = this.getPythonCmd();
        args.add("-u");
        args.add("-m");
        args.add(this.getPythonModule());
        args.add(String.valueOf(this.link.getPort()));
        args.add(this.link.getSecret());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().putAll(this.getCodeEnvResourcesEnvVariables());
        pb.environment().putAll(this.kernelEnvVariables);
        boolean impersonated = this.impersonationResolverService != null && this.impersonationResolverService.isEnabled();
        KernelUtils.handlePythonAndRPath(this.authCtx, this.projectKey, this.useProjectLibs, this.pythonlibs, this.workDir, impersonated, pb);
        logger.info((Object)("Starting Python process for kernel  " + this.getId()));
        this.process = this.createAndStartProcess(pb, this.cgrouppableProcessType);
        this.startStandardTailers();
        this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
        if (this.cgrouppableProcessType != null) {
            this.monitorThread.enableComputeResourceUsageReporting(args.get(0));
        }
        this.monitorThread.setCloseOnFailure((Closeable)this.link.getServerSocket());
        try {
            this.monitorThread.start();
            this.link.waitForProcess();
        }
        catch (IOException e) {
            if (StringUtils.isNotBlank((String)e.getMessage()) && e.getMessage().startsWith("Subprocess failed to connect") && this.processExitException != null) {
                throw new IOException("Failure while waiting for process to connect", this.processExitException);
            }
            throw e;
        }
        finally {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    protected abstract IsolableProcess createAndStartProcess(ProcessBuilder var1, GeneralSettingsDAO.CGrouppableProcessType var2) throws DKUSecurityException, IOException, InterruptedException;

    public Integer getPid() {
        if (this.process != null) {
            return this.process.getWorkingPid();
        }
        return null;
    }
}

