/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class LabelingCommentMerger {
    LabelingCommentMerger() {
    }

    public static MergeResult merge(Map<String, String> commentsByAnnotators) {
        Map<String, String> normalizedComments = commentsByAnnotators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Strings.nullToEmpty((String)((String)entry.getValue())).trim()));
        Set distinctValues = normalizedComments.values().stream().filter(v -> !Strings.isNullOrEmpty((String)v)).collect(Collectors.toSet());
        String mergedString = distinctValues.size() <= 1 ? distinctValues.stream().findFirst().orElse("") : LabelingCommentMerger.concatenate(normalizedComments);
        return new MergeResult(mergedString, distinctValues.size());
    }

    private static String concatenate(Map<String, String> normalizedComments) {
        return normalizedComments.entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getValue()))).sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\n"));
    }

    public static class MergeResult {
        public final String mergedComment;
        public final int nbDistinctComments;

        public MergeResult(String mergedComment, int nbDistinctComments) {
            this.mergedComment = mergedComment;
            this.nbDistinctComments = nbDistinctComments;
        }
    }
}

