/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

@RoutinelyUsedInExtensionCode
public class LLMStructuredRef {
    public String id;
    public LLMType type;
    public String connection;
    public String model;
    public String deployment;
    public String savedModelSmartId;
    public String savedModelVersionId;
    @Deprecated(forRemoval=true)
    public String retrievableKnowledgeSmartId;
    public SageMakerGenericLLMConnection.CustomSageMakerModelType sageMakerModelType;

    public LLMStructuredRef withOtherConnection(String connection) {
        LLMStructuredRef tmpRef = LLMStructuredRef.decodeId(this.encodeToId());
        tmpRef.connection = connection;
        return LLMStructuredRef.decodeId(tmpRef.encodeToId());
    }

    public static LLMStructuredRef decodeId(String id) {
        if (id.startsWith("agent:")) {
            String[] chunks = id.split(":");
            if (chunks.length == 2) {
                return LLMStructuredRef.forAgentSavedModel(chunks[1]);
            }
            if (chunks.length == 3) {
                return LLMStructuredRef.forAgentSavedModelVersion(chunks[1], chunks[2]);
            }
            throw new IllegalArgumentException("Invalid Agent LLM ID: " + id);
        }
        if (id.startsWith("savedmodel:finetuned_openai:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forOpenAIFineTunedSavedModelVersion(chunks[2], chunks[3], chunks[4]);
        }
        if (id.startsWith("savedmodel:finetuned_azureopenai:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forAzureOpenAIFineTunedSavedModelVersion(chunks[2], chunks[3], chunks[4]);
        }
        if (id.startsWith("savedmodel:finetuned_huggingfacelocal:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forHuggingfaceLocalFineTunedSavedModelVersion(chunks[2], chunks[3], chunks[4]);
        }
        if (id.startsWith("savedmodel:finetuned_bedrock:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forBedrockFineTunedSavedModelVersion(chunks[2], chunks[3], chunks[4]);
        }
        if (id.startsWith("openai:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forOpenAIConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("azureopenai-model:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forAzureAIConnection(chunks[1], chunks[2], LLMType.AZURE_OPENAI_MODEL);
        }
        if (id.startsWith("azureopenai:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forAzureAIConnection(chunks[1], chunks[2], LLMType.AZURE_OPENAI_DEPLOYMENT);
        }
        if (id.startsWith("azureaifoundry:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forAzureAIConnection(chunks[1], chunks[2], LLMType.AZURE_AI_FOUNDRY_DEPLOYMENT);
        }
        if (id.startsWith("cohere")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forCohereConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("mistralai:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forMistralAIConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("anthropic")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forAnthropicConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("vertex:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forVertexConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("bedrock")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forBedrockConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("mosaicml")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forMosaicMLConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("stabilityai")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forStabilityAIConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("nvidia-nim")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forNvidiaNimConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("huggingfaceapi:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forHuggingFaceAPIConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("huggingfacelocal:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forHuggingFaceLocalModel(chunks[1], chunks[2]);
        }
        if (id.startsWith("databricksllm:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forDatabricksLLMConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("snowflakecortex:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forSnowflakeCortexLLMConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("retrievalaugmented:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forRetrievalAugmented(chunks[1], chunks[2]);
        }
        if (id.startsWith("retrieval-augmented-llm:")) {
            String[] chunks = id.split(":");
            if (chunks.length == 2) {
                return LLMStructuredRef.forRetrievalAugmentedLLM(chunks[1]);
            }
            if (chunks.length == 3) {
                return LLMStructuredRef.forRetrievalAugmentedLLMVersion(chunks[1], chunks[2]);
            }
            throw new IllegalArgumentException("Invalid Retrieval Augmented LLM ID: " + id);
        }
        if (id.startsWith("custom:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forCustomConnection(chunks[1], chunks[2]);
        }
        if (id.startsWith("sagemaker-generic:")) {
            String[] chunks = id.split(":");
            return LLMStructuredRef.forGenericSageMakerConnection(chunks[1], SageMakerGenericLLMConnection.CustomSageMakerModelType.valueOf(chunks[2]));
        }
        if (id.startsWith("azure-llm:")) {
            String[] chunks = id.split(":", 3);
            return LLMStructuredRef.forAzureLLMConnection(chunks[1], chunks[2]);
        }
        throw new IllegalArgumentException("Invalid LLM id: " + id);
    }

    public String encodeToId() {
        switch (this.type) {
            case SAVED_MODEL_AGENT: {
                if (this.savedModelVersionId == null) {
                    return "agent:" + this.savedModelSmartId;
                }
                return "agent:" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case SAVED_MODEL_FINETUNED_OPENAI: {
                return "savedmodel:finetuned_openai:" + this.connection + ":" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER: {
                return "savedmodel:finetuned_huggingfacelocal:" + this.connection + ":" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case SAVED_MODEL_FINETUNED_AZURE_OPENAI: {
                return "savedmodel:finetuned_azureopenai:" + this.connection + ":" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case SAVED_MODEL_FINETUNED_BEDROCK: {
                return "savedmodel:finetuned_bedrock:" + this.connection + ":" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case OPENAI: {
                return "openai:" + this.connection + ":" + this.model;
            }
            case AZURE_OPENAI_MODEL: {
                return "azureopenai-model:" + this.connection + ":" + this.model;
            }
            case AZURE_OPENAI_DEPLOYMENT: {
                return "azureopenai:" + this.connection + ":" + this.deployment;
            }
            case AZURE_AI_FOUNDRY_DEPLOYMENT: {
                return "azureaifoundry:" + this.connection + ":" + this.deployment;
            }
            case MISTRALAI: {
                return "mistralai:" + this.connection + ":" + this.model;
            }
            case COHERE: {
                return "cohere:" + this.connection + ":" + this.model;
            }
            case MOSAICML: {
                return "mosaicml:" + this.connection + ":" + this.model;
            }
            case ANTHROPIC: {
                return "anthropic:" + this.connection + ":" + this.model;
            }
            case VERTEX: {
                return "vertex:" + this.connection + ":" + this.model;
            }
            case BEDROCK: {
                return "bedrock:" + this.connection + ":" + this.model;
            }
            case STABILITYAI: {
                return "stabilityai:" + this.connection + ":" + this.model;
            }
            case HUGGINGFACE_API: {
                return "huggingfaceapi:" + this.connection + ":" + this.model;
            }
            case HUGGINGFACE_TRANSFORMER_LOCAL: {
                return "huggingfacelocal:" + this.connection + ":" + this.model;
            }
            case RETRIEVAL_AUGMENTED: {
                if (this.savedModelVersionId == null) {
                    return "retrieval-augmented-llm:" + this.savedModelSmartId;
                }
                return "retrieval-augmented-llm:" + this.savedModelSmartId + ":" + this.savedModelVersionId;
            }
            case DATABRICKS: {
                return "databricksllm:" + this.connection + ":" + this.model;
            }
            case SAGEMAKER_GENERICLLM: {
                return "sagemaker-generic:" + this.connection + ":" + this.sageMakerModelType.name();
            }
            case AZURE_LLM: {
                return "azure-llm:" + this.connection + ":" + this.model;
            }
            case CUSTOM: {
                return "custom:" + this.connection + ":" + this.model;
            }
            case SAVED_MODEL_FINETUNED_VERTEX: {
                throw new IllegalArgumentException("Unsupported LLM type: " + String.valueOf((Object)this.type));
            }
            case SNOWFLAKE_CORTEX: {
                return "snowflakecortex:" + this.connection + ":" + this.model;
            }
            case NVIDIA_NIM: {
                return "nvidia-nim:" + this.connection + ":" + this.model;
            }
        }
        throw new IllegalArgumentException("Unknown LLM type: " + String.valueOf((Object)this.type));
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public static LLMStructuredRef forAgentSavedModel(String savedModelSmartId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_AGENT;
        ret.savedModelSmartId = savedModelSmartId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forAgentSavedModelVersion(String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_AGENT;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forOpenAIFineTunedSavedModelVersion(String connection, String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_FINETUNED_OPENAI;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forOpenAIConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.OPENAI;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forMistralAIConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.MISTRALAI;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forAzureOpenAIFineTunedSavedModelVersion(String connection, String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_FINETUNED_AZURE_OPENAI;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forAzureAIConnection(String connection, String identifier, LLMType llmType) {
        LLMStructuredRef ret = new LLMStructuredRef();
        switch (llmType) {
            case AZURE_OPENAI_DEPLOYMENT: 
            case AZURE_AI_FOUNDRY_DEPLOYMENT: {
                ret.deployment = identifier;
                break;
            }
            case AZURE_OPENAI_MODEL: {
                ret.model = identifier;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LLM Type " + connection + " for Azure Open AI connection");
            }
        }
        ret.type = llmType;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forCohereConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.COHERE;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forStabilityAIConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.STABILITYAI;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forMosaicMLConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.MOSAICML;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forAnthropicConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.ANTHROPIC;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forVertexConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.VERTEX;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forBedrockConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.BEDROCK;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forBedrockFineTunedSavedModelVersion(String connection, String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_FINETUNED_BEDROCK;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forHuggingfaceLocalFineTunedSavedModelVersion(String connection, String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forDatabricksLLMConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.DATABRICKS;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forSnowflakeCortexLLMConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SNOWFLAKE_CORTEX;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forHuggingFaceAPIConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.HUGGINGFACE_API;
        ret.connection = connection;
        ret.model = model;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forHuggingFaceLocalModel(String connection, String modelId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.HUGGINGFACE_TRANSFORMER_LOCAL;
        ret.connection = connection;
        ret.model = modelId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forNvidiaNimConnection(String connection, String modelId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.NVIDIA_NIM;
        ret.connection = connection;
        ret.model = modelId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forRetrievalAugmentedLLM(String savedModelSmartId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.RETRIEVAL_AUGMENTED;
        ret.savedModelSmartId = savedModelSmartId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forRetrievalAugmentedLLMVersion(String savedModelSmartId, String versionId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.RETRIEVAL_AUGMENTED;
        ret.savedModelSmartId = savedModelSmartId;
        ret.savedModelVersionId = versionId;
        ret.id = ret.encodeToId();
        return ret;
    }

    private static String crc32HashShort(String input) {
        CRC32 crc = new CRC32();
        crc.update(input.getBytes(StandardCharsets.UTF_8));
        return String.format("%08x", crc.getValue()).substring(0, 8);
    }

    @Deprecated(forRemoval=true)
    public static LLMStructuredRef forRetrievalAugmented(String rkSmartOrNotId, String ragModelId) {
        String rkId;
        Object targetSmId = "";
        try {
            AnyLoc rkSmartLoc = AnyLoc.resolveFull(rkSmartOrNotId);
            targetSmId = (String)targetSmId + rkSmartLoc.getProjectKey() + ".";
            rkId = rkSmartLoc.getId();
        }
        catch (Throwable ignored) {
            rkId = rkSmartOrNotId;
        }
        targetSmId = (String)targetSmId + LLMStructuredRef.crc32HashShort(rkId + ":" + ragModelId);
        return LLMStructuredRef.forRetrievalAugmentedLLM((String)targetSmId);
    }

    public static LLMStructuredRef forCustomConnection(String connection, String customModelId) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.CUSTOM;
        ret.connection = connection;
        ret.model = customModelId;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forGenericSageMakerConnection(String connection, SageMakerGenericLLMConnection.CustomSageMakerModelType modelType) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.SAGEMAKER_GENERICLLM;
        ret.connection = connection;
        ret.sageMakerModelType = modelType;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forAzureLLMConnection(String connection, String model) {
        LLMStructuredRef ret = new LLMStructuredRef();
        ret.type = LLMType.AZURE_LLM;
        ret.model = model;
        ret.connection = connection;
        ret.id = ret.encodeToId();
        return ret;
    }

    public static LLMStructuredRef forFinetunedSavedModelVersion(LLMType llmType, String connection, String savedModelSmartId, String version) {
        switch (llmType) {
            case SAVED_MODEL_FINETUNED_OPENAI: {
                return LLMStructuredRef.forOpenAIFineTunedSavedModelVersion(connection, savedModelSmartId, version);
            }
            case SAVED_MODEL_FINETUNED_AZURE_OPENAI: {
                return LLMStructuredRef.forAzureOpenAIFineTunedSavedModelVersion(connection, savedModelSmartId, version);
            }
            case SAVED_MODEL_FINETUNED_BEDROCK: {
                return LLMStructuredRef.forBedrockFineTunedSavedModelVersion(connection, savedModelSmartId, version);
            }
            case SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER: {
                return LLMStructuredRef.forHuggingfaceLocalFineTunedSavedModelVersion(connection, savedModelSmartId, version);
            }
        }
        throw new IllegalArgumentException("Unsupported fine-tuned llm type");
    }

    public String getFinetunedModelMetaName() {
        if (Sets.newHashSet((Object[])new LLMType[]{LLMType.OPENAI, LLMType.SAVED_MODEL_FINETUNED_OPENAI}).contains((Object)this.type)) {
            return "OpenAI fine-tuned Saved Model";
        }
        if (Sets.newHashSet((Object[])new LLMType[]{LLMType.AZURE_OPENAI_MODEL, LLMType.SAVED_MODEL_FINETUNED_AZURE_OPENAI}).contains((Object)this.type)) {
            return "Azure OpenAI fine-tuned Saved Model";
        }
        if (Sets.newHashSet((Object[])new LLMType[]{LLMType.BEDROCK, LLMType.SAVED_MODEL_FINETUNED_BEDROCK}).contains((Object)this.type)) {
            return "AWS Bedrock fine-tuned Saved Model";
        }
        if (Sets.newHashSet((Object[])new LLMType[]{LLMType.HUGGINGFACE_TRANSFORMER_LOCAL, LLMType.SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER}).contains((Object)this.type)) {
            return "Local Huggingface fine-tuned Saved Model";
        }
        return null;
    }

    public boolean isProjectBound() {
        switch (this.type) {
            case SAVED_MODEL_AGENT: 
            case SAVED_MODEL_FINETUNED_OPENAI: 
            case SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER: 
            case SAVED_MODEL_FINETUNED_AZURE_OPENAI: 
            case SAVED_MODEL_FINETUNED_BEDROCK: 
            case RETRIEVAL_AUGMENTED: 
            case SAVED_MODEL_FINETUNED_VERTEX: {
                return true;
            }
        }
        return false;
    }

    public String getModelNameForAudit() {
        if (!Strings.isNullOrEmpty((String)this.model)) {
            return this.model;
        }
        if (!Strings.isNullOrEmpty((String)this.deployment)) {
            return this.deployment;
        }
        if (!Strings.isNullOrEmpty((String)this.savedModelSmartId)) {
            if (Strings.isNullOrEmpty((String)this.savedModelVersionId)) {
                return this.savedModelSmartId;
            }
            return this.savedModelSmartId + ":" + this.savedModelVersionId;
        }
        return "unknown";
    }

    public String getMinimallyLeakyModelNameForReporting() {
        return !Strings.isNullOrEmpty((String)this.model) ? this.model : "unknown";
    }

    public boolean equals(Object other) {
        if (!(other instanceof LLMStructuredRef)) {
            return false;
        }
        return this.encodeToId().equals(((LLMStructuredRef)other).encodeToId());
    }

    public int hashCode() {
        return this.encodeToId().hashCode();
    }

    public static enum LLMType {
        OPENAI,
        AZURE_OPENAI_MODEL,
        AZURE_OPENAI_DEPLOYMENT,
        AZURE_AI_FOUNDRY_DEPLOYMENT,
        AZURE_LLM,
        MISTRALAI,
        VERTEX,
        COHERE,
        ANTHROPIC,
        BEDROCK,
        MOSAICML,
        DATABRICKS,
        HUGGINGFACE_TRANSFORMER_LOCAL,
        HUGGINGFACE_API,
        SNOWFLAKE_CORTEX,
        STABILITYAI,
        SAVED_MODEL_AGENT,
        SAVED_MODEL_FINETUNED_OPENAI,
        SAVED_MODEL_FINETUNED_AZURE_OPENAI,
        SAVED_MODEL_FINETUNED_VERTEX,
        SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER,
        SAVED_MODEL_FINETUNED_BEDROCK,
        RETRIEVAL_AUGMENTED,
        CUSTOM,
        SAGEMAKER_GENERICLLM,
        NVIDIA_NIM;

    }
}

