/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.metrics.engines.BasicMetricsEngine;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveProbeEngine;
import com.dataiku.dip.metrics.engines.ImpalaColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaProbeEngine;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.PythonProbeEngine;
import com.dataiku.dip.metrics.engines.SQLColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SQLProbeEngine;
import com.dataiku.dip.metrics.engines.SparkColumnMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkProbeEngine;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MetricsEngineDesc {
    public final String type;
    public final String displayName;
    public static final MetricsEngineDesc BasicEngine = new MetricsEngineDesc("Basic", "Basic"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new BasicMetricsEngine(dataset, datasetHandler, partition, config.basic, context);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new BasicMetricsEngine(folder, folderHandler, partition, config.basic, context);
        }
    };
    public static final MetricsEngineDesc DSSEngine = new MetricsEngineDesc("DSS", "Stream"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new DSSMetricsEngine(dataset, partition, config.dss, context);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc SQLMetricsEngine = new MetricsEngineDesc("SQL_Metrics", "SQL"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new SQLMetricsEngine(engineRun, dataset, partition, config.sql);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc HiveMetricsEngine = new MetricsEngineDesc("Hive_Metrics", "Hive"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            HiveMetricsEngine engine = new HiveMetricsEngine(engineRun, dataset, partition, config.hive);
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc ImpalaMetricsEngine = new MetricsEngineDesc("Impala_Metrics", "Impala"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new ImpalaMetricsEngine(engineRun, dataset, partition, config.impala);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc SparkMetricsEngine = new MetricsEngineDesc("Spark_Metrics", "Spark"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            SparkMetricsEngine engine = new SparkMetricsEngine(engineRun, dataset, partition, config.spark);
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc SQLColumnMetricsEngine = new MetricsEngineDesc("SQL_ColumnmMetrics", "SQL per column"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new SQLColumnMetricsEngine(dataset, partition, config.sql);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc HiveColumnMetricsEngine = new MetricsEngineDesc("Hive_ColumnmMetrics", "Hive per column"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            HiveColumnMetricsEngine engine = new HiveColumnMetricsEngine(dataset, partition, config.hive);
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc ImpalaColumnMetricsEngine = new MetricsEngineDesc("Impala_ColumnMetrics", "Impala per column"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new ImpalaColumnMetricsEngine(dataset, partition, config.impala);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc SparkColumnMetricsEngine = new MetricsEngineDesc("Spark_ColumnMetrics", "Spark per column"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            SparkColumnMetricsEngine engine = new SparkColumnMetricsEngine(dataset, partition, config.spark, context.clusterSettings.getSparkSettings());
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc PythonEngine = new MetricsEngineDesc("Python", "Python"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new PythonProbeEngine(dataset, datasetHandler, partition, config.python, ticket);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new PythonProbeEngine(folder, folderHandler, partition, config.python, ticket);
        }
    };
    public static final MetricsEngineDesc SQLQueryEngine = new MetricsEngineDesc("SQLQuery", "SQL query"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new SQLProbeEngine(dataset, datasetHandler, partition, config.sql);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc ImpalaQueryEngine = new MetricsEngineDesc("ImpalaQuery", "Impala query"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return new ImpalaProbeEngine(dataset, datasetHandler, partition, config.impala);
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc HiveQueryEngine = new MetricsEngineDesc("HiveQuery", "Hive query"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            HiveProbeEngine engine = new HiveProbeEngine(dataset, datasetHandler, partition, config.hive);
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };
    public static final MetricsEngineDesc SparkQueryEngine = new MetricsEngineDesc("SparkQuery", "Spark query"){

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, Dataset dataset, DatasetHandler datasetHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            SparkProbeEngine engine = new SparkProbeEngine(dataset, datasetHandler, partition, config.spark, context.clusterSettings.getSparkSettings());
            SpringUtils.getInstance().autowire((Object)engine);
            return engine;
        }

        @Override
        public MetricsEngine build(MetricsEngineRun engineRun, ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, MetricsEngineConfig config, APITicketService.Ticket ticket, MetricsEngineContext context) {
            return null;
        }
    };

    protected MetricsEngineDesc(String type, String displayName) {
        this.type = type;
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public abstract MetricsEngine build(MetricsEngineRun var1, Dataset var2, DatasetHandler var3, Partition var4, MetricsEngineConfig var5, APITicketService.Ticket var6, MetricsEngineContext var7);

    public abstract MetricsEngine build(MetricsEngineRun var1, ManagedFolder var2, ManagedFolderHandler var3, Partition var4, MetricsEngineConfig var5, APITicketService.Ticket var6, MetricsEngineContext var7);

    public static Set<MetricsEngineDesc> getAvailableEngines(MetricsEngineGeneralSettings settings, MetricsEngineConfig engineConfig) {
        HashSet engines = Sets.newHashSet((Object[])new MetricsEngineDesc[]{BasicEngine, PythonEngine});
        if (engineConfig.dss.active) {
            engines.add(DSSEngine);
        }
        if (engineConfig.sql.active) {
            engines.add(SQLMetricsEngine);
            engines.add(SQLColumnMetricsEngine);
            engines.add(SQLQueryEngine);
        }
        if (engineConfig.impala.active && settings.impalaEnabled) {
            engines.add(ImpalaMetricsEngine);
            engines.add(ImpalaColumnMetricsEngine);
            engines.add(ImpalaQueryEngine);
        }
        if (engineConfig.hive.active && settings.hiveEnabled) {
            engines.add(HiveMetricsEngine);
            engines.add(HiveColumnMetricsEngine);
            engines.add(HiveQueryEngine);
        }
        if (engineConfig.spark.active && settings.sparkEnabled) {
            engines.add(SparkMetricsEngine);
            engines.add(SparkColumnMetricsEngine);
            engines.add(SparkQueryEngine);
        }
        return engines;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricsEngineDesc other = (MetricsEngineDesc)obj;
        return this.type.equals(other.type);
    }

    public static class MetricsEngineConfig {
        public boolean padRunsWithMetrics = false;
        JdbcEngine.HiveMetricsEngineConfig hive = new JdbcEngine.HiveMetricsEngineConfig();
        BasicMetricsEngine.BasicMetricsEngineConfig basic = new BasicMetricsEngine.BasicMetricsEngineConfig();
        DSSMetricsEngine.DSSMetricsEngineConfig dss = new DSSMetricsEngine.DSSMetricsEngineConfig();
        JdbcEngine.SQLMetricsEngineConfig sql = new JdbcEngine.SQLMetricsEngineConfig();
        JdbcEngine.ImpalaMetricsEngineConfig impala = new JdbcEngine.ImpalaMetricsEngineConfig();
        JdbcEngine.SparkMetricsEngineConfig spark = new JdbcEngine.SparkMetricsEngineConfig();
        PythonProbeEngine.PythonMetricsEngineConfig python = new PythonProbeEngine.PythonMetricsEngineConfig();
    }

    public static class MetricsEngineGeneralSettings {
        public boolean hiveEnabled;
        public boolean impalaEnabled;
        public boolean sparkEnabled;

        public boolean couldUseHiveMetastore() {
            return this.hiveEnabled || this.impalaEnabled || this.sparkEnabled;
        }
    }

    public static class MetricsEngineContext {
        public List<Partition> partitions;
        public final AuthCtx user;
        public ClusterSettings clusterSettings;

        public MetricsEngineContext(AuthCtx user) {
            this.user = user;
        }
    }
}

