/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.AbstractPythonCheck;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.CheckType;
import com.dataiku.dip.metrics.checks.CustomPythonCheckType;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomPythonCheck
extends AbstractPythonCheck {
    public transient CustomPythonCheckType checkType;
    public JsonObject config;

    public CustomPythonCheck() {
        this.type = "custom_python";
        this.meta.withName("Custom check ");
    }

    void loadCheckType() {
        this.checkType = (CustomPythonCheckType)CheckType.getCheckType(this.type);
        if (this.checkType != null) {
            this.meta.withName(this.checkType.getMeta().label);
        }
    }

    @Override
    public String getCode() throws IOException {
        if (this.checkType == null) {
            return null;
        }
        return this.checkType.getCustomPythonChecksService().getCode(this.type);
    }

    @Override
    protected PluginSettingsResolver.ResolvedSettings getPluginConfig(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        if (this.checkType == null) {
            return new PluginSettingsResolver.ResolvedSettings(null, null);
        }
        return this.checkType.getCustomPythonChecksService().getExpandedPluginSettings(this.type, authCtx, projectKey, this.config);
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        return this.doRun(authCtx, context, runReport);
    }

    @Override
    public Check trimForSave() {
        return this;
    }

    @Override
    public String getLegacyDatabaseId() {
        if (this.meta != null) {
            if (!StringUtils.isBlank((String)this.meta.getLabel())) {
                return this.meta.getLabel();
            }
            return this.meta.getName();
        }
        return null;
    }

    @Override
    protected String getEnvName(String projectKey) throws IOException {
        CodeEnvSelector envSelector = new CodeEnvSelector();
        return envSelector.selectForCustomPythonRecipe(this.checkType.getDesc().ownerPluginId);
    }

    @Override
    protected String getResourceFolder() {
        if (this.checkType == null) {
            return null;
        }
        return this.checkType.getCustomPythonChecksService().getResourceFolder(this.type);
    }

    @Override
    protected String getLibFolder() {
        if (this.checkType == null) {
            return null;
        }
        return this.checkType.getCustomPythonChecksService().getLibFolder(this.type);
    }

    @Override
    public AbstractCheckContext.CheckResult doRun(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        Preconditions.checkNotNull((Object)this.checkType, (Object)"Plugin or check type not found");
        return super.doRun(authCtx, context, runReport);
    }

    @Override
    public RuleValidationError verifyConfig(Dataset dataset) {
        return null;
    }

    @Override
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return null;
    }
}

