/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.pivot.backend.dss.LinoPivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.dss.ShakerToLino;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;

public class LinoCacheBuilderService {
    final DataService shakerDataService;
    final SerializedShakerScript scriptForTypeHandling;
    final List<ScriptStep> steps;
    final SerializedShakerScript.RefreshableStreamableSelection sampleSettings;
    final Dataset dataset;
    final DSSAuthCtx user;
    final PivotTableRequest request;
    String usedSampleId;
    boolean onGoing;
    File cacheFolder;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.lino.service");

    public LinoCacheBuilderService(PivotTableRequest request, Dataset dataset, SerializedShakerScript scriptForTypeHandling, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps, DSSAuthCtx user, DataService shakerDataService) {
        this.request = request;
        this.dataset = dataset;
        this.scriptForTypeHandling = scriptForTypeHandling;
        this.sampleSettings = sampleSettings;
        this.steps = steps;
        this.user = user;
        this.shakerDataService = shakerDataService;
    }

    public void buildLinoCache() throws Exception {
        StreamableDatasetSelection selection;
        MemTable typeHandlingMT = this.shakerDataService.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.scriptForTypeHandling, null, null, (boolean)true, (AuthCtx)this.user).table;
        Schema schema = TableToSchema.inferSchemaSimple(typeHandlingMT, false);
        LinoUtils.checkAllColumns(schema.getColumns(), this.request);
        List<SchemaColumn> linoableColumns = LinoUtils.getLinoableColumns(typeHandlingMT);
        if (this.request == null || LinoUtils.allColumnsAreLinoable(linoableColumns, this.request)) {
            this.onGoing = true;
            logger.info((Object)"Will build and use a cache, computing new hash");
            this.usedSampleId = ShakerSamplingUtils.computeSampleId(this.user, this.dataset, this.sampleSettings, this.steps, typeHandlingMT);
            String shakerId = this.dataset.getProjectKey() + "_" + this.dataset.getName();
            this.cacheFolder = LinoPivotTablesService.getLinoCacheFolder(shakerId, this.usedSampleId, this.sampleSettings._refreshTrigger);
            DKUFileUtils.mkdirs((File)this.cacheFolder);
            selection = this.sampleSettings.selection;
            if (selection.filter != null) {
                logger.debug((Object)"Expanding variables");
                VariablesContext variablesContext = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(this.dataset.getProjectKey());
                FilterDescUtils.expand(selection.filter, variablesContext);
            }
        } else {
            throw new NotImplementedException();
        }
        logger.info((Object)("Build cache with " + JSON.json((Object)((Object)selection))));
        ShakerToLino.fromDataset(this.user, this.dataset, selection, this.steps, this.cacheFolder, "cache", linoableColumns);
        logger.info((Object)"Done");
        this.onGoing = false;
    }

    public void abortHook() {
        try {
            if (this.onGoing && this.cacheFolder != null) {
                DKUFileUtils.deleteDirectory((File)this.cacheFolder);
                logger.info((Object)("Future was aborted, deleted LINO cache " + this.cacheFolder.getPath()));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Couldn't delete LINO cache on future abort", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class BuildLinoCacheFutureResponse {
        String usedSampleId;
    }

    public static class BuildLinoCacheFutureThread
    extends FutureThread<BuildLinoCacheFutureResponse> {
        final DataService shakerDataService;
        final SerializedShakerScript scriptForTypeHandling;
        final List<ScriptStep> steps;
        final FuturePayload futurePayload;
        final SerializedShakerScript.RefreshableStreamableSelection sampleSettings;
        final Dataset dataset;
        final PivotTableRequest request;
        final LinoCacheBuilderService cacheBuilderService;
        String usedSampleId;

        public BuildLinoCacheFutureThread(PivotTableRequest request, Dataset dataset, SerializedShakerScript scriptForTypeHandling, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps, DSSAuthCtx user, DataService shakerDataService) {
            super(user);
            this.request = request;
            this.dataset = dataset;
            this.scriptForTypeHandling = scriptForTypeHandling;
            this.sampleSettings = sampleSettings;
            this.steps = steps;
            this.shakerDataService = shakerDataService;
            this.futurePayload = LinoPivotTablesService.buildFuturePayload(dataset);
            this.cacheBuilderService = new LinoCacheBuilderService(request, dataset, scriptForTypeHandling, sampleSettings, steps, this.owner, shakerDataService);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 1.0;
        }

        public void execute() throws Exception {
            try (FutureAborter.AutoCloseableAbortHook abort = FutureAborter.pushAutoCloseableHook(this.cacheBuilderService::abortHook);){
                this.cacheBuilderService.buildLinoCache();
                this.usedSampleId = this.cacheBuilderService.usedSampleId;
            }
        }

        public BuildLinoCacheFutureResponse getResult() {
            BuildLinoCacheFutureResponse r = new BuildLinoCacheFutureResponse();
            r.usedSampleId = this.usedSampleId;
            return r;
        }

        static {
            JSON.registerAdapter(BuildLinoCacheFutureThread.class, (Object)new JSON.Adapter<BuildLinoCacheFutureThread>(){

                public BuildLinoCacheFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    PivotTableRequest request = (PivotTableRequest)ctx.deserialize(jsonObj.get("request"), PivotTableRequest.class);
                    SerializedShakerScript scriptForTypeHandling = (SerializedShakerScript)ctx.deserialize(jsonObj.get("scriptForTypeHandling"), SerializedShakerScript.class);
                    SerializedShakerScript.RefreshableStreamableSelection sampleSettings = (SerializedShakerScript.RefreshableStreamableSelection)ctx.deserialize(jsonObj.get("sampleSettings"), SerializedShakerScript.RefreshableStreamableSelection.class);
                    List steps = (List)ctx.deserialize(jsonObj.get("steps"), new TypeToken<List<ScriptStep>>(){}.getType());
                    String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                    SerializedDataset serializedDataset = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                    Dataset dataset = Dataset.fromSerialized(datasetFullName, serializedDataset);
                    DataService service = (DataService)SpringUtils.getBean(DataService.class);
                    return new BuildLinoCacheFutureThread(request, dataset, scriptForTypeHandling, sampleSettings, steps, owner, service);
                }

                public JsonElement serialize(BuildLinoCacheFutureThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.addProperty("datasetFullName", ft.dataset.getFullName());
                    ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                    ret.add("scriptForTypeHandling", ctx.serialize((Object)ft.scriptForTypeHandling));
                    ret.add("sampleSettings", ctx.serialize((Object)ft.sampleSettings));
                    ret.add("steps", ctx.serialize(ft.steps));
                    ret.add("request", ctx.serialize((Object)ft.request));
                    return ret;
                }
            });
        }
    }
}

