/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKUtils;
import gnu.trove.iterator.TLongLongIterator;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Objects;

public class DateAxisFaceter
implements AxisFaceter {
    private final RowFilter filter;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double globalMin = Double.POSITIVE_INFINITY;
    private double globalMax = Double.NEGATIVE_INFINITY;
    private final ChartFilter.DateFilterPart part = ChartFilter.DateFilterPart.YEAR;
    private final ChartFilter.DateRelativeOption option = new ChartFilter.DateRelativeOption();
    private final TLongLongMap map = new TLongLongHashMap(10, 0.5f, Long.MIN_VALUE, -1L);
    private long nanValues = 0L;
    private long rawNanValues = 0L;
    private final Calendar cal = DKUtils.getUTCCalendar();

    public DateAxisFaceter(RowFilter filter) {
        this.filter = filter;
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            double value = block.doubles[i];
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                ++this.rawNanValues;
                if (!filters[i]) continue;
                ++this.nanValues;
                continue;
            }
            this.globalMin = Math.min((double)((long)value), this.globalMin);
            this.globalMax = Math.max((double)((long)value), this.globalMax);
            this.binify((long)value, filters[i]);
        }
    }

    private void binify(long ts, boolean toKeep) {
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RANGE && toKeep) {
            this.min = Math.min((double)ts, this.min);
            this.max = Math.max((double)ts, this.max);
        } else if (this.filter.dateFilterType != ChartFilter.DateFilterType.RELATIVE) {
            this.cal.setTimeInMillis(ts);
            int binId = DateAxisFaceter.getBinId(this.filter.dateFilterPart, ts, this.cal);
            if (this.map.get((long)binId) == -1L) {
                this.map.put((long)binId, 0L);
            }
            if (toKeep) {
                this.map.increment((long)binId);
            }
        }
    }

    @Override
    public FilterFacet compute(boolean shouldKeepRelevantValuesOnly) {
        FilterFacet ff = new FilterFacet();
        ff.globalMinValue = this.globalMin;
        ff.globalMaxValue = this.globalMax;
        if (this.min == Double.POSITIVE_INFINITY) {
            this.min = this.max = this.globalMin;
        }
        if (this.filter.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            ff.minValue = this.min;
            ff.maxValue = this.max;
            if (this.filter.dateFilterOption != null && this.filter.minValue != null && this.filter.maxValue != null) {
                ff.minValue = this.filter.minValue;
                ff.maxValue = this.filter.maxValue;
            }
        } else if (this.filter.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
            ff.part = this.part;
            ff.option = this.option;
        } else {
            IDateBinner dateBinner = BinningToSQL.toBinningMode(this.filter.dateFilterType, this.filter.dateFilterPart).getDateBinner();
            TLongLongIterator iterator = this.map.iterator();
            int i = this.map.size();
            while (i-- > 0) {
                iterator.advance();
                if (iterator.value() <= 0L && shouldKeepRelevantValuesOnly) continue;
                ff.values.add(new FilterFacet.Val("" + iterator.key(), dateBinner.getLabel(iterator.key()), iterator.value()));
            }
            if (this.nanValues > 0L || !shouldKeepRelevantValuesOnly && this.rawNanValues > 0L) {
                ff.values.add(new FilterFacet.Val("___dku_no_value___", "No value", this.nanValues));
            }
            ff.values.sort(PivotUtils.buildDateComparator(Objects.requireNonNullElse(this.filter.facetSorting, ChartFilter.FilterSortingOptions.NATURAL_ORDER_ASC), dateBinner));
        }
        return ff;
    }

    public static String getLabel(ChartFilter.DateFilterPart dateFilterPart, long binId) {
        switch (DateAxisFaceter.safePart(dateFilterPart)) {
            case YEAR: 
            case HOUR_OF_DAY: {
                return "" + binId;
            }
            case DAY_OF_WEEK: {
                return (new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"})[(int)binId];
            }
            case DAY_OF_MONTH: 
            case MONTH_OF_YEAR: 
            case QUARTER_OF_YEAR: 
            case WEEK_OF_YEAR: {
                return "" + (binId + 1L);
            }
            case INDIVIDUAL: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                return df.format(binId * 1000L);
            }
        }
        throw new Error("Unreachable");
    }

    public static int getBinId(ChartFilter.DateFilterPart dateFilterPart, long timestamp, Calendar cal) {
        cal.setTimeInMillis(timestamp);
        switch (DateAxisFaceter.safePart(dateFilterPart)) {
            case YEAR: {
                return cal.get(1);
            }
            case DAY_OF_MONTH: {
                return cal.get(5) - 1;
            }
            case DAY_OF_WEEK: {
                return (cal.get(7) + 5) % 7;
            }
            case HOUR_OF_DAY: {
                return cal.get(11);
            }
            case MONTH_OF_YEAR: {
                return cal.get(2);
            }
            case QUARTER_OF_YEAR: {
                return cal.get(2) / 3;
            }
            case WEEK_OF_YEAR: {
                return cal.get(3) - 1;
            }
            case INDIVIDUAL: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return (int)(cal.getTimeInMillis() / 1000L);
            }
        }
        throw new Error("unreachable");
    }

    private static ChartFilter.DateFilterPart safePart(ChartFilter.DateFilterPart dateFilterPart) {
        return dateFilterPart == null ? ChartFilter.DateFilterPart.YEAR : dateFilterPart;
    }
}

