/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.binners;

import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.DateAxisElt;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.pivot.backend.sql.binners.LongAxisBinner;
import com.google.common.annotations.VisibleForTesting;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.List;

public class DateBinner
implements LongAxisBinner {
    private boolean generateTotalBin;
    private TLongSet binIds = new TLongHashSet(100);
    private boolean naturalOrder;
    private List<Long> sortedBinIds = new ArrayList<Long>();
    private final IDateBinner binner;
    private List<AxisElt> sortedAxisElements;
    private DateAxisElt totalBin;

    DateBinner(DateAxisParams.BinningMode mode, TLongArrayList values, boolean naturalOrder, boolean generateTotalBin) {
        this.binner = mode.getDateBinner();
        if (values.isEmpty()) {
            return;
        }
        this.naturalOrder = naturalOrder;
        this.generateTotalBin = generateTotalBin;
        long minBin = this.binner.getBinIdFromSqlValue(values.min());
        long maxBin = this.binner.getBinIdFromSqlValue(values.max());
        this.binIds.add(minBin);
        this.binIds.add(maxBin);
        if (!naturalOrder) {
            for (int i = 0; i < values.size(); ++i) {
                this.sortedBinIds.add(this.binner.getBinIdFromSqlValue(values.get(i)));
            }
        }
    }

    public static int getNbBins(DateAxisParams.BinningMode mode, TLongArrayList values) {
        if (values.isEmpty()) {
            return 0;
        }
        IDateBinner binner = mode.getDateBinner();
        long minBin = binner.getBinIdFromSqlValue(values.min());
        long maxBin = binner.getBinIdFromSqlValue(values.max());
        return 1 + (int)(maxBin - minBin);
    }

    @VisibleForTesting
    DateAxisElt buildDateAxisEltFromBinId(long binId, int index) {
        return this.binner.buildDateAxisElt(binId, null, index);
    }

    @VisibleForTesting
    DateAxisElt buildDateAxisEltFromTimestamp(long timestamp, int index) {
        return this.binner.buildDateAxisElt(null, timestamp, index);
    }

    @Override
    public AxisElt getOtherBin() {
        return null;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        if (this.sortedAxisElements == null) {
            List<AxisElt> naturallyOrderedAxisElts = this.binner.getNaturallyOrderedAxisElementsFromBinIdRange(this.binIds);
            List<AxisElt> list = this.sortedAxisElements = this.naturalOrder ? naturallyOrderedAxisElts : this.sortAxisElts(naturallyOrderedAxisElts);
            if (this.generateTotalBin) {
                this.totalBin = new DateAxisElt();
                this.totalBin.label = "___dku_total_value___";
                this.totalBin.tsValue = Long.MAX_VALUE;
                this.totalBin.sortValue = 9.223372036854776E18;
                this.totalBin.binIndex = this.sortedAxisElements.size();
                this.sortedAxisElements.add(this.totalBin);
            }
        }
        return this.sortedAxisElements;
    }

    @Override
    public int assign(Long val) {
        if (val == null && this.generateTotalBin) {
            return this.totalBin.binIndex;
        }
        return this.getAxisElementIndex(this.binner.getBinIdFromSqlValue(val), this.getAxisElts());
    }

    private List<AxisElt> sortAxisElts(List<AxisElt> naturalAxisElts) {
        ArrayList<AxisElt> workingCopyOfNaturallyOrderedAxisElements = new ArrayList<AxisElt>(naturalAxisElts);
        ArrayList<AxisElt> orderedResult = new ArrayList<AxisElt>();
        for (Long binId : this.sortedBinIds) {
            int axisElementIndexForBinId = this.getAxisElementIndex(binId, workingCopyOfNaturallyOrderedAxisElements);
            orderedResult.add((AxisElt)workingCopyOfNaturallyOrderedAxisElements.remove(axisElementIndexForBinId));
        }
        orderedResult.addAll(workingCopyOfNaturallyOrderedAxisElements);
        return orderedResult;
    }

    private int getAxisElementIndex(long binId, List<AxisElt> axisElts) {
        for (int i = 0; i < axisElts.size(); ++i) {
            AxisElt axisElt = axisElts.get(i);
            if (!this.binner.getLabel(binId).equals(axisElt.label)) continue;
            return i;
        }
        throw new IllegalStateException(String.format("Could not find axis element for binId %s", binId));
    }
}

