/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.SQLPivotListener;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.FacetSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class FacetHybridExecutor
implements Callable<FilterFacet> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.facets");
    private final Future<BasicStatsBuilder.BasicStats> globalStatsFuture;
    private final ExecutionContext ctx;
    private final Future<ColumnMapper> colMappingFuture;
    private final List<RowFilter> filters;
    private final int index;
    private final RowFilter rf;
    private final Future<BasicStatsBuilder.BasicStats> basicStatsFuture;
    private final FutureProgressState futureState;

    public FacetHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, Future<BasicStatsBuilder.BasicStats> basicStatsFuture, Future<BasicStatsBuilder.BasicStats> globalStatsFuture, RowFilter rf, List<RowFilter> filters, int index, FutureProgressState futureState) {
        this.ctx = ctx;
        this.colMappingFuture = colMappingFuture;
        this.basicStatsFuture = basicStatsFuture;
        this.globalStatsFuture = globalStatsFuture;
        this.rf = rf;
        this.filters = filters;
        this.index = index;
        this.futureState = futureState;
    }

    public FilterFacet copyAndSetIndex(FilterFacet facet, BasicStatsBuilder.BasicStats basicStats) {
        BasicStatsBuilder.ColStats colStats;
        FilterFacet ff = (FilterFacet)JSON.deepCopy((Object)facet);
        ff.filterIdx = this.index;
        if (basicStats != null && ff.type != FilterRequest.FilterType.ALPHANUM_FACET && (colStats = basicStats.columnStats.get(ff.column)) != null) {
            ff.globalMaxValue = colStats.maxValue;
            ff.globalMinValue = colStats.minValue;
            ff.count = colStats.approxCount;
        }
        return ff;
    }

    @Override
    public FilterFacet call() throws Exception {
        logger.debug((Object)("Starting task: Facet " + this.index));
        try {
            this.ctx.listener.facetProgress(this.index, SQLPivotListener.FacetStatus.RUNNING);
            FilterFacet filterFacet = this.exec();
            return filterFacet;
        }
        finally {
            this.futureState.increment(1.0);
            this.ctx.listener.facetProgress(this.index, SQLPivotListener.FacetStatus.DONE);
            logger.debug((Object)("Done task: Facet " + this.index));
        }
    }

    private FilterFacet exec() throws Exception {
        FilterFacet facet = this.ctx.cache.facetCache.get(this.filters, this.rf);
        if (facet != null) {
            logger.info((Object)("Fetched facet #" + (this.index + 1) + " from cache"));
            return this.copyAndSetIndex(facet, null);
        }
        ArrayList<String> bsCols = new ArrayList<String>();
        for (AxisDef def : BasicStatsToSQL.determineDependentColumns(this.ctx.req)) {
            bsCols.add(def.column);
        }
        BasicStatsBuilder.BasicStats globalStats = null;
        if (this.globalStatsFuture != null && this.rf.columnType != AxisDef.Type.ALPHANUM) {
            globalStats = this.globalStatsFuture.get();
        }
        if (this.rf.columnType == AxisDef.Type.NUMERICAL && bsCols.contains(this.rf.column) && FilterUtils.isEquivalent(this.ctx.req.filters, this.filters)) {
            this.basicStatsFuture.get();
            facet = this.ctx.cache.facetCache.get(this.filters, this.rf);
            if (facet != null) {
                logger.info((Object)("Built facet #" + (this.index + 1) + " from basic stats"));
                return this.copyAndSetIndex(facet, globalStats);
            }
        }
        FacetSQLExecutor sqlExecutor = new FacetSQLExecutor(this.ctx, this.colMappingFuture, this.rf, this.filters, this.index, globalStats);
        facet = sqlExecutor.call();
        this.ctx.cache.facetCache.put(this.filters, this.rf, facet);
        return facet;
    }
}

