/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.sql.DatabricksSQLDialect;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.GreenplumSQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilterToSQL {
    private static final UnaryOperator<String> DEFAULT_TRANSFORMER = val -> val;
    public static final String DECIMAL_PLACES_KEY_PARAM = "decimal";
    private final ExpressionBuilder.ExpressionBuilderFactory expressionBuilder;
    private final ColumnMapper colMapping;
    private final SQLDialect dialect;
    private final BasicStatsBuilder.BasicStats globalStats;

    public FilterToSQL(SQLDialect dialect, ColumnMapper colMapping, BasicStatsBuilder.BasicStats globalStats) {
        this.colMapping = colMapping;
        this.dialect = dialect;
        this.globalStats = globalStats;
        this.expressionBuilder = new ExpressionBuilder.ExpressionBuilderFactory();
    }

    public FilterToSQL(SQLDialect dialect, ColumnMapper colMapping) {
        this(dialect, colMapping, null);
    }

    public ExpressionBuilder filterExpr(RowFilter rf) {
        if (rf.filterType == ChartFilter.FilterType.EXPLICIT) {
            return this.filterExplicitExpr(rf);
        }
        if (FilterUtils.canFilterAsAlphanum(rf)) {
            return this.filterAsAlphanum(rf);
        }
        if (rf.columnType == AxisDef.Type.NUMERICAL && rf.filterType == ChartFilter.FilterType.ALPHANUM_FACET) {
            return this.filterNumericalValues(rf);
        }
        if (!(rf.minValue == null && rf.maxValue == null && rf.getIncludeEmptyValuesOrDefault() || rf.columnType != AxisDef.Type.NUMERICAL && rf.columnType != AxisDef.Type.DATE)) {
            return this.filterNumericalRangeExpr(rf);
        }
        return null;
    }

    public void filterQuery(com.dataiku.dip.sql.queries.SelectQueryBuilder query, RowFilter rf) {
        ExpressionBuilder expr = this.filterExpr(rf);
        if (expr != null) {
            query.where(expr);
        }
    }

    public void filterQuery(SelectQueryBuilder query, RowFilter rf) {
        ExpressionBuilder expr = this.filterExpr(rf);
        if (expr != null) {
            query.where(expr.toSQL(this.dialect));
        }
    }

    public void filterQuery(com.dataiku.dip.sql.queries.SelectQueryBuilder query, List<RowFilter> rfs) {
        List<RowFilter> simpliedFilters = FilterUtils.intersectAndSort(rfs);
        for (RowFilter rf : simpliedFilters) {
            this.filterQuery(query, rf);
        }
    }

    public void filterQuery(SelectQueryBuilder query, List<RowFilter> rfs) {
        List<RowFilter> simpliedFilters = FilterUtils.intersectAndSort(rfs);
        for (RowFilter rf : simpliedFilters) {
            this.filterQuery(query, rf);
        }
    }

    public String buildFilterExpression(SQLDialect dialect, List<RowFilter> rfs) {
        ExpressionBuilder[] expressionFilters = (ExpressionBuilder[])rfs.stream().map(this::filterExpr).filter(Objects::nonNull).toArray(ExpressionBuilder[]::new);
        ExpressionBuilder expression = this.expressionBuilder.and(expressionFilters);
        if (expressionFilters.length == 0) {
            return null;
        }
        String fullFilterExpr = expression.toSQL(dialect);
        if (dialect instanceof TeradataSQLDialect) {
            return "CASE WHEN " + fullFilterExpr + " THEN 1 ELSE 0 END";
        }
        return fullFilterExpr;
    }

    private ExpressionBuilder filterExplicitExpr(RowFilter rf) {
        if (rf.explicitConditions.isEmpty()) {
            return null;
        }
        ExpressionBuilder[] explicitConditions = (ExpressionBuilder[])rf.explicitConditions.stream().map(explicitCondition -> {
            if (explicitCondition.columnType == AxisDef.Type.ALPHANUM || explicitCondition.columnType == AxisDef.Type.DATE && explicitCondition.dateFilterType != ChartFilter.DateFilterType.RANGE) {
                return this.filterAsAlphanum((ChartFilter.ExplicitCondition)explicitCondition);
            }
            if (!(explicitCondition.minValue == null && explicitCondition.maxValue == null || explicitCondition.columnType != AxisDef.Type.NUMERICAL && explicitCondition.columnType != AxisDef.Type.DATE)) {
                return this.filterNumericalRangeExpr((ChartFilter.ExplicitCondition)explicitCondition);
            }
            return null;
        }).filter(Objects::nonNull).toArray(ExpressionBuilder[]::new);
        return this.expressionBuilder.and(explicitConditions).not();
    }

    private ExpressionBuilder filterAsAlphanum(RowFilter rf) {
        BasicStatsBuilder.ColStats colStats;
        boolean useSelectedValues = FilterUtils.isASelectedValuesFilter(rf);
        ChartFilter.CustomOptions customOptions = Objects.requireNonNullElseGet(rf.customOptions, ChartFilter.CustomOptions::new);
        Integer decimalPlaces = customOptions.decimalPlaces;
        if (decimalPlaces == null && this.globalStats != null && rf.customOptions != null && (colStats = this.globalStats.columnStats.get(rf.column)) != null) {
            double minPrecision = (colStats.maxValue - colStats.minValue) / (double)colStats.approxCount;
            decimalPlaces = minPrecision > 0.0 ? Integer.valueOf((int)Math.ceil(-Math.log10(minPrecision))) : null;
        }
        ColumnMapper.TypedExpr colExpr = this.getColumnExpression(rf.column, rf.columnType, rf.dateFilterType, rf.dateFilterPart, decimalPlaces);
        UnaryOperator<String> transformer = this.getValueTransformer(rf.columnType, rf.dateFilterType, rf.dateFilterPart, rf.filterType);
        ExpressionBuilder expr = this.expressionBuilder.expr(this.colMapping.getAs((ColumnMapper.TypedExpr)colExpr, (ColumnMapper.ExprType)ColumnMapper.ExprType.STRING).expr);
        List<String> values = useSelectedValues ? rf.selectedValues : rf.excludedValues;
        String[] valuesTransformed = (String[])values.stream().map(val -> this.applyMode(customOptions.matchingMode, (String)transformer.apply((String)val))).toArray(String[]::new);
        if (values.isEmpty()) {
            return this.getEmptyFilter(useSelectedValues);
        }
        return this.filterValues(customOptions, !useSelectedValues, expr, valuesTransformed);
    }

    private ExpressionBuilder filterNumericalValues(RowFilter rf) {
        List<String> values;
        boolean useSelectedValues = FilterUtils.isASelectedValuesFilter(rf);
        ExpressionBuilder colExpr = this.expressionBuilder.expr(this.colMapping.getAs((String)rf.column, (ColumnMapper.ExprType)ColumnMapper.ExprType.NUMBER).expr);
        List<String> list = values = useSelectedValues ? rf.selectedValues : rf.excludedValues;
        if (values.isEmpty()) {
            return this.getEmptyFilter(useSelectedValues);
        }
        AtomicBoolean hasNullValue = new AtomicBoolean(false);
        List numericalValues = values.stream().map(nVal -> {
            if ("___dku_no_value___".equals(nVal)) {
                hasNullValue.set(true);
                return null;
            }
            return Double.valueOf(nVal);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (values.size() == 1 && hasNullValue.get() || numericalValues.size() == 1) {
            ExpressionBuilder expr = colExpr;
            if (numericalValues.size() == 1) {
                ExpressionBuilder expressionBuilder = expr = useSelectedValues ? colExpr.eq(numericalValues.get(0)) : colExpr.ne(numericalValues.get(0));
            }
            if (hasNullValue.get()) {
                if (numericalValues.size() == 1) {
                    return useSelectedValues ? expr.or(colExpr.isnull()) : expr.and(colExpr.isnotnull());
                }
                return useSelectedValues ? colExpr.isnull() : colExpr.isnotnull();
            }
            return expr;
        }
        ExpressionBuilder builder = colExpr.inList(numericalValues);
        if (hasNullValue.get()) {
            return useSelectedValues ? builder.or(colExpr.isnull()) : builder.not().and(colExpr.isnotnull());
        }
        return useSelectedValues ? builder : builder.not().or(colExpr.isnull());
    }

    private ExpressionBuilder filterAsAlphanum(ChartFilter.ExplicitCondition explicitCondition) {
        ColumnMapper.TypedExpr colExpr = this.getColumnExpression(explicitCondition.column, explicitCondition.columnType, explicitCondition.dateFilterType, explicitCondition.dateFilterPart, null);
        UnaryOperator<String> transformer = this.getValueTransformer(explicitCondition.columnType, explicitCondition.dateFilterType, explicitCondition.dateFilterPart, ChartFilter.FilterType.EXPLICIT);
        ExpressionBuilder columnExpression = this.expressionBuilder.expr(this.colMapping.getAs((ColumnMapper.TypedExpr)colExpr, (ColumnMapper.ExprType)ColumnMapper.ExprType.STRING).expr);
        String value = (String)transformer.apply(explicitCondition.singleValue);
        if ("___dku_no_value___".equals(value)) {
            return columnExpression.isnull();
        }
        return columnExpression.eq(value);
    }

    private ExpressionBuilder filterValues(ChartFilter.CustomOptions customOptions, boolean negate, ExpressionBuilder colExpr, String ... values) {
        if (values.length == 1) {
            return this.getOperator(customOptions.matchingMode, negate, this.normalize(customOptions, colExpr), this.normalize(customOptions, values[0]));
        }
        ExpressionBuilder[] expressionBuilders = (ExpressionBuilder[])Stream.of(values).map(val -> this.filterValues(customOptions, negate, colExpr, (String)val)).toArray(ExpressionBuilder[]::new);
        return negate ? this.expressionBuilder.and(expressionBuilders) : this.expressionBuilder.or(expressionBuilders);
    }

    private UnaryOperator<String> getValueTransformer(AxisDef.Type columnType, ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart, ChartFilter.FilterType filterType) {
        if (columnType == AxisDef.Type.DATE && filterType != ChartFilter.FilterType.ALPHANUM) {
            IDateBinner dateBinner = BinningToSQL.toBinningMode(dateFilterType, dateFilterPart).getDateBinner();
            return this.buildDateBinnerTransformer(dateBinner);
        }
        return DEFAULT_TRANSFORMER;
    }

    private ColumnMapper.TypedExpr getColumnExpression(String column, AxisDef.Type columnType, ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart, Integer rounding) {
        if (columnType == AxisDef.Type.DATE) {
            BinningToSQL binnerToSQL = new BinningToSQL(this.dialect, this.colMapping);
            return binnerToSQL.binningExpression(this.colMapping.getAs(column, ColumnMapper.ExprType.DATE), dateFilterType, dateFilterPart);
        }
        if (columnType == AxisDef.Type.NUMERICAL) {
            return new ColumnMapper.TypedExpr(FilterToSQL.numericalColumnAsAlphanum(this.expressionBuilder, column, this.dialect, rounding), ColumnMapper.ExprType.STRING);
        }
        return this.colMapping.getAs(column, ColumnMapper.ExprType.STRING);
    }

    public static String numericalColumnAsAlphanum(ExpressionBuilder.ExpressionBuilderFactory ef, String column, SQLDialect dialect, Integer rounding) {
        ExpressionBuilder expr = ef.col(column).castToString(512);
        if (Objects.requireNonNullElse(rounding, 0) > 0) {
            expr = ef.col(column).round(rounding).castToString(512);
        }
        if (FilterToSQL.needToTrimTrailingZeros(dialect)) {
            expr = expr.regexpReplace("(\\.\\d*?[1-9])0+$|\\.0+$", dialect.captureGroup(1));
        }
        return expr.toSQL(dialect);
    }

    private static boolean needToTrimTrailingZeros(SQLDialect dialect) {
        return dialect instanceof PostgreSQLDialect || dialect instanceof GreenplumSQLDialect || dialect instanceof DatabricksSQLDialect || dialect instanceof SparkSQLDialect;
    }

    private ExpressionBuilder getEmptyFilter(boolean negate) {
        return negate ? this.expressionBuilder.cst(1).ne(this.expressionBuilder.cst(1)) : this.expressionBuilder.cst(1).eq(this.expressionBuilder.cst(1));
    }

    private String applyMode(StringMatchingMode matchingMode, String value) {
        if (Objects.equals(value, "___dku_no_value___")) {
            return null;
        }
        switch (matchingMode) {
            case FULL_STRING: 
            case PATTERN: {
                return value;
            }
            case SUBSTRING: {
                return "%" + value + "%";
            }
        }
        throw new NotImplementedException("Unsupported mode");
    }

    private ExpressionBuilder getOperator(StringMatchingMode matchingMode, boolean negate, ExpressionBuilder colExpr, String value) {
        if (value == null) {
            return this.getNull(negate, colExpr);
        }
        switch (matchingMode) {
            case FULL_STRING: {
                return negate ? colExpr.ne(this.expressionBuilder.cst(value)) : colExpr.eq(this.expressionBuilder.cst(value));
            }
            case SUBSTRING: {
                return negate ? colExpr.like(this.expressionBuilder.cst(value)).not() : colExpr.like(this.expressionBuilder.cst(value));
            }
            case PATTERN: {
                return negate ? colExpr.rlike(this.expressionBuilder.cst(value)).not() : colExpr.rlike(this.expressionBuilder.cst(value));
            }
        }
        throw new NotImplementedException("");
    }

    private String normalize(ChartFilter.CustomOptions customOptions, String value) {
        if (customOptions.matchingMode == StringMatchingMode.PATTERN) {
            return value;
        }
        return value != null ? customOptions.normalizationMode.apply(value) : null;
    }

    private ExpressionBuilder normalize(ChartFilter.CustomOptions customOptions, ExpressionBuilder expr) {
        switch (customOptions.normalizationMode) {
            case LOWERCASE: {
                return expr.lower();
            }
            case NORMALIZED: {
                return expr.normalizeText();
            }
            case EXACT: {
                return expr;
            }
        }
        throw new NotImplementedException("Normalization mode not implemented");
    }

    private ExpressionBuilder getNull(boolean negate, ExpressionBuilder colExpr) {
        if (this.dialect instanceof SparkSQLDialect) {
            return negate ? colExpr.isnotnull().and(colExpr.isNonBlank()) : colExpr.isnull().or(colExpr.isBlank());
        }
        return negate ? colExpr.isnotnull() : colExpr.isnull();
    }

    private ExpressionBuilder filterNumericalRangeExpr(RowFilter rf) {
        return this.filterNumericalRangeExpr(rf.minValue, rf.maxValue, rf.columnType, rf.column, rf.getIncludeEmptyValuesOrDefault());
    }

    private ExpressionBuilder filterNumericalRangeExpr(ChartFilter.ExplicitCondition explicitCondition) {
        boolean includeEmptyValues = explicitCondition.minValue != null && explicitCondition.maxValue != null;
        return this.filterNumericalRangeExpr(explicitCondition.minValue, explicitCondition.maxValue, explicitCondition.columnType, explicitCondition.column, includeEmptyValues);
    }

    private ExpressionBuilder filterNumericalRangeExpr(Double minValue, Double maxValue, AxisDef.Type columnType, String column, boolean includeEmptyValues) {
        ColumnMapper.TypedExpr colExpr;
        if (columnType == AxisDef.Type.NUMERICAL) {
            colExpr = this.colMapping.getAs(column, ColumnMapper.ExprType.NUMBER);
        } else if (columnType == AxisDef.Type.DATE) {
            if (minValue != null) {
                minValue = minValue / 1000.0;
            }
            if (maxValue != null) {
                maxValue = maxValue / 1000.0;
            }
            colExpr = this.colMapping.getAs(column, ColumnMapper.ExprType.DATE);
            colExpr = new ColumnMapper.TypedExpr(this.dialect.datePartExpression(colExpr.expr, DatePart.SECOND_FROM_EPOCH), ColumnMapper.ExprType.NUMBER);
        } else {
            throw new RuntimeException("Unreachable");
        }
        ExpressionBuilder expression = this.expressionBuilder.expr(colExpr.expr);
        if (maxValue != null && minValue != null) {
            expression = maxValue.equals(minValue) ? expression.eq(minValue) : (maxValue < minValue ? this.getEmptyFilter(false) : expression.lte(maxValue).and(expression.gte(minValue)));
        } else if (maxValue != null) {
            expression = expression.lte(maxValue);
        } else if (minValue != null) {
            expression = expression.gte(minValue);
        }
        if (minValue != null || maxValue != null) {
            if (includeEmptyValues) {
                return expression.or(this.expressionBuilder.expr(colExpr.expr).isnull());
            }
            return expression;
        }
        if (!includeEmptyValues) {
            return expression.isnotnull();
        }
        return null;
    }

    private UnaryOperator<String> buildDateBinnerTransformer(IDateBinner dateBinner) {
        return val -> {
            if (val == null || "___dku_no_value___".equals(val)) {
                return "___dku_no_value___";
            }
            return "" + dateBinner.getSqlValueFromBinId(Long.parseLong(val));
        };
    }
}

