/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugin.tools;

import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.util.IsolatedClassLoaderBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;

public abstract class RunBase {
    private final String formatClass;
    private final String libPath;
    private final String jarFilePath;
    private final String classesDir;
    protected final JsonObject config;
    protected final JsonObject pluginConfig;

    RunBase(CommandLine cmdLine, int formatClassPos) {
        this(cmdLine.getArgs()[formatClassPos], cmdLine.getOptionValue("classes-dir"), cmdLine.getOptionValue("jar-file"), cmdLine.getOptionValue("lib"), cmdLine.getOptionValue("config"), cmdLine.getOptionValue("pluginConfig"));
    }

    RunBase(String formatClass, String classesDir, String jarFilePath, String libPath, String config, String pluginConfig) {
        assert (StringUtils.isNotBlank((String)classesDir) || StringUtils.isNotBlank((String)jarFilePath));
        assert (StringUtils.isBlank((String)classesDir) || StringUtils.isBlank((String)jarFilePath));
        this.formatClass = formatClass;
        this.classesDir = classesDir;
        this.jarFilePath = jarFilePath;
        this.libPath = libPath;
        this.config = StringUtils.isBlank((String)config) ? null : (JsonObject)new Gson().fromJson(config, JsonObject.class);
        this.pluginConfig = StringUtils.isBlank((String)pluginConfig) ? null : (JsonObject)new Gson().fromJson(pluginConfig, JsonObject.class);
    }

    CustomFormat getFormat() throws Exception {
        IsolatedClassLoaderBuilder classLoaderBuilder = new IsolatedClassLoaderBuilder();
        if (StringUtils.isNotBlank((String)this.libPath)) {
            classLoaderBuilder.withJarsInRecursiveDir(this.libPath);
        }
        if (StringUtils.isNotBlank((String)this.jarFilePath)) {
            classLoaderBuilder.withJarFile(this.jarFilePath);
        }
        if (this.classesDir != null) {
            classLoaderBuilder.withJarsInDir(this.classesDir);
        }
        URLClassLoader classLoader = classLoaderBuilder.build();
        return (CustomFormat)new PluginClazzLoader(classLoader).loadClazz(this.formatClass);
    }

    static void init() {
        URL u = Loader.getResource((String)"log4j.properties");
        if (u == null) {
            System.err.println("Logging resource not found ...");
            BasicConfigurator.configure();
        } else {
            PropertyConfigurator.configure((URL)Loader.getResource((String)"log4j.properties"));
        }
    }

    public static void fillOptions(Options opts) {
        opts.addOption(Option.builder((String)"lib").longOpt("lib").hasArg().build());
        opts.addOption(Option.builder((String)"jarFile").longOpt("jar-file").hasArg().build());
        opts.addOption(Option.builder((String)"classesDir").longOpt("classes-dir").hasArg().build());
        opts.addOption(Option.builder((String)"config").longOpt("config").hasArg().build());
        opts.addOption(Option.builder((String)"pluginConfig").longOpt("plugin-config").hasArg().build());
    }
}

