/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.populardatasets.MostUsedDatasetInfos;
import com.dataiku.dip.populardatasets.PopularDatasetsCacheService;
import com.dataiku.dip.populardatasets.PopularDatasetsConfig;
import com.dataiku.dip.populardatasets.PopularDatasetsProcessing;
import com.dataiku.dip.populardatasets.PopularDatasetsProcessingService;
import com.dataiku.dip.populardatasets.UIPopularDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PopularDatasetsService {
    @Autowired
    private PopularDatasetsProcessingService popularDatasetsProcessingService;
    @Autowired
    private PopularDatasetsCacheService popularDatasetsCacheService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDBService;
    @Autowired
    private PermissionsService permissionsService;
    private static final int MAX_NUMBER_OF_DISPLAYED_MOST_USED_DATASETS = 35;
    private boolean computationIsRunning = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.popularDatasets");

    @PostConstruct
    public void init() {
        try {
            logger.info((Object)"Initialization of the most used dataset in the instance");
            GeneralSettingsDAO.PopularDatasetsSettings popularDatasetsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().popularDatasetsSettings;
            PopularDatasetsConfig.ProcessingOptions config = this.getProcessingOptions(popularDatasetsSettings);
            this.startComputation(config, DSSAuthCtx.newNone());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute most used datasets on startup", (Throwable)e);
        }
    }

    public PopularDatasetsConfig.ProcessingOptions getProcessingOptions(GeneralSettingsDAO.PopularDatasetsSettings popularDatasetsSettings) {
        Preconditions.checkArgument((popularDatasetsSettings.minShares >= 1 ? 1 : 0) != 0, (Object)"Min # shares must be greater or equal to 1");
        Preconditions.checkArgument((popularDatasetsSettings.maxDaysSinceUseByANewRecipe > 0 ? 1 : 0) != 0, (Object)"Max # days since last used by a new recipe must be strictly positive");
        Preconditions.checkArgument((popularDatasetsSettings.maxDaysSinceLastRebuild >= -1 ? 1 : 0) != 0, (Object)"Max # days since last rebuild must be positive (or equal to -1 to be ignored)");
        PopularDatasetsConfig.ProcessingOptions res = new PopularDatasetsConfig.ProcessingOptions();
        res.minimumShares = popularDatasetsSettings.minShares;
        res.windowSize = popularDatasetsSettings.maxDaysSinceUseByANewRecipe;
        res.maxDaysSinceLastRebuild = popularDatasetsSettings.maxDaysSinceLastRebuild;
        res.onlyFromDataCollections = popularDatasetsSettings.onlyFromDataCollections;
        res.onlyTrendingDatasets = popularDatasetsSettings.onlyTrendingDatasets;
        Params params = DKUApp.getParams();
        res.recentTrendTolerance = params.getDoubleParam("dku.popularDatasets.recentTrendTolerance", res.recentTrendTolerance);
        res.trendMaxWindowCount = params.getIntParam("dku.popularDatasets.trendMaxWindowCount", Integer.valueOf(res.trendMaxWindowCount));
        res.trendPseudoLinearQuadraticThreshold = params.getDoubleParam("dku.popularDatasets.trendPseudoLinearQuadraticThreshold", res.trendPseudoLinearQuadraticThreshold);
        res.trendPseudoLinearSlopeThreshold = params.getDoubleParam("dku.popularDatasets.trendPseudoLinearSlopeThreshold", res.trendPseudoLinearSlopeThreshold);
        res.computePopularDatasets = popularDatasetsSettings.enablePopularDatasets;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<Boolean> startComputation(final PopularDatasetsConfig.ProcessingOptions config, AuthCtx authCtx) throws Exception {
        PopularDatasetsService popularDatasetsService = this;
        synchronized (popularDatasetsService) {
            if (this.computationIsRunning) {
                throw new Exception("Popular dataset computation is already in progress on this instance and should be available momentarily");
            }
            this.computationIsRunning = true;
        }
        SimpleFutureThread<Boolean> ft = new SimpleFutureThread<Boolean>(authCtx){

            @Override
            protected Boolean compute() throws Exception {
                try {
                    PopularDatasetsProcessing.Output output = PopularDatasetsService.this.popularDatasetsProcessingService.compute_NT(config);
                    Boolean bl = PopularDatasetsService.this.popularDatasetsCacheService.saveOutput(output);
                    return bl;
                }
                finally {
                    PopularDatasetsService.this.computationIsRunning = false;
                }
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"compute-most-used-datasets", (String)"Compute popular datasets");
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<Boolean>>(){});
    }

    public List<UIPopularDataset.AbstractPopularDataset> getPopularDatasetsForUser_NT(AuthCtx user) throws Exception {
        List<MostUsedDatasetInfos> mostUsedDatasets = this.popularDatasetsCacheService.getMostUsedDatasetLastResult();
        if (mostUsedDatasets == null) {
            mostUsedDatasets = Collections.emptyList();
        }
        ArrayList<UIPopularDataset.AbstractPopularDataset> result = new ArrayList<UIPopularDataset.AbstractPopularDataset>(35);
        int maximumSharedDatasetCheck = DKUApp.getParams().getIntParam("dku.homepage.mostSharedDataset.checkLimit", Integer.valueOf(500));
        for (int i = 0; i < Math.min(mostUsedDatasets.size(), maximumSharedDatasetCheck); ++i) {
            MostUsedDatasetInfos dataset = mostUsedDatasets.get(i);
            long lastBuildTime = -1L;
            try {
                ReadOnlyJobsInternalDB.ObjectBuild ob = this.jobsDBService.getLatestSuccessfulBuildForObject(dataset.dataset.projectKey, dataset.dataset.name);
                lastBuildTime = ob == null ? -1L : ob.buildStartTime;
            }
            catch (SQLException e) {
                logger.warn((Object)("Failed to get last build time for dataset " + dataset.dataset.projectKey + "." + dataset.dataset.name), (Throwable)e);
            }
            this.addAbstractDataset_NT(result, dataset.dataset, user, lastBuildTime, dataset.score);
            if (result.size() >= 35) break;
        }
        return result;
    }

    private void addAbstractDataset_NT(List<UIPopularDataset.AbstractPopularDataset> result, PopularDatasetsProcessing.DatasetInfo dataset, AuthCtx user, long lastBuildTime, double score) {
        try (Transaction t = this.transactionService.beginRead();){
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(dataset.projectKey, dataset.name);
            SerializedProject sp = this.projectsDAO.getMandatoryUnsafe(sd.projectKey);
            ProjectsService.ObjectVisibility visibility = this.projectsService.getObjectVisibility(user, sp, ITaggingService.TaggableType.DATASET, dataset.name);
            ExposedObjectsService.ObjectAuthorizations objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(dataset.projectKey, dataset.name, ITaggingService.TaggableType.DATASET, user);
            boolean hasAnyProjectAccess = this.permissionsService.hasAnyProjectAccess(user, sp);
            boolean canRequestAccess = this.projectsService.isAccessRequestsEnabled(sp, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
            if (visibility == ProjectsService.ObjectVisibility.READ) {
                int nColumns = sd.getSchema() != null ? sd.getSchema().columns.size() : 0;
                result.add(new UIPopularDataset.PopularDataset(sd, sp.name, objectAuthorizations, nColumns, dataset.projects, dataset.dataCollections, lastBuildTime, hasAnyProjectAccess, canRequestAccess, score));
            } else if (visibility == ProjectsService.ObjectVisibility.DISCOVER) {
                result.add(new UIPopularDataset.DiscoverablePopularDataset(sd, sp.name, objectAuthorizations, hasAnyProjectAccess, canRequestAccess, score));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to read permissions or details of " + dataset.getFullName()), (Throwable)e);
        }
    }

    public UIPopularDataset.PopularDatasetsStatus getPopularDatasetsStatus() throws IOException, ParseException {
        int numberOfDatasets;
        long lastRunTimestamp;
        long lastRunDuration;
        PopularDatasetsProcessing.RunMetadata lastRun = this.popularDatasetsCacheService.getLastResultMetadata();
        if (lastRun != null) {
            lastRunDuration = lastRun.perfMetrics.total;
            lastRunTimestamp = lastRun.timestamp;
            numberOfDatasets = lastRun.numberMostUsedDatasets;
        } else {
            lastRunDuration = 0L;
            lastRunTimestamp = -1L;
            numberOfDatasets = 0;
        }
        String expression = DKUApp.getParams().getParam("dku.cron.expr.popular-datasets.compute-popular-datasets", "20 24 4 * * ?");
        CronExpression cronExpression = new CronExpression(expression);
        long nextScheduledRun = cronExpression.getNextValidTimeAfter(new Date()).getTime();
        return new UIPopularDataset.PopularDatasetsStatus(lastRunDuration, lastRunTimestamp, nextScheduledRun, numberOfDatasets);
    }

    public boolean havePopularDatasetBeenComputed() throws IOException {
        return this.popularDatasetsCacheService.getLastResultMetadata() != null;
    }

    public UsageSummaryModel.PopularDatasetsReport getReportData() throws IOException {
        List<PopularDatasetsProcessing.RunMetadata> history = this.popularDatasetsCacheService.getMetadataHistory();
        if (history.isEmpty()) {
            return null;
        }
        long[] durations = history.stream().mapToLong(h -> h.perfMetrics.total).toArray();
        Arrays.sort(durations);
        long medianComputationDuration = durations.length % 2 == 0 ? (durations[durations.length / 2] + durations[durations.length / 2 - 1]) / 2L : durations[durations.length / 2];
        int lastDatasetCount = history.get((int)(history.size() - 1)).numberMostUsedDatasets;
        return new UsageSummaryModel.PopularDatasetsReport(lastDatasetCount, medianComputationDuration);
    }
}

