/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.recipes.RecipeDeserializer;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RecipeRegistry {
    private static final Map<String, RecipeMeta> library = new LinkedHashMap<String, RecipeMeta>();

    public static RecipeRunner buildRunner(JobActivity activity) throws Exception {
        RecipeMeta rm2 = RecipeRegistry.getMeta(activity);
        return rm2.buildRunner(activity);
    }

    public static <T extends RecipeParams> T getParamsAs(JobActivity activity, Class<T> ofClazz) {
        SerializedRecipe recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
        return (T)((RecipeParams)ofClazz.cast(recipe.params));
    }

    public static RecipeMeta getMeta(JobActivity activity) {
        if (!(activity.getSubgraph() instanceof RecipeRunnableSubgraph)) {
            throw ErrorContext.iae((String)"This activity is not a recipe-activity");
        }
        return RecipeRegistry.getMeta(((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel().type);
    }

    public static RecipeMeta getMeta(SerializedRecipe recipe) {
        return RecipeRegistry.getMeta(recipe.type);
    }

    public static synchronized RecipeMeta getMeta(String type) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)type), (Object)"Recipe type is not specified");
        if (library.containsKey(type)) {
            return library.get(type);
        }
        if (type.startsWith("Custom")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown recipe type: " + type);
        }
        if (type.startsWith("App_")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)AppsService.AppCodes.ERR_APP_BACKING_APPLICATION_RECIPE_NOT_INSTALLED, "Unknown recipe type: " + type);
        }
        throw new Error("Unknown recipe type " + type);
    }

    public static synchronized Iterable<RecipeMeta> getAllMeta() {
        return new ArrayList<RecipeMeta>(library.values());
    }

    public static boolean hasMeta(SerializedRecipe recipe) {
        return RecipeRegistry.hasMeta(recipe.type);
    }

    public static synchronized boolean hasMeta(String type) {
        return library.containsKey(type);
    }

    public static void deregister(RecipeMeta meta) {
        RecipeRegistry.deregister(meta.getType());
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }

    public static synchronized void register(RecipeMeta meta) {
        RecipeDeserializer.registerType(meta.getType(), meta.paramsClass());
        library.put(meta.getType(), meta);
    }

    public static void loadClass() {
        DKUtils.forceInit(RecipeDeserializer.class);
    }
}

