/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.compute.computations.transformers.Factorizer;
import com.dataiku.dip.eda.compute.computations.transformers.Flattener;
import com.dataiku.dip.eda.compute.computations.transformers.TransformingRunner;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelProtocol;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.Nullable;

public class EDAKernelCreator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.eda");

    public ComputationRunner createEDARunner_NT(AuthCtx authCtx, String projectKey, Dataset sourceDataset, StreamableDatasetSelection datasetSelection, @Nullable ContainerExecRuntimeConfig containerConfig) throws Exception {
        logger.infoV("Creating the EDA recipe kernel for dataset %s", new Object[]{sourceDataset.getFullName()});
        String containerConfigName = containerConfig != null ? containerConfig.name : null;
        SimplePythonKernel kernel = SimplePythonKernelFactory.prepareKernel((DSSAuthCtx)authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.EDA_RECIPE, null, "dataiku.eda.server", false, containerConfigName, "eda-recipe");
        EDAKernelProtocol protocol = new EDAKernelProtocol(kernel);
        try {
            kernel.start();
            logger.info((Object)"EDA recipe kernel started");
            protocol.loadDataset(sourceDataset, datasetSelection);
        }
        catch (Exception e) {
            protocol.close();
            throw e;
        }
        return new TransformingRunner(new Flattener(), new TransformingRunner(new Factorizer(), protocol));
    }
}

