/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.streaming.python.AbstractPythonContinuousRecipeRunner;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonFunctionRunnerThread;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonRecipeParams;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpoint;
import com.dataiku.dip.recipes.streaming.python.RowsPullingHandler;
import com.dataiku.dip.recipes.streaming.python.RowsPushingHandler;
import com.dataiku.dip.recipes.streaming.python.RowsSplittingHandler;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ContinuousPythonRecipeRunner
extends AbstractPythonContinuousRecipeRunner
implements AbortableRecipeRunner {
    private static Map<String, ContainerizedFunctionReplicaHolder> runningContainerizedFunctions = Maps.newHashMap();
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private IImpersonationResolverService impersonationService;
    private RowsPullingHandler rowsPullingHandler;
    private RowsPushingHandler rowsPushingHandler;
    private RowsSplittingHandler rowsSplittingHandler;
    private static Logger logger = Logger.getLogger((String)"dku.flow.python");

    public static synchronized ContainerizedFunctionReplicaHolder addContainerizedFunction(ContinuousPythonRecipeRunner runner, int nbReplicas, String code) throws InterruptedException {
        ContainerizedFunctionReplicaHolder holder = new ContainerizedFunctionReplicaHolder(runner, "function-" + SecretKeyGenerator.generate((int)8), nbReplicas, code);
        runningContainerizedFunctions.put(holder.id, holder);
        return holder;
    }

    public static synchronized void removeContainerizedFunction(ContainerizedFunctionReplicaHolder holder) {
        runningContainerizedFunctions.remove(holder.id);
    }

    public static synchronized ContainerizedFunctionReplicaDesc startContainerizedFunctionReplica(String executionId) throws Exception {
        if (!runningContainerizedFunctions.containsKey(executionId)) {
            throw new IllegalStateException("No function running for execution=" + executionId);
        }
        ContainerizedFunctionReplicaHolder holder = runningContainerizedFunctions.get(executionId);
        return holder.take();
    }

    public ContinuousPythonRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        super(activity, sr);
    }

    @Override
    public void init() throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() throws Exception {
        logger.info((Object)("Getting payload for " + this.activity.projectKey + "  " + this.activity.recipeId));
        String code = this.recipesDAO.getPayloadOrNull(this.activity.projectKey, this.activity.recipeId);
        ContinuousPythonRecipeParams params = this.recipe.getParamsAs(ContinuousPythonRecipeParams.class);
        assert (code != null);
        if (params.codeMode == ContinuousPythonRecipeParams.CodeMode.FUNCTION) {
            int inputStreamingEndpointCount = 0;
            for (SerializedRecipe.RecipeInput input : this.recipe.getFlatInputs()) {
                FlowComputable computable = this.computableFromRefService.get(this.projectKey, input.ref);
                inputStreamingEndpointCount += computable instanceof FlowStreamingEndpoint ? 1 : 0;
            }
            if (inputStreamingEndpointCount == 0) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "At least one streaming input is needed for function mode");
            }
        }
        CodeEnvSelector envSelector = new CodeEnvSelector();
        String envName = envSelector.selectForPythonRecipe(this.activity.projectKey, params.envSelection);
        try (AutoDelete recipeTmpDir = FlowJobUtils.getTmpFolder("python-recipe", "pyout");){
            switch (params.codeMode) {
                case FREE_FORM: {
                    this.runAsScript((File)recipeTmpDir, code, params, envName);
                    return;
                }
                case FUNCTION: {
                    this.runAsFunction((File)recipeTmpDir, code, params, envName);
                    return;
                }
            }
            return;
        }
    }

    private void runAsScript(File recipeTmpDir, String code, ContinuousPythonRecipeParams params, String envName) throws Exception {
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.activity.projectKey, params.containerSelection);
        if (containerConfig == null) {
            this.runAsScriptLocally(recipeTmpDir, code, params, envName);
        } else {
            List<String> readablePaths = this.getReadablePaths(this.recipe);
            switch (containerConfig.type) {
                case DOCKER: {
                    this.runAsScriptInDocker(recipeTmpDir, code, params, envName, containerConfig, readablePaths);
                    break;
                }
                case KUBERNETES: {
                    this.runAsScriptInKubernetes(recipeTmpDir, code, params, envName, containerConfig, readablePaths);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                }
            }
        }
    }

    private void runAsScriptLocally(final File recipeTmpDir, String code, ContinuousPythonRecipeParams params, final String envName) throws Exception {
        final File tmpScriptData = new File(recipeTmpDir, "script.py");
        logger.info((Object)("Dumping Python script to " + String.valueOf(tmpScriptData)));
        code = (String)code + "\n\n\nimport dataiku as _private_dataiku_import\n_private_dataiku_import._dataset_writer_atexit_handler()\n_private_dataiku_import._folder_writer_atexit_handler()";
        DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)code);
        if (this.impersonationService.isEnabled()) {
            UserImpersonationTarget impersonated = this.impersonationService.getTargetUser(this.projectKey, this.authCtxService.getAuthCtx());
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            aclHandler.setExclusiveAndStudioFullAccessOnDirectory(recipeTmpDir, impersonated.unixUser);
        }
        logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " processes"));
        ReplicasHolder replicasHolder = new ReplicasHolder(params.nbReplicas, params.restartOnFailure){

            @Override
            public ReplicaThread makeReplica(int nbReplicas, int replicaIndex) {
                return new ReplicaThread(nbReplicas, replicaIndex, (ReplicasHolder)this){

                    @Override
                    public void doRun(int restartCount) throws Exception {
                        File replicaTmpDir = new File(recipeTmpDir, "python-" + this.replicaIndex);
                        DKUFileUtils.mkdirs((File)replicaTmpDir);
                        ContinuousPythonRecipeRunner.this.executeScript(envName, replicaTmpDir, tmpScriptData, this.nbReplicas, this.replicaIndex, restartCount);
                    }
                };
            }
        };
        replicasHolder.launchAndWait();
        logger.info((Object)"Execution of user's Python code complete");
    }

    private void runAsScriptInDocker(final File recipeTmpDir, final String code, ContinuousPythonRecipeParams params, final String envName, final ContainerExecRuntimeConfig containerConfig, final List<String> readablePaths) throws Exception {
        final ContinuousPythonContainerDefinition definition = new ContinuousPythonContainerDefinition();
        definition.codeMode = ContinuousPythonRecipeParams.CodeMode.FREE_FORM;
        logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " docker processes"));
        ReplicasHolder replicasHolder = new ReplicasHolder(params.nbReplicas, params.restartOnFailure){

            @Override
            public ReplicaThread makeReplica(int nbReplicas, int replicaIndex) {
                return new ReplicaThread(nbReplicas, replicaIndex, (ReplicasHolder)this){

                    @Override
                    public void doRun(int restartCount) throws Exception {
                        File replicaTmpDir = new File(recipeTmpDir, "python-" + this.replicaIndex);
                        DKUFileUtils.mkdirs((File)replicaTmpDir);
                        HashMap extraEnv = Maps.newHashMap();
                        extraEnv.put("DKU_REPLICA_COUNT", Integer.toString(this.nbReplicas));
                        extraEnv.put("DKU_REPLICA_INDEX", Integer.toString(this.replicaIndex));
                        extraEnv.put("DKU_REPLICA_RESTARTS", Integer.toString(restartCount));
                        ContinuousPythonRecipeRunner.this.executeDockerCodeRecipe(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName), containerConfig, recipeTmpDir, replicaTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_CPYTHON, JSON.json((Object)definition), code, extraEnv, new File(replicaTmpDir, "process-out" + (String)(this.nbReplicas <= 1 ? "" : "-" + this.replicaIndex) + ".log"), readablePaths);
                    }
                };
            }
        };
        replicasHolder.launchAndWait();
    }

    private void runAsScriptInKubernetes(File recipeTmpDir, String code, ContinuousPythonRecipeParams params, String envName, ContainerExecRuntimeConfig containerConfig, List<String> readablePaths) throws Exception {
        ContinuousPythonContainerDefinition definition = new ContinuousPythonContainerDefinition();
        definition.codeMode = ContinuousPythonRecipeParams.CodeMode.FREE_FORM;
        logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " kubernetes pods"));
        this.executeKubernetesCodeRecipe(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName), containerConfig, recipeTmpDir, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_CPYTHON, JSON.json((Object)definition), code, Collections.emptyMap(), params.nbReplicas, params.restartOnFailure, readablePaths);
    }

    private void runAsFunction(File recipeTmpDir, String code, ContinuousPythonRecipeParams params, String envName) throws Exception {
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.activity.projectKey, params.containerSelection);
        code = (String)code + "\n\n\nimport dataiku as _private_dataiku_import\n_private_dataiku_import._dataset_writer_atexit_handler()\n_private_dataiku_import._folder_writer_atexit_handler()";
        try {
            this.rowsPushingHandler = new RowsPushingHandler(this.authCtxService.getAuthCtx(), this.projectKey, this.recipe, this.computableFromRefService, this.datasetsDAO, this::notifyBeforeAborting);
            List<FunctionCheckpoint> checkpointsToReplay = this.rowsPushingHandler.readLastCheckpointStored();
            logger.info((Object)("Start reading inputs from checkpointsToReplay=" + JSON.pretty(checkpointsToReplay)));
            this.rowsPullingHandler = new RowsPullingHandler(this.authCtxService.getAuthCtx(), this.projectKey, this.recipe, checkpointsToReplay, this.computableFromRefService, this::notifyBeforeAborting);
            this.rowsPushingHandler.setFunctionCheckpointComparator(this.rowsPullingHandler);
            int n = Math.max(1, params.nbReplicas);
            int k = Math.max(1, params.pipelineDepth);
            this.rowsSplittingHandler = new RowsSplittingHandler(1 + (n - 1) / k, k, this.rowsPullingHandler, this.rowsPushingHandler, this::notifyBeforeAborting);
            this.rowsSplittingHandler.startSplit();
            this.rowsPullingHandler.startPull();
            this.rowsPushingHandler.startPush();
            logger.info((Object)"Starting execution of user's Python code");
            if (containerConfig == null) {
                this.runAsFunctionLocally(recipeTmpDir, envName, params, (String)code);
            } else {
                List<String> readablePaths = this.getReadablePaths(this.recipe);
                switch (containerConfig.type) {
                    case DOCKER: {
                        this.runAsFunctionInDocker(recipeTmpDir, envName, params, (String)code, containerConfig, readablePaths);
                        break;
                    }
                    case KUBERNETES: {
                        this.runAsFunctionInKubernetes(recipeTmpDir, envName, params, (String)code, containerConfig, readablePaths);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                    }
                }
            }
            logger.info((Object)"Execution of user's Python code complete");
        }
        catch (Exception e) {
            logger.error((Object)"Failure in python function run", (Throwable)e);
            if (this.rowsSplittingHandler != null) {
                this.rowsSplittingHandler.errorSplit();
            }
            if (this.rowsPullingHandler != null) {
                this.rowsPullingHandler.errorPull();
            }
            if (this.rowsPushingHandler != null) {
                this.rowsPushingHandler.errorPush();
            }
            throw e;
        }
        finally {
            if (this.rowsSplittingHandler != null) {
                this.rowsSplittingHandler.stopSplit();
            }
            if (this.rowsPullingHandler != null) {
                this.rowsPullingHandler.stopPull();
            }
            if (this.rowsPushingHandler != null) {
                this.rowsPushingHandler.stopPush();
            }
        }
    }

    private List<String> getReadablePaths(SerializedRecipe sr) throws IOException {
        ArrayList readablePaths = Lists.newArrayList();
        for (SerializedRecipe.RecipeInput input : sr.getFlatInputs()) {
            FlowComputable source = this.computableFromRefService.get(this.projectKey, input.ref);
            if (!(source instanceof FlowSavedModel)) continue;
            SavedModel sm = ((FlowSavedModel)source).getSavedModel();
            readablePaths.add(MLPaths.savedModelBaseFolder(sm).getAbsolutePath());
        }
        return readablePaths;
    }

    private void runAsFunctionLocally(final File recipeTmpDir, final String envName, ContinuousPythonRecipeParams params, final String code) throws Exception {
        if (this.impersonationService.isEnabled()) {
            UserImpersonationTarget impersonated = this.impersonationService.getTargetUser(this.projectKey, this.authCtxService.getAuthCtx());
            FilesystemACLHandler aclHandler = new FilesystemACLHandler();
            aclHandler.setExclusiveAndStudioFullAccessOnDirectory(recipeTmpDir, impersonated.unixUser);
        }
        logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " workers (pipeline depth " + params.pipelineDepth + ")"));
        ReplicasHolder replicasHolder = new ReplicasHolder(params.nbReplicas, params.restartOnFailure){

            @Override
            public ReplicaThread makeReplica(int nbReplicas, int replicaIndex) {
                return new ReplicaThread(nbReplicas, replicaIndex, (ReplicasHolder)this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doRun(int restartCount) throws Exception {
                        File replicaTmpDir = new File(recipeTmpDir, "python-" + this.replicaIndex);
                        DKUFileUtils.mkdirs((File)replicaTmpDir);
                        String secret = SecretKeyGenerator.generate((int)8);
                        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                        try (BasicKernelLink link = new BasicKernelLink(secret, dssPortRange);){
                            ContinuousPythonFunctionRunnerThread workerThread = new ContinuousPythonFunctionRunnerThread(ContinuousPythonRecipeRunner.this.projectKey, (SecretProtectedKernelLink)link, code, ContinuousPythonRecipeRunner.this.rowsSplittingHandler, this.nbReplicas, this.replicaIndex, restartCount, null);
                            Runnable abortHook = () -> workerThread.stopHandling();
                            ContinuousPythonRecipeRunner.this.addAbortable(abortHook);
                            try {
                                workerThread.start();
                                ContinuousPythonRecipeRunner.this.executeModule(envName, replicaTmpDir, "dataiku.continuous.server", Integer.toString(link.getPort()), link.getSecret());
                            }
                            finally {
                                ContinuousPythonRecipeRunner.this.removeAbortable(abortHook);
                            }
                        }
                    }
                };
            }
        };
        replicasHolder.launchAndWait();
        logger.info((Object)"Execution of user's Python code complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsFunctionInDocker(final File recipeTmpDir, final String envName, ContinuousPythonRecipeParams params, String code, final ContainerExecRuntimeConfig containerConfig, final List<String> readablePaths) throws Exception {
        final ContainerizedFunctionReplicaHolder holder = ContinuousPythonRecipeRunner.addContainerizedFunction(this, params.nbReplicas, code);
        try {
            logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " docker workers (pipeline depth " + params.pipelineDepth + ")"));
            ReplicasHolder replicasHolder = new ReplicasHolder(params.nbReplicas, params.restartOnFailure){

                @Override
                public ReplicaThread makeReplica(int nbReplicas, int replicaIndex) {
                    return new ReplicaThread(nbReplicas, replicaIndex, (ReplicasHolder)this){

                        @Override
                        public void doRun(int restartCount) throws Exception {
                            File replicaTmpDir = new File(recipeTmpDir, "python-" + this.replicaIndex);
                            DKUFileUtils.mkdirs((File)replicaTmpDir);
                            ContinuousPythonContainerDefinition definition = new ContinuousPythonContainerDefinition();
                            definition.codeMode = ContinuousPythonRecipeParams.CodeMode.FUNCTION;
                            definition.functionId = holder.getId();
                            ContinuousPythonRecipeRunner.this.executeDockerCodeRecipe(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName), containerConfig, recipeTmpDir, replicaTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_CPYTHON, JSON.json((Object)definition), "", Maps.newHashMap(), new File(replicaTmpDir, "process-out.log"), readablePaths);
                        }
                    };
                }
            };
            replicasHolder.launchAndWait();
            logger.info((Object)"Execution of user's Python code complete");
        }
        finally {
            ContinuousPythonRecipeRunner.removeContainerizedFunction(holder);
            holder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsFunctionInKubernetes(File recipeTmpDir, String envName, ContinuousPythonRecipeParams params, String code, ContainerExecRuntimeConfig containerConfig, List<String> readablePaths) throws Exception {
        ContainerizedFunctionReplicaHolder holder = ContinuousPythonRecipeRunner.addContainerizedFunction(this, params.nbReplicas, code);
        try {
            logger.info((Object)("Starting execution of user's Python code in " + params.nbReplicas + " pods (pipeline depth " + params.pipelineDepth + ")"));
            ContinuousPythonContainerDefinition definition = new ContinuousPythonContainerDefinition();
            definition.codeMode = ContinuousPythonRecipeParams.CodeMode.FUNCTION;
            definition.functionId = holder.getId();
            this.executeKubernetesCodeRecipe(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName), containerConfig, recipeTmpDir, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_CPYTHON, JSON.json((Object)definition), "", Collections.emptyMap(), params.nbReplicas, params.restartOnFailure, readablePaths);
            logger.info((Object)"Execution of user's Python code complete");
        }
        finally {
            ContinuousPythonRecipeRunner.removeContainerizedFunction(holder);
            holder.close();
        }
    }

    @Override
    public void notifyBeforeAborting() {
        super.notifyBeforeAborting();
        logger.info((Object)"Aborting continuous python");
        if (this.rowsPullingHandler != null) {
            this.rowsPullingHandler.errorPull();
        }
        if (this.rowsPushingHandler != null) {
            this.rowsPushingHandler.errorPush();
        }
    }

    public static class ContainerizedFunctionReplicaHolder
    implements AutoCloseable {
        private final ContinuousPythonRecipeRunner runner;
        private final Runnable abortHook;
        private final LinkedBlockingQueue<ContainerizedFunctionReplicaItem> queue = new LinkedBlockingQueue();
        private final String id;
        private final int nbReplicas;
        private final List<ContainerizedFunctionReplica> active = Lists.newArrayList();
        private final String code;

        public ContainerizedFunctionReplicaHolder(ContinuousPythonRecipeRunner runner, String id, int nbReplicas, String code) throws InterruptedException {
            this.runner = runner;
            this.id = id;
            this.nbReplicas = nbReplicas;
            this.code = code;
            for (int replicaIndex = 0; replicaIndex < nbReplicas; ++replicaIndex) {
                this.queue.put(new ContainerizedFunctionReplicaItem(replicaIndex, 0));
            }
            this.abortHook = () -> {
                for (ContainerizedFunctionReplica replica : this.getReplicas()) {
                    replica.close();
                }
            };
            runner.addAbortable(this.abortHook);
        }

        public synchronized void addReplica(ContainerizedFunctionReplica replica) {
            this.active.add(replica);
        }

        public synchronized void removeReplica(ContainerizedFunctionReplica replica) {
            this.active.remove(replica);
        }

        public synchronized List<ContainerizedFunctionReplica> getReplicas() {
            return Lists.newArrayList(this.active);
        }

        public String getId() {
            return this.id;
        }

        public ContainerizedFunctionReplicaDesc take() throws Exception {
            ContainerizedFunctionReplicaItem replicaItem = this.queue.poll(10L, TimeUnit.SECONDS);
            if (replicaItem == null) {
                throw new IllegalStateException("No replica available for processing");
            }
            ContainerizedFunctionReplica replica = new ContainerizedFunctionReplica(this, this.nbReplicas, replicaItem.replicaIndex, replicaItem.restartCount, this.runner.projectKey, this.runner.rowsSplittingHandler, this.code);
            return replica.getDesc();
        }

        public void give(ContainerizedFunctionReplicaDesc desc) throws InterruptedException {
            this.queue.put(new ContainerizedFunctionReplicaItem(desc.replicaIndex, desc.restartCount + 1));
        }

        @Override
        public void close() throws Exception {
            this.runner.removeAbortable(this.abortHook);
        }

        public static class ContainerizedFunctionReplicaItem {
            public final int replicaIndex;
            public final int restartCount;

            public ContainerizedFunctionReplicaItem(int replicaIndex, int restartCount) {
                this.replicaIndex = replicaIndex;
                this.restartCount = restartCount;
            }
        }
    }

    public static class ContainerizedFunctionReplicaDesc {
        public int nbReplicas;
        public int replicaIndex;
        public int restartCount;
        public int linkPort;
        public String linkSecret;
        public String linkServerCert;

        public ContainerizedFunctionReplicaDesc(int nbReplicas, int replicaIndex, int restartCount, int linkPort, String linkSecret, String linkServerCert) {
            this.nbReplicas = nbReplicas;
            this.replicaIndex = replicaIndex;
            this.restartCount = restartCount;
            this.linkPort = linkPort;
            this.linkSecret = linkSecret;
            this.linkServerCert = linkServerCert;
        }
    }

    public abstract class ReplicasHolder
    implements Runnable {
        protected final boolean restartOnFailure;
        private final List<ReplicaThread> replicas = Lists.newArrayList();
        private Exception exception;

        public ReplicasHolder(int nbReplicas, boolean restartOnFailure) {
            this.restartOnFailure = restartOnFailure;
            for (int replicaIndex = 0; replicaIndex < nbReplicas; ++replicaIndex) {
                this.replicas.add(this.makeReplica(nbReplicas, replicaIndex));
            }
        }

        public abstract ReplicaThread makeReplica(int var1, int var2);

        public boolean shouldRestartOnFailure(Exception e) {
            if (this.restartOnFailure) {
                return true;
            }
            if (this.exception == null) {
                this.exception = e;
            }
            ContinuousPythonRecipeRunner.this.notifyBeforeAborting();
            return false;
        }

        public void launchAndWait() throws Exception {
            ContinuousPythonRecipeRunner.this.addAbortable(this);
            try {
                for (ReplicaThread replica : this.replicas) {
                    replica.start();
                }
                logger.info((Object)("Started " + this.replicas.size() + " copies of the the continuous python"));
                for (ReplicaThread replica : this.replicas) {
                    replica.join();
                }
                logger.info((Object)("Done waiting for " + this.replicas.size() + " copies of the the continuous python"));
            }
            finally {
                ContinuousPythonRecipeRunner.this.removeAbortable(this);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        @Override
        public void run() {
            for (ReplicaThread replica : this.replicas) {
                replica.stopLoop();
            }
        }
    }

    public static class ContinuousPythonContainerDefinition {
        public ContinuousPythonRecipeParams.CodeMode codeMode = ContinuousPythonRecipeParams.CodeMode.FREE_FORM;
        protected String functionId;
    }

    public static class ContainerizedFunctionReplica {
        private volatile boolean closed;
        private final transient ContainerizedFunctionReplicaHolder parent;
        private final int nbReplicas;
        private final int replicaIndex;
        private final int restartCount;
        private final SecretProtectedKernelLink link;
        private final ContinuousPythonFunctionRunnerThread workerThread;

        public ContainerizedFunctionReplica(ContainerizedFunctionReplicaHolder parent, int nbReplicas, int replicaIndex, int restartCount, String projectKey, RowsSplittingHandler rowsSplittingHandler, String code) throws Exception {
            this.parent = parent;
            this.nbReplicas = nbReplicas;
            this.replicaIndex = replicaIndex;
            this.restartCount = restartCount;
            parent.addReplica(this);
            String secret = SecretKeyGenerator.generate((int)8);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            this.link = new BasicKernelLink(secret, dssPortRange, EncryptedRPC.getSSLContext());
            this.workerThread = new ContinuousPythonFunctionRunnerThread(projectKey, this.link, code, rowsSplittingHandler, nbReplicas, replicaIndex, restartCount, this::close);
            this.workerThread.start();
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.link.close();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close replica link", (Throwable)e);
            }
            try {
                this.workerThread.stopHandling();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close replica worker thread", (Throwable)e);
            }
            try {
                this.parent.give(this.getDesc());
            }
            catch (InterruptedException e) {
                logger.error((Object)"Unable to return replica to pool", (Throwable)e);
            }
            this.parent.removeReplica(this);
        }

        private ContainerizedFunctionReplicaDesc getDesc() {
            return new ContainerizedFunctionReplicaDesc(this.nbReplicas, this.replicaIndex, this.restartCount, this.link.getPort(), this.link.getSecret(), EncryptedRPC.getPEMCertificateTextB64orNA());
        }
    }

    public abstract class ReplicaThread
    extends Thread {
        private final RWTransactionRef transaction;
        private final ReplicasHolder replicasHolder;
        protected final int nbReplicas;
        protected final int replicaIndex;
        private boolean stopLoop;

        public ReplicaThread(int nbReplicas, int replicaIndex, ReplicasHolder replicasHolder) {
            this.nbReplicas = nbReplicas;
            this.replicaIndex = replicaIndex;
            this.replicasHolder = replicasHolder;
            this.transaction = TransactionContext.retrieveWrite();
        }

        public abstract void doRun(int var1) throws Exception;

        public synchronized void stopLoop() {
            this.stopLoop = true;
        }

        public synchronized boolean getStopLoop() {
            return this.stopLoop;
        }

        @Override
        public void run() {
            TransactionContext.attach((TransactionRef)this.transaction);
            try {
                int restartCount = 0;
                while (!this.getStopLoop()) {
                    logger.info((Object)("Start replica " + this.replicaIndex));
                    try {
                        this.doRun(restartCount);
                        logger.info((Object)"Replica terminated gracefully");
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to run cpython process", (Throwable)e);
                        if (!this.replicasHolder.shouldRestartOnFailure(e)) {
                            break;
                        }
                        ++restartCount;
                    }
                }
            }
            finally {
                TransactionContext.detach((TransactionRef)this.transaction);
            }
        }
    }
}

