/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.reports.MessageLookupBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DefineVariablesStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return DefineVariablesStepParams.class;
        }

        @Override
        public String getType() {
            return "define_vars";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new DefineVariablesStepRunner(step.getParamsAs(DefineVariablesStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "define scenario variables";
        }

        @Override
        public String buildId(Step step) {
            DefineVariablesStepParams params = step.getParamsAs(DefineVariablesStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("def_scenar_vars");
            if (params != null) {
                for (SimpleKeyValue var : params.definitions) {
                    sb.append("_");
                    sb.append(var.key);
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private TransactionService transactionService;
    private final DefineVariablesStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.definevars");

    public DefineVariablesStepRunner(DefineVariablesStepParams params) {
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        if (this.params.evaluateValues) {
            MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
            VariableLookup lookup = null;
            try (Transaction t = this.transactionService.beginRead();){
                lookup = lookupBuilder.buildForVariablesStep(stepRun.getScenarioRun());
            }
            for (SimpleKeyValue skv : this.params.definitions) {
                logger.infoV("Update variable %s = %s", new Object[]{skv.key, skv.value});
                Object evaluated = lookup.typedGetResolved(skv.value);
                logger.infoV(" --> Evaluated to %s (%s)", new Object[]{evaluated, evaluated == null ? "null" : evaluated.getClass()});
                if (evaluated == null) continue;
                stepRun.getScenarioRun().getVariables().add(skv.key, new Gson().toJsonTree(evaluated));
                lookup.addVariable(skv.key, evaluated);
            }
        } else {
            for (Map.Entry e : this.params.variables.entrySet()) {
                logger.infoV("Update variable %s = %s", new Object[]{e.getKey(), e.getValue()});
                stepRun.getScenarioRun().getVariables().add((String)e.getKey(), (JsonElement)e.getValue());
            }
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class DefineVariablesStepParams
    implements StepParams {
        public JsonObject variables = new JsonObject();
        public List<SimpleKeyValue> definitions = new ArrayList<SimpleKeyValue>();
        public boolean evaluateValues = false;
    }
}

