/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.DeletedPythonPluginStepMeta;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.util.Map;

public class StepRegistry {
    private static final Map<String, StepMeta> library = Maps.newLinkedHashMap();
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.scheduler.steps");

    public static StepRunner buildRunner(Scenario scenario, Step step) {
        StepRunner runner = StepRegistry.getMeta(step).buildRunner(scenario, step);
        SpringUtils.getInstance().autowire((Object)runner);
        return runner;
    }

    public static StepMeta getMeta(Step step) {
        try {
            return StepRegistry.getMeta(step.getType());
        }
        catch (UnavailableDSSObjectException uoe) {
            logger.error((Object)("Could not find step type " + step.getType()), (Throwable)((Object)uoe));
            return new DeletedPythonPluginStepMeta(uoe.unavailableStepInfo.pluginId, uoe.unavailableStepInfo.elementId);
        }
    }

    public static synchronized StepMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        if (type.startsWith("pystep")) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType("pystep", type);
        }
        throw new IllegalStateException("Unknown step type " + type);
    }

    public static synchronized void register(StepMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }
}

