/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetDescriptionsService {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;

    public SerializedDataset setDatasetDescriptionsAndColumnDescriptions(AuthCtx authCtx, String projectKey, String datasetName, String shortDesc, String longDesc, Map<String, String> serializedColDesc) throws Exception {
        SerializedDataset serializedDataset;
        block19: {
            SerializedDataset sds;
            try (Transaction t = this.transactionService.beginRead();){
                sds = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
                if (sds.name == null) {
                    throw new IllegalArgumentException("Can't save a dataset with no name");
                }
            }
            Schema schema = sds.getSchema();
            if (schema == null) {
                schema = new Schema();
            }
            for (Map.Entry<String, String> entry : serializedColDesc.entrySet()) {
                String columnName = entry.getKey();
                String description = entry.getValue();
                SchemaColumn column = schema.getColumn(columnName);
                if (column == null) {
                    throw new IllegalArgumentException("Column not found in schema: " + columnName);
                }
                if (Objects.equals(column.comment, description)) continue;
                column.comment = description;
                column.isColumnEdited = true;
            }
            sds.setSchema(schema);
            sds.shortDesc = shortDesc;
            sds.description = longDesc;
            RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                this.saveService.save(projectKey, datasetName, sds, t.getUser());
                t.commit("Saved dataset " + sds.getFullName() + "with updated descriptions");
                this.auditTrailService.generic("dataset-save").with("projectKey", projectKey).with("datasetName", sds.name).emit();
                serializedDataset = sds;
                if (t == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("dataset-save", (Throwable)e).with("projectKey", projectKey).with("datasetName", sds.name).emit();
                    throw e;
                }
            }
            t.close();
        }
        return serializedDataset;
    }
}

