/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.auth.SimpleAuthCtxUsage;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.intercom.common.ConnectionsIntercomControllerBase;
import com.dataiku.dip.spark.SparkJobExecEnv;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ConnectionsPrivilegedIntercomController
extends ConnectionsIntercomControllerBase {
    @Autowired
    private SharedSecretAuthService sharedSecretAuthService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;

    private boolean comesFromEventServer(HttpServletRequest req) {
        String origin = req.getHeader("X-DKU-CallOrigin");
        return MainLoggingConfigurator.ProcessType.EVENTSERVER.name().equals(origin);
    }

    @Override
    protected boolean isAuthenticationValid(AuthCtx authCtx, DSSConnection conn, HttpServletRequest req) throws IOException {
        if (this.comesFromEventServer(req)) {
            return this.sharedSecretAuthService.hasValidSharedSecret(req);
        }
        return this.sharedSecretAuthService.hasValidSharedSecret(req) || SparkJobExecEnv.allowInsecureAccessToConnection();
    }

    @Override
    protected AuthCtxUsage getAuthCtxUsage(HttpServletRequest req) throws IOException, DKUSecurityException {
        String proxyUser;
        APITicketService.TicketUsage tu = this.authService.getAndUseTicket(req);
        if (tu != null) {
            return tu;
        }
        if (this.comesFromEventServer(req) && StringUtils.isNotBlank((String)(proxyUser = req.getHeader("X-DKU-EventServerProxyUser")))) {
            AuthCtx authCtx = this.authCtxCreationService.create_autoTxn(proxyUser.trim());
            return new SimpleAuthCtxUsage(authCtx);
        }
        throw new SecurityException("Ticket not given or unrecognized");
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/pintercom/connections/get-fully-resolved-credentials"})
    public void getFullyResolvedCredentials(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="true") boolean useTokenCache) throws Exception {
        super.getFullyResolvedCredentials(req, resp, name, projectKey, useTokenCache);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/pintercom/connections/refresh-google-default-credential-access-token"})
    public void refreshGoogleDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name) throws Exception {
        super.refreshGoogleDefaultCredentialAccessToken(req, resp, name);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/pintercom/connections/refresh-azure-default-credential-access-token"})
    public void refreshAzureDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String claims, @RequestParam List<String> scopes, @RequestParam String tenantId) throws Exception {
        super.refreshAzureDefaultCredentialAccessToken(req, resp, name, claims, scopes, tenantId);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/pintercom/connections/get-private-key-last-modified"})
    public void getPrivateKeyLastModified(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name) throws Exception {
        super.getPrivateKeyLastModified(req, resp, name);
    }
}

