/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.intercom.common.ConnectionsIntercomControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ConnectionsIntercomController
extends ConnectionsIntercomControllerBase {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private PasswordEncryptionService cryptoService;

    @AuditedCall(value={"msgType", "connection-get-details", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/api/tintercom/connections/get-details"})
    public void getDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionName) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(tu.getAuthCtx(), connectionName);
            if (!conn.detailsReadableBy(tu.getAuthCtx())) {
                throw new UnauthorizedException("You may not read details of connection " + connectionName, "connection-details-denied");
            }
            if (conn instanceof ConnectionWithEncryptedFields) {
                ((ConnectionWithEncryptedFields)((Object)conn)).decryptFields(this.cryptoService);
            }
            ConnectionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)conn);
        }
    }

    @Override
    protected boolean isAuthenticationValid(AuthCtx authCtx, DSSConnection conn, HttpServletRequest req) {
        return conn.detailsReadableBy(authCtx) || SparkJobExecEnv.allowInsecureAccessToConnection();
    }

    @Override
    protected AuthCtxUsage getAuthCtxUsage(HttpServletRequest req) throws IOException, DKUSecurityException {
        return this.authService.getAndUseMandTicket(req);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/tintercom/connections/get-fully-resolved-credentials"})
    public void getFullyResolvedCredentials(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="true") boolean useTokenCache) throws Exception {
        super.getFullyResolvedCredentials(req, resp, name, projectKey, useTokenCache);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/tintercom/connections/refresh-google-default-credential-access-token"})
    public void refreshGoogleDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name) throws Exception {
        super.refreshGoogleDefaultCredentialAccessToken(req, resp, name);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/tintercom/connections/refresh-azure-default-credential-access-token"})
    public void refreshAzureDefaultCredentialAccessToken(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String claims, @RequestParam List<String> scopes, @RequestParam String tenantId) throws Exception {
        super.refreshAzureDefaultCredentialAccessToken(req, resp, name, claims, scopes, tenantId);
    }

    @Override
    @AuditedCall(value={"msgType", "connection-get-credentials", "connectionName", "${name}"})
    @RequestMapping(value={"/api/tintercom/connections/get-private-key-last-modified"})
    public void getPrivateKeyLastModified(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name) throws Exception {
        super.getPrivateKeyLastModified(req, resp, name);
    }
}

