/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.docextraction.DocExtractionService;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.StructuredExtractorResponseOrError;
import com.dataiku.dip.docextraction.common.VlmExtractorResponseOrError;
import com.dataiku.dip.docextraction.common.chunks.VlmExtractionChunk;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DocExtractionIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private DocExtractionService docExtractionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TicketAuthService authService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/docextraction/vlm"})
    public VlmExtractorResponseOrError runVLM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam VLMExtractor.VLMExtractorRequest vlmRequest, @RequestParam String jobId, @RequestParam String activity) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            VlmExtractorResponseOrError vlmExtractorResponseOrError;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = tu.getAuthCtx();
                this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            }
            try {
                JobBackendLoggingContext.setJobContext(JobBackendLoggingContext.Topic.LLM, jobId, projectKey, activity);
                ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, (AuthCtxUsage)tu, u -> ComputeResourceUsageContext.forJobActivity((AuthCtx)authCtx, (String)projectKey, (String)jobId, (String)activity));
                List<? extends VlmExtractionChunk> textChunks = this.docExtractionService.runVLMextractor(authCtx, projectKey, vlmRequest);
                vlmExtractorResponseOrError = VlmExtractorResponseOrError.fromSuccess(textChunks);
            }
            catch (Exception e) {
                VlmExtractorResponseOrError vlmExtractorResponseOrError2;
                block19: {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    vlmExtractorResponseOrError2 = VlmExtractorResponseOrError.fromError(e);
                    CurrentComputeResourceUsageContext.clear();
                    JobBackendLoggingContext.resetJobContext();
                    if (tu == null) break block19;
                    tu.close();
                }
                return vlmExtractorResponseOrError2;
                {
                    catch (Throwable throwable) {
                        CurrentComputeResourceUsageContext.clear();
                        JobBackendLoggingContext.resetJobContext();
                        throw throwable;
                    }
                }
            }
            CurrentComputeResourceUsageContext.clear();
            JobBackendLoggingContext.resetJobContext();
            return vlmExtractorResponseOrError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/docextraction/structured-flatten"})
    public StructuredExtractorResponseOrError runStructuredFlatten(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam StructuredExtractor.StructuredExtractorSettings settings, @RequestParam InputRefs.ManagedFolderDocumentRef documentRef, @RequestParam boolean useSeparatedChunksForImages, @RequestParam String jobId, @RequestParam String activity) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            AuthCtx authCtx;
            try (Object t = this.transactionService.beginRead();){
                authCtx = tu.getAuthCtx();
                this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            }
            try {
                JobBackendLoggingContext.setJobContext(JobBackendLoggingContext.Topic.LLM, jobId, projectKey, activity);
                ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, (AuthCtxUsage)tu, u -> ComputeResourceUsageContext.forJobActivity((AuthCtx)authCtx, (String)projectKey, (String)jobId, (String)activity));
                t = this.docExtractionService.runStructuredExtractionFromManagedFolderAndFlattenToTextChunks(authCtx, projectKey, documentRef, settings, useSeparatedChunksForImages);
            }
            catch (Exception e) {
                StructuredExtractorResponseOrError structuredExtractorResponseOrError;
                block19: {
                    structuredExtractorResponseOrError = StructuredExtractorResponseOrError.fromError(e);
                    CurrentComputeResourceUsageContext.clear();
                    JobBackendLoggingContext.resetJobContext();
                    if (tu == null) break block19;
                    tu.close();
                }
                return structuredExtractorResponseOrError;
                {
                    catch (Throwable throwable) {
                        CurrentComputeResourceUsageContext.clear();
                        JobBackendLoggingContext.resetJobContext();
                        throw throwable;
                    }
                }
            }
            CurrentComputeResourceUsageContext.clear();
            JobBackendLoggingContext.resetJobContext();
            return t;
        }
    }
}

