/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.offlinequeues;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.IPersistentNotificationsInternalDB;
import com.dataiku.dip.dao.PersistentNotificationsInternalDB;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsGatherer;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionMentionEvent;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserOfflineQueueService {
    private static final int MAX_NOTIFICATIONS_PER_USER = 200;
    public static final String NAME = "user_offline_queues";
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    private IPersistentNotificationsInternalDB dao;
    private static Logger logger = Logger.getLogger((String)"dku.notifications.offline");

    public UserOfflineQueueService() {
        try {
            this.dao = new PersistentNotificationsInternalDB(NAME, 200);
            this.dao.create();
        }
        catch (Exception t) {
            logger.info((Object)"Failed to initialize user offline notifications", (Throwable)t);
        }
    }

    public void deleteForUser(String userLogin) {
        this.dao.deleteForUser(userLogin);
    }

    public void flush(String user) {
        this.dao.deleteForUser(user);
    }

    private String getFullyQualifiedDSSObjectId(EnrichmentService.Enrichable en) {
        return String.valueOf((Object)en.getTaggableType()) + "$$$" + en.getProjectKey() + "$$$" + en.getObjectId();
    }

    public void push(String user, TimelineItemEvent evt) {
        this.dao.insert(user, this.getFullyQualifiedDSSObjectId(evt.item), evt, false);
    }

    public void push(String user, CommitMentionEvent evt) {
        this.dao.insert(user, this.getFullyQualifiedDSSObjectId(evt), evt, false);
    }

    public void push(String user, DiscussionMentionEvent evt) {
        this.dao.insert(user, this.getFullyQualifiedDSSObjectId(evt), evt, false);
    }

    public void push(String user, JobStateChangedEvent evt) {
        this.dao.insert(user, evt.jobId, evt, false);
    }

    public void push(String user, ExportStateChangedEvent evt) {
        this.dao.insert(user, evt.status.exportId, evt, false);
    }

    public void push(String user, MLTaskStateChangedEvent evt) {
        this.dao.insert(user, evt.taskId, evt, false);
    }

    public void garbageCollect() throws Exception {
        ((PersistentNotificationsInternalDB)this.dao).garbageCollect();
    }

    public void sendAll() {
        logger.info((Object)"Start sending user offline queue");
        Map<String, List<IPersistentNotificationsInternalDB.PersistentNotification>> allItems = this.dao.getForAllUsers();
        for (String user : allItems.keySet()) {
            try {
                this.sendToUser(user, allItems.get(user));
            }
            catch (Exception t) {
                logger.error((Object)"Failed to send user offline notifications", (Throwable)t);
            }
            this.flush(user);
        }
        if (allItems.keySet().isEmpty()) {
            logger.info((Object)"No offline queue messages to send");
        }
    }

    private UserSettingsService.OfflineQueuesSettings getUserSettings(String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            UserSettingsService.UserSettings settings = this.userSettingsService.getForUser(login);
            if (settings != null) {
                UserSettingsService.OfflineQueuesSettings offlineQueuesSettings = settings.offlineQueue;
                return offlineQueuesSettings;
            }
            UserSettingsService.OfflineQueuesSettings offlineQueuesSettings = new UserSettingsService.OfflineQueuesSettings();
            return offlineQueuesSettings;
        }
    }

    private void sendToUser(String user, List<IPersistentNotificationsInternalDB.PersistentNotification> notifications) throws Exception {
        PublicUser pu;
        UserSettingsService.OfflineQueuesSettings params = this.getUserSettings(user);
        if (!params.enabled) {
            logger.info((Object)("Offline queue is disabled for user " + user + ", not sending"));
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            pu = this.usersService.getPublicUser(user);
        }
        if (pu.email == null) {
            return;
        }
        String body = this.makeBody(pu.displayName, notifications);
        logger.info((Object)("Send user offline queue to " + user));
        EmailNotificationsSender sender = new EmailNotificationsSender();
        sender.sendToUser(pu.email, (UserSettingsService.EmailNotificationsSettings)params, body);
    }

    private String makeBody(String userDisplayName, List<IPersistentNotificationsInternalDB.PersistentNotification> notifications) throws Exception {
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "notifications-email.ftl"});
        VariableLookup lookup = new VariableLookup();
        lookup.addVariable("username", userDisplayName);
        TemplatedContent templatedContent = new TemplatedContent();
        EmailNotificationsGatherer writer = new EmailNotificationsGatherer();
        boolean empty = true;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", settings.studioExternalUrl);
            lookup.addVariable("dssInstanceName", settings.nodeName);
            for (IPersistentNotificationsInternalDB.PersistentNotification pn : notifications) {
                BackendEvent me;
                if (pn.evt instanceof TimelineItemEvent) {
                    TimelineItemEvent tie = (TimelineItemEvent)pn.evt;
                    this.enrichmentService.enrich(tie.item);
                    writer.add(tie.item);
                    empty = false;
                    continue;
                }
                if (pn.evt instanceof JobStateChangedEvent) {
                    writer.add((JobStateChangedEvent)pn.evt);
                    empty = false;
                    continue;
                }
                if (pn.evt instanceof ExportStateChangedEvent) {
                    ExportStateChangedEvent esce = (ExportStateChangedEvent)pn.evt;
                    writer.add(esce);
                    empty = false;
                    continue;
                }
                if (pn.evt instanceof MLTaskStateChangedEvent) {
                    MLTaskStateChangedEvent msce = (MLTaskStateChangedEvent)pn.evt;
                    writer.add(msce);
                    empty = false;
                    continue;
                }
                if (pn.evt instanceof CommitMentionEvent) {
                    me = (CommitMentionEvent)pn.evt;
                    writer.add((CommitMentionEvent)me);
                    empty = false;
                    continue;
                }
                if (pn.evt instanceof DiscussionMentionEvent) {
                    me = (DiscussionMentionEvent)pn.evt;
                    writer.add((DiscussionMentionEvent)me);
                    empty = false;
                    continue;
                }
                logger.warn((Object)("Notification type not handled " + JSON.json((Object)pn.evt)));
            }
        }
        if (empty) {
            throw new IllegalStateException("Empty e-mail");
        }
        EmailNotificationsGatherer.GroupedNotifications items = writer.gather();
        lookup.addVariable("title", "Activity while you are offline");
        lookup.addVariable("intro", "");
        lookup.addVariable("items", items);
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(templatedContent, templateFile);
        return expandedTemplate.message;
    }
}

