/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.samples;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.samples.SnippetsDAO;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SnippetsCRUDService {
    @Autowired
    private SnippetsDAO dao;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.snippets");

    public List<SnippetsDAO.Snippet> list(String snippetType, final String[] categories, AuthCtx user) throws IOException {
        Validate.notNull((Object)snippetType);
        Validate.notNull((Object)categories);
        logger.infoV("Returning snippets of type '%s' with %s categories '%s'", new Object[]{snippetType, categories.length, StringUtils.join((Object[])categories, (String)",")});
        return FluentIterable.from(this.dao.list(snippetType, user)).filter((Predicate)new Predicate<SnippetsDAO.Snippet>(){

            public boolean apply(SnippetsDAO.Snippet arg0) {
                return categories.length == 0 || ArrayUtils.contains((Object[])categories, (Object)arg0.category);
            }
        }).toList();
    }

    public void save(SnippetsDAO.Snippet snippet, String snippetType, String category, AuthCtx user) throws IOException {
        Validate.notNull((Object)snippetType);
        Validate.notNull((Object)category);
        Preconditions.checkArgument((snippet.title != null ? 1 : 0) != 0, (Object)"Sample title is required");
        Optional<SnippetsDAO.Permission> adminPerm = snippet.getPermissions().stream().filter(perm -> perm.isAdmin).findAny();
        Preconditions.checkArgument((boolean)adminPerm.isPresent(), (Object)"A code sample must have at least one admin permission");
        if (snippet.id == null) {
            snippet.id = SecretKeyGenerator.generate((int)10);
        }
        snippet.category = category;
        for (SnippetsDAO.SnippetVariation v : snippet.variations) {
            if (v.id != null) continue;
            v.id = SecretKeyGenerator.generate((int)10);
        }
        this.dao.save(snippet, snippetType, user);
    }

    public void delete(String snippetId, String snippetType) throws IOException {
        Assert.notNull((Object)snippetId, (String)"An error occurred during the deletion process");
        Assert.notNull((Object)snippetType, (String)"An error occurred during the deletion process");
        this.dao.delete(snippetId, snippetType);
    }
}

