/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ProjectFoldersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.EffectiveProjectFolderReaders;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ProjectFolderCodes;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ProjectFoldersService
implements ApplicationListener<DSSStartedEvent> {
    @Autowired
    private ProjectFoldersDAO dao;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    public static final String ROOT_PROJECT_FOLDER_ID = "ROOT";
    public static final String SANDBOX_FOLDER_ID = "SANDBOX";
    private static final String APP_INSTANCES_PROJECT_FOLDER_ID = "APPS";
    private static final String PROJECT_STANDARDS_PROJECT_FOLDER_ID = "PROJECTSTANDARDS";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projectfolders");

    public void onApplicationEvent(DSSStartedEvent event) {
        this.cleanUpProjectFolders_NT(true);
        this.createDefaultSandboxFolder_NT();
    }

    public List<ProjectFolder> listAll_Uncheck() throws IOException {
        return this.dao.list();
    }

    public void cleanUpProjectFolders_NT(boolean skipIfRootPresent) {
        List folders = new ArrayList();
        HashSet<Object> projectKeys = new HashSet();
        HashSet<String> pfChanged = new HashSet<String>();
        try (Transaction ignored = this.transactionService.beginRead();){
            if (skipIfRootPresent && this.dao.getOrNull(ROOT_PROJECT_FOLDER_ID) != null) {
                return;
            }
            folders = this.dao.list();
            projectKeys = new HashSet<String>(this.projectsService.listProjectKeys());
        }
        catch (IOException e) {
            logger.error((Object)"Cannot read project folders or projects keys", (Throwable)e);
        }
        HashMap<String, ProjectFolder> projectsFolders = new HashMap<String, ProjectFolder>((Map<String, ProjectFolder>)Maps.uniqueIndex(folders, (Function)new Function<ProjectFolder, String>(){

            public String apply(ProjectFolder from) {
                return from.id;
            }
        }));
        ProjectFolder root = (ProjectFolder)projectsFolders.get(ROOT_PROJECT_FOLDER_ID);
        if (root == null) {
            root = this.buildRootProjectFolder(new HashSet<String>(), new HashSet<String>());
            projectsFolders.put(ROOT_PROJECT_FOLDER_ID, root);
            pfChanged.add(ROOT_PROJECT_FOLDER_ID);
        }
        if (StringUtils.isNotBlank((String)root.parentId)) {
            root.parentId = null;
            pfChanged.add(ROOT_PROJECT_FOLDER_ID);
        }
        if (!Objects.equals(root.id, ROOT_PROJECT_FOLDER_ID)) {
            root.id = ROOT_PROJECT_FOLDER_ID;
            pfChanged.add(ROOT_PROJECT_FOLDER_ID);
        }
        for (ProjectFolder pf : projectsFolders.values()) {
            this.cleanupFolder(pf, projectsFolders, pfChanged, projectKeys);
        }
        if (!projectKeys.isEmpty()) {
            root.projectKeys.addAll(projectKeys);
            pfChanged.add(ROOT_PROJECT_FOLDER_ID);
        }
        if (!pfChanged.isEmpty()) {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                for (String pfId : pfChanged) {
                    this.dao.save((ProjectFolder)projectsFolders.get(pfId));
                }
                t.commit("Cleanup project folders");
            }
            catch (IOException e) {
                logger.error((Object)"Cannot save or create root project folder", (Throwable)e);
            }
        }
    }

    private void cleanupFolder(ProjectFolder pf, Map<String, ProjectFolder> projectFolders, Set<String> pfChanged, Set<String> projectKeys) {
        if (!ROOT_PROJECT_FOLDER_ID.equals(pf.id)) {
            if (StringUtils.isBlank((String)pf.name)) {
                pf.name = "Untitled";
                pfChanged.add(pf.id);
            }
            if (StringUtils.isBlank((String)pf.parentId)) {
                pf.parentId = ROOT_PROJECT_FOLDER_ID;
                projectFolders.get((Object)ROOT_PROJECT_FOLDER_ID).childrenIds.add(pf.id);
                pfChanged.add(pf.id);
                pfChanged.add(ROOT_PROJECT_FOLDER_ID);
            } else {
                ProjectFolder parent = projectFolders.get(pf.parentId);
                if (parent == null || pf.id.equals(parent.id) || !parent.childrenIds.contains(pf.id)) {
                    pf.parentId = ROOT_PROJECT_FOLDER_ID;
                    projectFolders.get((Object)ROOT_PROJECT_FOLDER_ID).childrenIds.add(pf.id);
                    pfChanged.add(pf.id);
                    pfChanged.add(ROOT_PROJECT_FOLDER_ID);
                }
            }
        }
        for (String pKey : new HashSet<String>(pf.projectKeys)) {
            if (projectKeys.contains(pKey)) continue;
            pf.projectKeys.remove(pKey);
            pfChanged.add(pf.id);
        }
        projectKeys.removeAll(pf.projectKeys);
        for (String childId : new HashSet<String>(pf.childrenIds)) {
            ProjectFolder child = projectFolders.get(childId);
            if (child != null && !child.id.equals(pf.id) && Objects.equals(pf.id, child.parentId)) continue;
            pf.childrenIds.remove(childId);
            pfChanged.add(pf.id);
        }
    }

    private void createDefaultSandboxFolder_NT() {
        try (Transaction ignored = this.transactionService.beginRead();){
            if (this.dao.exists(SANDBOX_FOLDER_ID)) {
                return;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Cannot read project folders", (Throwable)e);
        }
        try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
            ProjectFolder rootFolder = (ProjectFolder)this.dao.getMandatory(ROOT_PROJECT_FOLDER_ID);
            ProjectFolder sandboxFolder = new ProjectFolder();
            sandboxFolder.id = SANDBOX_FOLDER_ID;
            sandboxFolder.name = "Sandbox";
            sandboxFolder.parentId = rootFolder.id;
            ProjectFolder.PermissionItem permission = new ProjectFolder.PermissionItem();
            permission.group = "$$ALL_USERS$$";
            permission.writeContents = true;
            sandboxFolder.permissions.add(permission);
            this.dao.save(sandboxFolder);
            rootFolder.childrenIds.add(sandboxFolder.id);
            this.dao.save(rootFolder);
            t.commit("Create default sandbox project folder");
        }
        catch (IOException e) {
            logger.error((Object)"Cannot create default sandbox project folder", (Throwable)e);
        }
    }

    public List<ProjectFolderSummary> listAll_Check(AuthCtx authCtx) throws IOException, DKUSecurityException {
        String current;
        ArrayList<ProjectFolderSummary> folders = new ArrayList<ProjectFolderSummary>();
        LinkedList<String> list = new LinkedList<String>(Collections.singletonList(ROOT_PROJECT_FOLDER_ID));
        HashMap<String, List<String>> projectFolderToAccessibleProjectKeysCache = new HashMap<String, List<String>>();
        while ((current = list.poll()) != null) {
            ProjectFolderSummary pfSummary = this.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, current, 1, projectFolderToAccessibleProjectKeysCache);
            if (!this.isProjectFolderRoot(pfSummary.id)) {
                folders.add(pfSummary);
            }
            for (ProjectFolderSummary child : pfSummary.children) {
                list.add(child.id);
            }
        }
        return folders;
    }

    public ProjectFolderSummary hierarchyFromRoot_Check(AuthCtx authCtx) throws IOException, DKUSecurityException {
        HashMap<String, List<String>> projectFolderToAccessibleProjectKeysCache = new HashMap<String, List<String>>();
        return this.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, ROOT_PROJECT_FOLDER_ID, -1, projectFolderToAccessibleProjectKeysCache);
    }

    public void saveProjectFolder_Uncheck(ProjectFolder projectFolder) throws IOException {
        this.dao.save(projectFolder);
    }

    public ProjectFolderOneLevelSummary locateProject(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        List folders = this.dao.list();
        HashMap<String, ProjectFolder> folderMap = new HashMap<String, ProjectFolder>();
        for (ProjectFolder folder : folders) {
            folderMap.put(folder.id, folder);
        }
        HashSet<String> visited = new HashSet<String>();
        ProjectFolder projectFolder = this.recLocateProject(ROOT_PROJECT_FOLDER_ID, projectKey, folderMap, visited);
        if (projectFolder == null) {
            logger.info((Object)("No project folder found containing " + projectKey + ". Default to root folder."));
            projectFolder = (ProjectFolder)this.dao.getMandatoryUnsafe(ROOT_PROJECT_FOLDER_ID);
        } else if (!this.permissionsService.hasProjectFolderPrivilege(authCtx, projectFolder.id, Privileges.ProjectFolderLevelPrivilegeType.READ)) {
            logger.info((Object)("Project folder " + projectFolder.id + " contains " + projectKey + " but can't be accessed by the user. Fallback to root folder."));
            projectFolder = (ProjectFolder)this.dao.getMandatoryUnsafe(ROOT_PROJECT_FOLDER_ID);
        }
        return this.buildProjectFolderOneLevelSummary(authCtx, projectFolder);
    }

    @Nullable
    public ProjectFolder recLocateProject(String folderId, String projectKey, Map<String, ProjectFolder> folders, Set<String> visited) {
        if (visited.contains(folderId)) {
            return null;
        }
        visited.add(folderId);
        ProjectFolder folder = folders.get(folderId);
        if (folder == null) {
            return null;
        }
        if (folder.projectKeys.contains(projectKey)) {
            return folder;
        }
        for (String child : folder.childrenIds) {
            ProjectFolder found = this.recLocateProject(child, projectKey, folders, visited);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public List<ProjectFolder> getProjectLocation_Uncheck(String projectKey) throws IOException {
        List<ProjectFolder> hierarchy = this.getProjectHierarchicalLocation(ROOT_PROJECT_FOLDER_ID, projectKey);
        if (hierarchy == null || hierarchy.isEmpty()) {
            return Collections.singletonList((ProjectFolder)this.dao.getMandatoryUnsafe(ROOT_PROJECT_FOLDER_ID));
        }
        return hierarchy;
    }

    public ProjectFolder getMandatoryUnsafe_Uncheck(String projectFolderId) throws IOException {
        return (ProjectFolder)this.dao.getMandatoryUnsafe(this.getProjectFolderIdOrRoot(projectFolderId));
    }

    public Set<String> getProjectKeys_Uncheck(String projectFolderId, boolean recursive) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        ProjectFolder pf = (ProjectFolder)this.dao.getMandatoryUnsafe(this.getProjectFolderIdOrRoot(projectFolderId));
        for (String pkey : pf.projectKeys) {
            ret.add(pkey);
        }
        if (recursive) {
            for (String child : pf.childrenIds) {
                ret.addAll(this.getProjectKeys_Uncheck(child, true));
            }
        }
        return ret;
    }

    public boolean isProjectFolderRoot(String projectFolderId) throws IOException {
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        return StringUtils.equals((String)pfid, (String)ROOT_PROJECT_FOLDER_ID);
    }

    public boolean isProjectFolderAppInstance(String projectFolderId) throws IOException {
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        return StringUtils.equals((String)pfid, (String)APP_INSTANCES_PROJECT_FOLDER_ID);
    }

    public void deleteForProject_Uncheck(String projectKey) throws IOException {
        this.deleteForProject(projectKey, ROOT_PROJECT_FOLDER_ID);
    }

    private void deleteForProject(String projectKey, String projectFolderId) throws IOException {
        ProjectFolder pf = (ProjectFolder)this.dao.getMandatory(projectFolderId);
        if (pf.projectKeys.remove(projectKey)) {
            this.dao.save(pf);
        }
        for (String child : pf.childrenIds) {
            this.deleteForProject(projectKey, child);
        }
    }

    private String generateNewId() throws IOException {
        String newId;
        TransactionContext.assertAttachedRWTransaction();
        while (this.dao.getOrNullUnsafe(newId = SecretKeyGenerator.generateSmall()) != null) {
        }
        return newId;
    }

    private ProjectFolder buildRootProjectFolder(Set<String> childrenIds, Set<String> projectKeys) {
        ProjectFolder root = new ProjectFolder();
        root.id = ROOT_PROJECT_FOLDER_ID;
        root.childrenIds = childrenIds;
        root.projectKeys = projectKeys;
        return root;
    }

    private ProjectFolder buildProjectFolder(String name) throws IOException, DKUSecurityException {
        TransactionContext.assertAttachedRWTransaction();
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AuthCtx user = t.getUser();
        this.checkProjectFolderNameValidity(name);
        String newId = this.generateNewId();
        ProjectFolder pf = new ProjectFolder();
        pf.id = newId;
        pf.name = name;
        pf.owner = user.getIdentifier();
        return pf;
    }

    private void checkProjectFolderNameValidity(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_NAME_EMPTY, "Project folder name cannot be empty");
        }
        if (!name.matches("^[^/]+$")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_NAME_INVALID, "Project folder name cannot contain the / character");
        }
    }

    public ProjectFolderOneLevelSummary getProjectFolderSummaryOneLevelMandatoryUnsafe_Check(AuthCtx authCtx, String projectFolderId) throws DKUSecurityException, IOException {
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        return this.buildProjectFolderOneLevelSummaryUnsafe_Check(authCtx, pfid);
    }

    public ProjectFolderSummary getProjectFolderSummaryMandatoryUnsafe_Check(AuthCtx authCtx, String projectFolderId, int maxChildrenDepth, Map<String, List<String>> projectFolderToAccessibleProjectKeysCache) throws DKUSecurityException, IOException {
        ProjectFolderSummaryOptions options = new ProjectFolderSummaryOptions();
        options.maxChildrenDepth = maxChildrenDepth;
        options.includeLimitedVisibility = false;
        options.retrieveProjects = true;
        options.retrieveAncestry = true;
        return this.getProjectFolderSummaryMandatoryUnsafe_Check(authCtx, projectFolderId, projectFolderToAccessibleProjectKeysCache, options);
    }

    public ProjectFolderSummary getDefaultProjectFolderSummary_Unsafe_NT(AuthCtx authCtx, String contextFolderId) throws DKUSecurityException, IOException {
        String folderIdFromRules = null;
        boolean useSubfolder = false;
        ProjectFolderSummary existingFolderSummary = null;
        String userSubFolderId = null;
        boolean mustCreateSubfolder = false;
        try (Transaction ignored = this.transactionService.beginRead();){
            if (!ROOT_PROJECT_FOLDER_ID.equals(contextFolderId) && this.permissionsService.hasProjectFolderPrivilege(authCtx, contextFolderId, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS)) {
                folderIdFromRules = contextFolderId;
            } else {
                GeneralSettingsDAO.DefaultFolderRule rule = this.findMatchingDefaultFolderRule_T(authCtx);
                if (rule != null) {
                    folderIdFromRules = rule.folderId;
                    useSubfolder = rule.subFolderPerUser;
                }
            }
            if (folderIdFromRules == null) {
                folderIdFromRules = contextFolderId;
            }
            Object existingFolderId = folderIdFromRules;
            if (useSubfolder) {
                userSubFolderId = folderIdFromRules + "-" + authCtx.getIdentifier();
                if (this.dao.exists(userSubFolderId)) {
                    existingFolderId = userSubFolderId;
                } else {
                    mustCreateSubfolder = true;
                }
            }
            ProjectFolderSummaryOptions options = new ProjectFolderSummaryOptions();
            options.retrieveAncestry = true;
            options.maxChildrenDepth = 1;
            existingFolderSummary = this.buildProjectFolderSummaryUnsafe_Check(authCtx, (String)existingFolderId, null, options);
        }
        return mustCreateSubfolder ? this.createPerUserSubFolder(authCtx, userSubFolderId, existingFolderSummary) : existingFolderSummary;
    }

    private GeneralSettingsDAO.DefaultFolderRule findMatchingDefaultFolderRule_T(AuthCtx authCtx) throws IOException, DKUSecurityException {
        TransactionContext.assertAttachedTransaction();
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        List<GeneralSettingsDAO.DefaultFolderRule> defaultFolderRules = generalSettings.defaultFolderSettings.rules;
        for (GeneralSettingsDAO.DefaultFolderRule rule : defaultFolderRules) {
            if (!"$$ALL_USERS$$".equals(rule.group) && !authCtx.getGroupsIfRelevant().contains(rule.group) || !StringUtils.isNotBlank((String)rule.folderId) || !this.dao.exists(rule.folderId) || !this.permissionsService.hasProjectFolderPrivilege(authCtx, rule.folderId, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS)) continue;
            return rule;
        }
        return null;
    }

    private ProjectFolderSummary createPerUserSubFolder(AuthCtx authCtx, String userSubFolderId, ProjectFolderSummary parentFolderSummary) throws IOException, DKUSecurityException {
        PublicUser user = this.usersService.getPublicUser(authCtx.getAssociatedDSSUserMand());
        String userSubFolderName = user.displayName;
        if (!userSubFolderId.contains(parentFolderSummary.id)) {
            return parentFolderSummary;
        }
        ProjectFolder userSubFolder = new ProjectFolder();
        userSubFolder.id = userSubFolderId;
        userSubFolder.name = userSubFolderName;
        userSubFolder.owner = authCtx.getIdentifier();
        userSubFolder.parentId = parentFolderSummary.id;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.dao.exists(userSubFolder.id)) {
                userSubFolder = (ProjectFolder)this.dao.getMandatory(parentFolderSummary.id);
            } else {
                ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(parentFolderSummary.id);
                this.permissionsService.hasProjectFolderPrivilege(authCtx, parentFolderSummary.id, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
                parentFolder.childrenIds.add(userSubFolder.id);
                this.dao.save(parentFolder);
                this.dao.save(userSubFolder);
                t.commit("Create per-user sandbox folder for user: " + authCtx.getIdentifier());
            }
        }
        ProjectFolderSummary userSubfolderSummary = new ProjectFolderSummary();
        userSubfolderSummary.name = userSubFolder.name;
        userSubfolderSummary.parent = parentFolderSummary;
        userSubfolderSummary.id = userSubFolder.id;
        userSubfolderSummary.canWriteContents = true;
        userSubfolderSummary.isAdmin = true;
        userSubfolderSummary.noPermissions = false;
        userSubfolderSummary.isOwner = StringUtils.equals((String)userSubFolder.owner, (String)authCtx.getIdentifier());
        return userSubfolderSummary;
    }

    public ProjectFolderSummary getProjectFolderSummaryMandatoryUnsafe_Check(AuthCtx authCtx, String projectFolderId, Map<String, List<String>> projectFolderToAccessibleProjectKeysCache, ProjectFolderSummaryOptions options) throws DKUSecurityException, IOException {
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        return this.buildProjectFolderSummaryUnsafe_Check(authCtx, pfid, projectFolderToAccessibleProjectKeysCache, options);
    }

    public ProjectFolderSettings getProjectFolderSettingsMandatoryUnsafe_Check(AuthCtx authCtx, String projectFolderId) throws DKUSecurityException, IOException {
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        if (this.isProjectFolderRoot(pfid)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_ROOT_GET_SETTINGS, "Root project folder does not have settings");
        }
        this.permissionsService.checkProjectFolderPrivilege(authCtx, pfid, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        ProjectFolder pf = (ProjectFolder)this.dao.getMandatoryUnsafe(pfid);
        ProjectFolderSettings pfs = new ProjectFolderSettings();
        pfs.name = pf.name;
        pfs.owner = pf.owner;
        pfs.permissions = new ArrayList<ProjectFolder.PermissionItem>();
        for (ProjectFolder.PermissionItem pi : pf.permissions) {
            ProjectFolder.PermissionItem newPi = new ProjectFolder.PermissionItem();
            newPi.admin = pi.admin;
            newPi.group = pi.group;
            newPi.read = pi.read;
            newPi.writeContents = pi.writeContents;
            pfs.permissions.add(newPi);
        }
        return pfs;
    }

    public void saveProjectFolder_Check(AuthCtx authCtx, String projectFolderId, ProjectFolderSettings projectFolderSettings) throws IOException, DKUSecurityException {
        this.checkAllUserGroupCanBeAdded(projectFolderSettings);
        String pfid = this.getProjectFolderIdOrRoot(projectFolderId);
        if (this.isProjectFolderRoot(pfid)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_ROOT_SET_SETTINGS, "Root project folder does not have settings");
        }
        this.permissionsService.checkProjectFolderPrivilege(authCtx, pfid, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        this.checkProjectFolderNameValidity(projectFolderSettings.name);
        ProjectFolder preExisting = (ProjectFolder)this.dao.getMandatory(pfid);
        preExisting.name = projectFolderSettings.name;
        preExisting.owner = projectFolderSettings.owner;
        List<ProjectFolder.PermissionItem> newPermissions = projectFolderSettings.permissions.stream().filter(pi -> pi.group != null).toList();
        if (newPermissions.size() != projectFolderSettings.permissions.size()) {
            logger.warn((Object)"Some permissions items have a null 'group' field. Ignoring them");
        }
        preExisting.permissions = newPermissions;
        this.dao.save(preExisting);
    }

    public void checkAllUserGroupCanBeAdded(ProjectFolderSettings projectFolderSettings) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
        if (projectFolderSettings.permissions.stream().anyMatch(p -> "$$ALL_USERS$$".equals(p.group) && gs.security.restrictUsersAndGroupsVisibility)) {
            throw new DKUSecurityException("The 'All users' group may not be included, due to the general settings of your instance.");
        }
    }

    public ProjectFolder createFolder_Check(AuthCtx authCtx, String optParentFolderId, String name) throws IOException, DKUSecurityException {
        String parentFolderId = this.getProjectFolderIdOrRoot(optParentFolderId);
        this.permissionsService.checkProjectFolderPrivilege(authCtx, parentFolderId, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(parentFolderId);
        ProjectFolder newFolder = this.buildProjectFolder(name);
        newFolder.parentId = parentFolder.id;
        if (!this.isProjectFolderRoot(parentFolder.id)) {
            for (ProjectFolder.PermissionItem p : parentFolder.permissions) {
                ProjectFolder.PermissionItem newP = new ProjectFolder.PermissionItem();
                newP.admin = p.admin;
                newP.group = p.group;
                newP.read = p.read;
                newP.writeContents = p.writeContents;
                newFolder.permissions.add(newP);
            }
        }
        parentFolder.childrenIds.add(newFolder.id);
        this.dao.save(parentFolder);
        this.dao.save(newFolder);
        return newFolder;
    }

    public void deleteFolder_Check(AuthCtx authCtx, String optProjectFolderId) throws IOException, DKUSecurityException {
        String projectFolderId = this.getProjectFolderIdOrRoot(optProjectFolderId);
        if (this.isProjectFolderRoot(projectFolderId)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_ROOT_DELETE, "Root project folder cannot be deleted");
        }
        this.permissionsService.checkProjectFolderPrivilege(authCtx, projectFolderId, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        ProjectFolder projectFolder = (ProjectFolder)this.dao.getMandatoryUnsafe(projectFolderId);
        ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(projectFolder.parentId);
        if (!projectFolder.childrenIds.isEmpty() || !projectFolder.projectKeys.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_DELETE_NON_EMPTY, "Non-empty project folders cannot be deleted");
        }
        parentFolder.childrenIds.remove(projectFolderId);
        this.dao.delete(projectFolderId);
        this.dao.save(parentFolder);
    }

    public void addProject_Check(AuthCtx authCtx, String projectFolderId, String projectKey) throws IOException, DKUSecurityException {
        String prjFolderId = this.getProjectFolderIdOrRoot(projectFolderId);
        this.permissionsService.checkProjectFolderPrivilege(authCtx, prjFolderId, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        ProjectFolder projectFolder = (ProjectFolder)this.dao.getMandatory(prjFolderId);
        projectFolder.projectKeys.add(projectKey);
        this.dao.save(projectFolder);
    }

    public void moveFolder_Check(AuthCtx authCtx, String from, String to) throws IOException, DKUSecurityException {
        ProjectFolder fromProjectFolder = (ProjectFolder)this.dao.getMandatory(this.getProjectFolderIdOrRoot(from));
        if (this.isProjectFolderRoot(fromProjectFolder.id)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_ROOT_MOVE, "Root project folder cannot be moved");
        }
        ProjectFolder toProjectFolder = (ProjectFolder)this.dao.getMandatory(this.getProjectFolderIdOrRoot(to));
        ProjectFolder parentFromProjectFolder = (ProjectFolder)this.dao.getMandatory(fromProjectFolder.parentId);
        if (StringUtils.equals((String)parentFromProjectFolder.id, (String)toProjectFolder.id)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_MOVE_TO_SAME_PARENT, "Project folders cannot be moved into their current parent");
        }
        this.checkCircularReference(fromProjectFolder, toProjectFolder);
        this.permissionsService.checkProjectFolderPrivilege(authCtx, toProjectFolder.id, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        this.permissionsService.checkProjectFolderPrivilege(authCtx, fromProjectFolder.id, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        ErrorContext.check((boolean)parentFromProjectFolder.childrenIds.contains(fromProjectFolder.id), (String)String.format("Folder %s (%s) does not contains folder %s (%s)", parentFromProjectFolder.name, parentFromProjectFolder.id, fromProjectFolder.name, fromProjectFolder.id));
        parentFromProjectFolder.childrenIds.remove(fromProjectFolder.id);
        toProjectFolder.childrenIds.add(fromProjectFolder.id);
        fromProjectFolder.parentId = toProjectFolder.id;
        this.dao.save(parentFromProjectFolder);
        this.dao.save(toProjectFolder);
        this.dao.save(fromProjectFolder);
    }

    private void checkCircularReference(ProjectFolder fromProjectFolder, ProjectFolder toProjectFolder) throws IOException {
        if (Objects.equals(fromProjectFolder.id, toProjectFolder.id) || Objects.equals(fromProjectFolder.id, toProjectFolder.parentId)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ProjectFolderCodes.ERR_PROJECT_FOLDER_MOVE_TO_CHILDREN, "When moving a project folder, the destination cannot be this project folder itself nor one of its descendants (a sub-project folder)");
        }
        if (!this.isProjectFolderRoot(toProjectFolder.id)) {
            ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(toProjectFolder.parentId);
            this.checkCircularReference(fromProjectFolder, parentFolder);
        }
    }

    public String getProjectFolderIdOrRoot(String folderId) throws IOException {
        return StringUtils.isBlank((String)folderId) ? ROOT_PROJECT_FOLDER_ID : folderId;
    }

    private void removeProjectsFromFolder(AuthCtx authCtx, ProjectFolder folder, Set<String> projectKeys) throws IOException, DKUSecurityException {
        if (projectKeys.isEmpty()) {
            return;
        }
        for (String projectKey : projectKeys) {
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            ErrorContext.check((boolean)folder.projectKeys.contains(projectKey), (String)String.format("%s does not exists in current folder %s (%s).", projectKey, folder.name, folder.id));
        }
        folder.projectKeys.removeAll(projectKeys);
        this.dao.save(folder);
    }

    public void moveProjectsFromFolder_Check(AuthCtx authCtx, String source, String destination, Set<String> projectKeys) throws IOException, DKUSecurityException {
        this.permissionsService.checkProjectFolderPrivilege(authCtx, this.getProjectFolderIdOrRoot(destination), Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        ProjectFolder fromProjectFolder = (ProjectFolder)this.dao.getMandatory(this.getProjectFolderIdOrRoot(source));
        this.removeProjectsFromFolder(authCtx, fromProjectFolder, projectKeys);
        ProjectFolder toProjectFolder = (ProjectFolder)this.dao.getMandatory(this.getProjectFolderIdOrRoot(destination));
        toProjectFolder.projectKeys.addAll(projectKeys);
        this.dao.save(toProjectFolder);
    }

    public void moveProjects_Check(AuthCtx authCtx, String to, Set<String> projectKeys) throws IOException, DKUSecurityException {
        this.permissionsService.checkProjectFolderPrivilege(authCtx, this.getProjectFolderIdOrRoot(to), Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        HashSet<String> remainingProjectKeys = new HashSet<String>(projectKeys);
        for (ProjectFolder folder : this.dao.listUnsafe()) {
            HashSet<String> inThisFolder = new HashSet<String>(remainingProjectKeys);
            inThisFolder.retainAll(folder.projectKeys);
            this.removeProjectsFromFolder(authCtx, folder, inThisFolder);
            remainingProjectKeys.removeAll(inThisFolder);
            if (!remainingProjectKeys.isEmpty()) continue;
            break;
        }
        ProjectFolder destinationFolder = (ProjectFolder)this.dao.getMandatory(this.getProjectFolderIdOrRoot(to));
        destinationFolder.projectKeys.addAll(projectKeys);
        this.dao.save(destinationFolder);
    }

    public boolean moveContent_Check(AuthCtx authCtx, String optFolderId, String destination) throws DKUSecurityException, IOException {
        String folderId = this.getProjectFolderIdOrRoot(optFolderId);
        String destinationId = this.getProjectFolderIdOrRoot(destination);
        ProjectFolder projectFolder = (ProjectFolder)this.dao.getMandatory(folderId);
        boolean movedSomething = !projectFolder.childrenIds.isEmpty() || !projectFolder.projectKeys.isEmpty();
        for (String child : projectFolder.childrenIds) {
            this.moveFolder_Check(authCtx, child, destinationId);
        }
        this.moveProjectsFromFolder_Check(authCtx, optFolderId, destinationId, projectFolder.projectKeys);
        return movedSomething;
    }

    public EffectiveProjectFolderReaders getEffectiveReaders_Check(AuthCtx authCtx, String folderId) throws IOException, DKUSecurityException {
        String pfid = this.getProjectFolderIdOrRoot(folderId);
        this.permissionsService.checkProjectFolderPrivilege(authCtx, pfid, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        ArrayList<String> availableGroups = new ArrayList<String>(this.usersService.listGroupNames(authCtx, false));
        availableGroups.add("$$ALL_USERS$$");
        List<UsersService.UIUser> availableUsers = this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx);
        return this.getEffectiveReaders_Uncheck(pfid, availableGroups, availableUsers);
    }

    private EffectiveProjectFolderReaders getEffectiveReaders_Uncheck(String folderId, List<String> availableGroups, List<UsersService.UIUser> availableUsers) throws IOException {
        EffectiveProjectFolderReaders effectiveReaders = new EffectiveProjectFolderReaders();
        ProjectFolder pf = (ProjectFolder)this.dao.getMandatoryUnsafe(folderId);
        for (ProjectFolder.PermissionItem pi : pf.permissions) {
            if (!StringUtils.isNotBlank((String)pi.group) || !availableGroups.contains(pi.group) || !PermissionsService.permissionItemIncludes(pi, Privileges.ProjectFolderLevelPrivilegeType.READ)) continue;
            effectiveReaders.addGroup(pi.group);
        }
        if (StringUtils.isNotBlank((String)pf.owner)) {
            for (UsersService.UIUser user : availableUsers) {
                if (!user.login.equals(pf.owner)) continue;
                effectiveReaders.addUser(pf.owner);
                break;
            }
        }
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        for (String pkey : pf.projectKeys) {
            SerializedProject prj = this.projectsService.getMandatoryUnsafe(pkey);
            if (this.projectsService.isVisible(prj, generalSettings)) {
                effectiveReaders.setContainsLimitedVisibilityProject();
                return effectiveReaders;
            }
            for (SerializedProject.PermissionItem pi : prj.permissions) {
                if (pi == null || !StringUtils.isNotBlank((String)pi.group) || !availableGroups.contains(pi.group) || !pi.hasAnyAccess()) continue;
                effectiveReaders.addGroup(pi.group);
            }
            block4: for (UsersService.UIUser user : availableUsers) {
                if (StringUtils.equals((String)user.login, (String)prj.owner)) {
                    effectiveReaders.addUser(prj.owner);
                    continue;
                }
                for (SerializedProject.PermissionItem pi : prj.permissions) {
                    if (pi == null || !user.login.equals(pi.user) || !pi.hasAnyAccess()) continue;
                    effectiveReaders.addUser(pi.user);
                    continue block4;
                }
            }
            block6: for (SerializedProject.AdditionalDashboardUser adu : prj.additionalDashboardUsers.users) {
                for (UsersService.UIUser user : availableUsers) {
                    if (!StringUtils.equals((String)user.login, (String)adu.login)) continue;
                    effectiveReaders.addUser(adu.login);
                    continue block6;
                }
            }
        }
        for (String child : pf.childrenIds) {
            effectiveReaders.add(this.getEffectiveReaders_Uncheck(child, availableGroups, availableUsers));
            if (!effectiveReaders.getContainsLimitedVisibilityProject()) continue;
            break;
        }
        return effectiveReaders;
    }

    private ProjectFolderOneLevelSummary buildProjectFolderOneLevelSummaryUnsafe_Check(AuthCtx authCtx, String projectFolderId) throws DKUSecurityException, IOException {
        this.permissionsService.checkProjectFolderPrivilege(authCtx, projectFolderId, Privileges.ProjectFolderLevelPrivilegeType.READ);
        ProjectFolder projectFolder = (ProjectFolder)this.dao.getMandatoryUnsafe(projectFolderId);
        return this.buildProjectFolderOneLevelSummary(authCtx, projectFolder);
    }

    @NotNull
    private ProjectFolderOneLevelSummary buildProjectFolderOneLevelSummary(AuthCtx authCtx, ProjectFolder projectFolder) {
        ProjectFolderOneLevelSummary pfols = new ProjectFolderOneLevelSummary();
        pfols.id = projectFolder.id;
        pfols.name = projectFolder.name;
        pfols.parentId = projectFolder.parentId;
        pfols.projectKeys = this.retrieveProjectKeys(authCtx, projectFolder, new HashMap<String, List<String>>(), false);
        pfols.childrenIds = new ArrayList<String>();
        for (String folderId : projectFolder.childrenIds) {
            try {
                if (!this.permissionsService.hasProjectFolderPrivilege(authCtx, folderId, Privileges.ProjectFolderLevelPrivilegeType.READ)) continue;
                pfols.childrenIds.add(folderId);
            }
            catch (DKUSecurityException e) {
                logger.errorV((Throwable)e, "Cannot get project folder permissions, ignoring project folder: %s", new Object[]{folderId});
            }
        }
        return pfols;
    }

    private ProjectFolderSummary buildProjectFolderSummaryUnsafe_Check(AuthCtx authCtx, String projectFolderId, Map<String, List<String>> projectFolderToAccessibleProjectKeysCache, ProjectFolderSummaryOptions options) throws DKUSecurityException, IOException {
        this.permissionsService.checkProjectFolderPrivilege(authCtx, projectFolderId, Privileges.ProjectFolderLevelPrivilegeType.READ);
        ProjectFolder projectFolder = (ProjectFolder)this.dao.getMandatoryUnsafe(projectFolderId);
        ProjectFolderSummary pfs = new ProjectFolderSummary();
        pfs.id = projectFolder.id;
        pfs.name = projectFolder.name;
        pfs.isOwner = StringUtils.equals((String)projectFolder.owner, (String)authCtx.getIdentifier());
        if (options.retrieveAncestry && StringUtils.isNotBlank((String)projectFolder.parentId) && this.permissionsService.hasProjectFolderPrivilege(authCtx, projectFolder.parentId, Privileges.ProjectFolderLevelPrivilegeType.READ)) {
            pfs.parent = this.buildProjectFolderSummaryUnsafe_Check(authCtx, projectFolder.parentId, projectFolderToAccessibleProjectKeysCache, options.buildOptionsForAncestor());
        }
        if (options.retrieveProjects) {
            pfs.projectKeys = this.retrieveProjectKeys(authCtx, projectFolder, projectFolderToAccessibleProjectKeysCache, options.includeLimitedVisibility);
        }
        pfs.children = new ArrayList<ProjectFolderSummary>();
        if (options.shouldRetrieveChildren()) {
            for (String childFolderId : projectFolder.childrenIds) {
                try {
                    if (!this.permissionsService.hasProjectFolderPrivilege(authCtx, childFolderId, Privileges.ProjectFolderLevelPrivilegeType.READ)) continue;
                    pfs.children.add(this.buildProjectFolderSummaryUnsafe_Check(authCtx, childFolderId, projectFolderToAccessibleProjectKeysCache, options.buildOptionsForChild()));
                }
                catch (DKUSecurityException e) {
                    logger.errorV((Throwable)e, "Cannot get project folder permissions, ignoring project folder: %s", new Object[]{childFolderId});
                }
            }
        }
        pfs.canWriteContents = this.permissionsService.hasProjectFolderPrivilege(authCtx, pfs.id, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
        pfs.isAdmin = this.permissionsService.hasProjectFolderPrivilege(authCtx, pfs.id, Privileges.ProjectFolderLevelPrivilegeType.ADMIN);
        pfs.noPermissions = true;
        for (ProjectFolder.PermissionItem pi : projectFolder.permissions) {
            if (!PermissionsService.permissionItemIncludes(pi, Privileges.ProjectFolderLevelPrivilegeType.READ)) continue;
            pfs.noPermissions = false;
            break;
        }
        return pfs;
    }

    public synchronized String ensureAppInstancesFolder(AuthCtx authCtx) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            if (this.dao.exists(APP_INSTANCES_PROJECT_FOLDER_ID)) {
                String string = APP_INSTANCES_PROJECT_FOLDER_ID;
                return string;
            }
        }
        logger.info((Object)"App instances folder doesn't exist yet, creating it");
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(ROOT_PROJECT_FOLDER_ID);
            ProjectFolder newFolder = new ProjectFolder();
            newFolder.id = APP_INSTANCES_PROJECT_FOLDER_ID;
            newFolder.name = "App instances";
            newFolder.owner = "admin";
            newFolder.parentId = parentFolder.id;
            parentFolder.childrenIds.add(newFolder.id);
            this.dao.save(parentFolder);
            this.dao.save(newFolder);
            t.commit("Create app instances folder");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return APP_INSTANCES_PROJECT_FOLDER_ID;
    }

    public synchronized String ensureProjectStandardsFolder_NT(AuthCtx authCtx) throws IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            if (this.dao.exists(PROJECT_STANDARDS_PROJECT_FOLDER_ID)) {
                String string = PROJECT_STANDARDS_PROJECT_FOLDER_ID;
                return string;
            }
        }
        logger.info((Object)"Project standards folder doesn't exist yet, creating it");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            ProjectFolder parentFolder = (ProjectFolder)this.dao.getMandatory(ROOT_PROJECT_FOLDER_ID);
            ProjectFolder newFolder = new ProjectFolder();
            newFolder.id = PROJECT_STANDARDS_PROJECT_FOLDER_ID;
            newFolder.name = "Project standards";
            newFolder.owner = "admin";
            newFolder.parentId = parentFolder.id;
            parentFolder.childrenIds.add(newFolder.id);
            this.dao.save(parentFolder);
            this.dao.save(newFolder);
            t.commit("Create project standards folder");
        }
        return PROJECT_STANDARDS_PROJECT_FOLDER_ID;
    }

    private List<ProjectFolder> getProjectHierarchicalLocation(String folderId, String projectKey) throws IOException {
        ProjectFolder folder;
        if (folderId != null && (folder = (ProjectFolder)this.dao.getOrNullUnsafe(folderId)) != null) {
            if (folder.projectKeys.contains(projectKey)) {
                ArrayList<ProjectFolder> result = new ArrayList<ProjectFolder>();
                result.add(folder);
                return result;
            }
            for (String childrenId : folder.childrenIds) {
                List<ProjectFolder> subFolderWithProject = this.getProjectHierarchicalLocation(childrenId, projectKey);
                if (subFolderWithProject == null) continue;
                subFolderWithProject.add(folder);
                return subFolderWithProject;
            }
        }
        return null;
    }

    private List<String> retrieveProjectKeys(AuthCtx authCtx, ProjectFolder projectFolder, Map<String, List<String>> projectFolderToAccessibleProjectKeysCaches, boolean includeLimitedVisibility) {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"services.projectFolders.retrieveProjectKeys");){
            if (projectFolder.id != null && projectFolderToAccessibleProjectKeysCaches.containsKey(projectFolder.id)) {
                DSSMetrics.registry().meter("services.projectFolders.retrieveProjectKeys.cacheHit").mark();
                ArrayList arrayList = Lists.newArrayList(projectFolderToAccessibleProjectKeysCaches.get(projectFolder.id).iterator());
                return arrayList;
            }
            DSSMetrics.registry().meter("services.projectFolders.retrieveProjectKeys.cacheMiss").mark();
            ArrayList<String> projectKeys = new ArrayList<String>();
            for (String projectKey : projectFolder.projectKeys) {
                try {
                    if (!this.permissionsService.hasAnyProjectAccess(authCtx, projectKey) && (!includeLimitedVisibility || !this.projectsService.isVisible(projectKey))) continue;
                    projectKeys.add(projectKey);
                }
                catch (DKUSecurityException e) {
                    logger.errorV((Throwable)e, "Cannot get project permissions, ignoring project: %s", new Object[]{projectKey});
                }
            }
            DSSMetrics.registry().histogram("services.projectFolders.retrieveProjectKeys.checked").update(projectFolder.projectKeys.size());
            DSSMetrics.registry().histogram("services.projectFolders.retrieveProjectKeys.retrieved").update(projectKeys.size());
            if (projectFolder.id != null) {
                projectFolderToAccessibleProjectKeysCaches.put(projectFolder.id, Lists.newArrayList(projectKeys));
            }
            ArrayList<String> arrayList = projectKeys;
            return arrayList;
        }
    }

    public static class ProjectFolderSummary {
        public String id;
        @UINullable
        public String name;
        @UINullable
        public ProjectFolderSummary parent;
        public List<String> projectKeys = new ArrayList<String>();
        public List<ProjectFolderSummary> children = new ArrayList<ProjectFolderSummary>();
        public boolean canWriteContents;
        public boolean isAdmin;
        public boolean isOwner;
        public boolean noPermissions;
    }

    public static class ProjectFolderOneLevelSummary {
        public String id;
        public String name;
        public String parentId;
        public List<String> projectKeys = new ArrayList<String>();
        public List<String> childrenIds = new ArrayList<String>();

        public ProjectFolderOneLevelSummary() {
        }

        public ProjectFolderOneLevelSummary(ProjectFolderSummary folder) {
            this.id = folder.id;
            this.name = folder.name;
            this.parentId = folder.parent == null ? null : folder.parent.id;
            this.projectKeys = folder.projectKeys;
            this.childrenIds = folder.children == null ? new ArrayList<String>() : folder.children.stream().map(c2 -> c2.id).collect(Collectors.toList());
        }
    }

    public static class ProjectFolderSummaryOptions {
        public boolean retrieveAncestry = false;
        public int maxChildrenDepth = 0;
        public boolean retrieveProjects = false;
        public boolean includeLimitedVisibility = false;

        public ProjectFolderSummaryOptions() {
        }

        public ProjectFolderSummaryOptions(ProjectFolderSummaryOptions from) {
            this.retrieveAncestry = from.retrieveAncestry;
            this.maxChildrenDepth = from.maxChildrenDepth;
            this.includeLimitedVisibility = from.includeLimitedVisibility;
            this.retrieveProjects = from.retrieveProjects;
        }

        public boolean shouldRetrieveChildren() {
            return this.maxChildrenDepth > 0 || this.maxChildrenDepth == -1;
        }

        public ProjectFolderSummaryOptions buildOptionsForAncestor() {
            if (!this.retrieveAncestry) {
                throw new IllegalStateException("Impossible to build ancestor options if retrieveAncestry is set to false");
            }
            ProjectFolderSummaryOptions ancestorOptions = new ProjectFolderSummaryOptions(this);
            ancestorOptions.retrieveAncestry = true;
            ancestorOptions.maxChildrenDepth = 0;
            return ancestorOptions;
        }

        public ProjectFolderSummaryOptions buildOptionsForChild() {
            if (!this.shouldRetrieveChildren()) {
                throw new IllegalStateException("Impossible to build child options - options indicate we should not be retrieving children");
            }
            ProjectFolderSummaryOptions childOptions = new ProjectFolderSummaryOptions(this);
            childOptions.retrieveAncestry = false;
            childOptions.maxChildrenDepth = this.maxChildrenDepth == -1 ? -1 : this.maxChildrenDepth - 1;
            return childOptions;
        }
    }

    public static class ProjectFolderSettings {
        public String name;
        public String owner;
        public List<ProjectFolder.PermissionItem> permissions;
    }
}

