/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.model.ActiveBundleState;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.model.FlowItemsToCompare;
import com.dataiku.dip.scheduler.model.FlowItemsToSwap;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.CustomPythonScenarioRunner;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioParams;
import com.dataiku.dip.scheduler.scenarios.ScenarioRegistry;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.scenarios.TestScenarioRunDTO;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.scheduler.scenarios.postactions.PostScenarioActionsHandler;
import com.dataiku.dip.scheduler.scenarios.testing.JunitXmlReport;
import com.dataiku.dip.scheduler.scenarios.testing.TestScenarioRunHTMLReportGenerator;
import com.dataiku.dip.scheduler.scenarios.testing.TestScenarioRunReportGenerator;
import com.dataiku.dip.scheduler.steps.BuildFlowItemStepRunner;
import com.dataiku.dip.scheduler.steps.CheckDatasetStepRunner;
import com.dataiku.dip.scheduler.steps.ClearItemsStepRunner;
import com.dataiku.dip.scheduler.steps.ComputeMetricsStepRunner;
import com.dataiku.dip.scheduler.steps.FinallyStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.FlowTestStepRunner;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.RefreshChartCacheStepRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.steps.SynchronizeHiveStepRunner;
import com.dataiku.dip.scheduler.steps.UpdateDatasetFromHiveStepRunner;
import com.dataiku.dip.scheduler.steps.WebappTestStepRunner;
import com.dataiku.dip.scheduler.triggers.DeletedPythonPluginTriggerMeta;
import com.dataiku.dip.scheduler.triggers.TemporalTriggerRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.DiagConfigRedactionUtils;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.server.notifications.backend.DashboardsReloadNeeded;
import com.dataiku.dip.server.notifications.backend.ScenarioStateChangeEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosBaseService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScenariosService {
    private ScenariosDAO dao;
    private DatasetsDAO datasetsDAO;
    private ClustersDAO clustersDAO;
    private PubSubService pubSub;
    private ScenariosTriggerService scenariosTriggerService;
    private ScenarioRunsService scenarioRunsService;
    private ScenarioRunContext scenarioRunContext;
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private FutureService futureService;
    private LicenseStatusService licenseStatusService;
    private LicenseEnforcementService licenseEnforcementService;
    private TaggingService taggingService;
    private ScenariosBaseService scenariosBaseService;
    private IPermissionsService permissionsService;
    private CodeEnvPermissionsService codeEnvPermissionsService;
    private ScenarioReportsService scenarioReportsService;
    private GeneralSettingsDAO generalSettingsDAO;
    private PasswordEncryptionService symetricCryptoService;
    private TransactionService transactionService;
    private ManagedFolderDAO managedFolderDAO;
    private CustomFieldsService customFieldsService;
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    private TaggableObjectsService taggableObjectsService;
    private PluginUsagesInspector pluginUsagesInspector;
    private FlowExecutionService2 flowExecutionService;
    private PostScenarioActionsHandler postScenarioActionsHandler;
    private UserAuthenticationService userAuthenticationService;
    private GeneralSettingsDAO gsDAO;
    private AutomationBundlesService automationBundleService;
    public static final String DEFAULT_CODE = "# This sample code helps you get started with the custom scenario API.\n#For more details and samples, please see our Documentation\nfrom dataiku.scenario import Scenario\n\n# The Scenario object is the main handle from which you initiate steps\nscenario = Scenario()\n\n# A few example steps follow\n\n# Building a dataset\nscenario.build_dataset(\"customers_prepared\", partitions=\"2015-01-03\")\n\n# Controlling the train of a dataset\ntrain_ret = scenario.train_model(\"uSEkldfsm\")\ntrained_model = train_ret.get_trained_model()\nperformance = trained_model.get_new_version_metrics().get_performance_values()\nif performance[\"AUC\"] > 0.85:\n    trained_model.activate_new_version()\n\n# Sending custom reports\nsender = scenario.get_message_sender(\"mail-scenario\", \"local-mail\") # A messaging channel\nsender.set_params(sender=\"dss@company.com\", recipient=\"data-scientists@company.com\")\n\nsender.send(subject=\"The scenario is doing well\", message=\"All is good\")\n";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenarios.service");

    @Autowired
    public ScenariosService(ScenariosDAO dao, DatasetsDAO datasetsDAO, ClustersDAO clustersDAO, PubSubService pubSub, ScenariosTriggerService scenariosTriggerService, ScenarioRunsService scenarioRunsService, ScenarioRunContext scenarioRunContext, ReadWriteJobsInternalDB jobsDatabaseService, FutureService futureService, LicenseStatusService licenseStatusService, LicenseEnforcementService licenseEnforcementService, TaggingService taggingService, ScenariosBaseService scenariosBaseService, IPermissionsService permissionsService, CodeEnvPermissionsService codeEnvPermissionsService, ScenarioReportsService scenarioReportsService, GeneralSettingsDAO generalSettingsDAO, PasswordEncryptionService symetricCryptoService, TransactionService transactionService, ManagedFolderDAO managedFolderDAO, CustomFieldsService customFieldsService, CustomPolicyHooksRegistry customPolicyHooksRegistry, TaggableObjectsService taggableObjectsService, PluginUsagesInspector pluginUsagesInspector, FlowExecutionService2 flowExecutionService, PostScenarioActionsHandler postScenarioActionsHandler, UserAuthenticationService userAuthenticationService, GeneralSettingsDAO gsDAO, AutomationBundlesService automationBundleService) {
        this.dao = dao;
        this.datasetsDAO = datasetsDAO;
        this.clustersDAO = clustersDAO;
        this.pubSub = pubSub;
        this.scenariosTriggerService = scenariosTriggerService;
        this.scenarioRunsService = scenarioRunsService;
        this.scenarioRunContext = scenarioRunContext;
        this.jobsDatabaseService = jobsDatabaseService;
        this.futureService = futureService;
        this.licenseStatusService = licenseStatusService;
        this.licenseEnforcementService = licenseEnforcementService;
        this.taggingService = taggingService;
        this.scenariosBaseService = scenariosBaseService;
        this.permissionsService = permissionsService;
        this.codeEnvPermissionsService = codeEnvPermissionsService;
        this.scenarioReportsService = scenarioReportsService;
        this.generalSettingsDAO = generalSettingsDAO;
        this.symetricCryptoService = symetricCryptoService;
        this.transactionService = transactionService;
        this.managedFolderDAO = managedFolderDAO;
        this.customFieldsService = customFieldsService;
        this.customPolicyHooksRegistry = customPolicyHooksRegistry;
        this.taggableObjectsService = taggableObjectsService;
        this.pluginUsagesInspector = pluginUsagesInspector;
        this.flowExecutionService = flowExecutionService;
        this.postScenarioActionsHandler = postScenarioActionsHandler;
        this.userAuthenticationService = userAuthenticationService;
        this.gsDAO = gsDAO;
        this.automationBundleService = automationBundleService;
    }

    public ScenariosService() {
    }

    public List<Scenario> list(String projectKey) throws IOException {
        return this.dao.list(projectKey);
    }

    public List<Scenario> listUnsafe(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public List<Scenario> list(String projectKey, boolean unsafe) throws IOException {
        return unsafe ? this.listUnsafe(projectKey) : this.list(projectKey);
    }

    public Scenario getOrNull(String projectKey, String scenarioId) throws IOException {
        return (Scenario)this.dao.getOrNull(projectKey, scenarioId);
    }

    public Scenario getOrNullUnsafe(String projectKey, String scenarioId) throws IOException {
        return (Scenario)this.dao.getOrNullUnsafe(projectKey, scenarioId);
    }

    public Scenario getMandatory(String projectKey, String scenarioId) throws IOException {
        return (Scenario)this.dao.getMandatory(projectKey, scenarioId);
    }

    public Scenario getMandatoryUnsafe(String projectKey, String scenarioId) throws IOException {
        return (Scenario)this.dao.getMandatoryUnsafe(projectKey, scenarioId);
    }

    public String getPayload(String projectKey, String scenarioId, String extension) throws IOException {
        return this.dao.getPayload(projectKey, scenarioId, extension);
    }

    public void savePayload(String projectKey, String scenarioId, String extension, String scriptData) throws IOException {
        this.dao.savePayload(projectKey, scenarioId, extension, scriptData);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public List<Scenario> listForSource(String projectKey, String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId) throws IOException {
        return this.listForSource(projectKey, sourceProjectKey, sourceType, sourceId, false);
    }

    public List<Scenario> listForSource(String projectKey, String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId, boolean unsafe) throws IOException {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        if (FlowComputable.FCType.isFlowComputable(sourceType)) {
            for (Scenario scenario : this.list(projectKey, unsafe)) {
                if (!this.usesSource(scenario, sourceProjectKey, sourceType, sourceId)) continue;
                scenarios.add(scenario);
            }
        } else {
            logger.info((Object)("Cannot list related scenarios for taggable type: " + String.valueOf((Object)sourceType)));
        }
        return scenarios;
    }

    public boolean usesSource(Scenario scenario, String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId) {
        if (!FlowComputable.FCType.isFlowComputable(sourceType) || !scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
            return false;
        }
        StepBasedScenarioRunner.StepBasedScenarioParams scenarioParams = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
        String sourceSmartName = new AnyLoc(sourceProjectKey, sourceId).getSmartName(scenario.getProjectKey());
        for (Step step2 : scenarioParams.steps) {
            if (!(step2.params instanceof FlowTestStepRunner.FlowTestStepParams)) continue;
            FlowTestStepRunner.FlowTestStepParams stepParams2 = step2.getParamsAs(FlowTestStepRunner.FlowTestStepParams.class);
            for (FlowItemsToSwap swap : stepParams2.getSwaps()) {
                if (!Objects.equals(swap.sourceSmartName, sourceSmartName) && !Objects.equals(swap.targetSmartName, sourceSmartName)) continue;
                return true;
            }
            for (FlowItemsToCompare compare : stepParams2.getCompares()) {
                if (!Objects.equals(compare.expectedSmartName, sourceSmartName) && !Objects.equals(compare.resultSmartName, sourceSmartName)) continue;
                return true;
            }
        }
        return scenarioParams.getSteps().stream().filter(step -> step.params instanceof StepParamsWithComputables).map(step -> (StepParamsWithComputables)((Object)step.getParams())).flatMap(stepParams -> stepParams.getComputablesSpec().stream()).anyMatch(item -> item.type.equals((Object)FlowComputable.FCType.fromTaggableType(sourceType)) && item.itemId.equals(sourceId) && sourceProjectKey.equals(!StringUtils.isBlank((String)item.projectKey) ? item.projectKey : scenario.projectKey));
    }

    public void deleteStepsForSource(String sourceProjectKey, ITaggingService.TaggableType sourceType, String sourceId) throws Exception {
        if (sourceType == ITaggingService.TaggableType.DATASET) {
            for (Scenario scenario : this.list(sourceProjectKey)) {
                boolean dirty = false;
                if (scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
                    StepBasedScenarioRunner.StepBasedScenarioParams params = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
                    for (Step step : params.getSteps()) {
                        if (!step.getType().equals(BuildFlowItemStepRunner.META.getType())) continue;
                        BuildFlowItemStepRunner.BuildFlowItemStepParams stepParams = (BuildFlowItemStepRunner.BuildFlowItemStepParams)step.getParams();
                        Iterator itemIterator = stepParams.builds.iterator();
                        while (itemIterator.hasNext()) {
                            FlowComputableSpecification itemSpecification = (FlowComputableSpecification)itemIterator.next();
                            if (!itemSpecification.type.equals((Object)FlowComputable.FCType.DATASET) || !itemSpecification.itemId.equals(sourceId)) continue;
                            itemIterator.remove();
                            dirty = true;
                        }
                    }
                }
                if (!dirty) continue;
                this.save(scenario.projectKey, scenario);
            }
        } else {
            throw new NotImplementedException("No source listing logic for " + String.valueOf((Object)sourceType));
        }
    }

    public Scenario create(String projectKey, Scenario scenario) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Preconditions.checkNotNull((Object)scenario.getParams(), (Object)"Null params");
        if (scenario.getType() == null) {
            throw new IllegalArgumentException("Scenario has no type");
        }
        if (StringUtils.isBlank((String)scenario.getId())) {
            if (StringUtils.isBlank((String)scenario.getName())) {
                scenario = scenario.withId(SecretKeyGenerator.generate((int)8));
            } else {
                String slug = scenario.getName().replaceAll("[^A-z0-9\\-_\\.]", "_");
                StringTransmogrifier transmogrifier = new StringTransmogrifier();
                for (Scenario existing : this.list(projectKey)) {
                    transmogrifier.addAlreadyTransmogrified(existing.getId());
                }
                String transmogrified = transmogrifier.transmogrify(slug);
                scenario = scenario.withId(transmogrified);
            }
        }
        for (Scenario existing : this.list(projectKey)) {
            if (!existing.getId().equals(scenario.getId())) continue;
            throw new IllegalArgumentException("Scenario id '" + scenario.getId() + "' is not unique.");
        }
        logger.info((Object)("Creating a scenario nodeType=" + String.valueOf((Object)ApplicationConfigurator.getNodeType())));
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            logger.info((Object)"SET AL");
            scenario.automationLocal = true;
        }
        scenario.creationTag = new VersionTag(t.getUser().getIdentifier());
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(scenario);
        if (CustomPythonScenarioRunner.META.getType().equals(scenario.getType())) {
            this.savePayload(projectKey, scenario.getId(), "py", DEFAULT_CODE);
        }
        return this.save(projectKey, scenario, true);
    }

    public Scenario save(String projectKey, Scenario scenario) throws Exception {
        boolean bl;
        boolean advancedSteps;
        if (scenario.getType() == null) {
            throw new IllegalArgumentException("Scenario has no type");
        }
        LicenseStatusService.LicensingStatus licenseStatus = this.licenseStatusService.getLicensingStatus();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features = this.licenseEnforcementService.getFeaturesStatus();
        boolean bl2 = advancedSteps = features.advancedScenarioStepsAllowed || licenseStatus.ceEntrepriseTrial;
        if (!advancedSteps) {
            if (CustomPythonScenarioRunner.META.getType().equals(scenario.getType())) {
                throw new LicenseRestrictionException("Python scenarios are not available in your license");
            }
            StepBasedScenarioRunner.StepBasedScenarioParams sbsp = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            if (sbsp != null && sbsp.steps != null) {
                for (Step step : sbsp.steps) {
                    if (BuildFlowItemStepRunner.META.getType().equals(step.type)) continue;
                    throw new LicenseRestrictionException("Scenario steps of type " + step.type + " are not available in your license");
                }
            }
        }
        boolean temporalTrigger = features.temporalTriggerAllowed || licenseStatus.ceEntrepriseTrial;
        boolean otherTriggers = features.allScenarioTriggersAllowed || licenseStatus.ceEntrepriseTrial;
        for (Trigger t : scenario.getTriggers()) {
            if (TemporalTriggerRunner.META.getType().equals(t.getType()) && !temporalTrigger) {
                throw new LicenseRestrictionException("Triggers of type " + t.getType() + " are not available in your license");
            }
            if (TemporalTriggerRunner.META.getType().equals(t.getType()) || otherTriggers) continue;
            throw new LicenseRestrictionException("Triggers of type " + t.getType() + " are not available in your license");
        }
        boolean bl3 = bl = features.allScenarioReportersAllowed || licenseStatus.ceEntrepriseTrial;
        if (!bl && scenario.getReporters().size() > 0) {
            throw new LicenseRestrictionException("Reporters are not available in your license");
        }
        return this.save(projectKey, scenario, false);
    }

    public Scenario duplicate(String projectKeyFrom, String idFrom, String projectKeyTo, String idTo, String nameTo) throws Exception {
        Scenario scenario = (Scenario)JSON.deepCopy((Object)this.getMandatoryUnsafe(projectKeyFrom, idFrom));
        scenario.withProjectKey(projectKeyTo).withName(nameTo).withId(idTo);
        for (Trigger trigger : scenario.getTriggers()) {
            trigger.active = false;
        }
        this.create(projectKeyTo, scenario);
        String scriptData = this.getPayload(projectKeyFrom, idFrom, "py");
        if (scriptData != null) {
            this.savePayload(projectKeyTo, scenario.id, "py", scriptData);
        }
        return scenario;
    }

    public Scenario saveNoParams(String projectKey, Scenario scenario, List<String> fieldsToSave) throws Exception {
        Preconditions.checkArgument((fieldsToSave != null && !fieldsToSave.isEmpty() ? 1 : 0) != 0, (Object)"Missing fields to save");
        Scenario oldScenario = this.getMandatory(projectKey, scenario.getId());
        Iterator<String> iterator = fieldsToSave.iterator();
        block16: while (iterator.hasNext()) {
            String fieldName;
            switch (fieldName = iterator.next()) {
                case "active": {
                    oldScenario.withActive(scenario.isActive());
                    continue block16;
                }
                case "checklists": {
                    oldScenario.withChecklists(scenario.getChecklists());
                    continue block16;
                }
                case "description": {
                    oldScenario.withDescription(scenario.getDescription());
                    continue block16;
                }
                case "shortDesc": {
                    oldScenario.withDescription(scenario.getShortDesc());
                    continue block16;
                }
                case "tags": {
                    oldScenario.withTags(scenario.getTags());
                    continue block16;
                }
                case "customFields": {
                    oldScenario.withCustomFields(scenario.getCustomFields());
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Field " + fieldName + " cannot be updated with saveNoParams");
        }
        return this.save(projectKey, oldScenario, false);
    }

    public Scenario saveReporterState(String projectKey, String scenarioId, Scenario.ReporterDigestItem reporter) throws Exception {
        if (reporter.id.isEmpty()) {
            throw new IllegalArgumentException("Reporter ID cannot be null");
        }
        Scenario oldScenario = this.getMandatory(projectKey, scenarioId);
        if (reporter.reporterType.equals(Scenario.ReporterType.REPORTER.toString())) {
            ScenarioReporter oldReporter = this.getNonNullReporter(oldScenario, reporter.id);
            oldReporter.withActive(reporter.active);
        } else if (reporter.reporterType.equals(Scenario.ReporterType.STEP.toString())) {
            Step stepReporter = this.getNonNullStep(oldScenario, reporter.id);
            if (reporter.active) {
                stepReporter.enableRun();
            } else {
                stepReporter.disableRun();
            }
        } else {
            throw new IllegalArgumentException("Unknown reporter type " + reporter.reporterType);
        }
        return this.save(projectKey, oldScenario, false);
    }

    public Scenario deleteReporter(String projectKey, String scenarioId, Scenario.ReporterDigestItem reporter) throws Exception {
        if (reporter.id.isEmpty()) {
            throw new IllegalArgumentException("Reporter ID cannot be null");
        }
        Scenario oldScenario = this.getMandatory(projectKey, scenarioId);
        if (reporter.reporterType.equals(Scenario.ReporterType.REPORTER.toString())) {
            ScenarioReporter oldReporter = this.getNonNullReporter(oldScenario, reporter.id);
            oldScenario.reporters.remove(oldReporter);
        } else if (reporter.reporterType.equals(Scenario.ReporterType.STEP.toString())) {
            Step stepReporter = this.getNonNullStep(oldScenario, reporter.id);
            StepBasedScenarioRunner.StepBasedScenarioParams stepParams = oldScenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            stepParams.steps.remove(stepReporter);
        } else {
            throw new IllegalArgumentException("Unknown reporter type " + reporter.reporterType);
        }
        return this.save(projectKey, oldScenario, false);
    }

    private ScenarioReporter getNonNullReporter(Scenario scenario, String reporterId) {
        ScenarioReporter oldReporter = scenario.getReporter(reporterId);
        if (oldReporter == null) {
            throw new IllegalArgumentException("Reporter not found with ID " + reporterId);
        }
        return oldReporter;
    }

    private Step getNonNullStep(Scenario scenario, String stepId) {
        Step stepReporter = scenario.getStep(stepId);
        if (stepReporter == null) {
            throw new IllegalArgumentException("Step not found with ID " + stepId);
        }
        return stepReporter;
    }

    protected Scenario save(String projectKey, Scenario scenario, boolean creation) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Scenario oldScenario;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (creation) {
            oldScenario = this.getOrNull(projectKey, scenario.getId());
            if (oldScenario != null) {
                throw new IllegalArgumentException("Scenario already exists:" + scenario.getFullId());
            }
        } else {
            oldScenario = this.getMandatory(projectKey, scenario.getId());
        }
        this.checkTestWebAppRunAsUser(scenario, t, oldScenario);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(scenario, oldScenario);
        if (!(StringUtils.isBlank((String)scenario.getRunAsUser()) || oldScenario != null && scenario.getRunAsUser().equals(oldScenario.getRunAsUser()) || t.getUser().getIdentifier().equals(scenario.getRunAsUser()) || this.permissionsService.isAdmin(t.getUser()))) {
            throw new SecurityException("Only an administrator may set the 'Run as user' to another user");
        }
        scenario = ScenarioRegistry.getMeta(scenario).prepareForSave(scenario);
        ScenarioRegistry.getMeta(scenario).checkSaveSecurity(scenario, oldScenario, this.codeEnvPermissionsService, t.getUser());
        for (Trigger trigger : scenario.getTriggers()) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(scenario.getProjectKey(), TriggerRegistry.getMeta(trigger.getType()), trigger.getParams(), null, t.getUser());
        }
        for (ScenarioReporter reporter : scenario.getReporters()) {
            if (!StringUtils.isNotBlank((String)reporter.variablesCode)) continue;
            t.getUser().failIfNoUnsafeCode("save reporter custom variable code");
        }
        for (Trigger trigger : scenario.getTriggers()) {
            if (trigger.getId() == null || trigger.getId().length() == 0) {
                trigger.withId(SecretKeyGenerator.generate((int)8));
            }
            trigger.notifyUpdate();
        }
        for (ScenarioReporter reporter : scenario.getReporters()) {
            IntegrationHook hook;
            if (reporter.getId() == null || reporter.getId().length() == 0) {
                reporter.withId(SecretKeyGenerator.generate((int)8));
            }
            if ((hook = reporter.getMessaging()) == null) continue;
            IntegrationHooksRegistry.getMeta(hook).prepareForSave(hook, this.symetricCryptoService, this.generalSettingsDAO.getUnsafe().security);
        }
        this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(scenario.getProjectKey(), scenario.getId()), scenario);
        this.dao.save(projectKey, scenario.getId(), scenario);
        this.taggingService.onObjectSaved(scenario.projectKey, scenario.tags);
        JsonObject details = new JsonObject();
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.SCENARIO_CREATE;
        } else if (oldScenario != null && !StringUtils.equals((String)oldScenario.name, (String)scenario.name)) {
            details.addProperty("oldName", oldScenario.name);
            details.addProperty("newName", scenario.name);
            action = TaggableObjectChangedEvent.ActionType.SCENARIO_RENAME;
        } else {
            action = TaggableObjectChangedEvent.ActionType.SCENARIO_EDIT;
            TaggableObjectDiffService.addTagEditInfoIfNeeded(oldScenario, scenario, details);
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SCENARIO, projectKey, scenario.getId(), t.getUser(), action).withDetails(details));
        try {
            this.scenarioReportsService.invalidateCachedReports(scenario);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to invalidate scenario reports", (Throwable)e);
        }
        return scenario;
    }

    private void checkTestWebAppRunAsUser(@Nonnull Scenario scenario, RWTransactionRef t, @Nullable Scenario oldScenario) {
        if (!this.permissionsService.isAdmin(t.getUser())) {
            HashMap<String, WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams> newScenarioQRTP = new HashMap<String, WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams>();
            HashMap<String, WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams> oldScenarioQRTP = new HashMap<String, WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams>();
            if (StepBasedScenarioRunner.META.getType().equals(scenario.getType())) {
                WebappTestStepRunner.WebappTestStepParams webappTestStepParams;
                StepBasedScenarioRunner.StepBasedScenarioParams sbsp = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
                if (sbsp != null && sbsp.steps != null) {
                    for (Step step : sbsp.steps) {
                        if (!WebappTestStepRunner.META.getType().equals(step.getType())) continue;
                        webappTestStepParams = step.getParamsAs(WebappTestStepRunner.WebappTestStepParams.class);
                        for (WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams curQrtParams : webappTestStepParams.queryResponseTestParams) {
                            newScenarioQRTP.put(curQrtParams.id, curQrtParams);
                        }
                    }
                }
                if (oldScenario != null && (sbsp = oldScenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class)) != null && sbsp.steps != null) {
                    for (Step step : sbsp.steps) {
                        if (!WebappTestStepRunner.META.getType().equals(step.getType())) continue;
                        webappTestStepParams = step.getParamsAs(WebappTestStepRunner.WebappTestStepParams.class);
                        for (WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams curQrtParams : webappTestStepParams.queryResponseTestParams) {
                            oldScenarioQRTP.put(curQrtParams.id, curQrtParams);
                        }
                    }
                }
            }
            for (Map.Entry curQRTP : newScenarioQRTP.entrySet()) {
                if (!StringUtils.isNotBlank((String)((WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams)curQRTP.getValue()).requestUser) || oldScenarioQRTP.containsKey(curQRTP.getKey()) && StringUtils.equals((String)((WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams)oldScenarioQRTP.get(curQRTP.getKey())).requestUser, (String)((WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams)curQRTP.getValue()).requestUser)) continue;
                throw new SecurityException(String.format("Only an administrator may set the 'Run as user' of a Test Webapp Query/Response test '%s' to another user", ((WebappTestStepRunner.WebappTestStepParams.QueryReponseTestParams)curQRTP.getValue()).label));
            }
        }
    }

    public void delete(String projectKey, String id) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            Scenario sc = (Scenario)this.dao.getOrNull(projectKey, id);
            this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), sc);
            if (sc != null) {
                details.addProperty("objectDisplayName", sc.name);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)"Error when getting Scenario", (Throwable)e);
        }
        this.dao.delete(projectKey, id);
        this.dao.deletePayload(projectKey, id, "py");
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SCENARIO, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.SCENARIO_DELETE).withDetails(details));
    }

    public FutureResponse<ReportItem> startScenarioRun(Scenario scenario, TriggerFire triggerFire, JsonObject initialVariables, DSSAuthCtx propagatedRunAsUser) throws Exception {
        BuildUtils.JobLocalConfigSnapshot snapshot;
        DSSAuthCtx liu;
        if (propagatedRunAsUser != null) {
            liu = propagatedRunAsUser;
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                liu = this.scenariosBaseService.getRunAsUser(scenario);
            }
        }
        liu = this.syncUserBeforeRunningScenario(liu);
        long startTimestamp = DateTime.now().getMillis();
        ScenarioRun scenarioRun = (ScenarioRun)new ScenarioRun().withTrigger(triggerFire).withStart(startTimestamp).withScenario(scenario);
        if (initialVariables != null) {
            scenarioRun.withVariables((JsonObject)JSON.deepCopy((Object)initialVariables));
        }
        HashSet<String> identifiers = new HashSet<String>(Collections.singletonList(liu.getIdentifier()));
        DSSAuthCtx initialAuthCtxWithVia = (DSSAuthCtx)((Object)JSON.deepCopy((Object)((Object)liu)));
        if (triggerFire.triggerAuthCtx != null) {
            identifiers.add(triggerFire.triggerAuthCtx.getIdentifier());
            initialAuthCtxWithVia.addParent(triggerFire.triggerAuthCtx);
        }
        scenarioRun.withRunAsUser(initialAuthCtxWithVia);
        scenarioRun.withMarkedAsTest(scenarioRun.getScenario().isMarkedAsTest());
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            scenarioRun.withBundleId(CommonBundleUtils.getActiveBundleId(scenarioRun.getScenario().getProjectKey()));
        }
        this.jobsDatabaseService.registerScenarioRun(scenarioRun);
        DSSAuthCtx authCtxWithVia = (DSSAuthCtx)((Object)JSON.deepCopy((Object)((Object)initialAuthCtxWithVia)));
        authCtxWithVia.addVia("scenario-run: scenario=" + scenario.projectKey + "." + scenario.id + " runId=" + scenarioRun.runId);
        scenarioRun.withRunAsUser(authCtxWithVia);
        try (Transaction t = this.transactionService.beginRead();){
            snapshot = BuildUtils.copyJobLocalConfig(liu, scenario.getProjectKey(), ScenarioRunContext.scenarioRunFolder(scenarioRun), scenario.id);
        }
        snapshot.copyConfigOnDisk();
        ScenarioThread scenarioThread = new ScenarioThread(scenario, scenarioRun, this, this.scenarioRunContext);
        this.scenarioRunsService.onScenarioRunStart(scenarioThread);
        if (triggerFire.getParams() == null || !triggerFire.getParams().has("fromJob")) {
            this.pubSub.publish(new ScenarioStateChangeEvent(scenario.getProjectKey(), scenario.getId(), scenarioRun.runId, ScenarioStateChangeEvent.State.RUNNING, identifiers, scenario.getName()));
        }
        return this.futureService.runFuture(scenarioThread, 0L, new TypeToken<FutureResponse<ReportItem>>(){});
    }

    private DSSAuthCtx syncUserBeforeRunningScenario(DSSAuthCtx liu) throws IOException, DKUSecurityException, CodedException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (gs.scenarioSecuritySettings.syncUserOnScenarioRun) {
            logger.info((Object)("Syncing user '" + liu.getAssociatedDSSUser() + "' before running scenario"));
            boolean isSynced = false;
            try {
                this.userAuthenticationService.syncUserBeforeAction(liu.getAssociatedDSSUser());
                isSynced = true;
            }
            catch (Exception e) {
                switch (gs.scenarioSecuritySettings.userSyncFailureAction) {
                    case WARN: {
                        logger.warnV((Throwable)e, "Failed to sync user '%s', running scenario nonetheless", new Object[]{liu.getAssociatedDSSUser()});
                        break;
                    }
                    case ABORT: {
                        logger.errorV((Throwable)e, "Failed to sync user '%s', aborting scenario run", new Object[]{liu.getAssociatedDSSUser()});
                        throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_SUPPLIER_SYNC_FAILED, "Failed to sync user '" + liu.getAssociatedDSSUser() + "', aborting scenario run", (Throwable)e);
                    }
                }
            }
            if (isSynced) {
                return liu.refresh();
            }
        }
        return liu;
    }

    public void endScenarioRun(ScenarioRun scenarioRun) throws Exception {
        long endTimestamp = DateTime.now().getMillis();
        this.jobsDatabaseService.updateScenarioRun(scenarioRun.withEnd(endTimestamp));
        this.scenarioRunsService.onScenarioRunCompleteGetQueuedTriggers(scenarioRun);
        ScenarioStateChangeEvent.State eventState = ScenarioStateChangeEvent.State.DONE;
        if (scenarioRun.getResult().getOutcome() == ReportItem.Outcome.FAILED) {
            eventState = ScenarioStateChangeEvent.State.FAILED;
        } else if (scenarioRun.getResult().getOutcome() == ReportItem.Outcome.ABORTED) {
            eventState = ScenarioStateChangeEvent.State.ABORTED;
        } else if (scenarioRun.getResult().getOutcome() == ReportItem.Outcome.WARNING) {
            eventState = ScenarioStateChangeEvent.State.DONE_WITH_WARNING;
        }
        Scenario scenario = scenarioRun.getScenario();
        if (scenarioRun.getTrigger() == null || scenarioRun.getTrigger().getParams() == null || !scenarioRun.getTrigger().getParams().has("fromJob")) {
            HashSet<String> initiators = new HashSet<String>(Collections.singletonList(scenarioRun.runAsUser.getIdentifier()));
            if (scenarioRun.getTrigger() != null && scenarioRun.getTrigger().triggerAuthCtx != null) {
                initiators.add(scenarioRun.getTrigger().triggerAuthCtx.getIdentifier());
            }
            ScenarioParams params = scenario.getParams();
            HashMap<String, Object> extraData = ScenariosService.getExtraData(params, scenario);
            this.pubSub.publish(new ScenarioStateChangeEvent(scenario.getProjectKey(), scenario.getId(), scenarioRun.runId, eventState, initiators, scenario.getName(), extraData));
        }
    }

    private static HashMap<String, Object> getExtraData(ScenarioParams params, Scenario scenario) {
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        if (params instanceof StepBasedScenarioRunner.StepBasedScenarioParams) {
            for (Step step : ((StepBasedScenarioRunner.StepBasedScenarioParams)params).getSteps()) {
                if (!Objects.equals(step.type, RefreshChartCacheStepRunner.META.getType())) continue;
                List dashboards = step.getParamsAs(RefreshChartCacheStepRunner.RefreshChartCacheStepParams.class).dashboards.stream().map(dashboardItem -> new AnyLoc(scenario.getProjectKey(), dashboardItem.smartName)).collect(Collectors.toList());
                DashboardsReloadNeeded.DashboardsReloadNeededParams value = (DashboardsReloadNeeded.DashboardsReloadNeededParams)extraData.getOrDefault("dashboards-reload-needed", new DashboardsReloadNeeded.DashboardsReloadNeededParams(new HashSet<AnyLoc>()));
                value.dashboards.addAll(dashboards);
                extraData.putIfAbsent("dashboards-reload-needed", value);
            }
        }
        return extraData;
    }

    public void runScenarioRunPostTriggerActions(ScenarioRun scenarioRun, String threadId) throws Exception {
        this.scenariosTriggerService.markRunAsDone(scenarioRun.getScenario(), threadId);
        this.scenariosTriggerService.fireDelayedTriggers(scenarioRun.getScenario());
    }

    public void runScenarioRunPostActions(ScenarioRun scenarioRun) {
        this.postScenarioActionsHandler.onEndOfScenario(scenarioRun);
    }

    public void cleanupScenarioRun(ScenarioRun scenarioRun) throws Exception {
        FinallyStepRunner.FinallyStepParams params = new FinallyStepRunner.FinallyStepParams();
        DSSAuthCtx authCtx = scenarioRun.getRunAsUser();
        try (Transaction t = this.transactionService.beginRead();){
            for (Cluster cluster : this.clustersDAO.listUnsafe()) {
                if (cluster.origin == null || cluster.origin.type != Cluster.ClusterOriginType.SCENARIO || !StringUtils.equals((String)scenarioRun.getRunId(), (String)cluster.origin.scenarioRunId) || !StringUtils.equals((String)scenarioRun.getScenario().getId(), (String)cluster.origin.scenarioId) || !StringUtils.equals((String)scenarioRun.getScenario().getProjectKey(), (String)cluster.origin.scenarioProjectKey)) continue;
                if (!cluster.origin.ownedByScenario) {
                    logger.info((Object)("Cluster " + cluster.id + " was started by the scenario but was set to survive the scenario run. Not tearing down"));
                    continue;
                }
                if (this.permissionsService.hasClusterPrivilege(authCtx, cluster.id, Privileges.ClusterLevelPrivilegeType.UPDATE)) {
                    params.clusterIds.add(cluster.id);
                    continue;
                }
                logger.warn((Object)("Unexpected situation : cluster " + cluster.id + " was started by the scenario, but the user cannot update it (its settings may have been modified during the scenario run)"));
            }
        }
        if (params.clusterIds.isEmpty()) {
            return;
        }
        logger.info((Object)("Cleanuping " + params.clusterIds.size() + " clusters"));
        Step step = new Step().withType(FinallyStepRunner.META.getType()).withId("finally").withName("Cleanup").withDescription("Automatic cleanup of resources allocated by the scenario");
        step.withParams(params);
        this.runStep(scenarioRun.getScenario(), scenarioRun, step);
    }

    private StepRun startStepRun(ScenarioRun scenarioRun, Step step) throws SQLException {
        long startTimestamp = DateTime.now().getMillis();
        StepRun stepRun = new StepRun().withScenarioRun(scenarioRun).withStep(step).withStart(startTimestamp);
        this.jobsDatabaseService.registerStepRun(stepRun);
        return stepRun;
    }

    public StepRun runStep(Scenario scenario, ScenarioRun scenarioRun, Step step) throws SQLException {
        return this.runStep(scenario, scenarioRun, step, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepRun runStep(Scenario scenario, ScenarioRun scenarioRun, Step step, int remainingStepRetries) throws SQLException {
        StepRun stepRun = this.startStepRun(scenarioRun, step);
        ReportTargetItem.ScenarioStepItem stepItemTarget = new ReportTargetItem.ScenarioStepItem(stepRun);
        ReportItem.StepDone reportItem = new ReportItem.StepDone(stepItemTarget);
        long started = DateTime.now().getMillis();
        try {
            logger.info((Object)"Step run initiated");
            StepRunner stepRunner = StepRegistry.buildRunner(scenario, step);
            this.scenarioRunContext.setStepRun(stepRun);
            int retryIndex = step.getMaxRetriesOnFail() - remainingStepRetries;
            stepRun.withRetryIndex(retryIndex);
            if (retryIndex > 0) {
                logger.info((Object)("Retry #" + retryIndex));
            }
            stepRunner.run(stepRun, reportItem);
            if (reportItem.getOutcome() == null) {
                reportItem.withOutcome(this.computeStepOutcomeFromChildrenItems(stepRun));
            }
            if (remainingStepRetries <= 0 && step.getParams() instanceof NonFatalStepParams && reportItem.getOutcome() == ReportItem.Outcome.FAILED && ((NonFatalStepParams)((Object)step.getParams())).shouldProceedOnFailure()) {
                if (retryIndex > 0) {
                    logger.warnV("The step failed its %d allowed attempts, but was marked as non-fatal for the scenario. Continuing run", new Object[]{retryIndex + 1});
                } else {
                    logger.warn((Object)"The step failed, but was marked as non-fatal for the scenario. Continuing run");
                }
                reportItem.withOutcome(ReportItem.Outcome.WARNING);
            }
            FutureProgressState.checkInterrupt();
            logger.info((Object)"Step run finished without exception");
            if (remainingStepRetries > 0 && reportItem.getOutcome() == ReportItem.Outcome.FAILED) {
                logger.info((Object)("Will retry the step " + step.name));
            }
            reportItem.withStart(started).withEnd(DateTime.now().getMillis());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Step run interrupted", (Throwable)ex);
            reportItem.withThrown(ex).withStart(started).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.ABORTED);
        }
        catch (Throwable ex) {
            logger.error((Object)"Step run hard failure", ex);
            reportItem.withThrown(ex).withStart(started).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
        }
        finally {
            stepRun.withResult(reportItem);
            stepRun.withEnd(reportItem.getEnd());
            this.scenarioRunContext.clearStepRun();
            this.jobsDatabaseService.updateStepRun(stepRun);
        }
        return stepRun;
    }

    public void dontRunStep(Scenario scenario, ScenarioRun scenarioRun, Step step, Exception e) throws SQLException {
        StepRun stepRun = this.startStepRun(scenarioRun, step);
        ReportTargetItem.ScenarioStepItem stepItemTarget = new ReportTargetItem.ScenarioStepItem(stepRun);
        ReportItem.StepDone reportItem = new ReportItem.StepDone(stepItemTarget);
        long started = DateTime.now().getMillis();
        reportItem.withThrown(e).withStart(started).withEnd(started).withOutcome(ReportItem.Outcome.WARNING);
        stepRun.withResult(reportItem).withEnd(started);
        this.jobsDatabaseService.updateStepRun(stepRun);
    }

    private ReportItem.Outcome computeStepOutcomeFromChildrenItems(StepRun stepRun) {
        ReportItem.Outcome outcome = ReportItem.Outcome.SUCCESS;
        HashMap counts = Maps.newHashMap();
        try {
            ScenarioRun scenarioRun = stepRun.getScenarioRun();
            Scenario scenario = scenarioRun.getScenario();
            for (ReportItem message : this.jobsDatabaseService.getStepRunMessages(scenario.getProjectKey(), scenario.getId(), scenarioRun.getRunId(), stepRun.getStep().getId(), stepRun.getRunId())) {
                int count = counts.containsKey((Object)message.getOutcome()) ? (Integer)counts.get((Object)message.getOutcome()) : 0;
                counts.put(message.getOutcome(), count + 1);
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to retrieve messages of step run", (Throwable)e);
        }
        if (counts.containsKey((Object)ReportItem.Outcome.FAILED)) {
            outcome = ReportItem.Outcome.FAILED;
        } else if (counts.containsKey((Object)ReportItem.Outcome.ABORTED)) {
            outcome = ReportItem.Outcome.ABORTED;
        } else if (counts.containsKey((Object)ReportItem.Outcome.WARNING)) {
            outcome = ReportItem.Outcome.WARNING;
        }
        return outcome;
    }

    public List<ScenarioRun> getLastRuns(String projectKey, String scenarioId, int limit, boolean onlyFinishedRuns) throws SQLException, IOException {
        Scenario scenario = (Scenario)this.dao.getMandatoryUnsafe(projectKey, scenarioId);
        return this.getLastRuns(scenario, limit, onlyFinishedRuns, true);
    }

    public List<ScenarioRun> getLastRuns(Scenario scenario, int limit, boolean onlyFinishedRuns, boolean withFullScenario) throws SQLException {
        return this.jobsDatabaseService.getLastRuns(scenario, limit, onlyFinishedRuns, withFullScenario);
    }

    public List<ScenarioRun> getRunsByDate(String projectKey, String scenarioId, DateTime fromDate, DateTime toDate) throws SQLException {
        return this.jobsDatabaseService.getRuns(projectKey, scenarioId, fromDate.getMillis(), toDate.getMillis(), false);
    }

    public List<StepRun> getStepRunsOfRun(ScenarioRunKey scenarioRun) throws SQLException {
        return this.getStepRunsOfRun(scenarioRun.getScenario().getProjectKey(), scenarioRun.getScenario().getId(), scenarioRun.getRunId());
    }

    private List<StepRun> getStepRunsOfRun(String projectKey, String scenarioId, String runId) throws SQLException {
        return this.jobsDatabaseService.getStepRuns(projectKey, scenarioId, runId);
    }

    private List<Scenario> getScenariosForProjectAndBundle(String projectKey, @Nullable String bundleId) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION && bundleId != null && !CommonBundleUtils.getActiveBundleId(projectKey).equals(bundleId)) {
                this.automationBundleService.listImported((String)projectKey).bundles.stream().filter(b -> StringUtils.equals((String)b.bundleId, (String)bundleId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find the bundle %s for project %s", bundleId, projectKey)));
                List<Scenario> list = CommonBundleUtils.getScenariosFromArchive(this.automationBundleService.getBundleArchive(projectKey, bundleId));
                return list;
            }
            List<Scenario> list = this.list(projectKey);
            return list;
        }
    }

    public List<TestScenarioRunDTO> getTestScenarioRunDTOs(String projectKey, @Nullable String bundleId) throws SQLException, IOException {
        ArrayList<TestScenarioRunDTO> ret = new ArrayList<TestScenarioRunDTO>();
        List<Scenario> scenarios = this.getScenariosForProjectAndBundle(projectKey, bundleId);
        if (scenarios.isEmpty()) {
            return ret;
        }
        scenarios.removeIf(p -> !p.markedAsTest);
        for (Scenario scenario : scenarios) {
            ScenarioRun latestScenarioRun = this.jobsDatabaseService.getLatestTestCompletedRun(scenario, bundleId);
            TestScenarioRunDTO dto = latestScenarioRun == null ? new TestScenarioRunDTO(scenario.getId(), null, scenario.getName(), 0L, 0L, null, new ArrayList<TestScenarioRunDTO.StepRunDTO>()) : this.getScenarioRunDTO(latestScenarioRun);
            ret.add(dto);
        }
        return ret;
    }

    public TestingStatus getTestingStatus(String projectKey, @Nullable String bundleId) throws SQLException, IOException {
        List<TestScenarioRunDTO> scenarioRuns = this.getTestScenarioRunDTOs(projectKey, bundleId);
        long nbSuccess = scenarioRuns.stream().filter(scenarioRun -> ReportItem.Outcome.SUCCESS.equals((Object)scenarioRun.outcome)).count();
        long nbWarnings = scenarioRuns.stream().filter(scenarioRun -> ReportItem.Outcome.WARNING.equals((Object)scenarioRun.outcome)).count();
        long nbFailures = scenarioRuns.stream().filter(scenarioRun -> ReportItem.Outcome.FAILED.equals((Object)scenarioRun.outcome)).count();
        long nbAborted = scenarioRuns.stream().filter(scenarioRun -> ReportItem.Outcome.ABORTED.equals((Object)scenarioRun.outcome)).count();
        return new TestingStatus(nbSuccess, nbWarnings, nbFailures, nbAborted);
    }

    public TestingStatus runTestScenarios_NT(@Nonnull DSSAuthCtx authCtx, @Nonnull String projectKey) throws Exception {
        List<Scenario> testScenarios;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            testScenarios = this.list(projectKey).stream().filter(Scenario::isMarkedAsTest).toList();
        }
        int nSuccess = 0;
        int nWarning = 0;
        int nFailure = 0;
        int nAborted = 0;
        block13: for (Scenario scenario : testScenarios) {
            ReportItem.Outcome outcome;
            try {
                outcome = this.runBlocking(authCtx, scenario);
            }
            catch (Exception e) {
                logger.warnV("Failed to run test scenario %s: %s", new Object[]{scenario.getId(), e.getMessage()});
                outcome = ReportItem.Outcome.FAILED;
            }
            switch (outcome) {
                case SUCCESS: {
                    ++nSuccess;
                    continue block13;
                }
                case WARNING: {
                    ++nWarning;
                    continue block13;
                }
                case FAILED: {
                    ++nFailure;
                    continue block13;
                }
                case ABORTED: {
                    ++nAborted;
                    continue block13;
                }
            }
            throw ErrorContext.isef((String)"Invalid outcome: %", (Object)((Object)outcome), (Object[])new Object[0]);
        }
        return new TestingStatus(nSuccess, nWarning, nFailure, nAborted);
    }

    @VisibleForTesting
    ReportItem.Outcome runBlocking(DSSAuthCtx authCtx, Scenario scenario) throws Exception {
        TriggerFire triggerFire = this.scenariosTriggerService.manualRun(authCtx, scenario, "API run", new JsonObject());
        String threadId = this.scenariosTriggerService.getLastScenarioThreadId(scenario);
        if (threadId == null) {
            throw ErrorContext.isef((String)"Could not retrieve a thread ID for run %s of scenario %s", (Object)triggerFire.getRunId(), (Object[])new Object[]{scenario.getId()});
        }
        FutureResponse fr = this.futureService.waitForFinalResponse(threadId);
        if (!fr.hasResult) {
            throw ErrorContext.isef((String)"Running scenario %s yielded no result", (Object)scenario.getId(), (Object[])new Object[0]);
        }
        return ((ReportItem.ScenarioDone)fr.result).getOutcome();
    }

    public TestScenarioRunDTO getScenarioRunDTO(ScenarioRun scenarioRun) throws SQLException {
        List<StepRun> stepRuns = this.getStepRunsOfRun(scenarioRun.getScenario().getProjectKey(), scenarioRun.getScenario().getId(), scenarioRun.getRunId());
        ArrayList<TestScenarioRunDTO.StepRunDTO> stepRunDTOs = new ArrayList<TestScenarioRunDTO.StepRunDTO>();
        for (StepRun stepRun : stepRuns) {
            Step step = stepRun.getStep();
            if (stepRun.getResult() == null) continue;
            Optional<ReportItem.RanPythonUnitTest> ranPythonUnitTestItem = this.findRanPythonUnitTestItem(stepRun.getAdditionalReportItems());
            boolean wasTestReportGenerated = ranPythonUnitTestItem.isPresent() && !StringUtils.isEmpty((String)ranPythonUnitTestItem.get().getRunReport());
            stepRunDTOs.add(new TestScenarioRunDTO.StepRunDTO(step.getId(), stepRun.getRunId(), step.getType(), step.getName(), stepRun.getStart(), stepRun.getEnd(), stepRun.getResult().outcome, wasTestReportGenerated));
        }
        return new TestScenarioRunDTO(scenarioRun.getScenario().getId(), scenarioRun.getRunId(), scenarioRun.getScenario().getName(), scenarioRun.getStart(), scenarioRun.getEnd(), scenarioRun.getCurrentOutcome(), stepRunDTOs);
    }

    public void createTestScenarioRunsReportFileForBundle(String projectKey, String bundleId, File reportFile) throws IOException, SQLException {
        logger.infoV("Creating test scenario JUnitXML report for bundle %s in project %s", new Object[]{bundleId, projectKey});
        this.createTestScenarioRunsReportFile(projectKey, bundleId, reportFile);
    }

    public void createTestScenarioRunsReportFileForProject(String projectKey, File reportFile) throws IOException, SQLException {
        logger.infoV("Creating test scenario JUnitXML report for project %s", new Object[]{projectKey});
        this.createTestScenarioRunsReportFile(projectKey, null, reportFile);
    }

    public void createTestScenarioRunsHTMLReportFile(String projectKey, String bundleId, String nodeId, @Nullable String userName, File reportFile) throws IOException, SQLException, TemplateException {
        TestScenarioRunHTMLReportGenerator.Model model = new TestScenarioRunHTMLReportGenerator.Model().withScenarioRunsInfo(this.getTestScenarioRunDTOs(projectKey, bundleId)).withGenerationInfo(projectKey, userName).withInstanceInfo(nodeId);
        if (bundleId != null) {
            String activatedOn = null;
            String activatedBy = null;
            if (CommonBundleUtils.getActiveBundleId(projectKey).equals(bundleId)) {
                ActiveBundleState abs = CommonBundleUtils.getActiveBundleState(projectKey);
                activatedOn = abs.activatedOn;
                activatedBy = abs.activatedBy;
            }
            model = model.withBundleInfo(bundleId, activatedOn, activatedBy);
            logger.infoV("Creating test scenario HTML report for bundle %s in project %s", new Object[]{bundleId, projectKey});
        } else {
            logger.infoV("Creating test scenario HTML report for project %s", new Object[]{projectKey});
        }
        TestScenarioRunHTMLReportGenerator.buildHTMLReport(model, reportFile);
    }

    private void createTestScenarioRunsReportFile(String projectKey, @Nullable String bundleId, File reportFile) throws IOException, SQLException {
        List<Scenario> scenarios = this.getScenariosForProjectAndBundle(projectKey, bundleId);
        ArrayList tSuites = Lists.newArrayList();
        for (Scenario scenario : scenarios) {
            ScenarioRun lastCompletedTestRun = this.jobsDatabaseService.getLatestTestCompletedRun(scenario, bundleId);
            if (lastCompletedTestRun == null) continue;
            List<StepRun> stepRuns = this.getStepRunsOfRun(projectKey, scenario.getId(), lastCompletedTestRun.getRunId());
            tSuites.add(TestScenarioRunReportGenerator.buildScenarioRunTestSuite(lastCompletedTestRun, stepRuns));
        }
        JunitXmlReport.TestSuites testSuites = new JunitXmlReport.TestSuites(tSuites);
        TestScenarioRunReportGenerator.writeReportToFile(testSuites, reportFile);
    }

    public void createTestScenarioRunReportFile(ScenarioRun scenarioRun, List<StepRun> stepRuns, File reportFile) throws IOException {
        logger.infoV("Creating JUnitXML report file for scenario run %s of scenario %s", new Object[]{scenarioRun.getRunId(), scenarioRun.getScenario().getId()});
        JunitXmlReport.TestSuite testSuite = TestScenarioRunReportGenerator.buildScenarioRunTestSuite(scenarioRun, stepRuns);
        JunitXmlReport.TestSuites testSuites = new JunitXmlReport.TestSuites(List.of(testSuite));
        TestScenarioRunReportGenerator.writeReportToFile(testSuites, reportFile);
    }

    public Optional<ReportItem.RanPythonUnitTest> findRanPythonUnitTestItem(List<ReportItem> additionalReportItems) {
        return additionalReportItems.stream().filter(reportItem -> ReportItem.ReportItemType.RAN_PYTHON_UNIT_TEST.equals((Object)reportItem.getType())).map(reportItem -> (ReportItem.RanPythonUnitTest)reportItem).findFirst();
    }

    public ScenarioRunDetails getScenarioRunDetails(String projectKey, String scenarioId, String runId, boolean includeCallstacksAndLogs) throws SQLException {
        ScenarioRunDetails ret = new ScenarioRunDetails();
        try {
            ret.scenarioRun = (ScenarioRun)JSON.parseFile((File)ScenarioRunContext.getScenarioRunFile(projectKey, scenarioId, runId), ScenarioRun.class, (boolean)false);
            ret.scenarioRun.scenario.projectKey = projectKey;
            ret.scenarioRun.scenario.id = scenarioId;
        }
        catch (FileNotFoundException e) {
            logger.warnV("Failed to parse scenario run file: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to parse scenario run file", (Throwable)e);
        }
        ret.stepRuns = this.jobsDatabaseService.getStepRuns(projectKey, scenarioId, runId);
        if (!includeCallstacksAndLogs) {
            ScenariosService.redactLogsAndCallstacks(ret);
        }
        return ret;
    }

    public ScenarioRunDetails getScenarioRunStartedByTriggerFire(String projectKey, String scenarioId, String triggerId, String triggerRunId) throws SQLException {
        ScenarioRunDetails ret = new ScenarioRunDetails();
        ret.scenarioRun = this.jobsDatabaseService.getScenarioRunOfTriggerFire(projectKey, scenarioId, triggerId, triggerRunId);
        return ret;
    }

    public void fakeRun(DSSAuthCtx liu, String projectKey, String scenarioId, String dateStr, String outcomeStr) throws IOException, SQLException {
        long timestamp;
        Scenario scenario = (Scenario)this.dao.getMandatory(projectKey, scenarioId);
        DateTime date = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
        long scenarioStart = timestamp = date.getMillis();
        ReportItem.Outcome outcome = ReportItem.Outcome.valueOf(outcomeStr);
        Random random = new Random();
        Trigger trigger = scenario.getTriggers().size() > 0 ? scenario.getTriggers().get(random.nextInt(scenario.getTriggers().size())) : new Trigger().withId("manual").withType("manual").withName("fake manual run");
        TriggerFire triggerFire = new TriggerFire().withProjectKey(projectKey).withScenarioId(scenarioId).withTrigger(trigger).withTimestamp(scenarioStart);
        this.jobsDatabaseService.saveTriggerFire(triggerFire);
        ScenarioRun scenarioRun = (ScenarioRun)new ScenarioRun().withTrigger(triggerFire).withStart(scenarioStart).withRunAsUser(liu).withScenario(scenario);
        this.jobsDatabaseService.registerScenarioRun(scenarioRun);
        if (scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
            StepBasedScenarioRunner.StepBasedScenarioParams params = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            int countdown = outcome == ReportItem.Outcome.FAILED || outcome == ReportItem.Outcome.ABORTED ? random.nextInt(params.steps.size()) : params.steps.size();
            logger.info((Object)("fake run will do " + countdown + " steps out of " + params.steps.size()));
            for (Step step : params.getSteps()) {
                long stepStart = timestamp;
                StepRun stepRun = new StepRun().withScenarioRun(scenarioRun).withStep(step).withStart(stepStart);
                this.jobsDatabaseService.registerStepRun(stepRun);
                timestamp += 120000L;
                ReportItem.Outcome stepOutcome = outcome;
                if (stepOutcome == ReportItem.Outcome.FAILED || stepOutcome == ReportItem.Outcome.ABORTED) {
                    if (countdown > 0) {
                        stepOutcome = ReportItem.Outcome.SUCCESS;
                    }
                } else if (stepOutcome == ReportItem.Outcome.WARNING && Math.random() > 0.1) {
                    stepOutcome = ReportItem.Outcome.SUCCESS;
                }
                stepRun.withEnd(timestamp).withResult(new ReportItem.StepDone(new ReportTargetItem.ScenarioStepItem(stepRun)).withOutcome(stepOutcome).withStart(stepStart).withEnd(timestamp));
                this.jobsDatabaseService.updateStepRun(stepRun);
                if (countdown <= 0) break;
                --countdown;
            }
        }
        scenarioRun.withEnd(timestamp).withResult(new ReportItem.ScenarioDone(new ReportTargetItem.ScenarioItem(scenarioRun)).withOutcome(outcome).withStart(scenarioStart).withEnd(timestamp));
        this.jobsDatabaseService.updateScenarioRun(scenarioRun);
        JSON.prettyToFile((Object)scenarioRun, (File)ScenarioRunContext.getScenarioRunFile(scenarioRun));
    }

    private String getProjectKey(List<TaggableObjectsService.TaggableObjectRef> refs) throws IllegalArgumentException {
        String projectKey = null;
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            Preconditions.checkNotNull((Object)ref, (Object)"Null element to add to the dashboard");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)ref.projectKey), (Object)"Empty projectKey");
            if (projectKey == null) {
                projectKey = ref.projectKey;
                continue;
            }
            if (projectKey.equals(ref.projectKey)) continue;
            throw new IllegalArgumentException("All items should be in the same project to be added to a scenario.");
        }
        return projectKey;
    }

    public void addToScenario(List<TaggableObjectsService.TaggableObjectRef> refs, AddToScenarioOptions options) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)options.action), (Object)"No action specified for scenario");
        Preconditions.checkArgument((!refs.isEmpty() ? 1 : 0) != 0, (Object)"No items to add to the scenario");
        String projectKey = this.getProjectKey(refs);
        if (options.creation) {
            this.createScenario(projectKey, options);
        }
        Scenario sc = (Scenario)this.dao.getMandatory(projectKey, options.scenarioId);
        if (!StepBasedScenarioRunner.META.getType().equals(sc.getType())) {
            throw ErrorContext.iaef((String)"Scenario %s is not step-based, cannot add items", (Object)sc.getFullId(), (Object[])new Object[0]);
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (Step existingSteps : sc.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class).getSteps()) {
            transmogrifier.addAlreadyTransmogrified(existingSteps.id);
        }
        Step step = new Step().withType(options.action);
        sc.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class).addSteps(step);
        if (options.action.equals(BuildFlowItemStepRunner.META.getType())) {
            stepParams = (BuildFlowItemStepRunner.BuildFlowItemStepParams)new BuildFlowItemStepRunner.BuildFlowItemStepParams.Builder().withJobType(JobDef.JobType.RECURSIVE_BUILD).build();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                stepParams.builds.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(BuildFlowItemStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(BuildFlowItemStepRunner.META.buildId(step)));
        } else if (options.action.equals(ClearItemsStepRunner.META.getType())) {
            stepParams = new ClearItemsStepRunner.ClearItemsStepParams();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                ((ClearItemsStepRunner.ClearItemsStepParams)stepParams).clears.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(ClearItemsStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(ClearItemsStepRunner.META.buildId(step)));
        } else if (options.action.equals(CheckDatasetStepRunner.META.getType())) {
            stepParams = new CheckDatasetStepRunner.CheckDatasetStepParams();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                ((CheckDatasetStepRunner.CheckDatasetStepParams)stepParams).checks.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(CheckDatasetStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(CheckDatasetStepRunner.META.buildId(step)));
        } else if (options.action.equals(ComputeMetricsStepRunner.META.getType())) {
            stepParams = new ComputeMetricsStepRunner.ComputeMetricsStepParams();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                ((ComputeMetricsStepRunner.ComputeMetricsStepParams)stepParams).computes.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(ComputeMetricsStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(ComputeMetricsStepRunner.META.buildId(step)));
        } else if (options.action.equals(SynchronizeHiveStepRunner.META.getType())) {
            stepParams = new SynchronizeHiveStepRunner.SynchronizeHiveStepParams();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                ((SynchronizeHiveStepRunner.SynchronizeHiveStepParams)stepParams).syncs.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(SynchronizeHiveStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(SynchronizeHiveStepRunner.META.buildId(step)));
        } else if (options.action.equals(UpdateDatasetFromHiveStepRunner.META.getType())) {
            stepParams = new UpdateDatasetFromHiveStepRunner.UpdateDatasetFromHiveStepParams();
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                ((UpdateDatasetFromHiveStepRunner.UpdateDatasetFromHiveStepParams)stepParams).syncs.add(FlowComputableSpecification.make(sc.getProjectKey(), ref));
            }
            step.params = stepParams;
            step.withName(UpdateDatasetFromHiveStepRunner.META.buildName(step));
            step.withId(transmogrifier.transmogrify(UpdateDatasetFromHiveStepRunner.META.buildId(step)));
        } else {
            throw ErrorContext.iae((String)("Action not supported to add to scenario: " + options.action));
        }
        this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(sc.getProjectKey(), sc.getId()), sc);
        this.dao.save(sc.getProjectKey(), sc.getId(), sc);
    }

    private String getPartitionsSpec(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        ManagedFolder mf;
        TimeDimension timeDim = null;
        if (ref.type == ITaggingService.TaggableType.DATASET) {
            SerializedDataset ds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(ref.projectKey, ref.id);
            if (ds != null && ds.partitioning.isPartitioned() && ds.partitioning.getDimensionNamesSet().size() == 1) {
                timeDim = ds.partitioning.getSingleTimeDimension();
            }
        } else if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER && (mf = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(ref.projectKey, ref.id)) != null && mf.partitioning != null && mf.partitioning.isPartitioned() && mf.partitioning.getDimensionNamesSet().size() == 1) {
            timeDim = mf.partitioning.getSingleTimeDimension();
        }
        if (timeDim != null) {
            switch (timeDim.mappedPeriod) {
                case HOUR: {
                    return "CURRENT_HOUR";
                }
                case DAY: {
                    return "CURRENT_DAY";
                }
                case MONTH: {
                    return "CURRENT_MONTH";
                }
                case YEAR: {
                    return "CURRENT_YEAR";
                }
            }
        }
        return null;
    }

    private void createScenario(String projectKey, AddToScenarioOptions options) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)options.scenarioName), (Object)"New scenario name not provided");
        Scenario scenario = new Scenario();
        scenario.name = options.scenarioName;
        scenario.id = options.scenarioId;
        scenario.projectKey = projectKey;
        scenario.type = StepBasedScenarioRunner.META.getType();
        scenario.params = new StepBasedScenarioRunner.StepBasedScenarioParams();
        this.create(projectKey, scenario);
    }

    public void sendScenarioDiagnostic(AuthCtx authCtx, HttpServletResponse resp, ScenarioRunDetails scenarioRunDetails) throws IOException {
        ScenarioRun scenarioRun = scenarioRunDetails.scenarioRun;
        String projectKey = scenarioRun.getScenario().getProjectKey();
        String scenarioId = scenarioRun.getScenario().getId();
        String runId = scenarioRun.getRunId();
        File runDir = ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId);
        String id = "dss-scenario-diag-" + projectKey + "-" + scenarioId + "-" + runId;
        HashMap directoriesToZip = Maps.newHashMap();
        directoriesToZip.put(id, runDir);
        if (scenarioRunDetails != null && scenarioRunDetails.stepRuns != null) {
            for (StepRun stepRun : scenarioRunDetails.stepRuns) {
                if (stepRun.additionalReportItems == null) continue;
                for (ReportItem reportItem : stepRun.additionalReportItems) {
                    if (!(reportItem instanceof ReportItem.JobExecuted)) continue;
                    ReportItem.JobExecuted job = (ReportItem.JobExecuted)reportItem;
                    if (!StringUtils.isNotBlank((String)job.jobId)) continue;
                    this.flowExecutionService.dumpStacksIfStillRunning_NT(projectKey, job.jobId);
                    File jobFolder = FlowJobUtils.jobFolder(false, projectKey, job.jobId);
                    if (!jobFolder.exists() || !jobFolder.isDirectory()) continue;
                    directoriesToZip.put(id + "/" + job.jobId + "/", jobFolder);
                }
            }
        }
        if (runDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + id + ".zip\"");
            resp.setStatus(200);
            try (ZipWriteFS zipFs = new ZipWriteFS((OutputStream)resp.getOutputStream(), 1);){
                for (Map.Entry entry : directoriesToZip.entrySet()) {
                    zipFs.makeDirectory((String)entry.getKey());
                    DiagConfigRedactionUtils.buildJobDiag((File)entry.getValue(), zipFs.directoryView((String)entry.getKey()), authCtx);
                }
                zipFs.writeObjectNoMkdir(new RelFile(new String[]{id, "scenario-run-details.json"}), (Object)scenarioRunDetails);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("run logs dir not found");
        }
    }

    public boolean isUnavailable(Scenario sc) {
        if (sc.params instanceof StepBasedScenarioRunner.StepBasedScenarioParams) {
            StepBasedScenarioRunner.StepBasedScenarioParams sbsParams = (StepBasedScenarioRunner.StepBasedScenarioParams)sc.params;
            for (Step curStep : sbsParams.steps) {
                StepMeta stepMeta = StepRegistry.getMeta(curStep);
                StepMeta.UnavailableStepInfo unavailableStepInfo = stepMeta.checkStepForDeletedPluginComponents(sc, curStep, this.pluginUsagesInspector);
                if (null == unavailableStepInfo) continue;
                return true;
            }
        }
        for (Trigger curTrig : sc.triggers) {
            TriggerMeta triggerMeta = TriggerRegistry.getMeta(curTrig);
            if (!(triggerMeta instanceof DeletedPythonPluginTriggerMeta)) continue;
            return true;
        }
        return false;
    }

    public String computeRunAsUser(Scenario scenario) {
        return this.scenariosBaseService.computeRunAsUser(scenario);
    }

    public List<StepMeta.UnavailableStepInfo> getUnavailableSteps(Scenario sc) {
        ArrayList<StepMeta.UnavailableStepInfo> ret = new ArrayList<StepMeta.UnavailableStepInfo>();
        if (sc.params instanceof StepBasedScenarioRunner.StepBasedScenarioParams) {
            StepBasedScenarioRunner.StepBasedScenarioParams sbsParams = (StepBasedScenarioRunner.StepBasedScenarioParams)sc.params;
            for (Step curStep : sbsParams.steps) {
                StepMeta stepMeta = StepRegistry.getMeta(curStep);
                StepMeta.UnavailableStepInfo unavailableStepInfo = stepMeta.checkStepForDeletedPluginComponents(sc, curStep, this.pluginUsagesInspector);
                if (null == unavailableStepInfo) continue;
                ret.add(unavailableStepInfo);
            }
        }
        return ret;
    }

    public List<String> getUnavailableTriggers(Scenario sc) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Trigger curTrig : sc.triggers) {
            TriggerMeta triggerMeta = TriggerRegistry.getMeta(curTrig);
            if (!(triggerMeta instanceof DeletedPythonPluginTriggerMeta)) continue;
            ret.add(curTrig.id);
        }
        return ret;
    }

    private static void redactLogsAndCallstacks(ScenarioRunDetails scenarioRunDetails) {
        ScenariosService.redactLogsAndCallstacks(scenarioRunDetails.scenarioRun);
        if (scenarioRunDetails.stepRuns != null) {
            for (StepRun stepRun : scenarioRunDetails.stepRuns) {
                ScenariosService.redactLogsAndCallstacks(stepRun.scenarioRun);
                ScenariosService.redactLogsAndCallstacks(stepRun.result);
                if (stepRun.additionalReportItems == null) continue;
                for (ReportItem reportItem : stepRun.additionalReportItems) {
                    ScenariosService.redactLogsAndCallstacks(reportItem);
                }
            }
        }
    }

    private static void redactLogsAndCallstacks(ScenarioRun scenarioRun) {
        if (scenarioRun != null) {
            ScenariosService.redactLogsAndCallstacks(scenarioRun.result);
        }
    }

    private static void redactLogsAndCallstacks(ReportItem result) {
        if (result != null) {
            result.logTail = SmartLogTail.restrictedLogTail();
            if (result.thrown != null) {
                result.thrown.stack = null;
            }
        }
    }

    public static class ScenarioRunDetails {
        public ScenarioRun scenarioRun;
        public List<StepRun> stepRuns;
    }

    public static class AddToScenarioOptions {
        public String action;
        public boolean creation;
        public String scenarioId;
        public String scenarioName;
    }
}

