/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.Latitude;
import com.dataiku.dip.shaker.types.Longitude;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class GeoPointCreator
extends SingleRowProcessor
implements Processor {
    private Parameter params;
    private Column lat_col;
    private Column lon_col;
    private Column out_col;
    public static final ProcessorMeta<GeoPointCreator, Parameter> META = new ProcessorMeta<GeoPointCreator, Parameter>(){

        @Override
        public String getName() {
            return "GeoPointCreator";
        }

        @Override
        public String getDocPage() {
            return "geopoint-create";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GeoPointCreator.HELP", "Create a column in GeoPoint format from two columns containing latitude and longitude. GeoPoint is a data meaning that represents a point on Earth, POINT(latitude, longitude), and is used in map charts.\n\nThis processor uses the WKT (well-known text) markup format for representing GeoPoints.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GeoPointCreator.DESCRIPTION", 1.actionVerb("Create") + " GeoPoint from lat/lon"), true).withMNEColParam("lat_column", this.translate(language, "SHAKER.PROCESSOR.GeoPointCreator.DESCRIPTION.LAT_COLUMN", "Input 'latitude' column")).withMNEColParam("lon_column", this.translate(language, "SHAKER.PROCESSOR.GeoPointCreator.DESCRIPTION.LON_COLUMN", "Input 'longitude' column")).withParam("out_column", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.GeoPointCreator.DESCRIPTION.OUT_COLUMN", "Output 'GeoPoint' column"));
        }

        @Override
        public GeoPointCreator build(Parameter parameter) {
            return new GeoPointCreator(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter creatorParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)creatorParams.lat_column)) {
                throw new IllegalConfigurationException("Missing latitude column information for lineage on the geopoint creator processor.");
            }
            if (StringUtils.isBlank((String)creatorParams.lon_column)) {
                throw new IllegalConfigurationException("Missing longitude column information for lineage on the geopoint creator processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)creatorParams.out_column)) {
                    if (!Objects.equals(creatorParams.lat_column, creatorParams.out_column) && !Objects.equals(creatorParams.lon_column, creatorParams.out_column)) {
                        updatedDatasetPairLineage.removeRelationsOnColumn(creatorParams.out_column);
                    }
                    updatedDatasetPairLineage.addFactorizedColumnRelations(creatorParams.lat_column, creatorParams.out_column);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(creatorParams.lon_column, creatorParams.out_column);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    public GeoPointCreator(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.lat_col = this.getColumnFactory().column(this.params.lat_column, Processor.ProcessorRole.INPUT_COLUMN);
        this.lon_col = this.getColumnFactory().column(this.params.lon_column, Processor.ProcessorRole.INPUT_COLUMN);
        this.out_col = this.getColumnFactory().column(this.params.out_column, Processor.ProcessorRole.OUTPUT_COLUMN);
        if (this.out_col instanceof MemColumn) {
            ((MemColumn)this.out_col).forceType((MeaningDetector)new GeoPoint());
        }
    }

    public void processRow(Row row) throws Exception {
        String latStr = row.get(this.lat_col);
        String lonStr = row.get(this.lon_col);
        if (StringUtils.isBlank((String)latStr) || StringUtils.isBlank((String)lonStr)) {
            return;
        }
        double parsedLatitude = Latitude.convert((String)latStr);
        double parsedLongitude = Longitude.convert((String)lonStr);
        if (!Double.isNaN(parsedLatitude) && !Double.isNaN(parsedLongitude)) {
            row.put(this.out_col, new GeoPoint.Coords(parsedLatitude, parsedLongitude).toWKT());
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String out_column;
        public String lat_column;
        public String lon_column;

        public void validate() throws IllegalArgumentException {
        }
    }
}

