/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorMeta;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.ParamsWithRemoteCodeEnv;
import com.dataiku.dip.shaker.resources.YarnPythonBinsSetup;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomJythonStepParams
implements StepParams,
ParamsWithRemoteCodeEnv {
    private static final long serialVersionUID = -1L;
    public String outputColumn;
    public String errorColumn;
    public Map<String, Object> customConfig = new HashMap<String, Object>();
    public transient Map<String, Object> resolvedConfig = new HashMap<String, Object>();
    public transient Map<String, Object> pluginConfig = new HashMap<String, Object>();
    public transient Map<String, String> variablesDefinition = Maps.newHashMap();
    public int vectorSize = 32;
    public String sourceColumnsPattern;
    public List<String> sourceColumnsList = Lists.newArrayList();
    public String fixedEnvName;
    protected static Logger logger = Logger.getLogger((String)"dku.shaker.python.param");

    public void validate() throws IllegalArgumentException {
    }

    @Override
    public String getCodeEnvName(MetaWithRemoteCodeEnv meta, String projectKey) throws IOException {
        if (YarnPythonBinsSetup.isRemote) {
            logger.info((Object)("Use fixed code env " + this.fixedEnvName));
            return "__BUILTIN_ENV__".equals(this.fixedEnvName) ? null : this.fixedEnvName;
        }
        logger.info((Object)"Pick code env for custom python udf");
        CustomJythonProcessorMeta customMeta = (CustomJythonProcessorMeta)meta;
        return new CodeEnvSelector().selectForCustomPythonRecipe(customMeta.getLoadedDesc().getOwnerPluginId());
    }

    @Override
    public void setCodeEnvName(String envName) {
        this.fixedEnvName = StringUtils.defaultIfBlank((String)envName, (String)"__BUILTIN_ENV__");
    }
}

