/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.shaker.types.MeaningDetector;
import java.util.regex.Pattern;

public class PatternUDMDetector
implements MeaningDetector {
    private UserDefinedMeaning udm;
    Pattern compiledPattern;

    public PatternUDMDetector(UserDefinedMeaning udm) {
        this.udm = udm;
        int flag = 0;
        if (this.udm.normalizationMode == StringNormalizationMode.LOWERCASE) {
            flag = 66;
        }
        this.compiledPattern = Pattern.compile(udm.pattern, flag);
    }

    public double detects(String val) {
        if (val != null && this.compiledPattern.matcher(this.udm.normalizationMode.apply(val)).matches()) {
            return 0.7f;
        }
        return 0.0;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isTemporal() {
        return false;
    }

    public String getMeaningId() {
        return this.udm.id;
    }

    public long longValue(String val) {
        return 0L;
    }

    public double doubleValue(String val) {
        return 0.0;
    }

    public boolean validates(String val) {
        return this.detects(val) > 0.0;
    }
}

