/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SparkErrorParser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.errors.parser");

    private SparkErrorParser() {
    }

    public static void enrichError(String language, SerializedError error) {
        logger.info((Object)("Enriching error message:" + error.message));
        if (SparkErrorParser.messageMatchesRE(error, "Failed to find data source.*kafka")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_MISSING_KAFKA_JARS);
            return;
        }
        if (SparkErrorParser.messageMatchesRE(error, "java.lang.IllegalArgumentException*Illegal pattern component.*\\bXXX\\b")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_COMMONS_LANG3_JAR_CONFLICT);
            return;
        }
        if (SparkErrorParser.messageMatchesRE(error, "Job aborted due to stage failure.*Lost task.*java.lang.OutOfMemoryError")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_FAILED_TASK_OOM);
            return;
        }
        if (SparkErrorParser.messageMatchesRE(error, "Job aborted due to stage failure.*Lost task.*ExecutorLostFailure.*Container killed by YARN for exceeding memory limits")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_FAILED_YARN_KILLED_MEMORY);
            return;
        }
        if ("java.lang.OutOfMemoryError".equals(error.errorType) && "Java heap space".equals(error.message)) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_FAILED_DRIVER_OOM);
            return;
        }
        ArrayList<String> patternsToMatchInLog = new ArrayList<String>();
        patternsToMatchInLog.add("Container killed by YARN for exceeding memory limits");
        if (language.equals("pyspark")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_PYSPARK_CODE_FAILED_UNSPECIFIED);
            return;
        }
        if (language.equals("scala")) {
            error.withCode((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_SCALA_CODE_FAILED_UNSPECIFIED);
            return;
        }
    }

    static boolean messageMatchesRE(SerializedError error, String pattern) {
        if (StringUtils.isBlank((String)error.message)) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        return p.matcher(error.message).find();
    }
}

